/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.annotations.concurrency.Slow;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.diagnostics.windows.VirusCheckerStatusProvider;
import com.android.tools.idea.diagnostics.windows.WindowsDefenderPowerShellStatusProvider;
import com.android.tools.idea.diagnostics.windows.WindowsDefenderRegistryStatusProvider;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.WindowsDefenderStatus;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsPerformanceHintsChecker {
    private static final Logger LOG = Logger.getInstance(WindowsPerformanceHintsChecker.class);
    private static final String ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY = "antivirus.scan.notification.last.shown.time";
    private static final Duration ANTIVIRUS_MIN_INTERVAL_BETWEEN_NOTIFICATIONS = Duration.ofDays(1L);
    private static final Pattern WINDOWS_ENV_VAR_PATTERN = Pattern.compile("%([^%]+?)%");
    private static final Pattern WINDOWS_DEFENDER_WILDCARD_PATTERN = Pattern.compile("[?*]");
    private AndroidStudioSystemHealthMonitor systemHealthMonitor = AndroidStudioSystemHealthMonitor.getInstance();
    private VirusCheckerStatusProvider myVirusCheckerStatusProvider = (Boolean)StudioFlags.ANTIVIRUS_CHECK_USE_REGISTRY.get() != false ? new WindowsDefenderRegistryStatusProvider() : new WindowsDefenderPowerShellStatusProvider();

    public void run() {
        if (SystemInfo.isWindows && (((Boolean)StudioFlags.ANTIVIRUS_METRICS_ENABLED.get()).booleanValue() || ((Boolean)StudioFlags.ANTIVIRUS_NOTIFICATION_ENABLED.get()).booleanValue())) {
            final Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(final @NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    application.executeOnPooledThread(() -> WindowsPerformanceHintsChecker.this.checkWindowsDefender(project, false));
                    GradleBuildState.subscribe(project, new GradleBuildListener(){

                        @Override
                        public void buildExecutorCreated(@NotNull GradleBuildInvoker.Request request) {
                            if (request == null) {
                                1.$$$reportNull$$$0(0);
                            }
                        }

                        @Override
                        public void buildStarted(@NotNull BuildContext context) {
                            if (context == null) {
                                1.$$$reportNull$$$0(1);
                            }
                        }

                        @Override
                        public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
                            BuildMode mode;
                            if (status == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            BuildMode buildMode = mode = context != null ? context.getBuildMode() : null;
                            if (status == BuildStatus.SUCCESS && (mode == BuildMode.ASSEMBLE || mode == BuildMode.ASSEMBLE_TRANSLATE || mode == BuildMode.REBUILD || mode == BuildMode.BUNDLE || mode == BuildMode.APK_FROM_BUNDLE)) {
                                application.executeOnPooledThread(() -> WindowsPerformanceHintsChecker.this.checkWindowsDefender(project, true));
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "request";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "context";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "status";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/android/tools/idea/diagnostics/WindowsPerformanceHintsChecker$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "buildExecutorCreated";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "buildStarted";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "buildFinished";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/diagnostics/WindowsPerformanceHintsChecker$1", "projectOpened"));
                }
            });
        }
    }

    @Slow
    private void checkWindowsDefender(@NotNull Project project, boolean showNotification2) {
        VirusCheckerStatusProvider.RealtimeScanningStatus status;
        if (project == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(0);
        }
        try {
            status = this.myVirusCheckerStatusProvider.getRealtimeScanningStatus();
        }
        catch (IOException exception) {
            LOG.warn("Error retrieving status of virus checker", (Throwable)exception);
            WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.UNKNOWN_STATUS, false, project);
            return;
        }
        switch (status) {
            case SCANNING_ENABLED: {
                WindowsDefenderStatus.Status overallStatus;
                List<Pattern> excludedPatterns = this.getExcludedPatterns();
                if (excludedPatterns == null) {
                    WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.UNKNOWN_STATUS, false, project);
                    break;
                }
                Map<Path, Boolean> pathStatuses = WindowsPerformanceHintsChecker.checkPathsExcluded(WindowsPerformanceHintsChecker.getImportantPaths(project), excludedPatterns);
                if (pathStatuses.containsValue(Boolean.FALSE)) {
                    if (showNotification2 && ((Boolean)StudioFlags.ANTIVIRUS_NOTIFICATION_ENABLED.get()).booleanValue() && !WindowsPerformanceHintsChecker.shownRecently()) {
                        this.showAntivirusNotification(project, WindowsPerformanceHintsChecker.getNotificationTextForNonExcludedPaths(pathStatuses));
                        WindowsPerformanceHintsChecker.setLastShownTime();
                    }
                    overallStatus = pathStatuses.containsValue(Boolean.TRUE) ? WindowsDefenderStatus.Status.SOME_EXCLUDED : WindowsDefenderStatus.Status.NONE_EXCLUDED;
                } else {
                    overallStatus = WindowsDefenderStatus.Status.ALL_EXCLUDED;
                }
                String projectDir = project.getBasePath();
                boolean projectPathExcluded = false;
                if (projectDir != null) {
                    projectPathExcluded = pathStatuses.getOrDefault(Paths.get(projectDir, new String[0]), false);
                }
                WindowsPerformanceHintsChecker.logWindowsDefenderStatus(overallStatus, projectPathExcluded, project);
                break;
            }
            case SCANNING_DISABLED: {
                WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.SCANNING_DISABLED, true, project);
            }
        }
    }

    private void showAntivirusNotification(@NotNull Project project, @NotNull String pathDetails) {
        if (project == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(1);
        }
        if (pathDetails == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(2);
        }
        final String key = "virus.scanning.warn.message";
        boolean ignored = false;
        final PropertiesComponent applicationProperties = PropertiesComponent.getInstance();
        final PropertiesComponent projectProperties = PropertiesComponent.getInstance((Project)project);
        if (applicationProperties != null) {
            ignored = applicationProperties.isValueSet("ignore." + key);
        }
        if (projectProperties != null) {
            ignored |= projectProperties.isValueSet("ignore." + key);
        }
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        AndroidStudioSystemHealthMonitor androidStudioSystemHealthMonitor = this.systemHealthMonitor;
        Objects.requireNonNull(androidStudioSystemHealthMonitor);
        AndroidStudioSystemHealthMonitor.MyNotification notification = androidStudioSystemHealthMonitor.new AndroidStudioSystemHealthMonitor.MyNotification(AndroidBundle.message(key, pathDetails));
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("virus.scanning.dont.show.again", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.expire();
                if (applicationProperties != null) {
                    applicationProperties.setValue("ignore." + key, "true");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/diagnostics/WindowsPerformanceHintsChecker$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("virus.scanning.dont.show.again.this.project", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                notification.expire();
                if (projectProperties != null) {
                    projectProperties.setValue("ignore." + key, "true");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/diagnostics/WindowsPerformanceHintsChecker$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.addAction((AnAction)AndroidStudioSystemHealthMonitor.detailsAction("https://d.android.com/r/studio-ui/antivirus-check"));
        notification.setImportant(true);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private static boolean shownRecently() {
        if ("true".equals(System.getProperty("disable.antivirus.notification.rate.limit"))) {
            return false;
        }
        String lastShownTime = PropertiesComponent.getInstance().getValue(ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY);
        if (lastShownTime == null) {
            return false;
        }
        try {
            Instant lastShown = Instant.parse(lastShownTime);
            return lastShown.plus(ANTIVIRUS_MIN_INTERVAL_BETWEEN_NOTIFICATIONS).isAfter(Instant.now());
        }
        catch (DateTimeException e) {
            WindowsPerformanceHintsChecker.setLastShownTime();
            return false;
        }
    }

    private static void setLastShownTime() {
        PropertiesComponent.getInstance().setValue(ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY, Instant.now().toString());
    }

    private static void logWindowsDefenderStatus(WindowsDefenderStatus.Status status, boolean projectDirExcluded, @NotNull Project project) {
        if (project == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(3);
        }
        LOG.info("Windows Defender status: " + status + "; projectDirExcluded? " + projectDirExcluded);
        if (((Boolean)StudioFlags.ANTIVIRUS_METRICS_ENABLED.get()).booleanValue() && !ApplicationManager.getApplication().isInternal() && StatisticsUploadAssistant.isSendAllowed()) {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WINDOWS_DEFENDER_STATUS).setWindowsDefenderStatus(WindowsDefenderStatus.newBuilder().setProjectDirExcluded(projectDirExcluded).setStatus(status)), project));
        }
    }

    @Slow
    @Nullable
    private List<Pattern> getExcludedPatterns() {
        try {
            List<String> excludedPaths = this.myVirusCheckerStatusProvider.getExcludedPaths();
            return excludedPaths.stream().map(path2 -> WindowsPerformanceHintsChecker.wildcardsToRegex(WindowsPerformanceHintsChecker.expandEnvVars(path2))).collect(Collectors.toList());
        }
        catch (IOException exception) {
            LOG.warn("Error retrieving list of excluded patterns", (Throwable)exception);
            return null;
        }
    }

    @NotNull
    private static List<Path> getImportantPaths(@NotNull Project project) {
        if (project == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(4);
        }
        String homeDir = System.getProperty("user.home");
        String gradleUserHome = System.getenv("GRADLE_USER_HOME");
        String projectDir = project.getBasePath();
        ArrayList<Path> paths = new ArrayList<Path>();
        if (projectDir != null) {
            paths.add(Paths.get(projectDir, new String[0]));
        }
        paths.add(Paths.get(PathManager.getSystemPath(), new String[0]));
        if (gradleUserHome != null) {
            paths.add(Paths.get(gradleUserHome, new String[0]));
        } else {
            paths.add(Paths.get(homeDir, ".gradle"));
        }
        AndroidSdkData sdkData = AndroidSdkUtils.getProjectSdkData(project);
        if (sdkData == null) {
            sdkData = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (sdkData != null) {
            paths.add(Paths.get(sdkData.getLocation().getAbsolutePath(), new String[0]));
        }
        ArrayList<Path> arrayList = paths;
        if (arrayList == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static String expandEnvVars(@NotNull String path2) {
        if (path2 == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(6);
        }
        Matcher m = WINDOWS_ENV_VAR_PATTERN.matcher(path2);
        StringBuffer result2 = new StringBuffer();
        while (m.find()) {
            String value2 = System.getenv(m.group(1));
            if (value2 == null) continue;
            m.appendReplacement(result2, Matcher.quoteReplacement(value2));
        }
        m.appendTail(result2);
        String string = result2.toString();
        if (string == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static Pattern wildcardsToRegex(@NotNull String path2) {
        if (path2 == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(8);
        }
        Matcher m = WINDOWS_DEFENDER_WILDCARD_PATTERN.matcher(path2);
        StringBuilder sb = new StringBuilder();
        int previousWildcardEnd = 0;
        while (m.find()) {
            sb.append(Pattern.quote(path2.substring(previousWildcardEnd, m.start())));
            if (m.group().equals("?")) {
                sb.append("[^\\\\]");
            } else {
                sb.append("[^\\\\]*");
            }
            previousWildcardEnd = m.end();
        }
        sb.append(Pattern.quote(path2.substring(previousWildcardEnd)));
        sb.append(".*");
        Pattern pattern = Pattern.compile(sb.toString(), 2);
        if (pattern == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(9);
        }
        return pattern;
    }

    @NotNull
    private static Map<Path, Boolean> checkPathsExcluded(@NotNull List<Path> paths, @NotNull List<Pattern> excludedPatterns) {
        if (paths == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(10);
        }
        if (excludedPatterns == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(11);
        }
        HashMap<Path, Boolean> result2 = new HashMap<Path, Boolean>();
        for (Path path2 : paths) {
            try {
                String canonical = path2.toRealPath(new LinkOption[0]).toString();
                boolean found = false;
                for (Pattern pattern : excludedPatterns) {
                    if (!pattern.matcher(canonical).matches()) continue;
                    found = true;
                    result2.put(path2, true);
                    break;
                }
                if (found) continue;
                result2.put(path2, false);
            }
            catch (IOException e) {
                LOG.warn("Windows Defender exclusion check couldn't get real path for " + path2, (Throwable)e);
            }
        }
        HashMap<Path, Boolean> hashMap = result2;
        if (hashMap == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    @NotNull
    private static String getNotificationTextForNonExcludedPaths(@NotNull Map<Path, Boolean> pathStatuses) {
        if (pathStatuses == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder();
        pathStatuses.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).forEach(entry -> sb.append("<br/>").append(entry.getKey()));
        String string = sb.toString();
        if (string == null) {
            WindowsPerformanceHintsChecker.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathDetails";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/WindowsPerformanceHintsChecker";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPatterns";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathStatuses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/WindowsPerformanceHintsChecker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportantPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandEnvVars";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "wildcardsToRegex";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPathsExcluded";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationTextForNonExcludedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkWindowsDefender";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showAntivirusNotification";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logWindowsDefenderStatus";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportantPaths";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandEnvVars";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wildcardsToRegex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkPathsExcluded";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationTextForNonExcludedPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

