/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFakeFileSystem
extends DummyFileSystem {
    @NonNls
    public static final String PROTOCOL = "android-dummy";
    public static final VirtualFileSystem INSTANCE = new AndroidFakeFileSystem();
    public static final char SEPARATOR = '/';

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path2) {
        Module m;
        List components;
        int size;
        if (path2 == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(0);
        }
        if ((size = (components = Splitter.on((char)'/').splitToList((CharSequence)path2)).size()) < 3) {
            return null;
        }
        String projectPath = Joiner.on((char)'/').join(components.subList(0, size - 2));
        String moduleName2 = (String)components.get(size - 2);
        String fileName = (String)components.get(size - 1);
        Project project = AndroidFakeFileSystem.findProject(projectPath);
        if (project == null) {
            return null;
        }
        if ("Translations Editor".equals(fileName) && (m = AndroidFakeFileSystem.findModule(project, moduleName2)) != null) {
            return StringsVirtualFile.getStringsVirtualFile(m);
        }
        return null;
    }

    @NotNull
    public static String constructPathForFile(@NotNull String fileName, @NotNull Module module) {
        if (fileName == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(1);
        }
        if (module == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(2);
        }
        String string = Joiner.on((char)'/').join((Object)module.getProject().getBasePath(), (Object)module.getName(), new Object[]{fileName});
        if (string == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String constructPathForFile(@NotNull String fileName, @NotNull Project project) {
        if (fileName == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(4);
        }
        if (project == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(5);
        }
        String string = Joiner.on((char)'/').join((Object)project.getBasePath(), (Object)"", new Object[]{fileName});
        if (string == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(7);
        }
        if (name == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(8);
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    private static Project findProject(@NotNull String basePath) {
        if (basePath == null) {
            AndroidFakeFileSystem.$$$reportNull$$$0(9);
        }
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!basePath.equals(p.getBasePath())) continue;
            return p;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/AndroidFakeFileSystem";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/AndroidFakeFileSystem";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "constructPathForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "constructPathForFile";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

