/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.device.fs.DownloadedFileData;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceExplorerFilesUtils;
import com.android.tools.idea.explorer.DeviceExplorerModel;
import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.DeviceExplorerViewListener;
import com.android.tools.idea.explorer.DeviceFileEntryNode;
import com.android.tools.idea.explorer.ErrorNode;
import com.android.tools.idea.explorer.FileTransferOperationTracker;
import com.android.tools.idea.explorer.FileTransferSummary;
import com.android.tools.idea.explorer.FileTransferWorkEstimate;
import com.android.tools.idea.explorer.FileTransferWorkEstimator;
import com.android.tools.idea.explorer.FileTransferWorkEstimatorProgress;
import com.android.tools.idea.explorer.LongRunningOperationTracker;
import com.android.tools.idea.explorer.MyLoadingNode;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileSystemServiceListener;
import com.android.tools.idea.explorer.fs.DeviceState;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.ui.TreeUtil;
import com.android.utils.FileUtils;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DeviceExplorerController {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(DeviceExplorerController.class);
    @NotNull
    private static final Key<DeviceExplorerController> KEY = Key.create((String)DeviceExplorerController.class.getName());
    @NotNull
    private static final String DEVICE_EXPLORER_BUSY_MESSAGE = "Device Explorer is busy, please retry later or cancel current operation";
    private static final long FILE_ENTRY_CREATION_TIMEOUT_MILLIS = 10000L;
    private static final long FILE_ENTRY_DELETION_TIMEOUT_MILLIS = 10000L;
    private int myShowLoadingNodeDelayMillis;
    private int myTransferringNodeRepaintMillis;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DeviceExplorerModel myModel;
    @NotNull
    private final DeviceExplorerView myView;
    @NotNull
    private final DeviceFileSystemService myService;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final DeviceExplorerFileManager myFileManager;
    @NotNull
    private final FileTransferWorkEstimator myWorkEstimator;
    @NotNull
    private final Set<DeviceFileEntryNode> myTransferringNodes;
    @NotNull
    private final Set<DeviceFileEntryNode> myLoadingChildren;
    @NotNull
    private final Alarm myLoadingNodesAlarms;
    @NotNull
    private final Alarm myTransferringNodesAlarms;
    @NotNull
    private final Alarm myLoadingChildrenAlarms;
    @NotNull
    private final FileOpener myFileOpener;
    @Nullable
    private LongRunningOperationTracker myLongRunningOperationTracker;

    public DeviceExplorerController(@NotNull Project project, @NotNull DeviceExplorerModel model2, @NotNull DeviceExplorerView view, @NotNull DeviceFileSystemService service, @NotNull DeviceExplorerFileManager fileManager, @NotNull FileOpener fileOpener, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor) {
        if (project == null) {
            DeviceExplorerController.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            DeviceExplorerController.$$$reportNull$$$0(1);
        }
        if (view == null) {
            DeviceExplorerController.$$$reportNull$$$0(2);
        }
        if (service == null) {
            DeviceExplorerController.$$$reportNull$$$0(3);
        }
        if (fileManager == null) {
            DeviceExplorerController.$$$reportNull$$$0(4);
        }
        if (fileOpener == null) {
            DeviceExplorerController.$$$reportNull$$$0(5);
        }
        if (edtExecutor == null) {
            DeviceExplorerController.$$$reportNull$$$0(6);
        }
        if (taskExecutor == null) {
            DeviceExplorerController.$$$reportNull$$$0(7);
        }
        this.myShowLoadingNodeDelayMillis = 200;
        this.myTransferringNodeRepaintMillis = 100;
        this.myTransferringNodes = new HashSet<DeviceFileEntryNode>();
        this.myLoadingChildren = new HashSet<DeviceFileEntryNode>();
        this.myProject = project;
        this.myModel = model2;
        this.myView = view;
        this.myService = service;
        this.myEdtExecutor = FutureCallbackExecutor.wrap((Executor)edtExecutor);
        this.myService.addListener(new ServiceListener());
        this.myView.addListener(new ViewListener());
        this.myFileManager = fileManager;
        this.myWorkEstimator = new FileTransferWorkEstimator((Executor)this.myEdtExecutor, taskExecutor);
        this.myLoadingNodesAlarms = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myTransferringNodesAlarms = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myLoadingChildrenAlarms = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myFileOpener = fileOpener;
        project.putUserData(KEY, (Object)this);
    }

    @Nullable
    public static DeviceExplorerController getProjectController(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        return (DeviceExplorerController)project.getUserData(KEY);
    }

    @Nullable
    private DefaultTreeModel getTreeModel() {
        return this.myModel.getTreeModel();
    }

    @Nullable
    private DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.myModel.getTreeSelectionModel();
    }

    public void setup() {
        this.myView.setup();
        this.myView.startRefresh("Initializing ADB");
        ListenableFuture<Void> future2 = this.myService.start(() -> AndroidSdkUtils.getAdb(this.myProject));
        this.myEdtExecutor.addListener(future2, this.myView::stopRefresh);
        this.myEdtExecutor.addCallback(future2, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result2) {
                DeviceExplorerController.this.refreshDeviceList();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                DeviceExplorerController.this.myView.reportErrorRelatedToService(DeviceExplorerController.this.myService, "Error initializing ADB", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$1", "onFailure"));
            }
        });
    }

    public void restartService() {
        this.myView.startRefresh("Restarting ADB");
        ListenableFuture<Void> future2 = this.myService.restart(() -> AndroidSdkUtils.getAdb(this.myProject));
        this.myEdtExecutor.addListener(future2, this.myView::stopRefresh);
        this.myEdtExecutor.addCallback(future2, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result2) {
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                DeviceExplorerController.this.myView.reportErrorRelatedToService(DeviceExplorerController.this.myService, "Error restarting ADB", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$2", "onFailure"));
            }
        });
    }

    private void refreshDeviceList() {
        this.cancelPendingOperations();
        this.myView.startRefresh("Refreshing list of devices");
        ListenableFuture futureDevices = this.myService.getDevices();
        this.myEdtExecutor.addListener(futureDevices, this.myView::stopRefresh);
        this.myEdtExecutor.addCallback(futureDevices, (FutureCallback)new FutureCallback<List<DeviceFileSystem>>(){

            public void onSuccess(@Nullable List<DeviceFileSystem> result2) {
                assert (result2 != null);
                DeviceExplorerController.this.myModel.removeAllDevices();
                result2.forEach(DeviceExplorerController.this.myModel::addDevice);
                if (result2.isEmpty()) {
                    DeviceExplorerController.this.myView.showNoDeviceScreen();
                }
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                DeviceExplorerController.this.myModel.removeAllDevices();
                DeviceExplorerController.this.myView.reportErrorRelatedToService(DeviceExplorerController.this.myService, "Error refreshing list of devices", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$3", "onFailure"));
            }
        });
    }

    private void setNoActiveDevice() {
        this.cancelPendingOperations();
        this.myModel.setActiveDevice(null);
        this.myModel.setActiveDeviceTreeModel(null, null, null);
        this.myView.showNoDeviceScreen();
    }

    private void setActiveDevice(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerController.$$$reportNull$$$0(8);
        }
        this.cancelPendingOperations();
        this.myModel.setActiveDevice(device);
        this.refreshActiveDevice(device);
    }

    private void deviceStateUpdated(@NotNull DeviceFileSystem device) {
        DeviceState lastKnownState;
        if (device == null) {
            DeviceExplorerController.$$$reportNull$$$0(9);
        }
        if (!Objects.equals(device, this.myModel.getActiveDevice())) {
            return;
        }
        DeviceState newState = device.getDeviceState();
        if (Objects.equals((Object)newState, (Object)(lastKnownState = this.myModel.getActiveDeviceLastKnownState(device)))) {
            return;
        }
        this.myModel.setActiveDeviceLastKnownState(device);
        this.refreshActiveDevice(device);
    }

    private void refreshActiveDevice(final @NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerController.$$$reportNull$$$0(10);
        }
        if (!Objects.equals(device, this.myModel.getActiveDevice())) {
            return;
        }
        if (device.getDeviceState() != DeviceState.ONLINE) {
            String message2 = device.getDeviceState() == DeviceState.UNAUTHORIZED || device.getDeviceState() == DeviceState.OFFLINE ? "Device is pending authentication: please accept debugging session on the device" : String.format("Device is not online (%s)", new Object[]{device.getDeviceState()});
            this.myView.reportMessageRelatedToDevice(device, message2);
            this.myModel.setActiveDeviceTreeModel(device, null, null);
            return;
        }
        ListenableFuture<DeviceFileEntry> futureRoot = device.getRootDirectory();
        this.myEdtExecutor.addCallback(futureRoot, (FutureCallback)new FutureCallback<DeviceFileEntry>(){

            public void onSuccess(@Nullable DeviceFileEntry result2) {
                assert (result2 != null);
                DeviceFileEntryNode rootNode = new DeviceFileEntryNode(result2);
                DefaultTreeModel model2 = new DefaultTreeModel(rootNode);
                DeviceExplorerController.this.myModel.setActiveDeviceTreeModel(device, model2, new DefaultTreeSelectionModel());
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    4.$$$reportNull$$$0(0);
                }
                DeviceExplorerController.this.myModel.setActiveDeviceTreeModel(device, null, null);
                DeviceExplorerController.this.myView.reportErrorRelatedToDevice(device, "Unable to access root directory of device", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$4", "onFailure"));
            }
        });
    }

    private void cancelPendingOperations() {
        this.myLoadingNodesAlarms.cancelAllRequests();
        this.myLoadingChildrenAlarms.cancelAllRequests();
        this.myTransferringNodesAlarms.cancelAllRequests();
        this.myLoadingChildren.clear();
        this.myTransferringNodes.clear();
        if (this.myLongRunningOperationTracker != null) {
            this.myLongRunningOperationTracker.cancel();
        }
    }

    private <T> ListenableFuture<Void> executeFuturesInSequence(@NotNull Iterator<T> iterator, @NotNull Function<T, ListenableFuture<Void>> taskFactory) {
        if (iterator == null) {
            DeviceExplorerController.$$$reportNull$$$0(11);
        }
        if (taskFactory == null) {
            DeviceExplorerController.$$$reportNull$$$0(12);
        }
        return this.myEdtExecutor.executeFuturesInSequence(iterator, taskFactory);
    }

    private void startNodeDownload(@NotNull DeviceFileEntryNode node) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(13);
        }
        this.startNodeTransfer(node, true);
    }

    private void startNodeUpload(@NotNull DeviceFileEntryNode node) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(14);
        }
        this.startNodeTransfer(node, false);
    }

    private void startNodeTransfer(@NotNull DeviceFileEntryNode node, boolean download) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(15);
        }
        this.myView.startTreeBusyIndicator();
        if (download) {
            node.setDownloading(true);
        } else {
            node.setUploading(true);
        }
        if (this.myTransferringNodes.isEmpty()) {
            this.myTransferringNodesAlarms.addRequest((Runnable)new MyTransferringNodesRepaint(), this.myTransferringNodeRepaintMillis);
        }
        this.myTransferringNodes.add(node);
    }

    private void stopNodeDownload(@NotNull DeviceFileEntryNode node) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(16);
        }
        this.stopNodeTransfer(node, true);
    }

    private void stopNodeUpload(@NotNull DeviceFileEntryNode node) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(17);
        }
        this.stopNodeTransfer(node, false);
    }

    private void stopNodeTransfer(@NotNull DeviceFileEntryNode node, boolean download) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(18);
        }
        this.myView.stopTreeBusyIndicator();
        if (download) {
            node.setDownloading(false);
        } else {
            node.setUploading(false);
        }
        if (this.getTreeModel() != null) {
            this.getTreeModel().nodeChanged(node);
        }
        this.myTransferringNodes.remove(node);
        if (this.myTransferringNodes.isEmpty()) {
            this.myTransferringNodesAlarms.cancelAllRequests();
        }
    }

    private void startLoadChildren(@NotNull DeviceFileEntryNode node) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(19);
        }
        this.myView.startTreeBusyIndicator();
        if (this.myLoadingChildren.isEmpty()) {
            this.myLoadingChildrenAlarms.addRequest((Runnable)new MyLoadingChildrenRepaint(), this.myTransferringNodeRepaintMillis);
        }
        this.myLoadingChildren.add(node);
    }

    private void stopLoadChildren(@NotNull DeviceFileEntryNode node) {
        if (node == null) {
            DeviceExplorerController.$$$reportNull$$$0(20);
        }
        this.myView.stopTreeBusyIndicator();
        this.myLoadingChildren.remove(node);
        if (this.myLoadingChildren.isEmpty()) {
            this.myLoadingChildrenAlarms.cancelAllRequests();
        }
    }

    private boolean checkLongRunningOperationAllowed() {
        return this.myLongRunningOperationTracker == null;
    }

    private void registerLongRunningOperation(@NotNull LongRunningOperationTracker tracker) throws Exception {
        if (tracker == null) {
            DeviceExplorerController.$$$reportNull$$$0(21);
        }
        if (!this.checkLongRunningOperationAllowed()) {
            throw new Exception(DEVICE_EXPLORER_BUSY_MESSAGE);
        }
        this.myLongRunningOperationTracker = tracker;
        Disposer.register((Disposable)this.myLongRunningOperationTracker, () -> {
            assert (ApplicationManager.getApplication().isDispatchThread());
            this.myLongRunningOperationTracker = null;
        });
    }

    public boolean hasActiveDevice() {
        return this.myModel.getActiveDevice() != null;
    }

    @TestOnly
    public void setShowLoadingNodeDelayMillis(int showLoadingNodeDelayMillis) {
        this.myShowLoadingNodeDelayMillis = showLoadingNodeDelayMillis;
    }

    @TestOnly
    public void setTransferringNodeRepaintMillis(int transferringNodeRepaintMillis) {
        this.myTransferringNodeRepaintMillis = transferringNodeRepaintMillis;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOpener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFactory";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setActiveDevice";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "deviceStateUpdated";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshActiveDevice";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "executeFuturesInSequence";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "startNodeDownload";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "startNodeUpload";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "startNodeTransfer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "stopNodeDownload";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "stopNodeUpload";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "stopNodeTransfer";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "startLoadChildren";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "stopLoadChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "registerLongRunningOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileOpener {
        @UiThread
        public void openFile(@NotNull Path var1);

        @UiThread
        public void openFile(@NotNull VirtualFile var1);
    }

    private static class NodeSorting {
        private NodeSorting() {
        }

        @NotNull
        public static Comparator<DeviceFileEntryNode> getEntryNodeComparator() {
            return NodeSorting.getCustomComparator(x -> x.getEntry().getName(), o1 -> o1.getEntry().isDirectory() || o1.isSymbolicLinkToDirectory());
        }

        @NotNull
        public static Comparator<TreeNode> getTreeNodeComparator() {
            Comparator comparator2 = (o1, o2) -> {
                if (o1 instanceof DeviceFileEntryNode && o2 instanceof DeviceFileEntryNode) {
                    return NodeSorting.getEntryNodeComparator().compare((DeviceFileEntryNode)o1, (DeviceFileEntryNode)o2);
                }
                if (o1 instanceof DeviceFileEntryNode) {
                    return 1;
                }
                if (o2 instanceof DeviceFileEntryNode) {
                    return -1;
                }
                return 0;
            };
            if (comparator2 == null) {
                NodeSorting.$$$reportNull$$$0(0);
            }
            return comparator2;
        }

        @NotNull
        public static <V> Comparator<V> getCustomComparator(@NotNull Function<V, String> nameProvider, @NotNull Predicate<V> isDirectory) {
            if (nameProvider == null) {
                NodeSorting.$$$reportNull$$$0(1);
            }
            if (isDirectory == null) {
                NodeSorting.$$$reportNull$$$0(2);
            }
            Comparator comparator2 = (o1, o2) -> {
                boolean isDir2;
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                boolean isDir1 = isDirectory.test(o1);
                if (isDir1 == (isDir2 = isDirectory.test(o2))) {
                    return StringUtil.compare((String)((String)nameProvider.apply(o1)), (String)((String)nameProvider.apply(o2)), (boolean)true);
                }
                if (isDir1) {
                    return -1;
                }
                return 1;
            };
            if (comparator2 == null) {
                NodeSorting.$$$reportNull$$$0(3);
            }
            return comparator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/DeviceExplorerController$NodeSorting";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreeNodeComparator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerController$NodeSorting";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCustomComparator";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyLoadingChildrenRepaint
    implements Runnable {
        private MyLoadingChildrenRepaint() {
        }

        @Override
        public void run() {
            DeviceExplorerController.this.myLoadingChildren.forEach(x -> {
                if (x.getChildCount() == 0) {
                    return;
                }
                TreeNode node = x.getFirstChild();
                if (node instanceof MyLoadingNode) {
                    MyLoadingNode loadingNode = (MyLoadingNode)((Object)((Object)node));
                    loadingNode.incTick();
                    if (DeviceExplorerController.this.getTreeModel() != null) {
                        DeviceExplorerController.this.getTreeModel().nodeChanged((TreeNode)((Object)loadingNode));
                    }
                }
            });
            DeviceExplorerController.this.myLoadingChildrenAlarms.addRequest((Runnable)new MyLoadingChildrenRepaint(), DeviceExplorerController.this.myTransferringNodeRepaintMillis);
        }
    }

    private class MyTransferringNodesRepaint
    implements Runnable {
        private MyTransferringNodesRepaint() {
        }

        @Override
        public void run() {
            DeviceExplorerController.this.myTransferringNodes.forEach(x -> {
                x.incTransferringTick();
                if (DeviceExplorerController.this.getTreeModel() != null) {
                    DeviceExplorerController.this.getTreeModel().nodeChanged((TreeNode)x);
                }
            });
            DeviceExplorerController.this.myTransferringNodesAlarms.addRequest((Runnable)new MyTransferringNodesRepaint(), DeviceExplorerController.this.myTransferringNodeRepaintMillis);
        }
    }

    private static final class ShowLoadingNodeRequest
    implements Runnable {
        @NotNull
        private DefaultTreeModel myTreeModel;
        @NotNull
        private DeviceFileEntryNode myNode;

        private ShowLoadingNodeRequest(@NotNull DefaultTreeModel treeModel, @NotNull DeviceFileEntryNode node) {
            if (treeModel == null) {
                ShowLoadingNodeRequest.$$$reportNull$$$0(0);
            }
            if (node == null) {
                ShowLoadingNodeRequest.$$$reportNull$$$0(1);
            }
            this.myTreeModel = treeModel;
            this.myNode = node;
        }

        @Override
        public void run() {
            this.myNode.setAllowsChildren(true);
            this.myNode.add((MutableTreeNode)((Object)new MyLoadingNode(this.myNode.getEntry())));
            this.myTreeModel.nodeStructureChanged(this.myNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "treeModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/explorer/DeviceExplorerController$ShowLoadingNodeRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ViewListener
    implements DeviceExplorerViewListener {
        private ViewListener() {
        }

        @Override
        public void noDeviceSelected() {
            DeviceExplorerController.this.setNoActiveDevice();
        }

        @Override
        public void deviceSelected(@NotNull DeviceFileSystem device) {
            if (device == null) {
                ViewListener.$$$reportNull$$$0(0);
            }
            DeviceExplorerController.this.setActiveDevice(device);
        }

        @Override
        public void openNodesInEditorInvoked(@NotNull List<DeviceFileEntryNode> treeNodes) {
            if (treeNodes == null) {
                ViewListener.$$$reportNull$$$0(1);
            }
            if (treeNodes.isEmpty()) {
                return;
            }
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(this.getCommonParentNode(treeNodes), DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            DeviceFileSystem device = DeviceExplorerController.this.myModel.getActiveDevice();
            HashMap downloadedNodes = new HashMap();
            DeviceExplorerController.this.myEdtExecutor.executeFuturesInSequence(treeNodes.iterator(), treeNode -> {
                if (downloadedNodes.containsKey(treeNode)) {
                    DeviceExplorerController.this.myFileOpener.openFile((Path)downloadedNodes.get(treeNode));
                    return null;
                }
                if (!Objects.equals(device, DeviceExplorerController.this.myModel.getActiveDevice())) {
                    return Futures.immediateFuture(null);
                }
                if (treeNode.getEntry().isDirectory()) {
                    return Futures.immediateFuture(null);
                }
                if (treeNode.isTransferring()) {
                    DeviceExplorerController.this.myView.reportErrorRelatedToNode((DeviceFileEntryNode)treeNode, "Entry is already downloading or uploading", new RuntimeException());
                    return Futures.immediateFuture(null);
                }
                ListenableFuture<Path> futurePath = this.downloadFileEntryToDefaultLocation((DeviceFileEntryNode)treeNode);
                ListenableFuture done = DeviceExplorerController.this.myEdtExecutor.transform(futurePath, path2 -> {
                    ListenableFuture<VirtualFile> getVirtualFile = DeviceExplorerFilesUtils.findFile(path2);
                    DeviceExplorerController.this.myEdtExecutor.transform(getVirtualFile, virtualFile -> {
                        DeviceExplorerController.this.myFileOpener.openFile((VirtualFile)virtualFile);
                        return null;
                    });
                    return null;
                });
                return DeviceExplorerController.this.myEdtExecutor.catching(done, Throwable.class, t -> {
                    String message2 = String.format("Error opening contents of device file %s", this.getUserFacingNodeName((DeviceFileEntryNode)treeNode));
                    DeviceExplorerController.this.myView.reportErrorRelatedToNode((DeviceFileEntryNode)treeNode, message2, (Throwable)t);
                    return null;
                });
            });
        }

        @Nullable
        private DeviceFileEntryNode getTreeNodeFromEntry(DeviceFileEntryNode treeNode, String entryFullPath) {
            TreeNode treeNodeRoot = this.getTreeNodeRoot(treeNode);
            if (!(treeNodeRoot instanceof DeviceFileEntryNode)) {
                return null;
            }
            DeviceFileEntryNode treeRoot = (DeviceFileEntryNode)treeNodeRoot;
            return this.findDeviceFileEntryNodeFromPath(treeRoot, entryFullPath);
        }

        private TreeNode getTreeNodeRoot(TreeNode node) {
            while (node.getParent() != null) {
                node = node.getParent();
            }
            return node;
        }

        @Nullable
        private DeviceFileEntryNode findDeviceFileEntryNodeFromPath(DeviceFileEntryNode root2, String entryFullPath) {
            List<String> pathComponents = AdbPathUtil.getSegments(entryFullPath);
            if (pathComponents.isEmpty()) {
                return root2;
            }
            DeviceFileEntryNode currentNode = root2;
            for (String segment : pathComponents) {
                if ((currentNode = currentNode.findChildEntry(segment)) != null) continue;
                return null;
            }
            return currentNode;
        }

        @UiThread
        @NotNull
        private ListenableFuture<Path> downloadFileEntryToDefaultLocation(@NotNull DeviceFileEntryNode treeNode) {
            Path localPath;
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(2);
            }
            try {
                localPath = DeviceExplorerController.this.myFileManager.getDefaultLocalPathForEntry(treeNode.getEntry());
            }
            catch (Throwable t) {
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)t);
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(3);
                }
                return listenableFuture;
            }
            ListenableFuture<FileTransferSummary> futureSave = this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNode), tracker -> FutureUtils.ignoreResult(this.downloadFileEntry(treeNode, localPath, (FileTransferOperationTracker)tracker)));
            ListenableFuture listenableFuture = DeviceExplorerController.this.myEdtExecutor.transform(futureSave, summary -> localPath);
            if (listenableFuture == null) {
                ViewListener.$$$reportNull$$$0(4);
            }
            return listenableFuture;
        }

        @Override
        public void saveNodesAsInvoked(@NotNull List<DeviceFileEntryNode> treeNodes) {
            if (treeNodes == null) {
                ViewListener.$$$reportNull$$$0(5);
            }
            if (treeNodes.isEmpty()) {
                return;
            }
            final DeviceFileEntryNode commonParentNode = this.getCommonParentNode(treeNodes);
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(commonParentNode, DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            ListenableFuture<FileTransferSummary> futureSummary = treeNodes.size() == 1 ? this.saveSingleNodeAs(treeNodes.get(0)) : this.saveMultiNodesAs(commonParentNode, treeNodes);
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureSummary, (FutureCallback)new FutureCallback<FileTransferSummary>(){

                public void onSuccess(@Nullable FileTransferSummary result2) {
                    assert (result2 != null);
                    ViewListener.this.reportSaveNodesAsSummary(commonParentNode, result2);
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DeviceExplorerController.this.myView.reportErrorRelatedToNode(commonParentNode, "Error saving file(s) to local file system", t);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener$1", "onFailure"));
                }
            });
        }

        private void reportSaveNodesAsSummary(@NotNull DeviceFileEntryNode node, @NotNull FileTransferSummary summary) {
            if (node == null) {
                ViewListener.$$$reportNull$$$0(6);
            }
            if (summary == null) {
                ViewListener.$$$reportNull$$$0(7);
            }
            this.reportFileTransferSummary(node, summary, "downloaded", "downloading");
        }

        @NotNull
        private ListenableFuture<FileTransferSummary> saveSingleNodeAs(@NotNull DeviceFileEntryNode treeNode) {
            Path localFile;
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(8);
            }
            if (treeNode.getEntry().isDirectory() || treeNode.isSymbolicLinkToDirectory()) {
                Path localDirectory;
                try {
                    localDirectory = this.chooseSaveAsDirectoryPath(treeNode);
                }
                catch (Exception e) {
                    ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
                    if (listenableFuture == null) {
                        ViewListener.$$$reportNull$$$0(9);
                    }
                    return listenableFuture;
                }
                if (localDirectory == null) {
                    ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new CancellationException());
                    if (listenableFuture == null) {
                        ViewListener.$$$reportNull$$$0(10);
                    }
                    return listenableFuture;
                }
                return this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNode), tracker -> this.downloadSingleDirectory(treeNode, localDirectory, (FileTransferOperationTracker)tracker));
            }
            try {
                localFile = this.chooseSaveAsFilePath(treeNode);
            }
            catch (Exception e) {
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(11);
                }
                return listenableFuture;
            }
            if (localFile == null) {
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new CancellationException());
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(12);
                }
                return listenableFuture;
            }
            return this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNode), tracker -> this.downloadSingleFile(treeNode, localFile, (FileTransferOperationTracker)tracker));
        }

        @NotNull
        private ListenableFuture<FileTransferSummary> saveMultiNodesAs(@NotNull DeviceFileEntryNode commonParentNode, @NotNull List<DeviceFileEntryNode> treeNodes) {
            Path localDirectory;
            if (commonParentNode == null) {
                ViewListener.$$$reportNull$$$0(13);
            }
            if (treeNodes == null) {
                ViewListener.$$$reportNull$$$0(14);
            }
            assert (!treeNodes.isEmpty());
            try {
                localDirectory = this.chooseSaveAsDirectoryPath(commonParentNode);
            }
            catch (Exception e) {
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(15);
                }
                return listenableFuture;
            }
            if (localDirectory == null) {
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new CancellationException());
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(16);
                }
                return listenableFuture;
            }
            return this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNodes), tracker -> DeviceExplorerController.this.executeFuturesInSequence(treeNodes.iterator(), treeNode -> {
                Path nodePath = localDirectory.resolve(treeNode.getEntry().getName());
                return this.downloadSingleNode((DeviceFileEntryNode)treeNode, nodePath, (FileTransferOperationTracker)tracker);
            }));
        }

        @UiThread
        @NotNull
        private ListenableFuture<FileTransferSummary> wrapFileTransfer(@NotNull Function<FileTransferOperationTracker, ListenableFuture<Void>> prepareTransfer, @NotNull Function<FileTransferOperationTracker, ListenableFuture<Void>> performTransfer) {
            if (prepareTransfer == null) {
                ViewListener.$$$reportNull$$$0(17);
            }
            if (performTransfer == null) {
                ViewListener.$$$reportNull$$$0(18);
            }
            FileTransferOperationTracker tracker = new FileTransferOperationTracker(DeviceExplorerController.this.myView);
            try {
                DeviceExplorerController.this.registerLongRunningOperation(tracker);
            }
            catch (Exception e) {
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(19);
                }
                return listenableFuture;
            }
            tracker.start();
            tracker.setCalculatingText(0, 0);
            tracker.setIndeterminate(true);
            Disposer.register((Disposable)DeviceExplorerController.this.myProject, (Disposable)tracker);
            DeviceExplorerController.this.myView.startTreeBusyIndicator();
            ListenableFuture<Void> futurePrepare = prepareTransfer.apply(tracker);
            ListenableFuture futureTransfer = DeviceExplorerController.this.myEdtExecutor.transformAsync(futurePrepare, aVoid -> {
                tracker.setIndeterminate(false);
                return (ListenableFuture)performTransfer.apply(tracker);
            });
            DeviceExplorerController.this.myEdtExecutor.addListener(futureTransfer, DeviceExplorerController.this.myView::stopTreeBusyIndicator);
            DeviceExplorerController.this.myEdtExecutor.addListener(futureTransfer, () -> Disposer.dispose((Disposable)tracker));
            ListenableFuture listenableFuture = DeviceExplorerController.this.myEdtExecutor.transform(futureTransfer, aVoid -> tracker.getSummary());
            if (listenableFuture == null) {
                ViewListener.$$$reportNull$$$0(20);
            }
            return listenableFuture;
        }

        public ListenableFuture<Void> addUploadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull List<Path> files2) {
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(21);
            }
            if (files2 == null) {
                ViewListener.$$$reportNull$$$0(22);
            }
            return DeviceExplorerController.this.executeFuturesInSequence(files2.iterator(), x -> this.addUploadOperationWork(tracker, (Path)x));
        }

        public ListenableFuture<Void> addUploadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull Path path2) {
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(23);
            }
            if (path2 == null) {
                ViewListener.$$$reportNull$$$0(24);
            }
            FileTransferWorkEstimatorProgress progress = this.createFileTransferEstimatorProgress(tracker);
            ListenableFuture<FileTransferWorkEstimate> futureWork = DeviceExplorerController.this.myWorkEstimator.estimateUploadWork(path2, progress);
            return DeviceExplorerController.this.myEdtExecutor.transform(futureWork, work -> {
                assert (work != null);
                tracker.addWorkEstimate((FileTransferWorkEstimate)work);
                return null;
            });
        }

        public ListenableFuture<Void> addDownloadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull List<DeviceFileEntryNode> entryNodes) {
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(25);
            }
            if (entryNodes == null) {
                ViewListener.$$$reportNull$$$0(26);
            }
            return DeviceExplorerController.this.executeFuturesInSequence(entryNodes.iterator(), node -> this.addDownloadOperationWork(tracker, (DeviceFileEntryNode)node));
        }

        public ListenableFuture<Void> addDownloadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull DeviceFileEntryNode entryNode) {
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(27);
            }
            if (entryNode == null) {
                ViewListener.$$$reportNull$$$0(28);
            }
            FileTransferWorkEstimatorProgress progress = this.createFileTransferEstimatorProgress(tracker);
            ListenableFuture<FileTransferWorkEstimate> futureEstimate = DeviceExplorerController.this.myWorkEstimator.estimateDownloadWork(entryNode.getEntry(), entryNode.isSymbolicLinkToDirectory(), progress);
            return DeviceExplorerController.this.myEdtExecutor.transform(futureEstimate, estimate -> {
                assert (estimate != null);
                tracker.addWorkEstimate((FileTransferWorkEstimate)estimate);
                return null;
            });
        }

        @NotNull
        private FileTransferWorkEstimatorProgress createFileTransferEstimatorProgress(final @NotNull FileTransferOperationTracker tracker) {
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(29);
            }
            return new FileTransferWorkEstimatorProgress(){

                @Override
                public void progress(int fileCount2, int directoryCount) {
                    tracker.setCalculatingText(fileCount2, directoryCount);
                }

                @Override
                public boolean isCancelled() {
                    return tracker.isCancelled();
                }
            };
        }

        @NotNull
        private ListenableFuture<Void> downloadSingleNode(@NotNull DeviceFileEntryNode node, @NotNull Path localPath, @NotNull FileTransferOperationTracker tracker) {
            if (node == null) {
                ViewListener.$$$reportNull$$$0(30);
            }
            if (localPath == null) {
                ViewListener.$$$reportNull$$$0(31);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(32);
            }
            if (node.getEntry().isDirectory()) {
                return this.downloadSingleDirectory(node, localPath, tracker);
            }
            return this.downloadSingleFile(node, localPath, tracker);
        }

        @NotNull
        private ListenableFuture<Void> downloadSingleFile(@NotNull DeviceFileEntryNode treeNode, @NotNull Path localPath, @NotNull FileTransferOperationTracker tracker) {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(33);
            }
            if (localPath == null) {
                ViewListener.$$$reportNull$$$0(34);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(35);
            }
            assert (!treeNode.getEntry().isDirectory());
            if (treeNode.isTransferring()) {
                tracker.addProblem(new Exception(String.format("File %s is already downloading or uploading", this.getUserFacingNodeName(treeNode))));
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(36);
                }
                return listenableFuture;
            }
            ListenableFuture<Long> futureEntrySize = this.downloadFileEntry(treeNode, localPath, tracker);
            SettableFuture futureResult = SettableFuture.create();
            DeviceExplorerController.this.myEdtExecutor.addConsumer(futureEntrySize, (byteCount, throwable) -> {
                if (throwable != null) {
                    tracker.addProblem(new Exception(String.format("Error saving contents of device file %s", this.getUserFacingNodeName(treeNode)), (Throwable)throwable));
                } else {
                    tracker.getSummary().addFileCount(1);
                    tracker.getSummary().addByteCount((long)byteCount);
                }
                futureResult.set(null);
            });
            SettableFuture settableFuture = futureResult;
            if (settableFuture == null) {
                ViewListener.$$$reportNull$$$0(37);
            }
            return settableFuture;
        }

        @NotNull
        private ListenableFuture<Void> downloadSingleDirectory(final @NotNull DeviceFileEntryNode treeNode, final @NotNull Path localDirectoryPath, final @NotNull FileTransferOperationTracker tracker) {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(38);
            }
            if (localDirectoryPath == null) {
                ViewListener.$$$reportNull$$$0(39);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(40);
            }
            assert (treeNode.getEntry().isDirectory() || treeNode.isSymbolicLinkToDirectory());
            if (tracker.isCancelled()) {
                ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(41);
                }
                return listenableFuture;
            }
            tracker.processDirectory();
            try {
                FileUtils.mkdirs((File)localDirectoryPath.toFile());
            }
            catch (Exception e) {
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(42);
                }
                return listenableFuture;
            }
            tracker.getSummary().addDirectoryCount(1);
            final SettableFuture futureResult = SettableFuture.create();
            ListenableFuture<Void> futureLoadChildren = this.loadNodeChildren(treeNode);
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureLoadChildren, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result2) {
                    ListenableFuture<Void> futureDownloadChildren = DeviceExplorerController.this.executeFuturesInSequence(treeNode.getChildEntryNodes().iterator(), node -> {
                        Path nodePath = localDirectoryPath.resolve(node.getEntry().getName());
                        return ViewListener.this.downloadSingleNode((DeviceFileEntryNode)node, nodePath, tracker);
                    });
                    DeviceExplorerController.this.myEdtExecutor.addConsumer(futureDownloadChildren, (aVoid, throwable) -> {
                        if (throwable != null) {
                            tracker.addProblem((Throwable)throwable);
                        }
                        futureResult.set(null);
                    });
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    tracker.addProblem(t);
                    futureResult.set(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener$3", "onFailure"));
                }
            });
            SettableFuture settableFuture = futureResult;
            if (settableFuture == null) {
                ViewListener.$$$reportNull$$$0(43);
            }
            return settableFuture;
        }

        @Override
        public void copyNodePathsInvoked(@NotNull List<DeviceFileEntryNode> treeNodes) {
            if (treeNodes == null) {
                ViewListener.$$$reportNull$$$0(44);
            }
            String text = treeNodes.stream().map(x -> x.getEntry().getFullPath()).collect(Collectors.joining("\n"));
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
        }

        @Override
        public void newFileInvoked(@NotNull DeviceFileEntryNode parentTreeNode) {
            if (parentTreeNode == null) {
                ViewListener.$$$reportNull$$$0(45);
            }
            this.newFileOrDirectory(parentTreeNode, "NewTextFile.txt", UIBundle.message((String)"new.file.dialog.title", (Object[])new Object[0]), UIBundle.message((String)"create.new.file.enter.new.file.name.prompt.text", (Object[])new Object[0]), UIBundle.message((String)"create.new.file.file.name.cannot.be.empty.error.message", (Object[])new Object[0]), x -> UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{x}), x -> parentTreeNode.getEntry().createNewFile((String)x));
        }

        @Override
        public void synchronizeNodesInvoked(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                ViewListener.$$$reportNull$$$0(46);
            }
            if (nodes.isEmpty()) {
                return;
            }
            Set directoryNodes = nodes.stream().map(x -> {
                if (x.isSymbolicLinkToDirectory() || x.getEntry().isDirectory()) {
                    return x;
                }
                return DeviceFileEntryNode.fromNode(x.getParent());
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            directoryNodes = directoryNodes.stream().flatMap(node -> {
                ArrayList<DeviceFileEntryNode> nodesToSynchronize = new ArrayList<DeviceFileEntryNode>();
                Stack<DeviceFileEntryNode> stack = new Stack<DeviceFileEntryNode>();
                stack.push((DeviceFileEntryNode)node);
                while (!stack.isEmpty()) {
                    DeviceFileEntryNode currentNode = (DeviceFileEntryNode)stack.pop();
                    nodesToSynchronize.add(currentNode);
                    currentNode.getChildEntryNodes().stream().filter(x -> x.getEntry().isDirectory() || x.isSymbolicLinkToDirectory()).filter(DeviceFileEntryNode::isLoaded).forEach(stack::push);
                }
                return nodesToSynchronize.stream();
            }).collect(Collectors.toSet());
            DeviceExplorerController.this.myView.startTreeBusyIndicator();
            ListenableFuture<Void> futuresRefresh = DeviceExplorerController.this.executeFuturesInSequence(directoryNodes.iterator(), treeNode -> {
                treeNode.setLoaded(false);
                return this.loadNodeChildren((DeviceFileEntryNode)treeNode);
            });
            DeviceExplorerController.this.myEdtExecutor.addListener(futuresRefresh, DeviceExplorerController.this.myView::stopTreeBusyIndicator);
        }

        @Override
        public void deleteNodesInvoked(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                ViewListener.$$$reportNull$$$0(47);
            }
            if (nodes.isEmpty()) {
                return;
            }
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(this.getCommonParentNode(nodes), DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            List<DeviceFileEntry> fileEntries = nodes.stream().map(DeviceFileEntryNode::getEntry).collect(Collectors.toList());
            String message2 = this.createDeleteConfirmationMessage(fileEntries);
            int returnValue = Messages.showOkCancelDialog((String)message2, (String)UIBundle.message((String)"delete.dialog.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (returnValue != 0) {
                return;
            }
            fileEntries.sort(Comparator.comparing(DeviceFileEntry::getFullPath));
            LinkedList<String> problems = new LinkedList<String>();
            for (DeviceFileEntry fileEntry : fileEntries) {
                ListenableFuture<Void> futureDelete = fileEntry.delete();
                try {
                    futureDelete.get(10000L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    LOGGER.info(String.format("Error deleting file \"%s\"", fileEntry.getFullPath()), t);
                    String problemMessage = ExceptionUtil.getRootCause((Throwable)t).getMessage();
                    if (StringUtil.isEmpty((String)problemMessage)) {
                        problemMessage = "Error deleting file";
                    }
                    problemMessage = String.format("%s: %s", fileEntry.getFullPath(), problemMessage);
                    problems.add(problemMessage);
                }
            }
            if (!problems.isEmpty()) {
                this.reportDeletionProblem(problems);
            }
            Set parentsToRefresh = nodes.stream().map(x -> DeviceFileEntryNode.fromNode(x.getParent())).filter(Objects::nonNull).collect(Collectors.toSet());
            DeviceExplorerController.this.executeFuturesInSequence(parentsToRefresh.iterator(), parentNode -> {
                parentNode.setLoaded(false);
                return this.loadNodeChildren((DeviceFileEntryNode)parentNode);
            });
        }

        private void reportDeletionProblem(@NotNull List<String> problems) {
            if (problems == null) {
                ViewListener.$$$reportNull$$$0(48);
            }
            if (problems.size() == 1) {
                Messages.showMessageDialog((String)("Could not erase file or folder:\n" + problems.get(0)), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return;
            }
            boolean more = false;
            if (problems.size() > 10) {
                problems = problems.subList(0, 10);
                more = true;
            }
            Messages.showMessageDialog((String)("Could not erase files or folders:\n  " + StringUtil.join(problems, (String)",\n  ") + (more ? "\n  ..." : "")), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }

        private String createDeleteConfirmationMessage(@NotNull List<DeviceFileEntry> filesToDelete) {
            if (filesToDelete == null) {
                ViewListener.$$$reportNull$$$0(49);
            }
            if (filesToDelete.size() == 1) {
                if (filesToDelete.get(0).isDirectory()) {
                    return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folder.confirmation.message", (Object[])new Object[]{filesToDelete.get(0).getName()});
                }
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.file.confirmation.message", (Object[])new Object[]{filesToDelete.get(0).getName()});
            }
            boolean hasFiles = false;
            boolean hasFolders = false;
            for (DeviceFileEntry file : filesToDelete) {
                boolean isDirectory = file.isDirectory();
                hasFiles |= !isDirectory;
                hasFolders |= isDirectory;
            }
            if (hasFiles && hasFolders) {
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.directories.confirmation.message", (Object[])new Object[]{filesToDelete.size()});
            }
            if (hasFolders) {
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folders.confirmation.message", (Object[])new Object[]{filesToDelete.size()});
            }
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.files.confirmation.message", (Object[])new Object[]{filesToDelete.size()});
        }

        @Override
        public void newDirectoryInvoked(@NotNull DeviceFileEntryNode parentTreeNode) {
            if (parentTreeNode == null) {
                ViewListener.$$$reportNull$$$0(50);
            }
            this.newFileOrDirectory(parentTreeNode, "NewFolder", UIBundle.message((String)"new.folder.dialog.title", (Object[])new Object[0]), UIBundle.message((String)"create.new.folder.enter.new.folder.name.prompt.text", (Object[])new Object[0]), UIBundle.message((String)"create.new.folder.folder.name.cannot.be.empty.error.message", (Object[])new Object[0]), x -> UIBundle.message((String)"create.new.folder.could.not.create.folder.error.message", (Object[])new Object[]{x}), x -> parentTreeNode.getEntry().createNewDirectory((String)x));
        }

        private void newFileOrDirectory(@NotNull DeviceFileEntryNode parentTreeNode, @NotNull String initialName, @NotNull String title, @NotNull String prompt, final @NotNull String emptyErrorMessage, @NotNull Function<String, String> errorMessage, @NotNull Function<String, ListenableFuture<Void>> createFunction) {
            DefaultTreeModel treeModel;
            if (parentTreeNode == null) {
                ViewListener.$$$reportNull$$$0(51);
            }
            if (initialName == null) {
                ViewListener.$$$reportNull$$$0(52);
            }
            if (title == null) {
                ViewListener.$$$reportNull$$$0(53);
            }
            if (prompt == null) {
                ViewListener.$$$reportNull$$$0(54);
            }
            if (emptyErrorMessage == null) {
                ViewListener.$$$reportNull$$$0(55);
            }
            if (errorMessage == null) {
                ViewListener.$$$reportNull$$$0(56);
            }
            if (createFunction == null) {
                ViewListener.$$$reportNull$$$0(57);
            }
            if ((treeModel = DeviceExplorerController.this.getTreeModel()) == null) {
                return;
            }
            while (true) {
                String newFileName;
                if ((newFileName = Messages.showInputDialog((String)prompt, (String)title, (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)new InputValidatorEx(){

                    @Nullable
                    public String getErrorText(String inputString) {
                        if (StringUtil.isEmpty((String)inputString.trim())) {
                            return emptyErrorMessage;
                        }
                        if (inputString.contains("/")) {
                            return "Path cannot contain \"/\" characters";
                        }
                        return null;
                    }

                    public boolean checkInput(String inputString) {
                        return this.canClose(inputString);
                    }

                    public boolean canClose(String inputString) {
                        return !StringUtil.isEmpty((String)inputString.trim());
                    }
                })) == null) {
                    return;
                }
                ListenableFuture<Void> futureResult = createFunction.apply(newFileName);
                try {
                    futureResult.get(10000L, TimeUnit.MILLISECONDS);
                    parentTreeNode.setLoaded(false);
                    ListenableFuture<Void> futureLoad = this.loadNodeChildren(parentTreeNode);
                    DeviceExplorerController.this.myEdtExecutor.addListener(futureLoad, () -> DeviceExplorerController.this.myView.expandNode(parentTreeNode));
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    this.showErrorMessage(errorMessage.apply(newFileName), e);
                    initialName = newFileName;
                    continue;
                }
                break;
            }
        }

        private void showErrorMessage(@NotNull String message2, @NotNull Throwable error) {
            if (message2 == null) {
                ViewListener.$$$reportNull$$$0(58);
            }
            if (error == null) {
                ViewListener.$$$reportNull$$$0(59);
            }
            if (error instanceof ExecutionException && error.getCause() != null) {
                error = error.getCause();
            }
            if (error.getMessage() != null) {
                message2 = (String)message2 + ":\n" + error.getMessage();
            }
            Messages.showMessageDialog((String)message2, (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }

        @Override
        public void uploadFilesInvoked(final @NotNull DeviceFileEntryNode treeNode) {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(60);
            }
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(treeNode, DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
            AtomicReference filesRef = new AtomicReference();
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)DeviceExplorerController.this.myProject, null, filesRef::set);
            if (filesRef.get() == null || ((List)filesRef.get()).isEmpty()) {
                return;
            }
            ListenableFuture<FileTransferSummary> futureSummary = this.wrapFileTransfer(tracker -> {
                List<Path> paths = ((List)filesRef.get()).stream().map(x -> Paths.get(x.getPath(), new String[0])).collect(Collectors.toList());
                return this.addUploadOperationWork((FileTransferOperationTracker)tracker, paths);
            }, tracker -> this.uploadVirtualFiles(treeNode, (List)filesRef.get(), (FileTransferOperationTracker)tracker));
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureSummary, (FutureCallback)new FutureCallback<FileTransferSummary>(){

                public void onSuccess(@Nullable FileTransferSummary result2) {
                    assert (result2 != null);
                    ViewListener.this.reportUploadFilesSummary(treeNode, result2);
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    DeviceExplorerController.this.myView.reportErrorRelatedToNode(treeNode, "Error uploading files(s) to device", t);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener$5", "onFailure"));
                }
            });
        }

        private void reportUploadFilesSummary(@NotNull DeviceFileEntryNode treeNode, @NotNull FileTransferSummary summary) {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(61);
            }
            if (summary == null) {
                ViewListener.$$$reportNull$$$0(62);
            }
            this.reportFileTransferSummary(treeNode, summary, "uploaded", "uploading");
        }

        private ListenableFuture<Void> uploadVirtualFiles(@NotNull DeviceFileEntryNode parentNode, @NotNull List<VirtualFile> files2, @NotNull FileTransferOperationTracker tracker) {
            if (parentNode == null) {
                ViewListener.$$$reportNull$$$0(63);
            }
            if (files2 == null) {
                ViewListener.$$$reportNull$$$0(64);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(65);
            }
            ListenableFuture<Void> futureUploadFiles = DeviceExplorerController.this.executeFuturesInSequence(files2.iterator(), file -> this.uploadVirtualFile(parentNode, (VirtualFile)file, tracker));
            return DeviceExplorerController.this.myEdtExecutor.transformAsync(futureUploadFiles, aVoid -> {
                parentNode.setLoaded(false);
                return this.loadNodeChildren(parentNode);
            });
        }

        @NotNull
        private ListenableFuture<Void> uploadVirtualFile(@NotNull DeviceFileEntryNode treeNode, @NotNull VirtualFile file, @NotNull FileTransferOperationTracker tracker) {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(66);
            }
            if (file == null) {
                ViewListener.$$$reportNull$$$0(67);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(68);
            }
            if (file.isDirectory()) {
                return this.uploadDirectory(treeNode, file, tracker);
            }
            return this.uploadFile(treeNode, file, tracker);
        }

        @NotNull
        private ListenableFuture<Void> uploadDirectory(final @NotNull DeviceFileEntryNode parentNode, final @NotNull VirtualFile file, final @NotNull FileTransferOperationTracker tracker) {
            if (parentNode == null) {
                ViewListener.$$$reportNull$$$0(69);
            }
            if (file == null) {
                ViewListener.$$$reportNull$$$0(70);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(71);
            }
            if (tracker.isCancelled()) {
                ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(72);
                }
                return listenableFuture;
            }
            tracker.processDirectory();
            tracker.getSummary().addDirectoryCount(1);
            final SettableFuture futureResult = SettableFuture.create();
            DeviceFileEntry parentEntry = parentNode.getEntry();
            final String directoryName = file.getName();
            ListenableFuture<Void> futureDirectory = parentEntry.createNewDirectory(directoryName);
            DeviceExplorerController.this.myEdtExecutor.addConsumer(futureDirectory, (aVoid, createDirectoryError) -> {
                parentNode.setLoaded(false);
                ListenableFuture<Void> futureLoadChildren = this.loadNodeChildren(parentNode);
                DeviceExplorerController.this.myEdtExecutor.addCallback(futureLoadChildren, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void result2) {
                        DeviceFileEntryNode childNode = parentNode.findChildEntry(directoryName);
                        if (childNode == null) {
                            if (createDirectoryError != null) {
                                tracker.addProblem(createDirectoryError);
                            } else {
                                tracker.addProblem(new Exception(String.format("Error creating directory \"%s\"", directoryName)));
                            }
                            futureResult.set(null);
                            return;
                        }
                        List<VirtualFile> childFiles = Arrays.stream(file.getChildren()).filter(x -> !x.getName().startsWith(".")).collect(Collectors.toList());
                        ListenableFuture<Void> futureFileUploads = ViewListener.this.uploadVirtualFiles(childNode, childFiles, tracker);
                        DeviceExplorerController.this.myEdtExecutor.addListener(futureFileUploads, () -> futureResult.set(null));
                    }

                    public void onFailure(@NotNull Throwable t) {
                        if (t == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        tracker.addProblem(t);
                        futureResult.set(null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener$6", "onFailure"));
                    }
                });
            });
            SettableFuture settableFuture = futureResult;
            if (settableFuture == null) {
                ViewListener.$$$reportNull$$$0(73);
            }
            return settableFuture;
        }

        @NotNull
        private ListenableFuture<Void> uploadFile(final @NotNull DeviceFileEntryNode parentNode, final @NotNull VirtualFile file, final @NotNull FileTransferOperationTracker tracker) {
            if (parentNode == null) {
                ViewListener.$$$reportNull$$$0(74);
            }
            if (file == null) {
                ViewListener.$$$reportNull$$$0(75);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(76);
            }
            if (tracker.isCancelled()) {
                ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(77);
                }
                return listenableFuture;
            }
            tracker.processFile();
            tracker.setUploadFileText(file, 0L, 0L);
            SettableFuture futureResult = SettableFuture.create();
            this.logFuture((ListenableFuture)futureResult, millis -> String.format(Locale.US, "Uploaded file in %,d msec: %s", millis, AdbPathUtil.resolve(parentNode.getEntry().getFullPath(), file.getName())));
            DeviceFileEntry parentEntry = parentNode.getEntry();
            final Path localPath = Paths.get(file.getPath(), new String[0]);
            final UploadFileState uploadState = new UploadFileState();
            ListenableFuture<Void> futureUpload = parentEntry.uploadFile(localPath, new FileTransferProgress(){
                private long previousBytes;

                @Override
                public void progress(long currentBytes, long totalBytes) {
                    tracker.processFileBytes(currentBytes - this.previousBytes);
                    tracker.setUploadFileText(file, currentBytes, totalBytes);
                    this.previousBytes = currentBytes;
                    uploadState.byteCount = totalBytes;
                    if (uploadState.childNode == null) {
                        String fileName = localPath.getFileName().toString();
                        uploadState.childNode = parentNode.findChildEntry(fileName);
                        if (uploadState.childNode != null) {
                            DeviceExplorerController.this.startNodeUpload(uploadState.childNode);
                        }
                    }
                    if (uploadState.childNode != null) {
                        uploadState.childNode.setTransferProgress(currentBytes, totalBytes);
                        return;
                    }
                    if (uploadState.loadChildrenFuture != null && uploadState.loadChildrenFuture.isDone()) {
                        uploadState.loadChildrenFuture = null;
                    }
                    if (currentBytes > 0L && uploadState.loadChildrenFuture == null) {
                        parentNode.setLoaded(false);
                        uploadState.loadChildrenFuture = ViewListener.this.loadNodeChildren(parentNode);
                    }
                }

                @Override
                public boolean isCancelled() {
                    return tracker.isCancelled();
                }
            });
            DeviceExplorerController.this.myEdtExecutor.addConsumer(futureUpload, (aVoid, throwable) -> {
                futureResult.set(null);
                if (throwable != null) {
                    tracker.addProblem((Throwable)throwable);
                } else {
                    tracker.getSummary().addFileCount(1);
                    tracker.getSummary().addByteCount(uploadState.byteCount);
                }
                if (uploadState.childNode != null) {
                    DeviceExplorerController.this.stopNodeUpload(uploadState.childNode);
                }
            });
            SettableFuture settableFuture = futureResult;
            if (settableFuture == null) {
                ViewListener.$$$reportNull$$$0(78);
            }
            return settableFuture;
        }

        private void reportFileTransferSummary(@NotNull DeviceFileEntryNode node, @NotNull FileTransferSummary summary, @NotNull String pastParticiple, @NotNull String presentParticiple) {
            if (node == null) {
                ViewListener.$$$reportNull$$$0(79);
            }
            if (summary == null) {
                ViewListener.$$$reportNull$$$0(80);
            }
            if (pastParticiple == null) {
                ViewListener.$$$reportNull$$$0(81);
            }
            if (presentParticiple == null) {
                ViewListener.$$$reportNull$$$0(82);
            }
            String fileString = StringUtil.pluralize((String)"file", (int)summary.getFileCount());
            String directoryString = StringUtil.pluralize((String)"directory", (int)summary.getDirectoryCount());
            String byteCountString = StringUtil.pluralize((String)"byte", (int)Ints.saturatedCast((long)summary.getByteCount()));
            if (summary.getProblems().isEmpty()) {
                String successMessage = summary.getDirectoryCount() > 0 ? String.format(Locale.getDefault(), "Successfully %s %,d %s and %,d %s for a total size of %,d %s in %s.", pastParticiple, summary.getFileCount(), fileString, summary.getDirectoryCount(), directoryString, summary.getByteCount(), byteCountString, StringUtil.formatDuration((long)summary.getDurationMillis())) : String.format(Locale.getDefault(), "Successfully %s %,d %s for a total of size of %,d %s in %s.", pastParticiple, summary.getFileCount(), fileString, summary.getByteCount(), byteCountString, StringUtil.formatDuration((long)summary.getDurationMillis()));
                DeviceExplorerController.this.myView.reportMessageRelatedToNode(node, successMessage);
                return;
            }
            List problems = summary.getProblems().stream().map(x -> ExceptionUtil.getRootCause((Throwable)x).getMessage()).filter(Objects::nonNull).collect(Collectors.toList());
            boolean more = false;
            if (problems.size() > 10) {
                problems = problems.subList(0, 10);
                more = true;
            }
            Object message2 = String.format("There were errors %s files and/or directories", presentParticiple);
            if (summary.getFileCount() > 0) {
                message2 = (String)message2 + String.format(Locale.getDefault(), ", although %,d %s %s successfully %s in %s for a total of size of %,d %s", summary.getFileCount(), fileString, summary.getFileCount() <= 1 ? "was" : "were", pastParticiple, StringUtil.formatDuration((long)summary.getDurationMillis()), summary.getByteCount(), byteCountString);
            }
            DeviceExplorerController.this.myView.reportErrorRelatedToNode(node, (String)message2, new Exception("\n  " + StringUtil.join(problems, (String)",\n  ") + (more ? "\n  ..." : "")));
        }

        @NotNull
        private DeviceFileEntryNode getCommonParentNode(@NotNull List<DeviceFileEntryNode> treeNodes) {
            TreePath commonPath;
            if (treeNodes == null) {
                ViewListener.$$$reportNull$$$0(83);
            }
            LOGGER.assertTrue((commonPath = TreeUtil.getCommonPath(treeNodes)) != null);
            DeviceFileEntryNode result2 = DeviceFileEntryNode.fromNode(commonPath.getLastPathComponent());
            LOGGER.assertTrue(result2 != null);
            DeviceFileEntryNode deviceFileEntryNode = result2;
            if (deviceFileEntryNode == null) {
                ViewListener.$$$reportNull$$$0(84);
            }
            return deviceFileEntryNode;
        }

        private <V> void logFuture(@NotNull ListenableFuture<V> future2, @NotNull Function<Long, String> message2) {
            if (future2 == null) {
                ViewListener.$$$reportNull$$$0(85);
            }
            if (message2 == null) {
                ViewListener.$$$reportNull$$$0(86);
            }
            long startNano = System.nanoTime();
            DeviceExplorerController.this.myEdtExecutor.addListener(future2, () -> {
                long endNano = System.nanoTime();
                LOGGER.trace((String)message2.apply((endNano - startNano) / 1000000L));
            });
        }

        @Nullable
        private Path chooseSaveAsFilePath(@NotNull DeviceFileEntryNode treeNode) throws Exception {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(87);
            }
            DeviceFileEntry entry = treeNode.getEntry();
            Path localPath = DeviceExplorerController.this.myFileManager.getDefaultLocalPathForEntry(entry);
            FileUtils.mkdirs((File)localPath.getParent().toFile());
            VirtualFile baseDir = VfsUtil.findFileByIoFile((File)localPath.getParent().toFile(), (boolean)true);
            if (baseDir == null) {
                throw new Exception(String.format("Unable to locate file \"%s\"", localPath.getParent()));
            }
            FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[0]);
            FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, DeviceExplorerController.this.myProject);
            VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir, localPath.getFileName().toString());
            if (fileWrapper == null) {
                throw new CancellationException();
            }
            return fileWrapper.getFile().toPath();
        }

        @Nullable
        private Path chooseSaveAsDirectoryPath(@NotNull DeviceFileEntryNode treeNode) throws Exception {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(88);
            }
            DeviceFileEntry entry = treeNode.getEntry();
            Path localPath = DeviceExplorerController.this.myFileManager.getDefaultLocalPathForEntry(entry);
            FileUtils.mkdirs((File)localPath.toFile());
            VirtualFile localDir = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (localDir == null) {
                throw new Exception(String.format("Unable to locate directory \"%s\"", localPath.getParent()));
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            AtomicReference result2 = new AtomicReference();
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)DeviceExplorerController.this.myProject, (VirtualFile)localDir, files2 -> {
                if (files2.size() == 1) {
                    Path path2 = Paths.get(((VirtualFile)files2.get(0)).getPath(), new String[0]);
                    result2.set(path2);
                }
            });
            return (Path)result2.get();
        }

        @NotNull
        private ListenableFuture<Long> downloadFileEntry(final @NotNull DeviceFileEntryNode treeNode, @NotNull Path localPath, final @NotNull FileTransferOperationTracker tracker) {
            if (treeNode == null) {
                ViewListener.$$$reportNull$$$0(89);
            }
            if (localPath == null) {
                ViewListener.$$$reportNull$$$0(90);
            }
            if (tracker == null) {
                ViewListener.$$$reportNull$$$0(91);
            }
            if (tracker.isCancelled()) {
                ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
                if (listenableFuture == null) {
                    ViewListener.$$$reportNull$$$0(92);
                }
                return listenableFuture;
            }
            tracker.processFile();
            DeviceFileEntry entry = treeNode.getEntry();
            final AtomicReference<Long> sizeRef = new AtomicReference<Long>(0L);
            ListenableFuture<DownloadedFileData> futureDownload = DeviceExplorerController.this.myFileManager.downloadFileEntry(entry, localPath, new DownloadProgress(){
                private long previousBytes;

                @Override
                public void onStarting(@NotNull String entryFullPath) {
                    if (entryFullPath == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    DeviceFileEntryNode currentNode = ViewListener.this.getTreeNodeFromEntry(treeNode, entryFullPath);
                    assert (currentNode != null);
                    this.previousBytes = 0L;
                    DeviceExplorerController.this.startNodeDownload(currentNode);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onProgress(@NotNull String entryFullPath, long currentBytes, long l) {
                    void totalBytes;
                    if (entryFullPath == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    DeviceFileEntryNode currentNode = ViewListener.this.getTreeNodeFromEntry(treeNode, entryFullPath);
                    assert (currentNode != null);
                    tracker.processFileBytes(currentBytes - this.previousBytes);
                    this.previousBytes = currentBytes;
                    tracker.setDownloadFileText(entryFullPath, currentBytes, (long)totalBytes);
                    currentNode.setTransferProgress(currentBytes, (long)totalBytes);
                }

                @Override
                public void onCompleted(@NotNull String entryFullPath) {
                    if (entryFullPath == null) {
                        8.$$$reportNull$$$0(2);
                    }
                    DeviceFileEntryNode currentNode = ViewListener.this.getTreeNodeFromEntry(treeNode, entryFullPath);
                    assert (currentNode != null);
                    sizeRef.set((Long)sizeRef.get() + this.previousBytes);
                    DeviceExplorerController.this.stopNodeDownload(currentNode);
                }

                @Override
                public boolean isCancelled() {
                    return tracker.isCancelled();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "entryFullPath";
                    objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener$8";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStarting";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onProgress";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCompleted";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.logFuture(futureDownload, millis -> String.format(Locale.US, "Downloaded file in %,d msec: %s", millis, entry.getFullPath()));
            ListenableFuture listenableFuture = DeviceExplorerController.this.myEdtExecutor.transform(futureDownload, aVoid -> (Long)sizeRef.get());
            if (listenableFuture == null) {
                ViewListener.$$$reportNull$$$0(93);
            }
            return listenableFuture;
        }

        @Override
        public void treeNodeExpanding(@NotNull DeviceFileEntryNode node) {
            if (node == null) {
                ViewListener.$$$reportNull$$$0(94);
            }
            this.loadNodeChildren(node);
        }

        private ListenableFuture<Void> loadNodeChildren(final @NotNull DeviceFileEntryNode node) {
            if (node == null) {
                ViewListener.$$$reportNull$$$0(95);
            }
            if (node.isLoaded()) {
                return Futures.immediateFuture(null);
            }
            node.setLoaded(true);
            if (node.isLeaf()) {
                return Futures.immediateFuture(null);
            }
            final DefaultTreeModel treeModel = DeviceExplorerController.this.getTreeModel();
            final DefaultTreeSelectionModel treeSelectionModel = DeviceExplorerController.this.getTreeSelectionModel();
            if (treeModel == null || treeSelectionModel == null) {
                return Futures.immediateFuture(null);
            }
            DeviceFileSystem fileSystem = DeviceExplorerController.this.myModel.getActiveDevice();
            if (!Objects.equals(fileSystem, node.getEntry().getFileSystem())) {
                return Futures.immediateFuture(null);
            }
            ShowLoadingNodeRequest showLoadingNode = new ShowLoadingNodeRequest(treeModel, node);
            DeviceExplorerController.this.myLoadingNodesAlarms.addRequest((Runnable)showLoadingNode, DeviceExplorerController.this.myShowLoadingNodeDelayMillis);
            DeviceExplorerController.this.startLoadChildren(node);
            ListenableFuture<List<DeviceFileEntry>> futureEntries = node.getEntry().getEntries();
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureEntries, (FutureCallback)new FutureCallback<List<DeviceFileEntry>>(){

                public void onSuccess(List<DeviceFileEntry> result2) {
                    if (!Objects.equals(treeModel, DeviceExplorerController.this.getTreeModel())) {
                        return;
                    }
                    TreePath[] oldSelections = treeSelectionModel.getSelectionPaths();
                    Set isLinkToDirectory = node.getChildEntryNodes().stream().filter(DeviceFileEntryNode::isSymbolicLinkToDirectory).map(x -> x.getEntry().getName()).collect(Collectors.toSet());
                    Comparator<DeviceFileEntry> comparator2 = NodeSorting.getCustomComparator(DeviceFileEntry::getName, x -> x.isDirectory() || isLinkToDirectory.contains(x.getName()));
                    result2.sort(comparator2);
                    List<DeviceFileEntryNode> addedNodes = ViewListener.this.updateChildrenNodes(treeModel, node, result2);
                    ViewListener.this.restoreTreeSelection(treeSelectionModel, oldSelections, node);
                    List<DeviceFileEntryNode> symlinkNodes = addedNodes.stream().filter(x -> x.getEntry().isSymbolicLink()).collect(Collectors.toList());
                    ViewListener.this.querySymbolicLinks(symlinkNodes, treeModel);
                }

                public void onFailure(@NotNull Throwable t) {
                    String message2;
                    if (t == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    if (StringUtil.isEmpty((String)(message2 = ExceptionUtil.getRootCause((Throwable)t).getMessage()))) {
                        message2 = String.format("Unable to list entries of directory %s", ViewListener.this.getUserFacingNodeName(node));
                    }
                    node.removeAllChildren();
                    node.add(new ErrorNode(message2));
                    node.setAllowsChildren(true);
                    treeModel.nodeStructureChanged(node);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener$9", "onFailure"));
                }
            });
            DeviceExplorerController.this.myEdtExecutor.addListener(futureEntries, () -> {
                DeviceExplorerController.this.stopLoadChildren(node);
                DeviceExplorerController.this.myLoadingNodesAlarms.cancelRequest((Runnable)showLoadingNode);
            });
            return FutureUtils.ignoreResult(futureEntries);
        }

        @NotNull
        private List<DeviceFileEntryNode> updateChildrenNodes(@NotNull DefaultTreeModel treeModel, @NotNull DeviceFileEntryNode parentNode, @NotNull List<DeviceFileEntry> newEntries) {
            if (treeModel == null) {
                ViewListener.$$$reportNull$$$0(96);
            }
            if (parentNode == null) {
                ViewListener.$$$reportNull$$$0(97);
            }
            if (newEntries == null) {
                ViewListener.$$$reportNull$$$0(98);
            }
            TreeUtil.UpdateChildrenOps<DeviceFileEntryNode, DeviceFileEntry> updateChildrenOps = new TreeUtil.UpdateChildrenOps<DeviceFileEntryNode, DeviceFileEntry>(){

                @Override
                @Nullable
                public DeviceFileEntryNode getChildNode(@NotNull DeviceFileEntryNode parentNode, int index) {
                    if (parentNode == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    return DeviceFileEntryNode.fromNode(parentNode.getChildAt(index));
                }

                @Override
                @NotNull
                public DeviceFileEntryNode mapEntry(@NotNull DeviceFileEntry entry) {
                    if (entry == null) {
                        10.$$$reportNull$$$0(1);
                    }
                    return new DeviceFileEntryNode(entry);
                }

                @Override
                public int compareNodeWithEntry(@NotNull DeviceFileEntryNode node, @NotNull DeviceFileEntry entry) {
                    if (node == null) {
                        10.$$$reportNull$$$0(2);
                    }
                    if (entry == null) {
                        10.$$$reportNull$$$0(3);
                    }
                    return node.getEntry().getName().compareTo(entry.getName());
                }

                @Override
                public void updateNode(@NotNull DeviceFileEntryNode node, @NotNull DeviceFileEntry entry) {
                    if (node == null) {
                        10.$$$reportNull$$$0(4);
                    }
                    if (entry == null) {
                        10.$$$reportNull$$$0(5);
                    }
                    node.setEntry(entry);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "parentNode";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "entry";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener$10";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getChildNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mapEntry";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "compareNodeWithEntry";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateNode";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            List<DeviceFileEntryNode> addedNodes = TreeUtil.updateChildrenNodes(treeModel, parentNode, newEntries, updateChildrenOps);
            parentNode.setAllowsChildren(parentNode.getChildCount() > 0);
            List<DeviceFileEntryNode> list = addedNodes;
            if (list == null) {
                ViewListener.$$$reportNull$$$0(99);
            }
            return list;
        }

        private void restoreTreeSelection(@NotNull DefaultTreeSelectionModel treeSelectionModel, @NotNull TreePath[] oldSelections, @NotNull DefaultMutableTreeNode parentNode) {
            if (treeSelectionModel == null) {
                ViewListener.$$$reportNull$$$0(100);
            }
            if (oldSelections == null) {
                ViewListener.$$$reportNull$$$0(101);
            }
            if (parentNode == null) {
                ViewListener.$$$reportNull$$$0(102);
            }
            HashSet newSelections = new HashSet();
            TreePath parentPath = new TreePath(parentNode.getPath());
            Arrays.stream(oldSelections).forEach(x -> this.restorePathSelection(treeSelectionModel, parentPath, (TreePath)x, newSelections));
            TreePath[] newSelectionArray = (TreePath[])ArrayUtil.toObjectArray(new ArrayList(newSelections), TreePath.class);
            treeSelectionModel.addSelectionPaths(newSelectionArray);
        }

        private void restorePathSelection(@NotNull DefaultTreeSelectionModel treeSelectionModel, @NotNull TreePath parentPath, @NotNull TreePath oldPath, @NotNull Set<TreePath> selections) {
            if (treeSelectionModel == null) {
                ViewListener.$$$reportNull$$$0(103);
            }
            if (parentPath == null) {
                ViewListener.$$$reportNull$$$0(104);
            }
            if (oldPath == null) {
                ViewListener.$$$reportNull$$$0(105);
            }
            if (selections == null) {
                ViewListener.$$$reportNull$$$0(106);
            }
            if (treeSelectionModel.isPathSelected(oldPath)) {
                return;
            }
            if (Objects.equals(parentPath, oldPath)) {
                return;
            }
            if (!parentPath.isDescendant(oldPath)) {
                return;
            }
            TreeNode node = (TreeNode)parentPath.getLastPathComponent();
            TreeNode existingChild = TreeUtil.getChildren(node).filter(x -> Objects.equals(x, oldPath.getLastPathComponent())).findFirst().orElse(null);
            if (existingChild == null) {
                selections.add(parentPath);
            }
        }

        private void querySymbolicLinks(@NotNull List<DeviceFileEntryNode> symlinkNodes, @NotNull DefaultTreeModel treeModel) {
            if (symlinkNodes == null) {
                ViewListener.$$$reportNull$$$0(107);
            }
            if (treeModel == null) {
                ViewListener.$$$reportNull$$$0(108);
            }
            DeviceExplorerController.this.executeFuturesInSequence(symlinkNodes.iterator(), treeNode -> {
                ListenableFuture<Boolean> futureIsLinkToDirectory = treeNode.getEntry().isSymbolicLinkToDirectory();
                DeviceExplorerController.this.myEdtExecutor.addConsumer(futureIsLinkToDirectory, (result2, throwable) -> {
                    boolean isDirectory;
                    if (throwable != null) {
                        LOGGER.info(String.format("Error determining if file entry \"%s\" is a link to a directory", treeNode.getEntry().getName()), throwable);
                    }
                    if (!Objects.equals(DeviceExplorerController.this.myModel.getTreeModel(), treeModel)) {
                        return;
                    }
                    boolean bl = isDirectory = result2 != null && result2 != false;
                    if (treeNode.isSymbolicLinkToDirectory() != isDirectory) {
                        MutableTreeNode parent = (MutableTreeNode)treeNode.getParent();
                        int previousIndex = TreeUtil.binarySearch(parent, treeNode, NodeSorting.getTreeNodeComparator());
                        if (previousIndex >= 0) {
                            treeModel.removeNodeFromParent((MutableTreeNode)treeNode);
                        }
                        treeNode.setSymbolicLinkToDirectory(isDirectory);
                        int newIndex = TreeUtil.binarySearch(parent, treeNode, NodeSorting.getTreeNodeComparator());
                        if (newIndex < 0) {
                            treeModel.insertNodeInto((MutableTreeNode)treeNode, parent, -(newIndex + 1));
                        }
                    }
                });
                return FutureUtils.ignoreResult(futureIsLinkToDirectory);
            });
        }

        @NotNull
        private String getUserFacingNodeName(@NotNull DeviceFileEntryNode node) {
            if (node == null) {
                ViewListener.$$$reportNull$$$0(109);
            }
            Object object = StringUtil.isEmpty((String)node.getEntry().getName()) ? "[root]" : "\"" + node.getEntry().getName() + "\"";
            if (object == null) {
                ViewListener.$$$reportNull$$$0(110);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 36: 
                case 37: 
                case 41: 
                case 42: 
                case 43: 
                case 72: 
                case 73: 
                case 77: 
                case 78: 
                case 84: 
                case 92: 
                case 93: 
                case 99: 
                case 110: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 36: 
                case 37: 
                case 41: 
                case 42: 
                case 43: 
                case 72: 
                case 73: 
                case 77: 
                case 78: 
                case 84: 
                case 92: 
                case 93: 
                case 99: 
                case 110: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 1: 
                case 5: 
                case 14: 
                case 44: 
                case 83: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeNodes";
                    break;
                }
                case 2: 
                case 8: 
                case 33: 
                case 38: 
                case 60: 
                case 61: 
                case 66: 
                case 87: 
                case 88: 
                case 89: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeNode";
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 36: 
                case 37: 
                case 41: 
                case 42: 
                case 43: 
                case 72: 
                case 73: 
                case 77: 
                case 78: 
                case 84: 
                case 92: 
                case 93: 
                case 99: 
                case 110: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener";
                    break;
                }
                case 6: 
                case 30: 
                case 79: 
                case 94: 
                case 95: 
                case 109: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: 
                case 62: 
                case 80: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "summary";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commonParentNode";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prepareTransfer";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "performTransfer";
                    break;
                }
                case 21: 
                case 23: 
                case 25: 
                case 27: 
                case 29: 
                case 32: 
                case 35: 
                case 40: 
                case 65: 
                case 68: 
                case 71: 
                case 76: 
                case 91: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 22: 
                case 64: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryNodes";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryNode";
                    break;
                }
                case 31: 
                case 34: 
                case 90: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localDirectoryPath";
                    break;
                }
                case 45: 
                case 50: 
                case 51: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentTreeNode";
                    break;
                }
                case 46: 
                case 47: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 48: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 49: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filesToDelete";
                    break;
                }
                case 52: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialName";
                    break;
                }
                case 53: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 54: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prompt";
                    break;
                }
                case 55: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyErrorMessage";
                    break;
                }
                case 56: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 57: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createFunction";
                    break;
                }
                case 58: 
                case 86: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 59: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 63: 
                case 69: 
                case 74: 
                case 97: 
                case 102: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
                case 67: 
                case 70: 
                case 75: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 81: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pastParticiple";
                    break;
                }
                case 82: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentParticiple";
                    break;
                }
                case 85: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 96: 
                case 108: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 98: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newEntries";
                    break;
                }
                case 100: 
                case 103: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeSelectionModel";
                    break;
                }
                case 101: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldSelections";
                    break;
                }
                case 104: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 105: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldPath";
                    break;
                }
                case 106: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selections";
                    break;
                }
                case 107: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symlinkNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerController$ViewListener";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadFileEntryToDefaultLocation";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "saveSingleNodeAs";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "saveMultiNodesAs";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapFileTransfer";
                    break;
                }
                case 36: 
                case 37: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadSingleFile";
                    break;
                }
                case 41: 
                case 42: 
                case 43: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadSingleDirectory";
                    break;
                }
                case 72: 
                case 73: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uploadDirectory";
                    break;
                }
                case 77: 
                case 78: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uploadFile";
                    break;
                }
                case 84: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonParentNode";
                    break;
                }
                case 92: 
                case 93: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadFileEntry";
                    break;
                }
                case 99: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateChildrenNodes";
                    break;
                }
                case 110: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserFacingNodeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deviceSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "openNodesInEditorInvoked";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadFileEntryToDefaultLocation";
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 36: 
                case 37: 
                case 41: 
                case 42: 
                case 43: 
                case 72: 
                case 73: 
                case 77: 
                case 78: 
                case 84: 
                case 92: 
                case 93: 
                case 99: 
                case 110: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "saveNodesAsInvoked";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "reportSaveNodesAsSummary";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "saveSingleNodeAs";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "saveMultiNodesAs";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapFileTransfer";
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "addUploadOperationWork";
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "addDownloadOperationWork";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileTransferEstimatorProgress";
                    break;
                }
                case 30: 
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadSingleNode";
                    break;
                }
                case 33: 
                case 34: 
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadSingleFile";
                    break;
                }
                case 38: 
                case 39: 
                case 40: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadSingleDirectory";
                    break;
                }
                case 44: {
                    objectArray = objectArray;
                    objectArray[2] = "copyNodePathsInvoked";
                    break;
                }
                case 45: {
                    objectArray = objectArray;
                    objectArray[2] = "newFileInvoked";
                    break;
                }
                case 46: {
                    objectArray = objectArray;
                    objectArray[2] = "synchronizeNodesInvoked";
                    break;
                }
                case 47: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteNodesInvoked";
                    break;
                }
                case 48: {
                    objectArray = objectArray;
                    objectArray[2] = "reportDeletionProblem";
                    break;
                }
                case 49: {
                    objectArray = objectArray;
                    objectArray[2] = "createDeleteConfirmationMessage";
                    break;
                }
                case 50: {
                    objectArray = objectArray;
                    objectArray[2] = "newDirectoryInvoked";
                    break;
                }
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    objectArray = objectArray;
                    objectArray[2] = "newFileOrDirectory";
                    break;
                }
                case 58: 
                case 59: {
                    objectArray = objectArray;
                    objectArray[2] = "showErrorMessage";
                    break;
                }
                case 60: {
                    objectArray = objectArray;
                    objectArray[2] = "uploadFilesInvoked";
                    break;
                }
                case 61: 
                case 62: {
                    objectArray = objectArray;
                    objectArray[2] = "reportUploadFilesSummary";
                    break;
                }
                case 63: 
                case 64: 
                case 65: {
                    objectArray = objectArray;
                    objectArray[2] = "uploadVirtualFiles";
                    break;
                }
                case 66: 
                case 67: 
                case 68: {
                    objectArray = objectArray;
                    objectArray[2] = "uploadVirtualFile";
                    break;
                }
                case 69: 
                case 70: 
                case 71: {
                    objectArray = objectArray;
                    objectArray[2] = "uploadDirectory";
                    break;
                }
                case 74: 
                case 75: 
                case 76: {
                    objectArray = objectArray;
                    objectArray[2] = "uploadFile";
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: {
                    objectArray = objectArray;
                    objectArray[2] = "reportFileTransferSummary";
                    break;
                }
                case 83: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonParentNode";
                    break;
                }
                case 85: 
                case 86: {
                    objectArray = objectArray;
                    objectArray[2] = "logFuture";
                    break;
                }
                case 87: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseSaveAsFilePath";
                    break;
                }
                case 88: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseSaveAsDirectoryPath";
                    break;
                }
                case 89: 
                case 90: 
                case 91: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadFileEntry";
                    break;
                }
                case 94: {
                    objectArray = objectArray;
                    objectArray[2] = "treeNodeExpanding";
                    break;
                }
                case 95: {
                    objectArray = objectArray;
                    objectArray[2] = "loadNodeChildren";
                    break;
                }
                case 96: 
                case 97: 
                case 98: {
                    objectArray = objectArray;
                    objectArray[2] = "updateChildrenNodes";
                    break;
                }
                case 100: 
                case 101: 
                case 102: {
                    objectArray = objectArray;
                    objectArray[2] = "restoreTreeSelection";
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    objectArray = objectArray;
                    objectArray[2] = "restorePathSelection";
                    break;
                }
                case 107: 
                case 108: {
                    objectArray = objectArray;
                    objectArray[2] = "querySymbolicLinks";
                    break;
                }
                case 109: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserFacingNodeName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 36: 
                case 37: 
                case 41: 
                case 42: 
                case 43: 
                case 72: 
                case 73: 
                case 77: 
                case 78: 
                case 84: 
                case 92: 
                case 93: 
                case 99: 
                case 110: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class UploadFileState {
            @Nullable
            public ListenableFuture<Void> loadChildrenFuture;
            @Nullable
            public DeviceFileEntryNode childNode;
            public long byteCount;

            private UploadFileState() {
            }
        }
    }

    private class ServiceListener
    implements DeviceFileSystemServiceListener {
        private ServiceListener() {
        }

        @Override
        public void serviceRestarted() {
            DeviceExplorerController.this.refreshDeviceList();
        }

        @Override
        public void deviceAdded(@NotNull DeviceFileSystem device) {
            if (device == null) {
                ServiceListener.$$$reportNull$$$0(0);
            }
            DeviceExplorerController.this.myModel.addDevice(device);
        }

        @Override
        public void deviceRemoved(@NotNull DeviceFileSystem device) {
            if (device == null) {
                ServiceListener.$$$reportNull$$$0(1);
            }
            DeviceExplorerController.this.myModel.removeDevice(device);
        }

        @Override
        public void deviceUpdated(@NotNull DeviceFileSystem device) {
            if (device == null) {
                ServiceListener.$$$reportNull$$$0(2);
            }
            DeviceExplorerController.this.myModel.updateDevice(device);
            DeviceExplorerController.this.deviceStateUpdated(device);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "device";
            objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerController$ServiceListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

