/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.ui.TreeUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceFileEntryNode
extends DefaultMutableTreeNode {
    @NotNull
    private DeviceFileEntry myEntry;
    private boolean myIsSymbolicLinkToDirectory;
    private boolean myLoaded;
    private boolean myDownloading;
    private boolean myUploading;
    private int myTransferringTick;
    private long myCurrentTransferredBytes;
    private long myTotalTransferredBytes;

    @Nullable
    public static DeviceFileEntryNode fromNode(@Nullable Object value2) {
        if (!(value2 instanceof DeviceFileEntryNode)) {
            return null;
        }
        return (DeviceFileEntryNode)value2;
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.myEntry.getName();
        if (string == null) {
            DeviceFileEntryNode.$$$reportNull$$$0(0);
        }
        return string;
    }

    public DeviceFileEntryNode(@NotNull DeviceFileEntry entry) {
        if (entry == null) {
            DeviceFileEntryNode.$$$reportNull$$$0(1);
        }
        this.myEntry = entry;
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.myLoaded = loaded;
    }

    public boolean isSymbolicLinkToDirectory() {
        return this.myIsSymbolicLinkToDirectory;
    }

    public void setSymbolicLinkToDirectory(boolean value2) {
        this.myIsSymbolicLinkToDirectory = value2;
    }

    @Override
    public boolean isLeaf() {
        return !this.isExpandable();
    }

    public boolean isExpandable() {
        return this.myEntry.isDirectory() || this.myIsSymbolicLinkToDirectory;
    }

    @NotNull
    public DeviceFileEntry getEntry() {
        DeviceFileEntry deviceFileEntry = this.myEntry;
        if (deviceFileEntry == null) {
            DeviceFileEntryNode.$$$reportNull$$$0(2);
        }
        return deviceFileEntry;
    }

    public void setEntry(@NotNull DeviceFileEntry entry) {
        if (entry == null) {
            DeviceFileEntryNode.$$$reportNull$$$0(3);
        }
        this.myEntry = entry;
    }

    public boolean isDownloading() {
        return this.myDownloading;
    }

    public boolean isUploading() {
        return this.myUploading;
    }

    public boolean isTransferring() {
        return this.isDownloading() || this.isUploading();
    }

    private void clearTransferInfo() {
        this.myUploading = false;
        this.myDownloading = false;
        this.myTransferringTick = 0;
        this.myCurrentTransferredBytes = 0L;
        this.myTotalTransferredBytes = 0L;
    }

    public void setDownloading(boolean downloading) {
        this.clearTransferInfo();
        this.myDownloading = downloading;
    }

    public void setUploading(boolean uploading) {
        this.clearTransferInfo();
        this.myUploading = uploading;
    }

    public int getTransferringTick() {
        return this.myTransferringTick;
    }

    public void incTransferringTick() {
        ++this.myTransferringTick;
    }

    public void setTransferProgress(long currentBytes, long totalBytes) {
        this.myCurrentTransferredBytes = currentBytes;
        this.myTotalTransferredBytes = totalBytes;
    }

    public long getCurrentTransferredBytes() {
        return this.myCurrentTransferredBytes;
    }

    public long getTotalTransferredBytes() {
        return this.myTotalTransferredBytes;
    }

    @NotNull
    public List<DeviceFileEntryNode> getChildEntryNodes() {
        List<DeviceFileEntryNode> list = TreeUtil.getChildren(this).map(DeviceFileEntryNode::fromNode).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            DeviceFileEntryNode.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public DeviceFileEntryNode findChildEntry(@NotNull String name) {
        if (name == null) {
            DeviceFileEntryNode.$$$reportNull$$$0(5);
        }
        return this.getChildEntryNodes().stream().filter(x -> Objects.equals(x.getEntry().getName(), name)).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/DeviceFileEntryNode";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/DeviceFileEntryNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEntryNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEntry";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findChildEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

