/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.npw.project;

import com.android.tools.idea.npw.module.ModuleModelKt;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.SourceProviderUtilKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class GradleAndroidModuleTemplate
implements AndroidModulePaths {
    @Nullable
    private File myModuleRoot;
    @Nullable
    private File mySrcRoot;
    @Nullable
    private File myTestRoot;
    @Nullable
    private File myUnitTestRoot;
    @NotNull
    private List<File> myResDirectories = Collections.emptyList();
    @Nullable
    private File myAidlRoot;
    @Nullable
    private File myManifestDirectory;

    @Override
    @Nullable
    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    @Nullable
    private static File appendPackageToRoot(@Nullable File root2, @Nullable String packageName) {
        if (root2 == null || packageName == null) {
            return root2;
        }
        String packagePath = packageName.replace('.', File.separatorChar);
        return new File(root2, packagePath);
    }

    @Override
    @Nullable
    public File getSrcDirectory(@Nullable String packageName) {
        return GradleAndroidModuleTemplate.appendPackageToRoot(this.mySrcRoot, packageName);
    }

    @Override
    @Nullable
    public File getTestDirectory(@Nullable String packageName) {
        return GradleAndroidModuleTemplate.appendPackageToRoot(this.myTestRoot, packageName);
    }

    @Override
    @Nullable
    public File getUnitTestDirectory(@Nullable String packageName) {
        return GradleAndroidModuleTemplate.appendPackageToRoot(this.myUnitTestRoot, packageName);
    }

    @Override
    @NotNull
    public List<File> getResDirectories() {
        List<File> list = this.myResDirectories;
        if (list == null) {
            GradleAndroidModuleTemplate.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @Nullable
    public File getAidlDirectory(@Nullable String packageName) {
        return GradleAndroidModuleTemplate.appendPackageToRoot(this.myAidlRoot, packageName);
    }

    @Override
    @Nullable
    public File getManifestDirectory() {
        return this.myManifestDirectory;
    }

    public static NamedModuleTemplate createDummyTemplate() {
        return GradleAndroidModuleTemplate.createDefaultTemplateAt("", "");
    }

    public static NamedModuleTemplate createDefaultTemplateAt(@NotNull String projectPath, @NotNull String moduleName2) {
        if (projectPath == null) {
            GradleAndroidModuleTemplate.$$$reportNull$$$0(1);
        }
        if (moduleName2 == null) {
            GradleAndroidModuleTemplate.$$$reportNull$$$0(2);
        }
        File moduleRoot = ModuleModelKt.getModuleRoot(projectPath, moduleName2);
        File baseSrcDir = new File(moduleRoot, "src");
        File baseFlavorDir = new File(baseSrcDir, "main");
        GradleAndroidModuleTemplate paths = new GradleAndroidModuleTemplate();
        paths.myModuleRoot = moduleRoot;
        paths.mySrcRoot = new File(baseFlavorDir, "java");
        paths.myTestRoot = new File(baseSrcDir.getPath(), "androidTest" + File.separatorChar + "java");
        paths.myUnitTestRoot = new File(baseSrcDir.getPath(), "test" + File.separatorChar + "java");
        paths.myResDirectories = ImmutableList.of((Object)new File(baseFlavorDir, "res"));
        paths.myAidlRoot = new File(baseFlavorDir, "aidl");
        paths.myManifestDirectory = baseFlavorDir;
        return new NamedModuleTemplate("main", paths);
    }

    @NotNull
    private static Collection<NamedIdeaSourceProvider> getSourceProviders(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        if (androidFacet == null) {
            GradleAndroidModuleTemplate.$$$reportNull$$$0(3);
        }
        List<NamedIdeaSourceProvider> providersForFile = null;
        if (targetDirectory != null) {
            providersForFile = SourceProviderUtilKt.getSourceProvidersForFile(androidFacet, targetDirectory);
        }
        if (providersForFile == null) {
            providersForFile = SourceProviderManager.getInstance(androidFacet).getAllSourceProviders();
        }
        List<NamedIdeaSourceProvider> list = providersForFile;
        if (list == null) {
            GradleAndroidModuleTemplate.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<NamedModuleTemplate> getModuleTemplates(@NotNull Module module, @Nullable VirtualFile targetDirectory) {
        AndroidFacet facet2;
        if (module == null) {
            GradleAndroidModuleTemplate.$$$reportNull$$$0(5);
        }
        if ((facet2 = AndroidFacet.getInstance((Module)module)) == null) {
            List<NamedModuleTemplate> list = Collections.emptyList();
            if (list == null) {
                GradleAndroidModuleTemplate.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<NamedModuleTemplate> templates = new ArrayList<NamedModuleTemplate>();
        for (NamedIdeaSourceProvider sourceProvider : GradleAndroidModuleTemplate.getSourceProviders(facet2, targetDirectory)) {
            GradleAndroidModuleTemplate paths = new GradleAndroidModuleTemplate();
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots.length > 0) {
                paths.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
            }
            paths.mySrcRoot = new File(VfsUtilCore.urlToPath((String)((String)Iterables.getFirst(sourceProvider.getJavaDirectoryUrls(), null))));
            List testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
            if (testsRoot.size() == 1) {
                paths.myUnitTestRoot = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
            } else if (!testsRoot.isEmpty()) {
                paths.myTestRoot = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
                paths.myUnitTestRoot = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(1)));
            }
            paths.myResDirectories = ImmutableList.copyOf((Collection)sourceProvider.getResDirectoryUrls().stream().map(it -> new File(VfsUtilCore.urlToPath((String)it))).collect(Collectors.toList()));
            paths.myAidlRoot = new File(VfsUtilCore.urlToPath((String)((String)Iterables.getFirst(sourceProvider.getAidlDirectoryUrls(), null))));
            paths.myManifestDirectory = sourceProvider.getManifestDirectoryUrls().stream().map(it -> new File(VfsUtilCore.urlToPath((String)it))).findFirst().get();
            templates.add(new NamedModuleTemplate(sourceProvider.getName(), paths));
        }
        ArrayList<NamedModuleTemplate> arrayList = templates;
        if (arrayList == null) {
            GradleAndroidModuleTemplate.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/npw/project/GradleAndroidModuleTemplate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getResDirectories";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/npw/project/GradleAndroidModuleTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceProviders";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultTemplateAt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceProviders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleTemplates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

