/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginInfo {
    public static final String APPLICATION_PLUGIN_ID = "com.android.application";
    public static final String DESCRIPTION = "Android Gradle plugin";
    public static final String ARTIFACT_ID = "gradle";
    public static final String GROUP_ID = "com.android.tools.build";
    @NotNull
    private final Module myModule;
    @Nullable
    private final GradleVersion myPluginVersion;
    @Nullable
    private final VirtualFile myPluginBuildFile;

    @Slow
    @Nullable
    public static AndroidPluginInfo find(@NotNull Project project) {
        AndroidPluginInfo modelPluginInfo;
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(0);
        }
        if ((modelPluginInfo = AndroidPluginInfo.findFromModel(project)) != null && modelPluginInfo.getPluginVersion() != null) {
            return modelPluginInfo;
        }
        AndroidPluginInfo buildPluginInfo = AndroidPluginInfo.findInBuildFiles(project, modelPluginInfo == null ? null : modelPluginInfo.getModule());
        return buildPluginInfo == null ? modelPluginInfo : buildPluginInfo;
    }

    @Slow
    @Nullable
    public static AndroidPluginInfo findFromBuildFiles(@NotNull Project project) {
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(1);
        }
        return AndroidPluginInfo.findInBuildFiles(project, null);
    }

    @Nullable
    public static AndroidPluginInfo findFromModel(@NotNull Project project) {
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(2);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
            if (gradleModel == null || gradleModel.getAndroidProject().getProjectType() != 0) continue;
            return new AndroidPluginInfo(module, gradleModel.getModelVersion(), null);
        }
        return null;
    }

    @Slow
    @Nullable
    private static AndroidPluginInfo findInBuildFiles(@NotNull Project project, @Nullable Module appModule) {
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(3);
        }
        Module fileAppModule = null;
        BuildFileSearchResult result2 = AndroidPluginInfo.searchInBuildFiles(project, appModule == null);
        if (result2.appVirtualFile != null) {
            fileAppModule = ModuleUtilCore.findModuleForFile((VirtualFile)result2.appVirtualFile, (Project)project);
        }
        if (fileAppModule != null || appModule != null) {
            GradleVersion pluginVersion = StringUtil.isNotEmpty((String)result2.pluginVersion) ? GradleVersion.tryParse((String)result2.pluginVersion) : null;
            return new AndroidPluginInfo(fileAppModule == null ? appModule : fileAppModule, pluginVersion, result2.pluginVirtualFile);
        }
        return null;
    }

    @Slow
    @NotNull
    private static BuildFileSearchResult searchInBuildFiles(@NotNull Project project, boolean searchForAppModule) {
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(4);
        }
        BuildFileSearchResult result2 = new BuildFileSearchResult();
        BuildFileProcessor.getInstance().processRecursively(project, (Processor<? super GradleBuildModel>)((Processor)buildModel -> {
            boolean keepSearchingForPluginVersion;
            List pluginIds;
            boolean keepSearchingForAppModule;
            boolean bl = keepSearchingForAppModule = searchForAppModule && result2.appVirtualFile == null;
            if (keepSearchingForAppModule && (pluginIds = PluginModel.extractNames((List)buildModel.plugins())).contains(APPLICATION_PLUGIN_ID)) {
                result2.appVirtualFile = buildModel.getVirtualFile();
                keepSearchingForAppModule = false;
            }
            boolean bl2 = keepSearchingForPluginVersion = result2.pluginVersion == null;
            if (keepSearchingForPluginVersion) {
                DependenciesModel dependencies2 = buildModel.buildscript().dependencies();
                for (ArtifactDependencyModel dependency : dependencies2.artifacts("classpath")) {
                    if (!AndroidPluginInfo.isAndroidPlugin(dependency.name().forceString(), dependency.group().toString())) continue;
                    String version2 = dependency.version().toString();
                    if (StringUtil.isNotEmpty((String)version2)) {
                        result2.pluginVirtualFile = buildModel.getVirtualFile();
                        result2.pluginVersion = version2;
                    }
                    keepSearchingForPluginVersion = false;
                    break;
                }
            }
            return keepSearchingForAppModule || keepSearchingForPluginVersion;
        }));
        BuildFileSearchResult buildFileSearchResult = result2;
        if (buildFileSearchResult == null) {
            AndroidPluginInfo.$$$reportNull$$$0(5);
        }
        return buildFileSearchResult;
    }

    @VisibleForTesting
    public AndroidPluginInfo(@NotNull Module module, @Nullable GradleVersion pluginVersion, @Nullable VirtualFile pluginBuildFile) {
        if (module == null) {
            AndroidPluginInfo.$$$reportNull$$$0(6);
        }
        this.myModule = module;
        this.myPluginVersion = pluginVersion;
        this.myPluginBuildFile = pluginBuildFile;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            AndroidPluginInfo.$$$reportNull$$$0(7);
        }
        return module;
    }

    @NotNull
    public LatestKnownPluginVersionProvider getLatestKnownPluginVersionProvider() {
        LatestKnownPluginVersionProvider latestKnownPluginVersionProvider = LatestKnownPluginVersionProvider.INSTANCE;
        if (latestKnownPluginVersionProvider == null) {
            AndroidPluginInfo.$$$reportNull$$$0(8);
        }
        return latestKnownPluginVersionProvider;
    }

    @Nullable
    public GradleVersion getPluginVersion() {
        return this.myPluginVersion;
    }

    @Nullable
    public VirtualFile getPluginBuildFile() {
        return this.myPluginBuildFile;
    }

    public boolean isExperimental() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPluginInfo that = (AndroidPluginInfo)o;
        return Objects.equals(this.myModule, that.myModule) && Objects.equals(this.myPluginVersion, that.myPluginVersion) && Objects.equals(this.myPluginBuildFile, that.myPluginBuildFile);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myPluginVersion, this.myPluginBuildFile);
    }

    public static boolean isAndroidPlugin(@NotNull String artifactId, String groupId) {
        if (artifactId == null) {
            AndroidPluginInfo.$$$reportNull$$$0(9);
        }
        return ARTIFACT_ID.equals(artifactId) && GROUP_ID.equals(groupId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/plugin/AndroidPluginInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/plugin/AndroidPluginInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "searchInBuildFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestKnownPluginVersionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFromBuildFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFromModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInBuildFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "searchInBuildFiles";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BuildFileSearchResult {
        @Nullable
        VirtualFile appVirtualFile;
        @Nullable
        VirtualFile pluginVirtualFile;
        @Nullable
        String pluginVersion;

        private BuildFileSearchResult() {
        }
    }
}

