/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionManager;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.NoopExternalSystemTaskNotificationListener;
import com.android.tools.idea.gradle.project.build.invoker.TaskExecutionProgressIndicator;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class GradleTasksExecutorImpl
extends GradleTasksExecutor {
    private static final long ONE_MINUTE_MS = 60000L;
    @NonNls
    private static final String APP_ICON_ID = "compiler";
    private static final String GRADLE_RUNNING_MSG_TITLE = "Gradle Running";
    private static final String PASSWORD_KEY_SUFFIX = ".password=";
    @NotNull
    private final Object myCompletionLock;
    @NotNull
    private final GradleBuildInvoker.Request myRequest;
    @NotNull
    private final BuildStopper myBuildStopper;
    @GuardedBy(value="myCompletionLock")
    private int myCompletionCounter;
    @NotNull
    private final GradleExecutionHelper myHelper;
    private volatile int myErrorCount;
    @NotNull
    private volatile ProgressIndicator myProgressIndicator;

    GradleTasksExecutorImpl(@NotNull GradleBuildInvoker.Request request, @NotNull BuildStopper buildStopper) {
        if (request == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(0);
        }
        if (buildStopper == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(1);
        }
        super(request.getProject());
        this.myCompletionLock = new Object();
        this.myHelper = new GradleExecutionHelper();
        this.myProgressIndicator = new EmptyProgressIndicator();
        this.myRequest = request;
        this.myBuildStopper = buildStopper;
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.myErrorCount > 0 ? "Gradle Invocation (errors)" : "Gradle Invocation (success)", "Gradle Invocation Finished", this.myErrorCount + " Errors", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(2);
        }
        this.myProgressIndicator = indicator;
        ProjectManager projectManager = ProjectManager.getInstance();
        Project project = this.myRequest.getProject();
        CloseListener closeListener = new CloseListener();
        projectManager.addProjectManagerListener(project, (ProjectManagerListener)closeListener);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)project)).getCompilationSemaphore();
        boolean acquired = false;
        try {
            try {
                while (!acquired) {
                    acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                    if (!this.myProgressIndicator.isCanceled()) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.addIndicatorDelegate();
            this.invokeGradleTasks();
        }
        finally {
            try {
                this.myProgressIndicator.stop();
                projectManager.removeProjectManagerListener(project, (ProjectManagerListener)closeListener);
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
        }
    }

    private void addIndicatorDelegate() {
        if (this.myProgressIndicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicator = (ProgressIndicatorEx)this.myProgressIndicator;
            indicator.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStateDelegate(this.myRequest.getTaskId(), this.myBuildStopper));
        }
    }

    private static void setUpBuildAttributionManager(LongRunningOperation operation, BuildAttributionManager buildAttributionManager, boolean skipIfNull) {
        if (skipIfNull && buildAttributionManager == null) {
            return;
        }
        operation.addProgressListener((ProgressListener)buildAttributionManager, new OperationType[]{OperationType.PROJECT_CONFIGURATION, OperationType.TASK, OperationType.TEST});
        buildAttributionManager.onBuildStart();
    }

    private void invokeGradleTasks() {
        Application application;
        Runnable task2;
        Project project = this.myRequest.getProject();
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project);
        AtomicReference<Object> model2 = new AtomicReference<Object>(null);
        Function executeTasksFunction = connection -> {
            block41: {
                String testOutput;
                BuildAttributionManager buildAttributionManager;
                GradleBuildState buildState;
                CancellationTokenSource cancellationTokenSource;
                ExternalSystemTaskNotificationListener taskListener;
                ExternalSystemTaskId id;
                Throwable buildError;
                StringBuilder output;
                Stopwatch stopwatch;
                block37: {
                    block38: {
                        stopwatch = Stopwatch.createStarted();
                        BuildAction buildAction = this.myRequest.getBuildAction();
                        boolean isRunBuildAction = buildAction != null;
                        List<String> gradleTasks = this.myRequest.getGradleTasks();
                        String executingTasksText = "Executing tasks: " + gradleTasks + " in project " + this.myRequest.getBuildFilePath().getPath();
                        this.addToEventLog(executingTasksText, MessageType.INFO);
                        output = new StringBuilder();
                        buildError = null;
                        id = this.myRequest.getTaskId();
                        taskListener = this.getTaskListener();
                        cancellationTokenSource = GradleConnector.newCancellationTokenSource();
                        this.myBuildStopper.register(id, cancellationTokenSource);
                        taskListener.onStart(id, this.myRequest.getBuildFilePath().getPath());
                        taskListener.onTaskOutput(id, executingTasksText + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator(), true);
                        BuildMode buildMode = BuildSettings.getInstance(this.myProject).getBuildMode();
                        buildState = GradleBuildState.getInstance(this.myProject);
                        buildState.buildStarted(new BuildContext(project, gradleTasks, buildMode));
                        buildAttributionManager = null;
                        boolean enableBuildAttribution = BuildAttributionUtil.isBuildAttributionEnabledForProject(this.myProject);
                        try {
                            Object logMessage;
                            AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
                            ArrayList commandLineArguments = Lists.newArrayList((Object[])buildConfiguration.getCommandLineOptions());
                            if (!commandLineArguments.contains("--parallel") && CompilerConfiguration.getInstance((Project)project).isParallelCompilationEnabled()) {
                                commandLineArguments.add("--parallel");
                            }
                            commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
                            File attributionFileDir = BuildAttributionUtil.getAgpAttributionFileDir(this.myRequest.getBuildFilePath());
                            if (enableBuildAttribution) {
                                commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.attribution.file.location", (String)attributionFileDir.getAbsolutePath()));
                            }
                            commandLineArguments.addAll(this.myRequest.getCommandLineArguments());
                            if (((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() || CommandLineArgs.isInTestingMode()) {
                                GradleInitScripts.getInstance().addLocalMavenRepoInitScriptCommandLineArg(commandLineArguments);
                                GradleUtil.attemptToUseEmbeddedGradle(project);
                            }
                            if (((String)(logMessage = "Build command line options: " + commandLineArguments)).contains(PASSWORD_KEY_SUFFIX)) {
                                ArrayList<Object> replaced = new ArrayList<Object>(commandLineArguments.size());
                                for (String option : commandLineArguments) {
                                    int index = option.indexOf(PASSWORD_KEY_SUFFIX);
                                    if (index == -1) {
                                        replaced.add(option);
                                        continue;
                                    }
                                    replaced.add(option.substring(0, index + PASSWORD_KEY_SUFFIX.length()) + "*********");
                                }
                                logMessage = ((Object)replaced).toString();
                            }
                            GradleTasksExecutorImpl.getLogger().info((String)logMessage);
                            executionSettings.withVmOptions(this.myRequest.getJvmArguments()).withArguments((Collection)commandLineArguments).withEnvironmentVariables(this.myRequest.getEnv()).passParentEnvs(this.myRequest.isPassParentEnvs());
                            BuildLauncher operation = isRunBuildAction ? connection.action(buildAction) : connection.newBuild();
                            GradleExecutionHelper.prepare((LongRunningOperation)operation, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(){

                                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                                    if (event == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    if (GradleTasksExecutorImpl.this.myBuildStopper.contains(id)) {
                                        taskListener.onStatusChange(event);
                                    }
                                }

                                public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text, boolean stdOut) {
                                    if (id2 == null) {
                                        1.$$$reportNull$$$0(1);
                                    }
                                    if (text == null) {
                                        1.$$$reportNull$$$0(2);
                                    }
                                    output.append(text);
                                    if (GradleTasksExecutorImpl.this.myBuildStopper.contains(id2)) {
                                        taskListener.onTaskOutput(id2, text, stdOut);
                                    }
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2;
                                    Object[] objectArray3 = new Object[3];
                                    switch (n) {
                                        default: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "event";
                                            break;
                                        }
                                        case 1: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "id";
                                            break;
                                        }
                                        case 2: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "text";
                                            break;
                                        }
                                    }
                                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutorImpl$1";
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "onStatusChange";
                                            break;
                                        }
                                        case 1: 
                                        case 2: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "onTaskOutput";
                                            break;
                                        }
                                    }
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            }, (ProjectConnection)connection);
                            if (enableBuildAttribution) {
                                buildAttributionManager = (BuildAttributionManager)ServiceManager.getService((Project)this.myProject, BuildAttributionManager.class);
                                GradleTasksExecutorImpl.setUpBuildAttributionManager((LongRunningOperation)operation, buildAttributionManager, ApplicationManager.getApplication().isUnitTestMode());
                            }
                            if (isRunBuildAction) {
                                ((BuildActionExecuter)operation).forTasks(ArrayUtilRt.toStringArray(gradleTasks));
                            } else {
                                operation.forTasks(ArrayUtilRt.toStringArray(gradleTasks));
                            }
                            operation.withCancellationToken(cancellationTokenSource.token());
                            if (isRunBuildAction) {
                                model2.set(((BuildActionExecuter)operation).run());
                            } else {
                                operation.run();
                            }
                            buildState.buildFinished(BuildStatus.SUCCESS);
                            taskListener.onSuccess(id);
                            if (buildAttributionManager != null) {
                                buildAttributionManager.onBuildSuccess(attributionFileDir);
                            }
                            if (buildError == null) break block37;
                            if (buildAttributionManager == null) break block38;
                            buildAttributionManager.onBuildFailure();
                        }
                        catch (BuildException e) {
                            String testOutput2;
                            block39: {
                                block40: {
                                    buildError = e;
                                    if (buildError == null) break block39;
                                    if (buildAttributionManager == null) break block40;
                                    buildAttributionManager.onBuildFailure();
                                }
                                if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                                    buildState.buildFinished(BuildStatus.CANCELED);
                                    taskListener.onCancel(id);
                                } else {
                                    buildState.buildFinished(BuildStatus.FAILED);
                                    BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment((ProjectConnection)connection, (ExternalSystemTaskId)id, (ExternalSystemTaskNotificationListener)taskListener, (CancellationTokenSource)cancellationTokenSource, (GradleExecutionSettings)executionSettings);
                                    GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
                                    ExternalSystemException userFriendlyError = projectResolverChain.getUserFriendlyError(buildEnvironment, buildError, this.myRequest.getBuildFilePath().getPath(), null);
                                    taskListener.onFailure(id, (Exception)((Object)userFriendlyError));
                                }
                            }
                            taskListener.onEnd(id);
                            this.myBuildStopper.remove(id);
                            String gradleOutput = output.toString();
                            Application application = ApplicationManager.getApplication();
                            if (GuiTestingService.getInstance().isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput2 = (String)application.getUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                                application.putUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                            }
                            application.invokeLater(() -> this.notifyGradleInvocationCompleted(buildState, stopwatch.elapsed(TimeUnit.MILLISECONDS)));
                            if (this.getProject().isDisposed()) break block41;
                            ArrayList<Message> buildMessages = new ArrayList<Message>();
                            if (buildError instanceof BuildException) {
                                String message2 = ExternalSystemApiUtil.buildErrorMessage((Throwable)buildError);
                                GradleBuildInvoker.AfterGradleInvocationTask[] msg = new Message(Message.Kind.ERROR, message2, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                                buildMessages.add((Message)msg);
                            }
                            GradleInvocationResult result2 = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildError, model2.get());
                            for (GradleBuildInvoker.AfterGradleInvocationTask task2 : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                                task2.execute(result2);
                            }
                        }
                    }
                    if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                        buildState.buildFinished(BuildStatus.CANCELED);
                        taskListener.onCancel(id);
                    } else {
                        buildState.buildFinished(BuildStatus.FAILED);
                        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment((ProjectConnection)connection, (ExternalSystemTaskId)id, (ExternalSystemTaskNotificationListener)taskListener, (CancellationTokenSource)cancellationTokenSource, (GradleExecutionSettings)executionSettings);
                        GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
                        ExternalSystemException userFriendlyError = projectResolverChain.getUserFriendlyError(buildEnvironment, buildError, this.myRequest.getBuildFilePath().getPath(), null);
                        taskListener.onFailure(id, (Exception)((Object)userFriendlyError));
                    }
                }
                taskListener.onEnd(id);
                this.myBuildStopper.remove(id);
                String gradleOutput = output.toString();
                Application application = ApplicationManager.getApplication();
                if (GuiTestingService.getInstance().isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput = (String)application.getUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                    application.putUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                }
                application.invokeLater(() -> this.notifyGradleInvocationCompleted(buildState, stopwatch.elapsed(TimeUnit.MILLISECONDS)));
                if (this.getProject().isDisposed()) break block41;
                ArrayList<Message> buildMessages = new ArrayList<Message>();
                if (buildError instanceof BuildException) {
                    String message3 = ExternalSystemApiUtil.buildErrorMessage((Throwable)buildError);
                    GradleBuildInvoker.AfterGradleInvocationTask[] msg = new Message(Message.Kind.ERROR, message3, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                    buildMessages.add((Message)msg);
                }
                GradleInvocationResult result3 = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildError, model2.get());
                for (GradleBuildInvoker.AfterGradleInvocationTask task3 : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                    task3.execute(result3);
                }
                break block41;
                break block41;
                catch (Throwable e) {
                    buildError = e;
                    this.handleTaskExecutionError(e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        if (buildError != null) {
                            if (buildAttributionManager != null) {
                                buildAttributionManager.onBuildFailure();
                            }
                            if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                                buildState.buildFinished(BuildStatus.CANCELED);
                                taskListener.onCancel(id);
                            } else {
                                buildState.buildFinished(BuildStatus.FAILED);
                                BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment((ProjectConnection)connection, (ExternalSystemTaskId)id, (ExternalSystemTaskNotificationListener)taskListener, (CancellationTokenSource)cancellationTokenSource, (GradleExecutionSettings)executionSettings);
                                GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
                                ExternalSystemException userFriendlyError = projectResolverChain.getUserFriendlyError(buildEnvironment, buildError, this.myRequest.getBuildFilePath().getPath(), null);
                                taskListener.onFailure(id, (Exception)((Object)userFriendlyError));
                            }
                        }
                        taskListener.onEnd(id);
                        this.myBuildStopper.remove(id);
                        gradleOutput = output.toString();
                        application = ApplicationManager.getApplication();
                        if (GuiTestingService.getInstance().isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput = (String)application.getUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                            application.putUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                        }
                        application.invokeLater(() -> this.notifyGradleInvocationCompleted(buildState, stopwatch.elapsed(TimeUnit.MILLISECONDS)));
                        if (!this.getProject().isDisposed()) {
                            buildMessages = new ArrayList<Message>();
                            if (buildError instanceof BuildException) {
                                String message4 = ExternalSystemApiUtil.buildErrorMessage((Throwable)buildError);
                                Message msg = new Message(Message.Kind.ERROR, message4, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                                buildMessages.add(msg);
                            }
                            result2 = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildError, model2.get());
                            for (GradleBuildInvoker.AfterGradleInvocationTask task4 : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                                task4.execute(result2);
                            }
                        }
                    }
                }
            }
            return null;
        };
        if (GuiTestingService.getInstance().isGuiTestingMode() && (task2 = (Runnable)(application = ApplicationManager.getApplication()).getUserData(GuiTestingService.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY)) != null) {
            application.putUserData(GuiTestingService.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY, null);
            task2.run();
        }
        try {
            this.myHelper.execute(this.myRequest.getBuildFilePath().getPath(), executionSettings, this.myRequest.getTaskId(), this.myRequest.getTaskListener(), null, executeTasksFunction);
        }
        catch (ExternalSystemException e) {
            if (e.getOriginalReason().startsWith("com.intellij.openapi.progress.ProcessCanceledException")) {
                GradleTasksExecutorImpl.getLogger().info("Gradle execution cancelled.", (Throwable)e);
            }
            throw e;
        }
    }

    @NotNull
    private ExternalSystemTaskNotificationListener getTaskListener() {
        ExternalSystemTaskNotificationListener result2 = this.myRequest.getTaskListener();
        if (result2 == null) {
            result2 = new NoopExternalSystemTaskNotificationListener();
        }
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = result2;
        if (externalSystemTaskNotificationListener == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(3);
        }
        return externalSystemTaskNotificationListener;
    }

    private static boolean wasBuildCanceled(@NotNull Throwable buildError) {
        if (buildError == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(4);
        }
        return GradleUtil.hasCause(buildError, BuildCancelledException.class);
    }

    private void handleTaskExecutionError(@NotNull Throwable e) {
        if (e == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(5);
        }
        if (this.myProgressIndicator.isCanceled()) {
            GradleTasksExecutorImpl.getLogger().info("Failed to complete Gradle execution. Project may be closing or already closed.", e);
            return;
        }
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
        String error = Strings.nullToEmpty((String)rootCause.getMessage());
        if (error.contains("Build cancelled")) {
            return;
        }
        Runnable showErrorTask = () -> {
            ++this.myErrorCount;
            if (IdeInfo.getInstance().isAndroidStudio() && error.startsWith("Supplied javaHome is not a valid folder")) {
                IdeSdks ideSdks = IdeSdks.getInstance();
                File androidHome = ideSdks.getAndroidSdkPath();
                String androidSdkPath = androidHome != null ? androidHome.getPath() : null;
                SelectSdkDialog selectSdkDialog = new SelectSdkDialog(null, androidSdkPath);
                selectSdkDialog.setModal(true);
                if (selectSdkDialog.showAndGet()) {
                    String jdkHome = selectSdkDialog.getJdkHome();
                    UIUtil.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> ideSdks.setJdkPath(new File(jdkHome))));
                }
            }
        };
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myRequest.getProject(), (Runnable)showErrorTask);
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(GradleBuildInvoker.class);
        if (logger2 == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(6);
        }
        return logger2;
    }

    private void notifyGradleInvocationCompleted(@NotNull GradleBuildState buildState, long durationMillis) {
        Project project;
        if (buildState == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(7);
        }
        if (!(project = this.myRequest.getProject()).isDisposed()) {
            MessageType messageType;
            String statusMsg = this.createStatusMessage(buildState, durationMillis);
            MessageType messageType2 = messageType = this.myErrorCount > 0 ? MessageType.ERROR : MessageType.INFO;
            if (durationMillis > 60000L) {
                BALLOON_NOTIFICATION.createNotification(statusMsg, messageType).notify(project);
            } else {
                this.addToEventLog(statusMsg, messageType);
            }
            GradleTasksExecutorImpl.getLogger().info(statusMsg);
        }
    }

    @NotNull
    private String createStatusMessage(@NotNull GradleBuildState buildState, long durationMillis) {
        if (buildState == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(8);
        }
        String message2 = "Gradle build " + GradleTasksExecutorImpl.formatBuildStatusFromState(buildState);
        if (this.myErrorCount > 0) {
            message2 = message2 + String.format(Locale.US, " with %d error(s)", this.myErrorCount);
        }
        String string = message2 = message2 + " in " + StringUtil.formatDuration((long)durationMillis);
        if (string == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String formatBuildStatusFromState(@NotNull GradleBuildState state) {
        BuildSummary summary;
        if (state == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(10);
        }
        if ((summary = state.getSummary()) != null) {
            switch (summary.getStatus()) {
                case SKIPPED: {
                    return "skipped";
                }
                case SUCCESS: {
                    return "finished";
                }
                case FAILED: {
                    return "failed";
                }
                case CANCELED: {
                    return "cancelled";
                }
            }
        }
        return "finished";
    }

    private void addToEventLog(@NotNull String message2, @NotNull MessageType type) {
        if (message2 == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(11);
        }
        if (type == null) {
            GradleTasksExecutorImpl.$$$reportNull$$$0(12);
        }
        LOGGING_NOTIFICATION.createNotification(message2, type).notify(this.myProject);
    }

    private void attemptToStopBuild() {
        this.myBuildStopper.attemptToStopBuild(this.myRequest.getTaskId(), this.myProgressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueAndWaitForCompletion() {
        int counterBefore;
        Object object = this.myCompletionLock;
        synchronized (object) {
            counterBefore = this.myCompletionCounter;
        }
        this.queue();
        object = this.myCompletionLock;
        synchronized (object) {
            while (this.myCompletionCounter <= counterBefore) {
                try {
                    this.myCompletionLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public void onSuccess() {
        super.onSuccess();
        this.onCompletion();
    }

    public void onCancel() {
        super.onCancel();
        this.onCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletion() {
        Object object = this.myCompletionLock;
        synchronized (object) {
            ++this.myCompletionCounter;
            this.myCompletionLock.notifyAll();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildStopper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildError";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatusMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wasBuildCanceled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleTaskExecutionError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyGradleInvocationCompleted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStatusMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatBuildStatusFromState";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToEventLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProgressIndicatorStateDelegate
    extends TaskExecutionProgressIndicator {
        ProgressIndicatorStateDelegate(@NotNull ExternalSystemTaskId taskId, BuildStopper buildStopper) {
            if (taskId == null) {
                ProgressIndicatorStateDelegate.$$$reportNull$$$0(0);
            }
            if (buildStopper == null) {
                ProgressIndicatorStateDelegate.$$$reportNull$$$0(1);
            }
            super(taskId, buildStopper);
        }

        @Override
        void onCancel() {
            this.stopAppIconProgress();
        }

        public void stop() {
            super.stop();
            this.stopAppIconProgress();
        }

        private void stopAppIconProgress() {
            UIUtil.invokeLaterIfNeeded(() -> {
                Project project;
                AppIcon appIcon = AppIcon.getInstance();
                if (appIcon.hideProgress(project = GradleTasksExecutorImpl.this.myRequest.getProject(), (Object)GradleTasksExecutorImpl.APP_ICON_ID)) {
                    if (GradleTasksExecutorImpl.this.myErrorCount > 0) {
                        appIcon.setErrorBadge(project, String.valueOf(GradleTasksExecutorImpl.this.myErrorCount));
                        appIcon.requestAttention(project, true);
                    } else {
                        appIcon.setOkBadge(project, true);
                        appIcon.requestAttention(project, false);
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "taskId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildStopper";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutorImpl$ProgressIndicatorStateDelegate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CloseListener
    implements VetoableProjectManagerListener,
    ContentManagerListener {
        private boolean myIsApplicationExitingOrProjectClosing;
        private boolean myUserAcceptedCancel;

        private CloseListener() {
        }

        public void projectOpened(@NotNull Project project) {
            if (project == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
        }

        public boolean canClose(@NotNull Project project) {
            if (project == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            if (!project.equals(GradleTasksExecutorImpl.this.myProject)) {
                return true;
            }
            if (this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    return false;
                }
                GradleTasksExecutorImpl.this.attemptToStopBuild();
                return true;
            }
            return !GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
        }

        public void projectClosing(@NotNull Project project) {
            if (project == null) {
                CloseListener.$$$reportNull$$$0(2);
            }
            if (project.equals(GradleTasksExecutorImpl.this.myProject)) {
                this.myIsApplicationExitingOrProjectClosing = true;
            }
        }

        private boolean shouldPromptUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
        }

        private boolean askUserToCancelGradleExecution() {
            String msg = "Gradle is running. Proceed with Project closing?";
            int result2 = Messages.showYesNoDialog((Project)GradleTasksExecutorImpl.this.myProject, (String)msg, (String)GradleTasksExecutorImpl.GRADLE_RUNNING_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            return result2 == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutorImpl$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

