/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.NewProjectSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImporter {
    @NonNls
    private static final String SHOW_UNLINKED_GRADLE_POPUP = "show.inlinked.gradle.project.popup";
    @NotNull
    private final SdkSync mySdkSync;
    @NotNull
    private final NewProjectSetup myNewProjectSetup;
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;

    @NotNull
    public static GradleProjectImporter getInstance() {
        GradleProjectImporter gradleProjectImporter = (GradleProjectImporter)ApplicationManager.getApplication().getService(GradleProjectImporter.class);
        if (gradleProjectImporter == null) {
            GradleProjectImporter.$$$reportNull$$$0(0);
        }
        return gradleProjectImporter;
    }

    public GradleProjectImporter() {
        this(SdkSync.getInstance(), new NewProjectSetup(), new ProjectFolder.Factory());
    }

    @NonInjectable
    @VisibleForTesting
    GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull NewProjectSetup newProjectSetup, @NotNull ProjectFolder.Factory projectFolderFactory) {
        if (sdkSync == null) {
            GradleProjectImporter.$$$reportNull$$$0(1);
        }
        if (newProjectSetup == null) {
            GradleProjectImporter.$$$reportNull$$$0(2);
        }
        if (projectFolderFactory == null) {
            GradleProjectImporter.$$$reportNull$$$0(3);
        }
        this.mySdkSync = sdkSync;
        this.myNewProjectSetup = newProjectSetup;
        this.myProjectFolderFactory = projectFolderFactory;
    }

    @Nullable
    public Project importProjectCore(@NotNull VirtualFile projectFolder, @Nullable Project newProject) {
        if (projectFolder == null) {
            GradleProjectImporter.$$$reportNull$$$0(4);
        }
        File projectFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectFolder);
        try {
            this.setUpLocalProperties(projectFolderPath);
            if (newProject == null) {
                String projectName = projectFolder.getName();
                newProject = this.createProject(projectName, projectFolderPath);
            }
            this.importProjectNoSync(new Request(newProject));
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            this.getLogger().error(e);
            newProject = null;
        }
        return newProject;
    }

    private void setUpLocalProperties(@NotNull File projectFolderPath) throws IOException {
        if (projectFolderPath == null) {
            GradleProjectImporter.$$$reportNull$$$0(5);
        }
        try {
            LocalProperties localProperties = new LocalProperties(projectFolderPath);
            if (IdeInfo.getInstance().isAndroidStudio()) {
                this.mySdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            this.getLogger().info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            throw e;
        }
    }

    @NotNull
    private Logger getLogger() {
        Logger logger2 = Logger.getInstance(this.getClass());
        if (logger2 == null) {
            GradleProjectImporter.$$$reportNull$$$0(6);
        }
        return logger2;
    }

    public void importProjectNoSync(@NotNull Request request) throws IOException {
        if (request == null) {
            GradleProjectImporter.$$$reportNull$$$0(7);
        }
        File projectFolderPath = Projects.getBaseDirPath((Project)request.project).getAbsoluteFile();
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectFolderPath);
        projectFolder.createTopLevelBuildFile();
        projectFolder.createIdeaProjectFolder();
        Project newProject = request.project;
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(newProject);
        projectInfo.setNewProject(request.isNewProject);
        projectInfo.setImportedProject(true);
        GradleProjectImporter.silenceUnlinkedGradleProjectNotificationIfNecessary(newProject);
        this.myNewProjectSetup.prepareProjectForImport(newProject, request.javaLanguageLevel);
    }

    @NotNull
    public Project createProject(@NotNull String projectName, @NotNull File projectFolderPath) {
        if (projectName == null) {
            GradleProjectImporter.$$$reportNull$$$0(8);
        }
        if (projectFolderPath == null) {
            GradleProjectImporter.$$$reportNull$$$0(9);
        }
        Project newProject = this.myNewProjectSetup.createProject(projectName, projectFolderPath.toPath());
        GradleProjectSettings projectSettings = new GradleProjectSettings();
        GradleSettings settings = GradleSettings.getInstance((Project)newProject);
        GradleProjectImportUtil.setupGradleSettings((GradleSettings)settings);
        GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Path)projectFolderPath.toPath());
        GradleSettings.getInstance((Project)newProject).setStoreProjectFilesExternally(false);
        ExternalSystemApiUtil.getSettings((Project)newProject, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)projectSettings);
        Project project = newProject;
        if (project == null) {
            GradleProjectImporter.$$$reportNull$$$0(10);
        }
        return project;
    }

    private static void silenceUnlinkedGradleProjectNotificationIfNecessary(Project newProject) {
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject);
        if (gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            PropertiesComponent.getInstance((Project)newProject).setValue(SHOW_UNLINKED_GRADLE_POPUP, false, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/importing/GradleProjectImporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkSync";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProjectSetup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolderFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolder";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolderPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/importing/GradleProjectImporter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProjectCore";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUpLocalProperties";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importProjectNoSync";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        public final Project project;
        @Nullable
        public LanguageLevel javaLanguageLevel;
        public boolean isNewProject;

        public Request(@NotNull Project project) {
            if (project == null) {
                Request.$$$reportNull$$$0(0);
            }
            this.project = project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter$Request", "<init>"));
        }
    }
}

