/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.importing.TopLevelModuleFactory;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewProjectSetup {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");
    @NotNull
    private final TopLevelModuleFactory myTopLevelModuleFactory;

    public NewProjectSetup() {
        this(new TopLevelModuleFactory(IdeInfo.getInstance(), IdeSdks.getInstance()));
    }

    @VisibleForTesting
    NewProjectSetup(@NotNull TopLevelModuleFactory topLevelModuleFactory) {
        if (topLevelModuleFactory == null) {
            NewProjectSetup.$$$reportNull$$$0(0);
        }
        this.myTopLevelModuleFactory = topLevelModuleFactory;
    }

    @NotNull
    public Project createProject(@NotNull String projectName, @NotNull Path projectPath) {
        Project newProject;
        if (projectName == null) {
            NewProjectSetup.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            NewProjectSetup.$$$reportNull$$$0(2);
        }
        if ((newProject = ProjectManagerEx.getInstanceEx().newProject(projectPath, OpenProjectTask.newProject().withProjectName(projectName))) == null) {
            throw new NullPointerException("Failed to create a new project");
        }
        Sdk projectJdk = IdeSdks.getInstance().getJdk();
        if (projectJdk != null) {
            ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)newProject).setProjectSdk(projectJdk));
        }
        Project project = newProject;
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(3);
        }
        return project;
    }

    void prepareProjectForImport(@NotNull Project project, @Nullable LanguageLevel languageLevel) {
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(4);
        }
        TransactionGuard.submitTransaction((Disposable)project, () -> this.openProjectAndActivateProjectView(project));
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            LanguageLevelProjectExtension extension;
            Sdk jdk = IdeSdks.getInstance().getJdk();
            if (jdk != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)project).setProjectSdk(jdk));
            }
            if (languageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)project)) != null) {
                extension.setLanguageLevel(languageLevel);
            }
            File compilerOutputFolderPath = new File(Projects.getBaseDirPath((Project)project), FileUtil.join((String[])new String[]{"build", "classes"}));
            String compilerOutputFolderUrl = FilePaths.pathToIdeaUrl((File)compilerOutputFolderPath);
            CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)project);
            assert (compilerProjectExt != null);
            compilerProjectExt.setCompilerOutputUrl(compilerOutputFolderUrl);
            ProjectTypeService.setProjectType((Project)project, (ProjectType)ANDROID_PROJECT_TYPE);
        }), null, null);
    }

    private void openProjectAndActivateProjectView(@NotNull Project project) {
        if (project == null) {
            NewProjectSetup.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.myTopLevelModuleFactory.createTopLevelModule(project));
        GradleProjects.open(project);
        ToolWindows.activateProjectView(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelModuleFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/importing/NewProjectSetup";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/importing/NewProjectSetup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectForImport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openProjectAndActivateProjectView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

