/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.dsl.UpToDateChecker;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.intellij.openapi.project.Project;

public class GradleDslUpToDateChecker
implements UpToDateChecker {
    public boolean checkUpToDate(Project project) {
        return ((GradleDslUpToDateCheckerService)project.getService(GradleDslUpToDateCheckerService.class)).isUpToDate();
    }

    public void setUpToDate(Project project) {
        ((GradleDslUpToDateCheckerService)project.getService(GradleDslUpToDateCheckerService.class)).setModelUpToDate();
    }

    public static class GradleDslUpToDateCheckerService {
        private final Project myProject;
        private long myModelSyncTime = -1L;

        public GradleDslUpToDateCheckerService(Project project) {
            this.myProject = project;
        }

        public boolean isUpToDate() {
            long lastKnownSyncTime = GradleSyncState.getInstance(this.myProject).getLastSyncFinishedTimeStamp();
            return !GradleFiles.getInstance(this.myProject).areGradleFilesModified() && this.myModelSyncTime == lastKnownSyncTime;
        }

        public void setModelUpToDate() {
            this.myModelSyncTime = GradleSyncState.getInstance(this.myProject).getLastSyncFinishedTimeStamp();
        }
    }
}

