/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.cleanup.PreSyncProjectCleanUp;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncChecks;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleSyncInvoker {
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final PreSyncProjectCleanUp myPreSyncProjectCleanUp;
    @NotNull
    private final PreSyncChecks myPreSyncChecks;

    @NotNull
    public static GradleSyncInvoker getInstance() {
        GradleSyncInvoker gradleSyncInvoker = (GradleSyncInvoker)ApplicationManager.getApplication().getService(GradleSyncInvoker.class);
        if (gradleSyncInvoker == null) {
            GradleSyncInvoker.$$$reportNull$$$0(0);
        }
        return gradleSyncInvoker;
    }

    public GradleSyncInvoker() {
        this(FileDocumentManager.getInstance(), new PreSyncProjectCleanUp(), new PreSyncChecks());
    }

    private GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull PreSyncProjectCleanUp preSyncProjectCleanUp, @NotNull PreSyncChecks preSyncChecks) {
        if (fileDocumentManager == null) {
            GradleSyncInvoker.$$$reportNull$$$0(1);
        }
        if (preSyncProjectCleanUp == null) {
            GradleSyncInvoker.$$$reportNull$$$0(2);
        }
        if (preSyncChecks == null) {
            GradleSyncInvoker.$$$reportNull$$$0(3);
        }
        this.myFileDocumentManager = fileDocumentManager;
        this.myPreSyncProjectCleanUp = preSyncProjectCleanUp;
        this.myPreSyncChecks = preSyncChecks;
    }

    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(4);
        }
        if (trigger == null) {
            GradleSyncInvoker.$$$reportNull$$$0(5);
        }
        this.requestProjectSync(project, trigger, null);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger, @Nullable GradleSyncListener listener2) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(6);
        }
        if (trigger == null) {
            GradleSyncInvoker.$$$reportNull$$$0(7);
        }
        Request request = new Request(trigger);
        this.requestProjectSync(project, request, listener2);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(8);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(9);
        }
        this.requestProjectSync(project, request, null);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(10);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(11);
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        if (GradleSyncInvoker.isBuildInProgress(project)) {
            GradleProjects.setSyncRequestedDuringBuild(project, true);
            return;
        }
        Runnable syncTask = () -> {
            ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            if (this.prepareProject(project, listener2)) {
                this.sync(project, request, listener2);
            }
        };
        GradleSyncState.getInstance(project).syncTaskCreated(request, listener2);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(syncTask);
        } else if (request.runInBackground) {
            application.invokeLater(syncTask, project.getDisposed());
        } else {
            application.invokeAndWait(syncTask);
        }
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        IdeFrame frame;
        StatusBarEx statusBar;
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(12);
        }
        StatusBarEx statusBarEx = statusBar = (frame = WindowManagerEx.getInstanceEx().findFrameFor(project)) == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task2 = (TaskInfo)backgroundProcess.getFirst();
            if (!(task2 instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private boolean prepareProject(@NotNull Project project, @Nullable GradleSyncListener listener2) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(13);
        }
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(project);
        if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() || projectInfo.hasTopLevelGradleFile()) {
            boolean isImportedProject = projectInfo.isImportedProject();
            if (!isImportedProject) {
                this.myFileDocumentManager.saveAllDocuments();
            }
            return true;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
            AndroidNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
            if (listener2 != null) {
                listener2.syncFailed(project, msg);
            }
        });
        return false;
    }

    @WorkerThread
    private void sync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        PreSyncCheckResult checkResult;
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(14);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(15);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(project).removeAllMessages());
        if (!request.skipPreSyncChecks && !(checkResult = this.runPreSyncChecks(project)).isSuccess()) {
            String cause = Strings.nullToEmpty((String)checkResult.getFailureCause());
            GradleSyncInvoker.handlePreSyncCheckFailure(project, cause, listener2, request);
            return;
        }
        this.myPreSyncProjectCleanUp.cleanUp(project);
        if (!GradleSyncState.getInstance(project).syncStarted(request, listener2)) {
            return;
        }
        new GradleSyncExecutor(project).sync(request, listener2);
    }

    @VisibleForTesting
    @NotNull
    PreSyncCheckResult runPreSyncChecks(@NotNull Project project) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(16);
        }
        PreSyncCheckResult preSyncCheckResult = this.myPreSyncChecks.canSyncAndTryToFix(project);
        if (preSyncCheckResult == null) {
            GradleSyncInvoker.$$$reportNull$$$0(17);
        }
        return preSyncCheckResult;
    }

    private static void handlePreSyncCheckFailure(@NotNull Project project, @NotNull String failureCause, @Nullable GradleSyncListener syncListener, @NotNull Request request) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(18);
        }
        if (failureCause == null) {
            GradleSyncInvoker.$$$reportNull$$$0(19);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(20);
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        ExternalSystemTaskId taskId = GradleSyncInvoker.createFailedPreCheckSyncTaskWithStartMessage(project);
        syncState.setExternalSystemTaskId(taskId);
        if (syncState.syncStarted(request, syncListener)) {
            syncState.syncFailed(failureCause, null, syncListener);
        }
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        List<Failure> failures = messages.showEvents(taskId);
        FailureResultImpl result2 = new FailureResultImpl(failures);
        FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), failureCause, (EventResult)result2);
        ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((Object)taskId, (BuildEvent)finishBuildEvent);
    }

    @NotNull
    public static ExternalSystemTaskId createFailedPreCheckSyncTaskWithStartMessage(@NotNull Project project) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(21);
        }
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
        String workingDir = FileUtil.toCanonicalPath((String)Projects.getBaseDirPath((Project)project).getPath());
        DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)taskId, "Preparing for sync", workingDir, System.currentTimeMillis());
        SyncViewManager syncManager = (SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class);
        syncManager.onEvent((Object)taskId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "Running pre sync checks..."));
        ExternalSystemTaskId externalSystemTaskId = taskId;
        if (externalSystemTaskId == null) {
            GradleSyncInvoker.$$$reportNull$$$0(22);
        }
        return externalSystemTaskId;
    }

    @NotNull
    public List<GradleModuleModels> fetchGradleModels(@NotNull Project project) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(23);
        }
        List<GradleModuleModels> list = new GradleSyncExecutor(project).fetchGradleModels();
        if (list == null) {
            GradleSyncInvoker.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preSyncProjectCleanUp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preSyncChecks";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failureCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "runPreSyncChecks";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFailedPreCheckSyncTaskWithStartMessage";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchGradleModels";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBuildInProgress";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareProject";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runPreSyncChecks";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "handlePreSyncCheckFailure";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFailedPreCheckSyncTaskWithStartMessage";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fetchGradleModels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        public final GradleSyncStats.Trigger trigger;
        public boolean runInBackground;
        public boolean useCachedGradleModels;
        public boolean forceFullVariantsSync;
        public boolean skipPreSyncChecks;
        @Nullable
        public VariantOnlySyncOptions variantOnlySyncOptions;

        @VisibleForTesting
        @NotNull
        public static Request testRequest() {
            return new Request(GradleSyncStats.Trigger.TRIGGER_TEST_REQUESTED);
        }

        public Request(@NotNull GradleSyncStats.Trigger trigger) {
            if (trigger == null) {
                Request.$$$reportNull$$$0(0);
            }
            this.runInBackground = true;
            this.trigger = trigger;
        }

        @NotNull
        public ProgressExecutionMode getProgressExecutionMode() {
            ProgressExecutionMode progressExecutionMode = this.runInBackground ? ProgressExecutionMode.IN_BACKGROUND_ASYNC : ProgressExecutionMode.MODAL_SYNC;
            if (progressExecutionMode == null) {
                Request.$$$reportNull$$$0(1);
            }
            return progressExecutionMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.trigger == request.trigger && this.runInBackground == request.runInBackground && this.useCachedGradleModels == request.useCachedGradleModels && this.forceFullVariantsSync == request.forceFullVariantsSync && this.skipPreSyncChecks == request.skipPreSyncChecks && Objects.equals(this.variantOnlySyncOptions, request.variantOnlySyncOptions);
        }

        public int hashCode() {
            return Objects.hash(this.trigger, this.runInBackground, this.useCachedGradleModels, this.forceFullVariantsSync, this.skipPreSyncChecks, this.variantOnlySyncOptions);
        }

        public String toString() {
            return "RequestSettings{trigger=" + this.trigger + ", runInBackground=" + this.runInBackground + ", useCachedGradleModels=" + this.useCachedGradleModels + ", forceFullVariantsSync=" + this.forceFullVariantsSync + ", skipPreSyncChecks=" + this.skipPreSyncChecks + ", variantOnlySyncOptions=" + this.variantOnlySyncOptions + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigger";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProgressExecutionMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

