/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenProjectStructureHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DaemonContextMismatchErrorHandler
extends BaseSyncErrorHandler {
    private static final String JAVA_HOME = "javaHome=";

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String expectedAndActual;
        String text;
        List<String> message2;
        if (rootCause == null) {
            DaemonContextMismatchErrorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DaemonContextMismatchErrorHandler.$$$reportNull$$$0(1);
        }
        if ((message2 = DaemonContextMismatchErrorHandler.getMessageLines(text = rootCause.getMessage())).isEmpty()) {
            return null;
        }
        String firstLine = message2.get(0);
        if (StringUtil.isNotEmpty((String)firstLine) && firstLine.contains("The newly created daemon process has a different context than expected.") && message2.size() > 3 && "Java home is different.".equals(message2.get(2)) && StringUtil.isNotEmpty((String)(expectedAndActual = DaemonContextMismatchErrorHandler.parseExpectedAndActualJavaHomes(text)))) {
            DaemonContextMismatchErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.DAEMON_CONTEXT_MISMATCH);
            return firstLine + "\n" + message2.get(2) + "\n" + expectedAndActual + "\nPlease configure the JDK to match the expected one.";
        }
        return null;
    }

    @VisibleForTesting
    static String parseExpectedAndActualJavaHomes(@NotNull String errorMsg) {
        String expected2;
        int endIndex;
        int startIndex;
        if (errorMsg == null) {
            DaemonContextMismatchErrorHandler.$$$reportNull$$$0(2);
        }
        if ((startIndex = errorMsg.indexOf(JAVA_HOME)) != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex && StringUtil.isNotEmpty((String)(expected2 = errorMsg.substring(startIndex, endIndex)))) {
            String actual = null;
            startIndex = errorMsg.indexOf(JAVA_HOME, endIndex);
            if (startIndex != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex) {
                actual = errorMsg.substring(startIndex, endIndex);
            }
            Object s = String.format("Expecting: '%1$s'", expected2);
            s = actual != null ? (String)s + String.format(" but was: '%1$s'.", actual) : (String)s + ".";
            return s;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            DaemonContextMismatchErrorHandler.$$$reportNull$$$0(3);
        }
        if (text == null) {
            DaemonContextMismatchErrorHandler.$$$reportNull$$$0(4);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(OpenProjectStructureHyperlink.openJdkSettings(project));
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            DaemonContextMismatchErrorHandler.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMsg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseExpectedAndActualJavaHomes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

