/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.utils.BuildScriptUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginAction;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleDslMethodNotFoundErrorHandler
extends SyncErrorHandler {
    private static final String GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX = "Gradle DSL method not found";
    private static final Pattern MISSING_METHOD_PATTERN = Pattern.compile("Could not find method (.*?) .*");

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        if (error == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(2);
        }
        if ((text = GradleDslMethodNotFoundErrorHandler.findErrorMessage(project, this.getRootCause(error))) != null) {
            GradleDslMethodNotFoundErrorHandler.getQuickFixHyperlinks(notification, project, text);
            return true;
        }
        return false;
    }

    private static String findErrorMessage(@NotNull Project project, @NotNull Throwable rootCause) {
        String errorType;
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(3);
        }
        if (rootCause == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(4);
        }
        if ((errorType = rootCause.getClass().getName()).equals("org.gradle.api.internal.MissingMethodException") || errorType.equals("org.gradle.internal.metaobject.AbstractDynamicObject$CustomMessageMissingMethodException")) {
            String method = GradleDslMethodNotFoundErrorHandler.parseMissingMethod(rootCause.getMessage());
            GradleDslMethodNotFoundErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.DSL_METHOD_NOT_FOUND);
            return "Gradle DSL method not found: '" + method + "'";
        }
        return null;
    }

    @NotNull
    private static String parseMissingMethod(@NotNull String rootCauseText) {
        Matcher matcher;
        if (rootCauseText == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(5);
        }
        return (matcher = MISSING_METHOD_PATTERN.matcher(rootCauseText)).find() ? matcher.group(1) : "";
    }

    private static void getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        VirtualFile file;
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(7);
        }
        if (text == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(8);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        String filePath = notification.getFilePath();
        VirtualFile virtualFile = file = filePath != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath) : null;
        if (filePath != null && file != null && BuildScriptUtil.isDefaultGradleBuildFile((File)new File(filePath))) {
            GradleDslMethodNotFoundErrorHandler.updateNotificationWithBuildFile(project, file, notification, text);
            return;
        }
        if (file != null && notification.getLine() > 0 && notification.getNavigatable() == null) {
            OpenFileHyperlink hyperlink = new OpenFileHyperlink(filePath, notification.getLine() - 1);
            hyperlinks.add(hyperlink);
        }
        GradleSyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
    }

    private static void updateNotificationWithBuildFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull NotificationData notification, @NotNull String text) {
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(10);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(11);
        }
        if (text == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(12);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        NotificationHyperlink gradleSettingsHyperlink = GradleDslMethodNotFoundErrorHandler.getGradleSettingsHyperlink(project);
        NotificationHyperlink applyGradlePluginHyperlink = GradleDslMethodNotFoundErrorHandler.getApplyGradlePluginHyperlink(virtualFile, notification);
        FixAndroidGradlePluginVersionHyperlink upgradeAndroidPluginHyperlink = new FixAndroidGradlePluginVersionHyperlink();
        String newMsg = text + "\nPossible causes:\n";
        if (!GradleDslMethodNotFoundErrorHandler.gradleModelIsRecent(project)) {
            newMsg = newMsg + String.format("The project '%1$s' may be using a version of the Android Gradle plug-in that does not contain the method (e.g. 'testCompile' was added in 1.1.0).\n", project.getName());
            if (!GradleUtil.hasKtsBuildFiles(project)) {
                newMsg = newMsg + upgradeAndroidPluginHyperlink.toHtml() + "\n";
            }
            newMsg = newMsg + "\n";
        }
        newMsg = newMsg + String.format("The project '%1$s' may be using a version of Gradle that does not contain the method.\n", project.getName()) + gradleSettingsHyperlink.toHtml() + "\n\nThe build file may be missing a Gradle plugin.\n" + applyGradlePluginHyperlink.toHtml();
        notification.setTitle("Gradle Sync Issues");
        notification.setMessage(newMsg);
        notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
        hyperlinks.add(gradleSettingsHyperlink);
        hyperlinks.add(applyGradlePluginHyperlink);
        hyperlinks.add(upgradeAndroidPluginHyperlink);
        GradleSyncMessages.getInstance(project).addNotificationListener(notification, hyperlinks);
    }

    @NotNull
    private static NotificationHyperlink getGradleSettingsHyperlink(@NotNull Project project) {
        VirtualFile propertiesFile;
        GradleWrapper gradleWrapper;
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(13);
        }
        if (GradleDslMethodNotFoundErrorHandler.isUsingWrapper(project) && (gradleWrapper = GradleWrapper.find(project)) != null && (propertiesFile = gradleWrapper.getPropertiesFile()) != null) {
            return new NotificationHyperlink("open.wrapper.file", "Open Gradle wrapper file"){

                @Override
                protected void execute(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, propertiesFile);
                    FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundErrorHandler$1", "execute"));
                }
            };
        }
        return new OpenGradleSettingsHyperlink();
    }

    private static boolean gradleModelIsRecent(@NotNull Project project) {
        GradleVersion pluginVersion;
        AndroidPluginInfo androidPluginInfo;
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(14);
        }
        if ((androidPluginInfo = AndroidPluginInfo.findFromBuildFiles(project)) != null && (pluginVersion = androidPluginInfo.getPluginVersion()) != null) {
            return pluginVersion.compareTo(LatestKnownPluginVersionProvider.INSTANCE.get()) > 0;
        }
        return false;
    }

    private static boolean isUsingWrapper(@NotNull Project project) {
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(15);
        }
        GradleProjectSettings gradleSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        return (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && gradleWrapper != null;
    }

    @NotNull
    private static NotificationHyperlink getApplyGradlePluginHyperlink(final @NotNull VirtualFile virtualFile, final @NotNull NotificationData notification) {
        if (virtualFile == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(16);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(17);
        }
        return new NotificationHyperlink("apply.gradle.plugin", "Apply Gradle plugin"){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                GradleDslMethodNotFoundErrorHandler.openFile(virtualFile, notification, project);
                ActionManager actionManager = ActionManager.getInstance();
                String actionId = "AddGradleDslPluginAction";
                AnAction action2 = actionManager.getAction(actionId);
                assert (action2 instanceof AddGradleDslPluginAction);
                AddGradleDslPluginAction addPluginAction = (AddGradleDslPluginAction)action2;
                actionManager.tryToExecute((AnAction)addPluginAction, ActionCommand.getInputEvent((String)actionId), null, "unknown", true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundErrorHandler$2", "execute"));
            }
        };
    }

    private static void openFile(@NotNull VirtualFile virtualFile, @NotNull NotificationData notification, @NotNull Project project) {
        if (virtualFile == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(18);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(19);
        }
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(20);
        }
        int line = notification.getLine() - 1;
        int column = notification.getColumn() - 1;
        line = line < 0 ? -1 : line;
        column = column < 0 ? -1 : column + 1;
        new OpenFileDescriptor(project, virtualFile, line, column).navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCauseText";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMissingMethod";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuickFixHyperlinks";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationWithBuildFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getGradleSettingsHyperlink";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "gradleModelIsRecent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsingWrapper";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplyGradlePluginHyperlink";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

