/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHeapSpaceErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text;
        List<String> message2;
        int lineCount;
        if (rootCause == null) {
            JavaHeapSpaceErrorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaHeapSpaceErrorHandler.$$$reportNull$$$0(1);
        }
        if ((lineCount = (message2 = JavaHeapSpaceErrorHandler.getMessageLines(text = rootCause.getMessage())).size()) == 0) {
            return null;
        }
        String firstLine = message2.get(0);
        String newMsg = null;
        if (StringUtil.isNotEmpty((String)firstLine) && firstLine.endsWith("Java heap space")) {
            newMsg = firstLine + ".";
        } else if (StringUtil.isNotEmpty((String)firstLine) && lineCount > 1 && firstLine.startsWith("Unable to start the daemon process")) {
            Object cause = null;
            for (int i2 = 1; i2 < lineCount; ++i2) {
                String line = message2.get(i2);
                if (!"Error occurred during initialization of VM".equals(line) || i2 >= lineCount - 1) continue;
                cause = message2.get(i2 + 1);
                break;
            }
            if (cause != null && ((String)cause).startsWith("Could not reserve enough space for object heap")) {
                firstLine = StringUtil.trimEnd((String)firstLine, (String)".");
                if (!((String)cause).endsWith(".")) {
                    cause = (String)cause + ".";
                }
                newMsg = firstLine + ": " + StringUtil.decapitalize((String)cause);
            }
        }
        if (StringUtil.isNotEmpty(newMsg)) {
            newMsg = newMsg + "\nPlease assign more memory to Gradle in the project's gradle.properties file.\nFor example, the following line, in the gradle.properties file, sets the maximum Java heap size to 1,024 MB:\n<em>org.gradle.jvmargs=-Xmx1024m</em>";
            if (rootCause instanceof OutOfMemoryError) {
                newMsg = "Out of memory: " + newMsg;
                JavaHeapSpaceErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.OUT_OF_MEMORY);
            } else {
                JavaHeapSpaceErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.JAVA_HEAP_ERROR);
            }
            return newMsg;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            JavaHeapSpaceErrorHandler.$$$reportNull$$$0(2);
        }
        if (text == null) {
            JavaHeapSpaceErrorHandler.$$$reportNull$$$0(3);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new OpenUrlHyperlink("http://www.gradle.org/docs/current/userguide/build_environment.html", "Read Gradle's configuration guide"));
        hyperlinks.add(new OpenUrlHyperlink("http://docs.oracle.com/javase/7/docs/technotes/guides/vm/gc-ergonomics.html", "Read about Java's heap size"));
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            JavaHeapSpaceErrorHandler.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

