/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.BuildProjectHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ObjectStreamErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        if (error == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(2);
        }
        if ((text = ObjectStreamErrorHandler.findErrorMessage(project, error)) != null) {
            ObjectStreamErrorHandler.findAndAddQuickFixes(notification, project, text);
            return true;
        }
        return false;
    }

    private static String findErrorMessage(@NotNull Project project, @NotNull Throwable rootCause) {
        String text;
        if (project == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(3);
        }
        if (rootCause == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(text = rootCause.getMessage())) && ObjectStreamErrorHandler.getFirstLineMessage(text).endsWith("unexpected end of block data")) {
            ObjectStreamErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.OBJECT_STREAM_ERROR);
            Object newMsg = "An unexpected I/O error occurred.\n";
            newMsg = (String)newMsg + String.format("The error, \"%1$s\" usually happens on Linux when Build-tools or an Android platform being used in a project is not installed.\n", text);
            return newMsg;
        }
        return null;
    }

    private static void findAndAddQuickFixes(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(6);
        }
        if (text == null) {
            ObjectStreamErrorHandler.$$$reportNull$$$0(7);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        BuildProjectHyperlink buildProjectHyperlink = new BuildProjectHyperlink();
        OpenAndroidSdkManagerHyperlink openAndroidSdkManagerHyperlink = new OpenAndroidSdkManagerHyperlink();
        text = (String)text + "Please try one of the following:\n" + buildProjectHyperlink.toHtml() + " to obtain the cause of the error\n\n" + openAndroidSdkManagerHyperlink.toHtml() + " to check if there are any missing components";
        hyperlinks.add(buildProjectHyperlink);
        hyperlinks.add(openAndroidSdkManagerHyperlink);
        notification.setTitle("Gradle Sync Issues");
        notification.setMessage((String)text);
        notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
        GradleSyncMessages.getInstance(project).addNotificationListener(notification, hyperlinks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/ObjectStreamErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorMessage";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndAddQuickFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

