/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;

public class GradleModuleModelDataService
extends ModuleModelDataService<GradleModuleModel> {
    @NotNull
    private final GradleModuleSetup myModuleSetup;

    public GradleModuleModelDataService() {
        this(new GradleModuleSetup());
    }

    @VisibleForTesting
    GradleModuleModelDataService(@NotNull GradleModuleSetup moduleSetup) {
        if (moduleSetup == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(0);
        }
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<GradleModuleModel> getTargetDataKey() {
        Key<GradleModuleModel> key = AndroidProjectKeys.GRADLE_MODULE_MODEL;
        if (key == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<GradleModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, GradleModuleModel> modelsByModuleName) {
        if (toImport == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(4);
        }
        if (modelsByModuleName == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(5);
        }
        for (Module module : modelsProvider.getModules()) {
            GradleModuleModel gradleModuleModel = modelsByModuleName.get(module.getName());
            if (gradleModuleModel == null) {
                this.onModelNotFound(module, modelsProvider);
                continue;
            }
            this.myModuleSetup.setUpModule(module, modelsProvider, gradleModuleModel);
        }
        GradleModuleModelDataService.populateExtraBuildParticipantFromBuildSrc(toImport, project);
    }

    @Override
    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(7);
        }
        Facets.removeAllFacets(modelsProvider.getModifiableFacetModel(module), GradleFacet.getFacetTypeId());
    }

    private static void populateExtraBuildParticipantFromBuildSrc(@NotNull Collection<DataNode<GradleModuleModel>> toImport, @NotNull Project project) {
        BuildParticipant participant;
        if (toImport == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(9);
        }
        if (toImport.isEmpty()) {
            return;
        }
        DataNode<ProjectData> projectDataDataNode = GradleModuleModelDataService.findProjectDataNode(toImport.iterator().next());
        if (projectDataDataNode != null && !(participant = GradleModuleModelDataService.getParticipant(projectDataDataNode)).getProjects().isEmpty()) {
            project.putUserData(ModuleFinder.EXTRA_BUILD_PARTICIPANT_FROM_BUILD_SRC, (Object)participant);
        }
    }

    @NotNull
    private static BuildParticipant getParticipant(@NotNull DataNode<ProjectData> projectDataDataNode) {
        if (projectDataDataNode == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(10);
        }
        BuildParticipant participant = new BuildParticipant();
        participant.setRootProjectName(((ProjectData)projectDataDataNode.getData()).getExternalName());
        for (DataNode moduleNode : ExternalSystemApiUtil.getChildren(projectDataDataNode, (Key)ProjectKeys.MODULE)) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)"true", (CharSequence)((ModuleData)moduleNode.getData()).getProperty("buildSrcModule"))) continue;
            String moduleFolder = ((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath();
            participant.getProjects().add(moduleFolder);
            if (!"buildSrc".equals(((ModuleData)moduleNode.getData()).getExternalName())) continue;
            participant.setRootPath(moduleFolder);
        }
        BuildParticipant buildParticipant = participant;
        if (buildParticipant == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(11);
        }
        return buildParticipant;
    }

    @Nullable
    private static DataNode<ProjectData> findProjectDataNode(@NotNull DataNode<GradleModuleModel> gradleModuleDataNode) {
        DataNode projectDataNode;
        DataNode moduleDataNode;
        if (gradleModuleDataNode == null) {
            GradleModuleModelDataService.$$$reportNull$$$0(12);
        }
        if ((moduleDataNode = gradleModuleDataNode.getParent()) != null && (projectDataNode = moduleDataNode.getParent()) != null) {
            return projectDataNode.getDataNode(ProjectKeys.PROJECT);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetup";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsByModuleName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataDataNode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModuleDataNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/data/service/GradleModuleModelDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParticipant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onModelNotFound";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateExtraBuildParticipantFromBuildSrc";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParticipant";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findProjectDataNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

