/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.hyperlink.ConfirmSHA256FromGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.RemoveSHA256FromGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.PersistentSHA256Checksums;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class GradleWrapperPreSyncCheck
extends AndroidStudioSyncCheck {
    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSyncAndTryToFix(@NotNull Project project) {
        block9: {
            GradleWrapper gradleWrapper;
            if (project == null) {
                GradleWrapperPreSyncCheck.$$$reportNull$$$0(0);
            }
            if ((gradleWrapper = GradleWrapper.find(project)) != null) {
                PreSyncCheckResult preSyncCheckResult;
                File propertiesFilePath;
                block10: {
                    propertiesFilePath = gradleWrapper.getPropertiesFilePath();
                    if (gradleWrapper.getDistributionSha256Sum() == null) break block9;
                    if (!GradleWrapperPreSyncCheck.continueWithSync(gradleWrapper)) break block10;
                    PreSyncCheckResult preSyncCheckResult2 = PreSyncCheckResult.SUCCESS;
                    if (preSyncCheckResult2 == null) {
                        GradleWrapperPreSyncCheck.$$$reportNull$$$0(1);
                    }
                    return preSyncCheckResult2;
                }
                try {
                    String fileName = propertiesFilePath.getName();
                    String MORE_INFO_URL = "https://github.com/gradle/gradle/issues/9361";
                    String errorMessage = "It is not fully supported to define distributionSha256Sum in " + fileName + ".\nUsing an incorrect value may freeze or crash Android Studio.\nPlease manually verify or remove this property from all of included projects if applicable.\nFor more details, see " + MORE_INFO_URL + ".\n";
                    SyncMessage syncMessage = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, errorMessage);
                    ConfirmSHA256FromGradleWrapperHyperlink confirmHyperlink = ConfirmSHA256FromGradleWrapperHyperlink.create(gradleWrapper);
                    if (confirmHyperlink != null) {
                        syncMessage.add(confirmHyperlink);
                    }
                    syncMessage.add(new RemoveSHA256FromGradleWrapperHyperlink());
                    syncMessage.add(new OpenFileHyperlink(propertiesFilePath.getAbsolutePath(), "Open Gradle wrapper properties", -1, -1));
                    GradleSyncMessages.getInstance(project).report(syncMessage);
                    SyncIssueUsageReporter.Companion.getInstance(project).collect(AndroidStudioEvent.GradleSyncFailure.DISTRIBUTIONSHA256SUM_FOUND_IN_WRAPPER);
                    preSyncCheckResult = PreSyncCheckResult.failure("Sync cancelled due to distributionSha256Sum in " + fileName);
                }
                catch (IOException e) {
                    Logger.getInstance(this.getClass()).warn("Unsupported property distributionSha256Sum in " + propertiesFilePath.getPath());
                }
                if (preSyncCheckResult == null) {
                    GradleWrapperPreSyncCheck.$$$reportNull$$$0(2);
                }
                return preSyncCheckResult;
            }
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        if (preSyncCheckResult == null) {
            GradleWrapperPreSyncCheck.$$$reportNull$$$0(3);
        }
        return preSyncCheckResult;
    }

    private static boolean continueWithSync(@NotNull GradleWrapper wrapper) {
        if (wrapper == null) {
            GradleWrapperPreSyncCheck.$$$reportNull$$$0(4);
        }
        PersistentSHA256Checksums checksums = PersistentSHA256Checksums.getInstance();
        try {
            String URLString = wrapper.getDistributionUrl();
            if (URLString == null) {
                return false;
            }
            URL url = new URL(URLString);
            if (url.getProtocol().equalsIgnoreCase("file")) {
                return true;
            }
            return checksums.isChecksumStored(wrapper.getDistributionUrl(), wrapper.getDistributionSha256Sum());
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/precheck/GradleWrapperPreSyncCheck";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/precheck/GradleWrapperPreSyncCheck";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCheckCanSyncAndTryToFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCheckCanSyncAndTryToFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "continueWithSync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

