/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public final class DependencySetupIssues {
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final Map<String, MissingModule> myMissingModules;
    @NotNull
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath;
    @NotNull
    private final Set<InvalidModuleDependency> myInvalidModuleDependencies;

    @NotNull
    public static DependencySetupIssues getInstance(@NotNull Project project) {
        if (project == null) {
            DependencySetupIssues.$$$reportNull$$$0(0);
        }
        DependencySetupIssues dependencySetupIssues = (DependencySetupIssues)ServiceManager.getService((Project)project, DependencySetupIssues.class);
        if (dependencySetupIssues == null) {
            DependencySetupIssues.$$$reportNull$$$0(1);
        }
        return dependencySetupIssues;
    }

    public DependencySetupIssues(@NotNull Project project) {
        if (project == null) {
            DependencySetupIssues.$$$reportNull$$$0(2);
        }
        this.myMissingModules = new ConcurrentHashMap<String, MissingModule>();
        this.myDependentsOnLibrariesWithoutBinaryPath = new CopyOnWriteArraySet<String>();
        this.myInvalidModuleDependencies = new CopyOnWriteArraySet<InvalidModuleDependency>();
        this.mySyncMessages = GradleSyncMessages.getInstance(project);
    }

    @NonInjectable
    public DependencySetupIssues(@NotNull GradleSyncMessages syncMessages) {
        if (syncMessages == null) {
            DependencySetupIssues.$$$reportNull$$$0(3);
        }
        this.myMissingModules = new ConcurrentHashMap<String, MissingModule>();
        this.myDependentsOnLibrariesWithoutBinaryPath = new CopyOnWriteArraySet<String>();
        this.myInvalidModuleDependencies = new CopyOnWriteArraySet<InvalidModuleDependency>();
        this.mySyncMessages = syncMessages;
    }

    public void reportIssues() {
        String msg;
        this.reportModulesNotFoundIssues(this.getMissingModules());
        for (String dependent : this.getDependentsOnLibrariesWithoutBinaryPath()) {
            msg = String.format("Module '%1$s' depends on libraries that do not have a 'binary' path.", dependent);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.ERROR, msg));
        }
        for (InvalidModuleDependency dependency : this.myInvalidModuleDependencies) {
            msg = String.format("Ignoring dependency of module '%1$s' on module '%2$s'. %3$s", dependency.dependent, dependency.dependency.getName(), dependency.cause);
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(dependency.dependency);
            assert (buildFile != null);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(dependency.dependency.getProject(), buildFile, 0);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.WARNING, (Navigatable)navigatable, msg));
        }
        this.clear();
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModules() {
        return DependencySetupIssues.getMissingModules(this.myMissingModules);
    }

    @NotNull
    private static List<MissingModule> getMissingModules(@NotNull Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName == null) {
            DependencySetupIssues.$$$reportNull$$$0(4);
        }
        if (missingModulesByName.isEmpty()) {
            List<MissingModule> list = Collections.emptyList();
            if (list == null) {
                DependencySetupIssues.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<MissingModule> missingModules = new ArrayList<MissingModule>();
        ArrayList<String> names = new ArrayList<String>(missingModulesByName.keySet());
        if (names.size() > 1) {
            names.sort(String::compareTo);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        ArrayList<MissingModule> arrayList = missingModules;
        if (arrayList == null) {
            DependencySetupIssues.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @VisibleForTesting
    @NotNull
    List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        return DependencySetupIssues.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
    }

    @NotNull
    private static List<String> sortSet(@NotNull Set<String> set) {
        if (set == null) {
            DependencySetupIssues.$$$reportNull$$$0(7);
        }
        if (set.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DependencySetupIssues.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<String> sorted2 = new ArrayList<String>(set);
        if (sorted2.size() > 1) {
            sorted2.sort(String::compareTo);
        }
        ArrayList<String> arrayList = sorted2;
        if (arrayList == null) {
            DependencySetupIssues.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private void reportModulesNotFoundIssues(@NotNull List<MissingModule> missingModules) {
        if (missingModules == null) {
            DependencySetupIssues.$$$reportNull$$$0(10);
        }
        if (!missingModules.isEmpty()) {
            for (MissingModule missingModule : missingModules) {
                ArrayList<String> messageLines = new ArrayList<String>();
                StringBuilder text = new StringBuilder();
                text.append(String.format("Unable to find module with Gradle path '%1$s' (needed by module", missingModule.dependencyPath));
                DependencySetupIssues.addDependentsToText(text, missingModule.dependentNames);
                text.append(".)");
                messageLines.add(text.toString());
                this.mySyncMessages.report(new SyncMessage("Missing Dependencies", missingModule.issueType, ArrayUtil.toStringArray(messageLines)));
            }
        }
    }

    private static void addDependentsToText(@NotNull StringBuilder text, @NotNull List<String> dependents) {
        if (text == null) {
            DependencySetupIssues.$$$reportNull$$$0(11);
        }
        if (dependents == null) {
            DependencySetupIssues.$$$reportNull$$$0(12);
        }
        assert (!dependents.isEmpty());
        if (dependents.size() == 1) {
            text.append(String.format(" '%1$s'", dependents.get(0)));
            return;
        }
        text.append("s: ");
        int i2 = 0;
        for (String dependent : dependents) {
            if (i2++ > 0) {
                text.append(", ");
            }
            text.append(String.format("'%1$s'", dependent));
        }
    }

    private void clear() {
        this.myMissingModules.clear();
        this.myDependentsOnLibrariesWithoutBinaryPath.clear();
        this.myInvalidModuleDependencies.clear();
    }

    public void addMissingModule(@NotNull String dependencyName, @NotNull String dependentName) {
        if (dependencyName == null) {
            DependencySetupIssues.$$$reportNull$$$0(13);
        }
        if (dependentName == null) {
            DependencySetupIssues.$$$reportNull$$$0(14);
        }
        Map<String, MissingModule> mapping = this.myMissingModules;
        MissingModule missingModule = mapping.computeIfAbsent(dependencyName, name -> new MissingModule((String)name));
        missingModule.addDependent(dependentName);
    }

    public void addMissingBinaryPath(@NotNull String dependentName) {
        if (dependentName == null) {
            DependencySetupIssues.$$$reportNull$$$0(15);
        }
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
    }

    public void addInvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String cause) {
        if (dependency == null) {
            DependencySetupIssues.$$$reportNull$$$0(16);
        }
        if (dependent == null) {
            DependencySetupIssues.$$$reportNull$$$0(17);
        }
        if (cause == null) {
            DependencySetupIssues.$$$reportNull$$$0(18);
        }
        this.myInvalidModuleDependencies.add(new InvalidModuleDependency(dependency, dependent, cause));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingModulesByName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingModules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependents";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sortSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMissingModules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sortSet";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportModulesNotFoundIssues";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDependentsToText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addMissingModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addMissingBinaryPath";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addInvalidModuleDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class InvalidModuleDependency {
        @NotNull
        final Module dependency;
        @NotNull
        final String dependent;
        @NotNull
        final String cause;

        InvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String cause) {
            if (dependency == null) {
                InvalidModuleDependency.$$$reportNull$$$0(0);
            }
            if (dependent == null) {
                InvalidModuleDependency.$$$reportNull$$$0(1);
            }
            if (cause == null) {
                InvalidModuleDependency.$$$reportNull$$$0(2);
            }
            this.dependency = dependency;
            this.dependent = dependent;
            this.cause = cause;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependency";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues$InvalidModuleDependency";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class MissingModule {
        @NotNull
        final String dependencyPath;
        @NotNull
        final MessageType issueType;
        @NotNull
        final List<String> dependentNames;

        MissingModule(@NotNull String dependencyPath) {
            if (dependencyPath == null) {
                MissingModule.$$$reportNull$$$0(0);
            }
            this.issueType = MessageType.ERROR;
            this.dependentNames = new CopyOnWriteArrayList<String>();
            this.dependencyPath = dependencyPath;
        }

        void addDependent(@NotNull String dependentName) {
            if (dependentName == null) {
                MissingModule.$$$reportNull$$$0(1);
            }
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                this.dependentNames.sort(String::compareTo);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependentName";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues$MissingModule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDependent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

