/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import org.jetbrains.annotations.NotNull;

public class ProjectJdkSetupStep
extends ProjectSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final IdeInfo myIdeInfo;

    public ProjectJdkSetupStep() {
        this(IdeSdks.getInstance(), Jdks.getInstance(), IdeInfo.getInstance());
    }

    @VisibleForTesting
    ProjectJdkSetupStep(@NotNull IdeSdks ideSdks, @NotNull Jdks jdks, @NotNull IdeInfo ideInfo) {
        if (ideSdks == null) {
            ProjectJdkSetupStep.$$$reportNull$$$0(0);
        }
        if (jdks == null) {
            ProjectJdkSetupStep.$$$reportNull$$$0(1);
        }
        if (ideInfo == null) {
            ProjectJdkSetupStep.$$$reportNull$$$0(2);
        }
        this.myIdeSdks = ideSdks;
        this.myJdks = jdks;
        this.myIdeInfo = ideInfo;
    }

    @Override
    public void setUpProject(@NotNull Project project) {
        if (project == null) {
            ProjectJdkSetupStep.$$$reportNull$$$0(3);
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Application application = ApplicationManager.getApplication();
        boolean androidStudio = this.myIdeInfo.isAndroidStudio();
        Sdk ideJdk = androidStudio ? this.myIdeSdks.getJdk() : (projectJdk == null || !this.myIdeSdks.isJdkCompatible(projectJdk) ? this.myIdeSdks.getJdk() : projectJdk);
        if (ideJdk == null) {
            SyncMessage message2 = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, "Unable to find a JDK");
            message2.add(this.myJdks.getWrongJdkQuickFixes(project));
            GradleSyncMessages.getInstance(project).report(message2);
            return;
        }
        String homePath = ideJdk.getHomePath();
        if (homePath != null) {
            Runnable task2 = () -> application.runWriteAction(() -> this.myJdks.setJdk(project, ideJdk));
            TransactionGuard.submitTransaction((Disposable)project, (Runnable)task2);
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/project/ProjectJdkSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

