/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetAndroidModuleNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetModulesTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

class TargetModulesPanel
extends ToolWindowPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final TargetModulesTreeBuilder myTreeBuilder;
    @NotNull
    private final NodeHyperlinkSupport<TargetAndroidModuleNode> myHyperlinkSupport;

    TargetModulesPanel(@NotNull PsContext context) {
        if (context == null) {
            TargetModulesPanel.$$$reportNull$$$0(0);
        }
        super("Target Modules/Artifacts", AllIcons.Nodes.ModuleGroup, ToolWindowAnchor.RIGHT);
        this.myContext = context;
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree(treeModel){

            protected void processMouseEvent(MouseEvent e) {
                TargetAndroidModuleNode node;
                int id = e.getID();
                if (id == 501 && (node = TargetModulesPanel.this.myHyperlinkSupport.getIfHyperlink(e)) != null) {
                    PsAndroidModule module = (PsAndroidModule)node.getFirstModel();
                    String name = module.getName();
                    TargetModulesPanel.this.myContext.setSelectedModule(name, TargetModulesPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.myTree.setRowHeight(JBUI.scale((int)24));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                TargetModulesPanel.this.popupInvoked(x, y);
            }
        });
        this.setHeaderActions();
        this.getHeader().setPreferredFocusedComponent((JComponent)this.myTree);
        this.myTreeBuilder = new TargetModulesTreeBuilder((JTree)this.myTree, treeModel, context.getUiSettings());
        JScrollPane scrollPane = UiUtil.setUp(this.myTreeBuilder, "targetModules");
        this.add((Component)scrollPane, "Center");
        this.myHyperlinkSupport = new NodeHyperlinkSupport<TargetAndroidModuleNode>(this.myTree, TargetAndroidModuleNode.class, this.myContext, false);
    }

    private void setHeaderActions() {
        ArrayList<AnAction> additionalActions = new ArrayList<AnAction>();
        additionalActions.add((AnAction)new AbstractBaseCollapseAllAction(this.myTree){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                TargetModulesPanel.this.myTree.requestFocusInWindow();
                TargetModulesPanel.this.myTreeBuilder.collapseAllNodes();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/TargetModulesPanel$3", "actionPerformed"));
            }
        });
        this.getHeader().setAdditionalActions(additionalActions);
    }

    private void popupInvoked(int x, int y) {
        TargetAndroidModuleNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsAndroidModule module = (PsAndroidModule)node.getFirstModel();
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add((AnAction)new GoToModuleAction(module.getName(), this.myContext, (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group2);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    void displayTargetModules(@NotNull List<AbstractDependencyNode<?, ? extends PsBaseDependency>> dependencyNodes) {
        if (dependencyNodes == null) {
            TargetModulesPanel.$$$reportNull$$$0(1);
        }
        this.myTreeBuilder.displayTargetModules(dependencyNodes);
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myTreeBuilder);
        Disposer.dispose(this.myHyperlinkSupport);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyNodes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/TargetModulesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "displayTargetModules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

