/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.structure.configurables.RepositorySearchFactory;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryKey;
import com.android.tools.idea.gradle.structure.model.PsLibraryKeyKt;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchQuery;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResultKt;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003*+,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001f\u001a\u00020 2\u000e\b\u0001\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010#\u001a\u00020 H\u0016J\u0006\u0010$\u001a\u00020 J$\u0010%\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0'H\u0003R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/android/tools/idea/gradle/structure/model/PsProject;", "repositorySearchFactory", "Lcom/android/tools/idea/gradle/structure/configurables/RepositorySearchFactory;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/gradle/structure/model/PsProject;Lcom/android/tools/idea/gradle/structure/configurables/RepositorySearchFactory;)V", "availableLibraryUpdateStorage", "Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage;", "getAvailableLibraryUpdateStorage", "()Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage;", "beingSearchedKeys", "", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryKey;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "runningLock", "Ljava/util/concurrent/locks/Lock;", "runningSearches", "Ljava/util/concurrent/Future;", "add", "", "listener", "Lkotlin/Function0;", "dispose", "queueUpdateCheck", "search", "repositories", "", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "keys", "AvailableUpdatesListener", "RefreshAvailableUpdates", "UpdatesAvailable", "intellij.android.core"})
public final class PsLibraryUpdateCheckerDaemon
extends PsDaemon {
    @NotNull
    private final AvailableLibraryUpdateStorage availableLibraryUpdateStorage;
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    private final EventDispatcher<AvailableUpdatesListener> eventDispatcher;
    private final Set<PsLibraryKey> beingSearchedKeys;
    private final Set<Future<?>> runningSearches;
    private final Lock runningLock;
    private final PsProject project;
    private final RepositorySearchFactory repositorySearchFactory;

    @NotNull
    public final AvailableLibraryUpdateStorage getAvailableLibraryUpdateStorage() {
        return this.availableLibraryUpdateStorage;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    public final void queueUpdateCheck() {
        this.getMainQueue().queue((Update)new RefreshAvailableUpdates());
    }

    public final void add(@UiThread @NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)new AvailableUpdatesListener(listener2){
            final /* synthetic */ Function0 $listener;

            public void availableUpdates() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Lock lock = this.runningLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.runningSearches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Future it = (Future)element$iv;
                boolean bl4 = false;
                it.cancel(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Slow
    private final void search(Collection<? extends ArtifactRepository> repositories, Collection<PsLibraryKey> keys) {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv3;
        List $i$f$filterTo2;
        Object future2;
        PsLibraryUpdateCheckerDaemon key;
        Set<Future<?>> $this$mapTo$iv$iv2;
        Lock $this$filterTo$iv$iv;
        PsLibraryKey psLibraryKey;
        PsLibraryKey it;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        AvailableLibraryUpdateStorage updateStorage = this.availableLibraryUpdateStorage;
        long currentTimeMillis = System.currentTimeMillis();
        Iterable $this$associateBy$iv = updateStorage.retainAll((Function1<? super AvailableLibraryUpdateStorage.AvailableLibraryUpdate, Boolean>)((Function1)new Function1<AvailableLibraryUpdateStorage.AvailableLibraryUpdate, Boolean>(currentTimeMillis, keys){
            final /* synthetic */ long $currentTimeMillis;
            final /* synthetic */ Collection $keys;

            public final boolean invoke(@NotNull AvailableLibraryUpdateStorage.AvailableLibraryUpdate it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                long searchTimeMillis = it.getLastSearchTimeMillis();
                return searchTimeMillis > 0L && TimeUnit.MILLISECONDS.toDays(this.$currentTimeMillis - searchTimeMillis) < (long)3 && this.$keys.contains(it.toLibraryKey());
            }
            {
                this.$currentTimeMillis = l;
                this.$keys = collection2;
                super(1);
            }
        }));
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            AvailableLibraryUpdateStorage.AvailableLibraryUpdate availableLibraryUpdate = (AvailableLibraryUpdateStorage.AvailableLibraryUpdate)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            psLibraryKey = ((AvailableLibraryUpdateStorage.AvailableLibraryUpdate)((Object)it)).toLibraryKey();
            object.put(psLibraryKey, element$iv$iv);
        }
        Map existingUpdateKeys2 = destination$iv$iv;
        Iterable $this$filter$iv = keys;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (PsLibraryKey)element$iv$iv;
            boolean bl2 = false;
            if (!(!existingUpdateKeys2.containsKey(it) && this.beingSearchedKeys.add(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set requests = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        ArtifactRepositorySearchService searcher = this.repositorySearchFactory.create(repositories);
        $this$filterTo$iv$iv = this.runningLock;
        boolean destination$iv$iv2 = false;
        $i$f$filterTo2 = false;
        $this$filterTo$iv$iv.lock();
        try {
            boolean bl = false;
            if (this.isStopped()) {
                return;
            }
            Iterable $this$map$iv = requests;
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                PsLibraryKey psLibraryKey2 = (PsLibraryKey)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl3 = false;
                future2 = searcher.search(new SearchRequest(new SearchQuery(((PsLibraryKey)((Object)key)).getGroup(), ((PsLibraryKey)((Object)key)).getName()), 1, 0));
                this.runningSearches.add((Future<?>)future2);
                Pair pair = TuplesKt.to((Object)key, future2);
                collection2.add(pair);
            }
            $i$f$filterTo2 = (List)destination$iv$iv3;
        }
        finally {
            $this$filterTo$iv$iv.unlock();
        }
        List resultFutures = $i$f$filterTo2;
        Object $this$map$iv = resultFutures;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it2;
            Pair $i$f$mapTo2 = (Pair)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            psLibraryKey = TuplesKt.to((Object)it2.getFirst(), (Object)SearchResultKt.getResultSafely((Future)it2.getSecond()));
            object.add(psLibraryKey);
        }
        List searchResults = (List)destination$iv$iv4;
        $this$map$iv = this.runningLock;
        $i$f$map = false;
        boolean $this$mapTo$iv$iv3 = false;
        $this$map$iv.lock();
        try {
            void $this$mapTo$iv$iv4;
            void $this$map$iv2;
            boolean bl = false;
            Iterable $i$f$mapTo3 = resultFutures;
            $this$mapTo$iv$iv2 = this.runningSearches;
            boolean $i$f$map2 = false;
            void it2 = $this$map$iv2;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                void it3;
                Pair bl3 = (Pair)item$iv$iv;
                future2 = destination$iv$iv5;
                boolean bl4 = false;
                ListenableFuture listenableFuture = (ListenableFuture)it3.getSecond();
                future2.add((ListenableFuture)listenableFuture);
            }
            future2 = (List)destination$iv$iv5;
            $this$mapTo$iv$iv3 = $this$mapTo$iv$iv2.removeAll((Collection)future2);
        }
        finally {
            $this$map$iv.unlock();
        }
        Iterable $this$flatMap$iv = searchResults;
        boolean $i$f$flatMap = false;
        Iterable bl = $this$flatMap$iv;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair it4 = (Pair)element$iv$iv;
            boolean bl5 = false;
            Object object2 = (SearchResult)it4.getSecond();
            if (object2 == null || (object2 = ((SearchResult)object2).getArtifacts()) == null || (object2 = UtilKt.nullize((List)object2)) == null) {
                boolean bl6;
                key = this;
                boolean bl7 = false;
                boolean bl8 = false;
                PsLibraryUpdateCheckerDaemon $this$run = key;
                boolean bl9 = false;
                PsLibraryKey key2 = (PsLibraryKey)it4.getFirst();
                SearchResult result2 = (SearchResult)it4.getSecond();
                Object object3 = result2;
                if (object3 != null && (object3 = ((SearchResult)object3).getErrors()) != null && object3.isEmpty()) {
                    bl6 = false;
                    object2 = CollectionsKt.listOf((Object)new FoundArtifact("", key2.getGroup(), key2.getName(), CollectionsKt.emptyList()));
                } else {
                    bl6 = false;
                    object2 = CollectionsKt.emptyList();
                }
            }
            Iterable list$iv$iv = (Iterable)object2;
            CollectionsKt.addAll((Collection)destination$iv$iv6, (Iterable)list$iv$iv);
        }
        List foundArtifacts = (List)destination$iv$iv6;
        Iterable $this$forEach$iv = searchResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it5 = (Pair)element$iv;
            boolean bl10 = false;
            this.beingSearchedKeys.remove(it5.getFirst());
        }
        Lock lock = this.runningLock;
        boolean bl11 = false;
        boolean bl12 = false;
        lock.lock();
        try {
            boolean bl13 = false;
            if (!this.isStopped()) {
                Iterable $this$forEach$iv2 = foundArtifacts;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    FoundArtifact it6 = (FoundArtifact)element$iv;
                    boolean bl14 = false;
                    updateStorage.addOrUpdate(it6, currentTimeMillis);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
    }

    public PsLibraryUpdateCheckerDaemon(@NotNull Disposable parentDisposable, @NotNull PsProject project, @NotNull RepositorySearchFactory repositorySearchFactory) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repositorySearchFactory, (String)"repositorySearchFactory");
        super(parentDisposable);
        this.project = project;
        this.repositorySearchFactory = repositorySearchFactory;
        this.availableLibraryUpdateStorage = AvailableLibraryUpdateStorage.Companion.getInstance(this.project.getIdeProject());
        this.mainQueue = this.createQueue("Project Structure Daemon Update Checker", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Available Update Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        EventDispatcher eventDispatcher = EventDispatcher.create(AvailableUpdatesListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(A\u2026atesListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.newSetFromMap(ConcurrentHashMap())");
        this.beingSearchedKeys = set;
        boolean bl = false;
        this.runningSearches = new LinkedHashSet();
        this.runningLock = new ReentrantLock();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$RefreshAvailableUpdates;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class RefreshAvailableUpdates
    extends Update {
        public void run() {
            boolean bl = false;
            Set repositories = new LinkedHashSet();
            boolean bl2 = false;
            Set keys = new LinkedHashSet();
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, repositories, keys){
                final /* synthetic */ RefreshAvailableUpdates this$0;
                final /* synthetic */ Set $repositories;
                final /* synthetic */ Set $keys;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    if (this.this$0.isDisposed() || this.this$0.PsLibraryUpdateCheckerDaemon.this.isStopped()) {
                        return;
                    }
                    Iterable $this$forEach$iv = PsLibraryUpdateCheckerDaemon.access$getProject$p(this.this$0.PsLibraryUpdateCheckerDaemon.this).getModules();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Collection<PsLibraryKey> collection2;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        PsModule module = (PsModule)element$iv;
                        boolean bl = false;
                        this.$repositories.addAll(module.getArtifactRepositories());
                        Iterable iterable = module.getDependencies().getLibraries();
                        Set set = this.$keys;
                        boolean $i$f$map = false;
                        void var10_10 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            PsDeclaredLibraryDependency psDeclaredLibraryDependency = (PsDeclaredLibraryDependency)item$iv$iv;
                            collection2 = destination$iv$iv;
                            boolean bl2 = false;
                            PsLibraryKey psLibraryKey = PsLibraryKeyKt.toLibraryKey(it.getSpec());
                            collection2.add(psLibraryKey);
                        }
                        collection2 = (List)destination$iv$iv;
                        set.addAll((Collection)collection2);
                    }
                }
                {
                    this.this$0 = refreshAvailableUpdates;
                    this.$repositories = set;
                    this.$keys = set2;
                    super(0);
                }
            }));
            if (!repositories.isEmpty() && !keys.isEmpty()) {
                PsLibraryUpdateCheckerDaemon.this.search(repositories, keys);
            } else {
                PsLibraryUpdateCheckerDaemon.this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
            }
        }

        public RefreshAvailableUpdates() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.project);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$UpdatesAvailable;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class UpdatesAvailable
    extends Update {
        @UiThread
        public void run() {
            ((AvailableUpdatesListener)PsLibraryUpdateCheckerDaemon.this.eventDispatcher.getMulticaster()).availableUpdates();
        }

        public UpdatesAvailable() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.project);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "Ljava/util/EventListener;", "availableUpdates", "", "intellij.android.core"})
    private static interface AvailableUpdatesListener
    extends EventListener {
        @UiThread
        public void availableUpdates();
    }
}

