/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.android.download.AndroidProfilerDownloader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        EmbeddedDistributionPaths embeddedDistributionPaths = (EmbeddedDistributionPaths)ApplicationManager.getApplication().getService(EmbeddedDistributionPaths.class);
        if (embeddedDistributionPaths == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(0);
        }
        return embeddedDistributionPaths;
    }

    @NotNull
    public List<File> findAndroidStudioLocalMavenRepoPaths() {
        if (!((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() && !CommandLineArgs.isInTestingMode()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(1);
            }
            return immutableList;
        }
        List<File> list = this.doFindAndroidStudioLocalMavenRepoPaths();
        if (list == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(2);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    List<File> doFindAndroidStudioLocalMavenRepoPaths() {
        ArrayList<File> repoPaths = new ArrayList<File>();
        ArrayList<String> repoCandidates = new ArrayList<String>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            List<File> pathsFromEnv = this.repoPathsFromString(studioCustomRepo, File::isDirectory);
            repoPaths.addAll(pathsFromEnv);
        } else {
            repoCandidates.add("/../../out/repo");
        }
        repoCandidates.add("/../../out/studio/repo");
        repoCandidates.add("/../../prebuilts/tools/common/m2/repository");
        for (String candidate : repoCandidates) {
            File offlineRepo = new File(FileUtil.toCanonicalPath((String)(PathManager.getHomePath() + FileUtil.toSystemDependentName((String)candidate))));
            if (!offlineRepo.isDirectory()) continue;
            repoPaths.add(offlineRepo);
        }
        ImmutableList immutableList = ImmutableList.copyOf(repoPaths);
        if (immutableList == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @NotNull
    @VisibleForTesting
    List<File> repoPathsFromString(@NotNull String studioCustomRepo, @NotNull Predicate<File> isValid) {
        if (studioCustomRepo == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(4);
        }
        if (isValid == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(5);
        }
        String pathSeparator = System.getProperty("path.separator", ";");
        ArrayList<File> paths = new ArrayList<File>();
        for (String customRepo : studioCustomRepo.split(pathSeparator)) {
            File customRepoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)customRepo)));
            if (!isValid.test(customRepoPath)) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable: " + customRepoPath);
            }
            paths.add(customRepoPath);
        }
        ArrayList<File> arrayList = paths;
        if (arrayList == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public File findEmbeddedProfilerTransform(@NotNull AndroidVersion version2) {
        if (version2 == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(7);
        }
        String path2 = "plugins/android/resources/profilers-transform.jar";
        File file = new File(PathManager.getHomePath(), path2);
        if (file.exists()) {
            File file2 = file;
            if (file2 == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(8);
            }
            return file2;
        }
        file = this.getOptionalIjPath(path2);
        if (file != null && file.exists()) {
            File file3 = file;
            if (file3 == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(9);
            }
            return file3;
        }
        assert (IdeInfo.getInstance().isAndroidStudio()) : "Bazel paths exist only in AndroidStudio development mode";
        String relativePath = FileUtil.toSystemDependentName((String)"/../../bazel-bin/tools/base/profiler/transform/profilers-transform.jar");
        return new File(PathManager.getHomePath() + relativePath);
    }

    public String findEmbeddedInstaller() {
        String path2 = "plugins/android/resources/installer";
        File file = new File(PathManager.getHomePath(), path2);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        file = this.getOptionalIjPath(path2);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        assert (IdeInfo.getInstance().isAndroidStudio()) : "Bazel paths exist only in AndroidStudio development mode";
        return new File(PathManager.getHomePath(), "../../bazel-bin/tools/base/deploy/installer/android-installer").getAbsolutePath();
    }

    @Nullable
    private File getOptionalIjPath(String path2) {
        AndroidProfilerDownloader.getInstance().makeSureComponentIsInPlace();
        return AndroidProfilerDownloader.getInstance().getHostDir(path2);
    }

    @Nullable
    public File findEmbeddedGradleDistributionPath() {
        String relativePath;
        File distributionPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (distributionPath != null) {
            Logger log = EmbeddedDistributionPaths.getLog();
            File embeddedPath = new File(distributionPath, "gradle-6.1.1");
            log.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                log.info("Found embedded Gradle 6.1.1");
                return embeddedPath;
            }
            log.info("Unable to find embedded Gradle 6.1.1");
            return null;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        distributionPath = new File(FileUtil.toCanonicalPath((String)(ideHomePath + (relativePath = FileUtil.toSystemDependentName((String)"/../../tools/external/gradle")))));
        if (distributionPath.isDirectory()) {
            return distributionPath;
        }
        String localDistributionPath = System.getProperty("local.gradle.distribution.path");
        if (localDistributionPath != null && (distributionPath = new File(FileUtil.toCanonicalPath((String)localDistributionPath))).isDirectory()) {
            return distributionPath;
        }
        return null;
    }

    @Nullable
    public File findEmbeddedGradleDistributionFile(@NotNull String gradleVersion2) {
        File distributionPath;
        if (gradleVersion2 == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(10);
        }
        if ((distributionPath = this.findEmbeddedGradleDistributionPath()) != null) {
            File allDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-all.zip");
            if (allDistributionFile.isFile() && allDistributionFile.exists()) {
                return allDistributionFile;
            }
            File binDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-bin.zip");
            if (binDistributionFile.isFile() && binDistributionFile.exists()) {
                return binDistributionFile;
            }
        }
        return null;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(EmbeddedDistributionPaths.class);
        if (logger2 == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(11);
        }
        return logger2;
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @Nullable
    public File tryToGetEmbeddedJdkPath() {
        try {
            return this.getEmbeddedJdkPath();
        }
        catch (Throwable t) {
            Logger.getInstance(EmbeddedDistributionPaths.class).warn("Failed to find a valid embedded JDK", t);
            return null;
        }
    }

    @NotNull
    public File getEmbeddedJdkPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File jdkRootPath = new File(ideHomePath, SystemInfo.isMac ? FileUtil.join((String[])new String[]{"jre", "jdk"}) : "jre");
        if (jdkRootPath.isDirectory()) {
            return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        }
        if (System.getProperty("android.test.embedded.jdk") != null) {
            File jdkDir = new File(System.getProperty("android.test.embedded.jdk"));
            assert (jdkDir.exists());
            File file = jdkDir;
            if (file == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(12);
            }
            return file;
        }
        String jdkDevPath = System.getProperty("studio.dev.jdk", ideHomePath + "/../../prebuilts/studio/jdk");
        String relativePath = FileUtil.toSystemDependentName((String)jdkDevPath);
        jdkRootPath = new File(FileUtil.toCanonicalPath((String)relativePath));
        if (SystemInfo.isJavaVersionAtLeast((int)11, (int)0, (int)0)) {
            jdkRootPath = new File(jdkRootPath, "jdk11");
        }
        if (SystemInfo.isWindows) {
            jdkRootPath = new File(jdkRootPath, "win64");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = new File(jdkRootPath, "linux");
        } else if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "mac");
        }
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @NotNull
    private static File getSystemSpecificJdkPath(File jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "/Contents/Home");
        }
        if (!jdkRootPath.isDirectory()) {
            throw new Error(String.format("Incomplete or corrupted installation - \"%s\" directory does not exist", jdkRootPath.toString()));
        }
        File file = jdkRootPath;
        if (file == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(13);
        }
        return file;
    }

    @NotNull
    private static String getIdeHomePath() {
        String string = FileUtil.toSystemDependentName((String)PathManager.getHomePath());
        if (string == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/EmbeddedDistributionPaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "studioCustomRepo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isValid";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndroidStudioLocalMavenRepoPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindAndroidStudioLocalMavenRepoPaths";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/EmbeddedDistributionPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "repoPathsFromString";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findEmbeddedProfilerTransform";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedJdkPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemSpecificJdkPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "repoPathsFromString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findEmbeddedProfilerTransform";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findEmbeddedGradleDistributionFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

