/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolutionDialog;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConflictResolution {
    private ConflictResolution() {
    }

    public static boolean solveSelectionConflict(@NotNull Conflict conflict) {
        if (conflict == null) {
            ConflictResolution.$$$reportNull$$$0(0);
        }
        return ConflictResolution.solveSelectionConflict(conflict, true);
    }

    private static boolean solveSelectionConflict(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        NdkModuleModel ndkModel;
        AndroidFacet facet2;
        if (conflict == null) {
            ConflictResolution.$$$reportNull$$$0(1);
        }
        if ((facet2 = AndroidFacet.getInstance((Module)conflict.getSource())) == null || !AndroidModel.isRequired(facet2)) {
            return true;
        }
        AndroidModuleModel source = AndroidModuleModel.get(facet2);
        if (source == null) {
            return false;
        }
        String newVariant = ConflictResolution.resolveNewVariant(conflict, showConflictResolutionDialog);
        if (StringUtil.isEmpty((String)newVariant)) {
            return false;
        }
        NdkFacet ndkFacet = NdkFacet.getInstance(conflict.getSource());
        NdkModuleModel ndkModuleModel = ndkModel = ndkFacet == null ? null : ndkFacet.getNdkModuleModel();
        if (ndkModel != null) {
            String newNdkVariant = ConflictResolution.resolveNewNdkVariant(ndkModel, newVariant);
            if (newNdkVariant == null) {
                return false;
            }
            ndkModel.setSelectedVariantName(newNdkVariant);
            ndkFacet.setNdkModuleModel(ndkModel);
        }
        source.setSelectedVariantName(newVariant);
        source.syncSelectedVariantAndTestArtifact(facet2);
        return true;
    }

    @Nullable
    private static String resolveNewVariant(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        Collection<String> variants;
        if (conflict == null) {
            ConflictResolution.$$$reportNull$$$0(2);
        }
        if ((variants = conflict.getVariants()).size() == 1) {
            return (String)ContainerUtil.getFirstItem(variants);
        }
        if (!showConflictResolutionDialog) {
            return null;
        }
        ConflictResolutionDialog dialog2 = new ConflictResolutionDialog(conflict);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2.getSelectedVariant();
    }

    @Nullable
    private static String resolveNewNdkVariant(@NotNull NdkModuleModel ndkModel, @NotNull String newVariant) {
        String userSelectedAbi;
        String ndkVariant;
        if (ndkModel == null) {
            ConflictResolution.$$$reportNull$$$0(3);
        }
        if (newVariant == null) {
            ConflictResolution.$$$reportNull$$$0(4);
        }
        if (ndkModel.variantExists(ndkVariant = newVariant + "-" + (userSelectedAbi = ndkModel.getAbiName(ndkModel.getSelectedVariant().getName())))) {
            return ndkVariant;
        }
        String expectedPrefix = newVariant + "-";
        Optional<NdkVariant> variant = ndkModel.getVariants().stream().filter(it -> it.getName().startsWith(expectedPrefix)).findFirst();
        return variant.map(NdkVariant::getName).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflict";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVariant";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/variant/conflict/ConflictResolution";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "solveSelectionConflict";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveNewVariant";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveNewNdkVariant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

