/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictSet {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ImmutableList<Conflict> mySelectionConflicts;
    @NotNull
    private final ImmutableList<Conflict> myStructureConflicts;

    @NotNull
    public static ConflictSet findConflicts(@NotNull Project project) {
        if (project == null) {
            ConflictSet.$$$reportNull$$$0(0);
        }
        HashMap selectionConflicts = Maps.newHashMap();
        HashMap structureConflicts = Maps.newHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            String gradlePath;
            AndroidModuleModel currentAndroidModel = AndroidModuleModel.get(module);
            if (currentAndroidModel == null || currentAndroidModel.getAndroidProject().getProjectType() == 0 || (gradlePath = GradleUtil.getGradlePath(module)) == null) continue;
            String selectedVariant = currentAndroidModel.getSelectedVariant().getName();
            List dependentModules = (List)ApplicationManager.getApplication().runReadAction(() -> ModuleUtilCore.getAllDependentModules((Module)module));
            for (Module dependent : dependentModules) {
                String expectedVariant;
                AndroidModuleModel dependentAndroidModel = AndroidModuleModel.get(dependent);
                if (dependentAndroidModel == null || StringUtil.isEmpty((String)(expectedVariant = ConflictSet.getExpectedVariant(dependentAndroidModel, gradlePath)))) continue;
                ConflictSet.addConflict(structureConflicts, module, selectedVariant, dependent, expectedVariant);
                if (selectedVariant.equals(expectedVariant)) continue;
                ConflictSet.addConflict(selectionConflicts, module, selectedVariant, dependent, expectedVariant);
            }
        }
        ArrayList<Conflict> filteredStructureConflicts = new ArrayList<Conflict>();
        for (Conflict conflict : structureConflicts.values()) {
            if (conflict.getVariants().size() <= 1) continue;
            filteredStructureConflicts.add(conflict);
        }
        return new ConflictSet(project, selectionConflicts.values(), filteredStructureConflicts);
    }

    private static void addConflict(@NotNull Map<String, Conflict> allConflicts, @NotNull Module source, @NotNull String selectedVariant, @NotNull Module affected, @NotNull String expectedVariant) {
        if (allConflicts == null) {
            ConflictSet.$$$reportNull$$$0(1);
        }
        if (source == null) {
            ConflictSet.$$$reportNull$$$0(2);
        }
        if (selectedVariant == null) {
            ConflictSet.$$$reportNull$$$0(3);
        }
        if (affected == null) {
            ConflictSet.$$$reportNull$$$0(4);
        }
        if (expectedVariant == null) {
            ConflictSet.$$$reportNull$$$0(5);
        }
        String causeName = source.getName();
        Conflict conflict = allConflicts.computeIfAbsent(causeName, k -> new Conflict(source, selectedVariant));
        conflict.addAffectedModule(affected, expectedVariant);
    }

    @Nullable
    private static String getExpectedVariant(@NotNull AndroidModuleModel dependentAndroidModel, @NotNull String dependencyGradlePath) {
        if (dependentAndroidModel == null) {
            ConflictSet.$$$reportNull$$$0(6);
        }
        if (dependencyGradlePath == null) {
            ConflictSet.$$$reportNull$$$0(7);
        }
        List<Library> dependencies2 = GradleUtil.getModuleDependencies(dependentAndroidModel.getSelectedVariant());
        for (Library dependency : dependencies2) {
            if (!dependencyGradlePath.equals(dependency.getProjectPath())) continue;
            return dependency.getVariant();
        }
        return null;
    }

    ConflictSet(@NotNull Project project, @NotNull Collection<Conflict> selectionConflicts, @NotNull Collection<Conflict> structureConflicts) {
        if (project == null) {
            ConflictSet.$$$reportNull$$$0(8);
        }
        if (selectionConflicts == null) {
            ConflictSet.$$$reportNull$$$0(9);
        }
        if (structureConflicts == null) {
            ConflictSet.$$$reportNull$$$0(10);
        }
        this.myProject = project;
        this.mySelectionConflicts = ImmutableList.copyOf(selectionConflicts);
        this.myStructureConflicts = ImmutableList.copyOf(structureConflicts);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ConflictSet.$$$reportNull$$$0(11);
        }
        return project;
    }

    @NotNull
    public List<Conflict> getSelectionConflicts() {
        ImmutableList<Conflict> immutableList = this.mySelectionConflicts;
        if (immutableList == null) {
            ConflictSet.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    @NotNull
    public List<Conflict> getStructureConflicts() {
        ImmutableList<Conflict> immutableList = this.myStructureConflicts;
        if (immutableList == null) {
            ConflictSet.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    public void showSelectionConflicts() {
        GradleSyncMessages messages = GradleSyncMessages.getInstance(this.myProject);
        for (final Conflict conflict : this.mySelectionConflicts) {
            final Module source = conflict.getSource();
            String hyperlinkText = String.format("Select '%1$s' in \"Build Variants\" window", source.getName());
            NotificationHyperlink selectInBuildVariantsWindowHyperlink = new NotificationHyperlink("select.conflict.in.variants.window", hyperlinkText){

                @Override
                protected void execute(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BuildVariantView.getInstance(project).findAndSelect(source);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/conflict/ConflictSet$1", "execute"));
                }
            };
            NotificationHyperlink quickFixHyperlink = new NotificationHyperlink("fix.conflict", "Fix problem"){

                @Override
                protected void execute(@NotNull Project project) {
                    boolean solved;
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (solved = ConflictResolution.solveSelectionConflict(conflict)) {
                        ConflictSet conflicts = ConflictSet.findConflicts(project);
                        conflicts.showSelectionConflicts();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/conflict/ConflictSet$2", "execute"));
                }
            };
            SyncMessage msg = new SyncMessage("Variant Selection Conflicts", MessageType.WARNING, conflict.toString());
            msg.add(selectInBuildVariantsWindowHyperlink);
            msg.add(quickFixHyperlink);
            messages.report(msg);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                BuildVariantView.getInstance(this.myProject).updateContents((List<Conflict>)this.mySelectionConflicts);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allConflicts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affected";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedVariant";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentAndroidModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyGradlePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConflicts";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureConflicts";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/conflict/ConflictSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/conflict/ConflictSet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionConflicts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addConflict";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedVariant";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

