/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.javadoc;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDocRenderer {
    private static final int MASK_NORMAL = 0;
    private static final int MASK_FLAVOR_SELECTED = 1;
    private static final int MASK_ITEM_HIDDEN = 2;

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceType type, @NotNull String name, boolean framework) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(1);
        }
        if (name == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(2);
        }
        return AndroidJavaDocRenderer.render(module, null, type, name, framework);
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration, @NotNull ResourceType type, @NotNull String name, boolean framework) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(3);
        }
        if (type == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(5);
        }
        return AndroidJavaDocRenderer.render(module, configuration, ResourceUrl.create((ResourceType)type, (String)name, (boolean)framework));
    }

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceUrl url) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(6);
        }
        if (url == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(7);
        }
        return AndroidJavaDocRenderer.render(module, null, url);
    }

    @Nullable
    public static String render(@NotNull Module module, @Nullable Configuration configuration, @NotNull ResourceUrl url) {
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(8);
        }
        if (url == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(9);
        }
        ResourceValueRenderer renderer2 = ResourceValueRenderer.create(url.type, module, configuration);
        boolean framework = url.isFramework();
        if (renderer2 == null || framework && renderer2.getFrameworkResources() == null || !framework && renderer2.getAppResources() == null) {
            return null;
        }
        String valueDoc = renderer2.render(url);
        if (url.type.equals((Object)ResourceType.ATTR)) {
            String attrDoc = AndroidJavaDocRenderer.renderAttributeDoc(module, configuration, (url.isFramework() ? "android:" : "") + url.name);
            if (valueDoc == null) {
                return attrDoc;
            }
            return AndroidJavaDocRenderer.injectExternalDocumentation(attrDoc, valueDoc);
        }
        return valueDoc;
    }

    @NotNull
    private static String renderAttributeDoc(@NotNull Module module, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinition def;
        if (module == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(10);
        }
        if (name == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(11);
        }
        String doc = (def = ResolutionUtils.getAttributeDefinition(module, configuration, name)) == null ? null : def.getDescription(null);
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.openHtmlBody();
        builder2.beginBold();
        builder2.add(name);
        builder2.endBold();
        int api = ResolutionUtils.getOriginalApiLevel(name, module.getProject());
        if (api > 1) {
            builder2.add(" (Added in API level ");
            builder2.add(String.valueOf(api));
            builder2.add(")");
        }
        builder2.addHtml("<br/>");
        if (!StringUtil.isEmpty((String)doc)) {
            builder2.addHtml(doc);
            builder2.addHtml("<br/>");
        }
        builder2.addHtml("<hr/>");
        builder2.closeHtmlBody();
        String string = builder2.getHtml();
        if (string == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static String injectExternalDocumentation(@Nullable String rendered, @Nullable String external) {
        if (rendered == null) {
            return external;
        }
        if (external == null) {
            return rendered;
        }
        int styleStart = ((String)external).indexOf("<style");
        int styleEnd = ((String)external).indexOf("</style>");
        if (styleStart != -1 && styleEnd != -1) {
            String style = ((String)external).substring(styleStart, styleEnd + "</style>".length());
            external = ((String)external).substring(0, styleStart) + ((String)external).substring(styleEnd + "</style>".length());
            int insert = ((String)rendered).indexOf("<body>");
            if (insert != -1) {
                int headEnd = ((String)rendered).lastIndexOf("</head>", insert);
                if (headEnd != -1) {
                    insert = headEnd;
                    rendered = ((String)rendered).substring(0, insert) + style + ((String)rendered).substring(insert);
                } else {
                    rendered = ((String)rendered).substring(0, insert) + "<head>" + style + "</head>" + ((String)rendered).substring(insert);
                }
            }
        }
        external = AndroidJavaDocRenderer.getTagContent(AndroidJavaDocRenderer.getTagContent((String)external, "body"), "html");
        int bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</body>", (int)0);
        if (bodyEnd == -1) {
            bodyEnd = StringUtil.indexOfIgnoreCase((String)rendered, (String)"</html>", (int)0);
        }
        if (bodyEnd != -1) {
            return ((String)rendered).substring(0, bodyEnd) + (String)external + ((String)rendered).substring(bodyEnd);
        }
        return (String)rendered + (String)external;
    }

    @NotNull
    private static String getTagContent(@NotNull String text, @NotNull String tag) {
        if (text == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(13);
        }
        if (tag == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(14);
        }
        int start = StringUtil.indexOfIgnoreCase((String)text, (String)("<" + tag), (int)0);
        int end = StringUtil.indexOfIgnoreCase((String)text, (String)("</" + tag + ">"), (int)0);
        if (start != -1 && end != -1 && (start = StringUtil.indexOfIgnoreCase((String)text, (String)">", (int)start)) != -1) {
            String string = text.substring(start + 1, end);
            if (string == null) {
                AndroidJavaDocRenderer.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean haveFlavors(List<ItemInfo> items2) {
        for (ItemInfo info : items2) {
            if (info.flavor == null) continue;
            return true;
        }
        return false;
    }

    private static void markHidden(List<ItemInfo> items2) {
        HashSet<String> hiddenQualifiers = new HashSet<String>();
        for (ItemInfo info : items2) {
            String folder = info.folder;
            if (hiddenQualifiers.contains(folder)) {
                info.displayMask |= 2;
            }
            hiddenQualifiers.add(folder);
        }
    }

    private static String renderFolderName(String name) {
        String prefix = "values";
        if (name.equals(prefix)) {
            return "Default";
        }
        if (name.startsWith(prefix + "-")) {
            return name.substring(prefix.length() + 1);
        }
        return name;
    }

    @NotNull
    private static ResourceReference urlToReference(ResourceUrl url) {
        return new ResourceReference(ResourceNamespace.fromBoolean((boolean)url.isFramework()), url.type, url.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Dimension getSize(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidJavaDocRenderer.$$$reportNull$$$0(17);
        }
        try {
            ImageInputStream input = ImageIO.createImageInputStream(file.getInputStream());
            if (input != null) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            reader.setInput(input);
                            Dimension dimension2 = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            reader.dispose();
                            return dimension2;
                        }
                        catch (Throwable throwable) {
                            reader.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "renderAttributeDoc";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderAttributeDoc";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTagContent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ItemInfo
    implements Comparable<ItemInfo> {
        @Nullable
        public final ResourceValue value;
        @NotNull
        public final FolderConfiguration configuration;
        @Nullable
        public final String flavor;
        @NotNull
        public final String folder;
        public final int rank;
        public int displayMask;

        private ItemInfo(@Nullable ResourceValue value2, @NotNull FolderConfiguration configuration, @NotNull String folder, @Nullable String flavor, int rank, int initialMask) {
            if (configuration == null) {
                ItemInfo.$$$reportNull$$$0(0);
            }
            if (folder == null) {
                ItemInfo.$$$reportNull$$$0(1);
            }
            this.value = value2;
            this.configuration = configuration;
            this.flavor = flavor;
            this.folder = folder;
            this.displayMask = initialMask;
            this.rank = rank;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemInfo itemInfo = (ItemInfo)o;
            if (this.rank != itemInfo.rank) {
                return false;
            }
            if (!this.configuration.equals((Object)itemInfo.configuration)) {
                return false;
            }
            if (this.flavor != null ? !this.flavor.equals(itemInfo.flavor) : itemInfo.flavor != null) {
                return false;
            }
            if (!this.folder.equals(itemInfo.folder)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(itemInfo.value) : itemInfo.value != null);
        }

        public int hashCode() {
            int result2 = this.value != null ? this.value.hashCode() : 0;
            result2 = 31 * result2 + this.configuration.hashCode();
            result2 = 31 * result2 + (this.flavor != null ? this.flavor.hashCode() : 0);
            result2 = 31 * result2 + this.folder.hashCode();
            result2 = 31 * result2 + this.rank;
            return result2;
        }

        @Override
        public int compareTo(@NotNull ItemInfo other) {
            if (other == null) {
                ItemInfo.$$$reportNull$$$0(2);
            }
            if (this.rank != other.rank) {
                return this.rank - other.rank;
            }
            DensityQualifier density1 = this.configuration.getDensityQualifier();
            DensityQualifier density2 = other.configuration.getDensityQualifier();
            if (density1 != null && density2 != null) {
                Density density1Value = density1.getValue() == null ? Density.MEDIUM : density1.getValue();
                Density density2Value = density2.getValue() == null ? Density.MEDIUM : density2.getValue();
                int delta = density2Value.compareTo((Enum)density1Value);
                if (delta != 0) {
                    return delta;
                }
                if (density1Value == Density.MEDIUM && density1 != density2) {
                    return density2 == density2.getNullQualifier() ? 1 : 0;
                }
            }
            return this.configuration.compareTo(other.configuration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ItemInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ColorValueRenderer
    extends ResourceValueRenderer {
        private ColorValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                ColorValueRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            if (resolver == null) {
                ColorValueRenderer.$$$reportNull$$$0(1);
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value2 != null) {
                value2 = resolver.resolveResValue(value2);
            }
            return value2;
        }

        private static float resolveAlpha(@NotNull ResourceItemResolver resolver, @Nullable String alphaValue) {
            if (resolver == null) {
                ColorValueRenderer.$$$reportNull$$$0(2);
            }
            float alpha = 1.0f;
            if (alphaValue != null) {
                try {
                    alpha = Float.parseFloat(ResourceHelper.resolveStringValue((RenderResources)resolver, alphaValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return alpha;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder2, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            if (builder2 == null) {
                ColorValueRenderer.$$$reportNull$$$0(3);
            }
            if (item == null) {
                ColorValueRenderer.$$$reportNull$$$0(4);
            }
            if (url == null) {
                ColorValueRenderer.$$$reportNull$$$0(5);
            }
            ResourceItemResolver resolver = this.createResolver(item);
            resourceValue2 = ColorValueRenderer.resolveValue(resolver, resourceValue2);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue2 != null) {
                this.renderColorToHtml(resolver, builder2, resourceValue2, showResolution, 1.0f, 0);
            } else if (item.value != null) {
                ColorValueRenderer.renderError(builder2, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder2, true, false);
            }
        }

        private void renderColorToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder2, @NotNull ResourceValue resourceValue2, boolean showResolution, float alpha, int depth) {
            if (resolver == null) {
                ColorValueRenderer.$$$reportNull$$$0(6);
            }
            if (builder2 == null) {
                ColorValueRenderer.$$$reportNull$$$0(7);
            }
            if (resourceValue2 == null) {
                ColorValueRenderer.$$$reportNull$$$0(8);
            }
            if (depth >= 50) {
                ColorValueRenderer.renderError(builder2, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resourceValue2, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    ColorValueRenderer.renderError(builder2, "Empty StateList");
                } else {
                    builder2.addHtml("<table>");
                    for (StateListState state : states) {
                        builder2.addHtml("<tr>");
                        builder2.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        float stateAlpha = ColorValueRenderer.resolveAlpha(resolver, state.getAlpha()) * alpha;
                        ResourceValue resolvedStateResource = resolver.findResValue(state.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = ColorValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderColorToHtml(resolver, builder2, resolvedStateResource, showResolution, stateAlpha, depth + 1);
                        } else {
                            this.renderColorToHtml(builder2, state.getValue(), stateAlpha);
                        }
                        this.mySmall = oldSmall;
                        builder2.addHtml("</td>");
                        builder2.addHtml("<td>");
                        builder2.addHtml(state.getDescription());
                        builder2.addHtml("</td>");
                        if (lookupChain != null) {
                            builder2.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder2, true, false);
                            builder2.addHtml("</td>");
                        }
                        builder2.addHtml("</tr>");
                    }
                    builder2.addHtml("</table>");
                }
            } else {
                this.renderColorToHtml(builder2, resourceValue2.getValue(), alpha);
            }
        }

        private void renderColorToHtml(@NotNull HtmlBuilder builder2, @Nullable String colorString, float alpha) {
            Color color;
            if (builder2 == null) {
                ColorValueRenderer.$$$reportNull$$$0(9);
            }
            if ((color = ResourceHelper.parseColor(colorString)) == null) {
                ColorValueRenderer.renderError(builder2, colorString);
                return;
            }
            int combinedAlpha = (int)((float)color.getAlpha() * alpha);
            color = ColorUtil.toAlpha((Color)color, (int)ResourceHelper.clamp(combinedAlpha, 0, 255));
            this.renderColorToHtml(builder2, color);
        }

        public void renderColorToHtml(@NotNull HtmlBuilder builder2, @NotNull Color color) {
            if (builder2 == null) {
                ColorValueRenderer.$$$reportNull$$$0(10);
            }
            if (color == null) {
                ColorValueRenderer.$$$reportNull$$$0(11);
            }
            Color displayColor = color;
            int width = 200;
            int height = 100;
            if (this.mySmall) {
                int divisor = 3;
                width /= divisor;
                height /= divisor;
            }
            if (color.getAlpha() != 255) {
                float alpha = (float)color.getAlpha() / 255.0f;
                Color backgroundColor = EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)DocumentationComponent.COLOR_KEY);
                if (backgroundColor != null) {
                    color = new Color((int)((float)backgroundColor.getRed() * (1.0f - alpha) + alpha * (float)color.getRed()), (int)((float)backgroundColor.getGreen() * (1.0f - alpha) + alpha * (float)color.getGreen()), (int)((float)backgroundColor.getBlue() * (1.0f - alpha) + alpha * (float)color.getBlue()));
                }
            }
            String colorString = String.format(Locale.US, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
            String foregroundColor = ColorUtil.isDark((Color)color) ? "white" : "black";
            String css = "background-color:" + colorString + ";width:" + width + "px;text-align:center;vertical-align:middle;";
            builder2.addHtml("<table style=\"" + css + "\" border=\"0\"><tr height=\"" + height + "\">");
            builder2.addHtml("<td align=\"center\" valign=\"middle\" height=\"" + height + "\" style=\"color:" + foregroundColor + "\">");
            builder2.addHtml(ResourceHelper.colorToString(displayColor));
            builder2.addHtml("</td></tr></table>");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 3: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceValue";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ColorValueRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveAlpha";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderColorToHtml";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DrawableValueRenderer
    extends ResourceValueRenderer {
        private DrawableValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                DrawableValueRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            if (resolver == null) {
                DrawableValueRenderer.$$$reportNull$$$0(1);
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (value2 != null) {
                value2 = resolver.resolveResValue(value2);
            }
            return value2;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder2, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            FolderConfiguration configuration;
            DensityQualifier densityQualifier;
            if (builder2 == null) {
                DrawableValueRenderer.$$$reportNull$$$0(2);
            }
            if (item == null) {
                DrawableValueRenderer.$$$reportNull$$$0(3);
            }
            if (url == null) {
                DrawableValueRenderer.$$$reportNull$$$0(4);
            }
            if (!ResourceQualifier.isValid((ResourceQualifier)(densityQualifier = (configuration = item.configuration).getDensityQualifier()))) {
                densityQualifier = new DensityQualifier(Density.MEDIUM);
                configuration = FolderConfiguration.copyOf((FolderConfiguration)item.configuration);
                configuration.setDensityQualifier(densityQualifier);
            }
            ResourceItemResolver resolver = this.createResolver(item.value, configuration);
            resourceValue2 = DrawableValueRenderer.resolveValue(resolver, resourceValue2);
            assert (resolver.getLookupChain() != null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>(resolver.getLookupChain());
            if (resourceValue2 != null) {
                this.renderDrawableToHtml(resolver, builder2, resourceValue2, showResolution, configuration, 0);
            } else if (item.value != null) {
                DrawableValueRenderer.renderError(builder2, item.value.getValue());
            }
            if (showResolution) {
                this.displayChain(url, lookupChain, builder2, true, false);
            }
        }

        private void renderDrawableToHtml(@NotNull ResourceItemResolver resolver, @NotNull HtmlBuilder builder2, @NotNull ResourceValue resolvedValue, boolean showResolution, @NotNull FolderConfiguration configuration, int depth) {
            if (resolver == null) {
                DrawableValueRenderer.$$$reportNull$$$0(5);
            }
            if (builder2 == null) {
                DrawableValueRenderer.$$$reportNull$$$0(6);
            }
            if (resolvedValue == null) {
                DrawableValueRenderer.$$$reportNull$$$0(7);
            }
            if (configuration == null) {
                DrawableValueRenderer.$$$reportNull$$$0(8);
            }
            if (depth >= 50) {
                DrawableValueRenderer.renderError(builder2, "Resource indirection too deep; might be cyclical");
                return;
            }
            StateList stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resolvedValue, this.myModule.getProject());
            if (stateList != null) {
                List<StateListState> states = stateList.getStates();
                if (states.isEmpty()) {
                    DrawableValueRenderer.renderError(builder2, "Empty StateList");
                } else {
                    builder2.addHtml("<table>");
                    for (StateListState state : states) {
                        builder2.addHtml("<tr>");
                        builder2.addHtml("<td>");
                        boolean oldSmall = this.mySmall;
                        this.mySmall = true;
                        ResourceValue resolvedStateResource = resolver.findResValue(state.getValue(), false);
                        ArrayList<ResourceValue> lookupChain = null;
                        if (resolvedStateResource != null) {
                            resolvedStateResource = DrawableValueRenderer.resolveValue(resolver, resolvedStateResource);
                            assert (resolver.getLookupChain() != null);
                            ArrayList<ResourceValue> arrayList = lookupChain = showResolution ? new ArrayList<ResourceValue>(resolver.getLookupChain()) : null;
                        }
                        if (resolvedStateResource != null) {
                            this.renderDrawableToHtml(resolver, builder2, resolvedStateResource, showResolution, configuration, depth + 1);
                        } else {
                            DrawableValueRenderer.renderError(builder2, state.getValue());
                        }
                        this.mySmall = oldSmall;
                        builder2.addHtml("</td>");
                        builder2.addHtml("<td>");
                        builder2.addHtml(state.getDescription());
                        builder2.addHtml("</td>");
                        if (lookupChain != null) {
                            builder2.addHtml("<td>");
                            ResourceUrl resUrl = ResourceUrl.parse((String)state.getValue());
                            assert (resUrl != null);
                            this.displayChain(resUrl, lookupChain, builder2, true, false);
                            builder2.addHtml("</td>");
                        }
                        builder2.addHtml("</tr>");
                    }
                    builder2.addHtml("</table>");
                }
            } else {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)this.myModule);
                assert (facet2 != null);
                FolderConfiguration folderConfiguration = ResolutionUtils.getFolderConfiguration(facet2, resolvedValue, configuration);
                DensityQualifier densityQualifier = folderConfiguration.getDensityQualifier();
                if (!ResourceQualifier.isValid((ResourceQualifier)densityQualifier)) {
                    densityQualifier = configuration.getDensityQualifier();
                    assert (ResourceQualifier.isValid((ResourceQualifier)densityQualifier));
                }
                String value2 = resolvedValue.getValue();
                assert (value2 != null);
                this.renderDrawableToHtml(builder2, value2, densityQualifier.getValue(), resolvedValue);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder2, @NotNull String result2, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            if (builder2 == null) {
                DrawableValueRenderer.$$$reportNull$$$0(9);
            }
            if (result2 == null) {
                DrawableValueRenderer.$$$reportNull$$$0(10);
            }
            if (density == null) {
                DrawableValueRenderer.$$$reportNull$$$0(11);
            }
            if (resolvedValue == null) {
                DrawableValueRenderer.$$$reportNull$$$0(12);
            }
            if (ResourceHelper.isFileResource(result2)) {
                VirtualFile file = FileExtensions.toVirtualFile(ResourceHelper.toFileResourcePathString(result2));
                if (file == null) {
                    DrawableValueRenderer.renderError(builder2, result2);
                } else {
                    this.renderDrawableToHtml(builder2, file, density, resolvedValue);
                }
            } else if (result2.startsWith("#")) {
                ColorValueRenderer colorRenderer = (ColorValueRenderer)ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                assert (colorRenderer != null);
                colorRenderer.setSmall(this.mySmall);
                colorRenderer.renderColorToHtml(builder2, result2, 1.0f);
            } else {
                DrawableValueRenderer.renderError(builder2, result2);
            }
        }

        private void renderDrawableToHtml(@NotNull HtmlBuilder builder2, @NotNull VirtualFile virtualFile, @NotNull Density density, @NotNull ResourceValue resolvedValue) {
            if (builder2 == null) {
                DrawableValueRenderer.$$$reportNull$$$0(13);
            }
            if (virtualFile == null) {
                DrawableValueRenderer.$$$reportNull$$$0(14);
            }
            if (density == null) {
                DrawableValueRenderer.$$$reportNull$$$0(15);
            }
            if (resolvedValue == null) {
                DrawableValueRenderer.$$$reportNull$$$0(16);
            }
            String path2 = virtualFile.getPath();
            boolean isWebP = path2.endsWith(".webp");
            if (SdkUtils.hasImageExtension((String)path2) && !isWebP) {
                File file;
                if (virtualFile.getFileSystem().getProtocol().equals("file")) {
                    file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                } else {
                    try {
                        file = FileUtilRt.createTempFile((String)"render", (String)".png", (boolean)true);
                        try (InputStream input = virtualFile.getInputStream();
                             OutputStream output = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND, StandardOpenOption.WRITE);){
                            FileUtilRt.copy((InputStream)input, (OutputStream)output);
                        }
                    }
                    catch (IOException e) {
                        DrawableValueRenderer.renderError(builder2, e.toString());
                        return;
                    }
                }
                URL fileUrl = DrawableValueRenderer.fileToUrl(file);
                if (fileUrl != null) {
                    builder2.beginDiv("background-color:gray;padding:10px");
                    builder2.addImage(fileUrl, path2);
                    builder2.endDiv();
                    Dimension size = AndroidJavaDocRenderer.getSize(virtualFile);
                    if (size != null) {
                        builder2.addHtml(String.format(Locale.US, "%1$d&#xd7;%2$d px (%3$d&#xd7;%4$d dp @ %5$s)", size.width, size.height, DrawableValueRenderer.px2dp(size.width, density), DrawableValueRenderer.px2dp(size.height, density), density.getResourceValue()));
                    }
                }
            } else if (this.myConfiguration != null) {
                BufferedImage image;
                Dimension size;
                RenderTask renderTask = ThemeEditorUtils.configureRenderTask(this.myModule, this.myConfiguration);
                int width = 100;
                int height = 100;
                if (isWebP && (size = AndroidJavaDocRenderer.getSize(virtualFile)) != null) {
                    width = size.width;
                    height = size.height;
                }
                renderTask.setOverrideRenderSize(width, height);
                try {
                    image = renderTask.renderDrawable(resolvedValue).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    DrawableValueRenderer.renderError(builder2, e.toString());
                    return;
                }
                if (image != null) {
                    try {
                        URL fileUrl;
                        File tempFile = FileUtilRt.createTempFile((String)"render", (String)".png", (boolean)true);
                        boolean ok = ImageIO.write((RenderedImage)image, "PNG", tempFile);
                        if (ok && (fileUrl = DrawableValueRenderer.fileToUrl(tempFile)) != null) {
                            builder2.beginDiv("background-color:gray;padding:10px");
                            builder2.addImage(fileUrl, null);
                            builder2.endDiv();
                        }
                    }
                    catch (IOException e) {
                        DrawableValueRenderer.renderError(builder2, e.toString());
                    }
                } else {
                    DrawableValueRenderer.renderError(builder2, "Couldn't render " + virtualFile);
                }
            } else {
                DrawableValueRenderer.renderError(builder2, path2);
            }
        }

        @Nullable
        private static URL fileToUrl(@NotNull File file) {
            if (file == null) {
                DrawableValueRenderer.$$$reportNull$$$0(17);
            }
            try {
                return SdkUtils.fileToUrl((File)file);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        private static int px2dp(int px, Density density) {
            return (int)((float)px * (float)Density.MEDIUM.getDpiValue() / (float)density.getDpiValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: 
                case 6: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 7: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedValue";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "density";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$DrawableValueRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveValue";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderDrawableToHtml";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileToUrl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ArrayRenderer
    extends ResourceValueRenderer {
        private ArrayRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                ArrayRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static ResourceValue resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value2) {
            if (resolver == null) {
                ArrayRenderer.$$$reportNull$$$0(1);
            }
            if (value2 != null) {
                assert (resolver.getLookupChain() != null);
                resolver.setLookupChainList(new ArrayList());
                return resolver.resolveResValue(value2);
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder2, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            ResourceItemResolver resolver;
            ResourceValue value2;
            if (builder2 == null) {
                ArrayRenderer.$$$reportNull$$$0(2);
            }
            if (item == null) {
                ArrayRenderer.$$$reportNull$$$0(3);
            }
            if (url == null) {
                ArrayRenderer.$$$reportNull$$$0(4);
            }
            if ((value2 = ArrayRenderer.resolveValue(resolver = this.createResolver(item), resourceValue2)) instanceof ArrayResourceValue) {
                ArrayResourceValue arv = (ArrayResourceValue)value2;
                builder2.add(Joiner.on((String)", ").skipNulls().join((Iterable)arv));
            } else if (value2 != null) {
                builder2.add(value2.toString());
            }
            if (showResolution) {
                List lookupChain = resolver.getLookupChain();
                assert (lookupChain != null);
                if (lookupChain.size() > 1) {
                    this.displayChain(url, lookupChain, builder2, true, false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ArrayRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveValue";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TextValueRenderer
    extends ResourceValueRenderer {
        private TextValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                TextValueRenderer.$$$reportNull$$$0(0);
            }
            super(module, configuration);
        }

        @Nullable
        private static String resolveStringValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue itemValue, @NotNull ResourceUrl url) {
            if (resolver == null) {
                TextValueRenderer.$$$reportNull$$$0(1);
            }
            if (url == null) {
                TextValueRenderer.$$$reportNull$$$0(2);
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList(new ArrayList());
            if (itemValue != null) {
                String value2 = itemValue.getValue();
                if (value2 != null) {
                    ResourceUrl parsed = ResourceUrl.parse((String)value2);
                    if (parsed != null) {
                        ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        v.setValue(url.toString());
                        ResourceValue resourceValue2 = resolver.resolveResValue((ResourceValue)v);
                        if (resourceValue2 != null && resourceValue2.getValue() != null) {
                            return resourceValue2.getValue();
                        }
                    }
                    return value2;
                }
                ResourceValueImpl v = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                v.setValue(url.toString());
                ResourceValue resourceValue3 = resolver.resolveResValue((ResourceValue)v);
                if (resourceValue3 != null && resourceValue3.getValue() != null) {
                    return resourceValue3.getValue();
                }
                if (resourceValue3 instanceof StyleResourceValue) {
                    return resourceValue3.getResourceUrl().toString();
                }
                return url.toString();
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder2, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue2) {
            if (builder2 == null) {
                TextValueRenderer.$$$reportNull$$$0(3);
            }
            if (item == null) {
                TextValueRenderer.$$$reportNull$$$0(4);
            }
            if (url == null) {
                TextValueRenderer.$$$reportNull$$$0(5);
            }
            ResourceItemResolver resolver = this.createResolver(item);
            String value2 = TextValueRenderer.resolveStringValue(resolver, resourceValue2, url);
            List lookupChain = resolver.getLookupChain();
            if (value2 != null) {
                boolean found = false;
                if (url.isTheme()) {
                    if (value2.startsWith("#")) {
                        Color color = ResourceHelper.parseColor(value2);
                        if (color != null) {
                            found = true;
                            ResourceValueRenderer renderer2 = ResourceValueRenderer.create(ResourceType.COLOR, this.myModule, this.myConfiguration);
                            assert (renderer2 != null);
                            ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                            resolved.setValue(value2);
                            renderer2.renderToHtml(builder2, item, url, false, (ResourceValue)resolved);
                            builder2.newline();
                        }
                    } else if (value2.endsWith(".png") && ResourceHelper.isFileResource(value2)) {
                        found = true;
                        ResourceValueRenderer renderer3 = ResourceValueRenderer.create(ResourceType.DRAWABLE, this.myModule, this.myConfiguration);
                        assert (renderer3 != null);
                        ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), null);
                        resolved.setValue(value2);
                        renderer3.renderToHtml(builder2, item, url, false, (ResourceValue)resolved);
                        builder2.newline();
                    }
                    if (!found) {
                        assert (lookupChain != null);
                        int i2 = lookupChain.size();
                        while (--i2 >= 0) {
                            ResourceValueRenderer renderer4;
                            ResourceUrl resourceUrl;
                            String value22;
                            ResourceValue rv = (ResourceValue)lookupChain.get(i2);
                            if (rv == null || (value22 = rv.getValue()) == null || (resourceUrl = ResourceUrl.parse((String)value22, (boolean)rv.isFramework())) == null || resourceUrl.isTheme() || (renderer4 = TextValueRenderer.create(resourceUrl.type, this.myModule, this.myConfiguration)) == null || renderer4.getClass() == this.getClass()) continue;
                            found = true;
                            ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(resourceUrl), null);
                            resolved.setValue(value2);
                            renderer4.renderToHtml(builder2, item, resourceUrl, false, (ResourceValue)resolved);
                            builder2.newline();
                            break;
                        }
                    }
                }
                if (!(found || showResolution && lookupChain != null && !lookupChain.isEmpty())) {
                    builder2.add(value2);
                }
            } else if (item.value != null && item.value.getValue() != null) {
                builder2.add(item.value.getValue());
            }
            if (showResolution) {
                ResourceValue rv;
                assert (lookupChain != null);
                this.displayChain(url, lookupChain, builder2, true, true);
                if (!lookupChain.isEmpty() && (rv = (ResourceValue)lookupChain.get(lookupChain.size() - 1)) instanceof StyleResourceValue) {
                    StyleResourceValue srv = (StyleResourceValue)rv;
                    this.displayStyleValues(builder2, item, resolver, srv);
                }
            }
        }

        private void displayStyleValues(HtmlBuilder builder2, ItemInfo item, ResourceItemResolver resolver, StyleResourceValue styleValue) {
            List lookupChain = resolver.getLookupChain();
            builder2.addHtml("<hr>");
            builder2.addBold(styleValue.getName()).add(":").newline();
            HashSet<String> visitedStyleValues = new HashSet<String>();
            HashSet<String> masked = new HashSet<String>();
            while (styleValue != null && visitedStyleValues.add(styleValue.asReference().getQualifiedName())) {
                ImmutableList values = Ordering.usingToString().immutableSortedCopy((Iterable)styleValue.getDefinedItems());
                for (StyleItemResourceValue itemResourceValue : values) {
                    StyleItemResourceValue v;
                    String name = itemResourceValue.getAttrName();
                    if (!masked.add(name)) continue;
                    String value2 = null;
                    ResourceReference attr = itemResourceValue.getAttr();
                    if (attr != null && (v = styleValue.getItem(attr)) != null) {
                        value2 = v.getValue();
                    }
                    builder2.addNbsps(4);
                    if (attr != null && attr.getNamespace() == ResourceNamespace.ANDROID) {
                        builder2.add("android:");
                    }
                    builder2.addBold(name).add(" = ").add(value2 == null ? "null" : value2);
                    if (value2 != null) {
                        ResourceUrl url = ResourceUrl.parse((String)value2, (boolean)styleValue.isFramework());
                        if (url != null) {
                            ResourceValueRenderer renderer2;
                            ResourceUrl resolvedUrl = url;
                            int count = 0;
                            while (resolvedUrl != null) {
                                ResourceValue resourceValue2;
                                if (lookupChain != null) {
                                    lookupChain.clear();
                                }
                                if (resolvedUrl.isTheme()) {
                                    ResourceReference ref = new ResourceReference(ResourceNamespace.fromBoolean((boolean)resolvedUrl.isFramework()), ResourceType.ATTR, resolvedUrl.name);
                                    resourceValue2 = resolver.findItemInTheme(ref);
                                } else {
                                    resourceValue2 = resolver.findResValue(resolvedUrl.toString(), resolvedUrl.isFramework());
                                }
                                if (resourceValue2 == null || resourceValue2.getValue() == null) break;
                                url = resolvedUrl;
                                value2 = resourceValue2.getValue();
                                resolvedUrl = ResourceUrl.parse((String)value2, (boolean)resolvedUrl.isFramework());
                                if (count++ != 50) continue;
                                break;
                            }
                            if ((renderer2 = TextValueRenderer.create(url.type, this.myModule, this.myConfiguration)) != null && renderer2.getClass() != this.getClass()) {
                                builder2.newline();
                                renderer2.setSmall(true);
                                ResourceValueImpl resolved = new ResourceValueImpl(AndroidJavaDocRenderer.urlToReference(url), value2);
                                renderer2.renderToHtml(builder2, item, url, false, (ResourceValue)resolved);
                                continue;
                            }
                            builder2.add(" => ");
                            int index = value2.indexOf("exploded-aar");
                            if (index != -1) {
                                value2 = value2.substring(index + "exploded-aar".length() + 1);
                            }
                            builder2.add(value2);
                            builder2.newline();
                            continue;
                        }
                        builder2.newline();
                        continue;
                    }
                    builder2.newline();
                }
                if ((styleValue = resolver.getParent(styleValue)) == null) continue;
                builder2.newline();
                builder2.add("Inherits from: ").add(styleValue.getResourceUrl().toString()).add(":").newline();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$TextValueRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveStringValue";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderToHtml";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ResourceValueRenderer
    implements ResourceItemResolver.ResourceProvider {
        protected final Module myModule;
        protected final Configuration myConfiguration;
        protected LocalResourceRepository myAppResources;
        protected ResourceResolver myResourceResolver;
        protected boolean mySmall;
        protected ResourceRepository myFrameworkResources;

        protected ResourceValueRenderer(@NotNull Module module, @Nullable Configuration configuration) {
            if (module == null) {
                ResourceValueRenderer.$$$reportNull$$$0(0);
            }
            this.myModule = module;
            this.myConfiguration = configuration;
        }

        protected ResourceValueRenderer(Module module) {
            this(module, null);
        }

        public void setSmall(boolean small) {
            this.mySmall = small;
        }

        public abstract void renderToHtml(@NotNull HtmlBuilder var1, @NotNull ItemInfo var2, @NotNull ResourceUrl var3, boolean var4, @Nullable ResourceValue var5);

        @Nullable
        public static ResourceValueRenderer create(@NotNull ResourceType type, @NotNull Module module, @Nullable Configuration configuration) {
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(1);
            }
            if (module == null) {
                ResourceValueRenderer.$$$reportNull$$$0(2);
            }
            switch (type) {
                case ATTR: 
                case STRING: 
                case DIMEN: 
                case INTEGER: 
                case BOOL: 
                case STYLE: {
                    return new TextValueRenderer(module, configuration);
                }
                case ARRAY: {
                    return new ArrayRenderer(module, configuration);
                }
                case MIPMAP: 
                case DRAWABLE: {
                    return new DrawableValueRenderer(module, configuration);
                }
                case COLOR: {
                    return new ColorValueRenderer(module, configuration);
                }
            }
            return null;
        }

        @Nullable
        public String render(@NotNull ResourceUrl url) {
            List<ItemInfo> items2;
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(3);
            }
            if ((items2 = this.gatherItems(url)) != null) {
                Collections.sort(items2);
                return this.renderKeyValues(items2, url);
            }
            return null;
        }

        @Nullable
        private List<ItemInfo> gatherItems(@NotNull ResourceUrl url) {
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(4);
            }
            ResourceType type = url.type;
            String resourceName = url.name;
            boolean framework = url.isFramework();
            if (framework) {
                ArrayList<ItemInfo> results = new ArrayList<ItemInfo>();
                this.addItemsFromFramework(null, 0, 0, type, resourceName, results);
                return results;
            }
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)this.myModule);
            if (facet2 == null) {
                return null;
            }
            ArrayList<ItemInfo> results = new ArrayList<ItemInfo>();
            LocalResourceRepository resources = this.getAppResources();
            List<AndroidFacet> dependencies2 = AndroidUtils.getAllAndroidDependencies(this.myModule, true);
            boolean hasGradleModel = false;
            int rank = 0;
            for (AndroidFacet reachableFacet : Iterables.concat((Iterable)ImmutableList.of((Object)facet2), dependencies2)) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(reachableFacet);
                if (androidModel == null) continue;
                hasGradleModel = true;
                String facetModuleName = reachableFacet.getModule().getName();
                assert (AndroidModel.isRequired(reachableFacet));
                IdeAndroidProject androidProject = androidModel.getAndroidProject();
                IdeVariant selectedVariant = androidModel.getSelectedVariant();
                HashSet<SourceProvider> selectedProviders = new HashSet<SourceProvider>();
                BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
                assert (buildType != null);
                SourceProvider sourceProvider = buildType.getSourceProvider();
                String buildTypeName = selectedVariant.getName();
                ResourceValueRenderer.addItemsFromSourceSet(buildTypeName + " (" + facetModuleName + ")", 1, rank++, sourceProvider, type, resourceName, results, reachableFacet);
                selectedProviders.add(sourceProvider);
                List productFlavors = selectedVariant.getProductFlavors();
                for (int i2 = productFlavors.size() - 1; i2 >= 0; --i2) {
                    String flavorName = (String)productFlavors.get(i2);
                    ProductFlavorContainer productFlavor = androidModel.findProductFlavor(flavorName);
                    assert (productFlavor != null);
                    SourceProvider provider2 = productFlavor.getSourceProvider();
                    ResourceValueRenderer.addItemsFromSourceSet(flavorName + " (" + facetModuleName + ")", 1, rank++, provider2, type, resourceName, results, reachableFacet);
                    selectedProviders.add(provider2);
                }
                SourceProvider main = androidProject.getDefaultConfig().getSourceProvider();
                ResourceValueRenderer.addItemsFromSourceSet("main (" + facetModuleName + ")", 1, rank++, main, type, resourceName, results, reachableFacet);
                selectedProviders.add(main);
                Collection buildTypes = androidProject.getBuildTypes();
                for (BuildTypeContainer container : buildTypes) {
                    SourceProvider provider3 = container.getSourceProvider();
                    if (selectedProviders.contains(provider3)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getBuildType().getName() + " (" + facetModuleName + ")", 0, rank++, provider3, type, resourceName, results, reachableFacet);
                    selectedProviders.add(provider3);
                }
                Collection flavors = androidProject.getProductFlavors();
                for (ProductFlavorContainer container : flavors) {
                    SourceProvider provider4 = container.getSourceProvider();
                    if (selectedProviders.contains(provider4)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getProductFlavor().getName() + " (" + facetModuleName + ")", 0, rank++, provider4, type, resourceName, results, reachableFacet);
                    selectedProviders.add(provider4);
                }
            }
            if (resources != null) {
                if (hasGradleModel) {
                    for (AarResourceRepository dependency : ResourceRepositoryManager.getInstance(facet2).getLibraryResources()) {
                        ResourceValueRenderer.addItemsFromRepository(dependency.getDisplayName(), 0, rank++, (ResourceRepository)dependency, false, type, resourceName, results);
                    }
                } else {
                    ResourceValueRenderer.addItemsFromRepository(null, 0, 0, (ResourceRepository)resources, false, type, resourceName, results);
                }
            }
            return results;
        }

        private static void addItemsFromSourceSet(@Nullable String flavor, int mask, int rank, @NotNull SourceProvider sourceProvider, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results, @NotNull AndroidFacet facet2) {
            if (sourceProvider == null) {
                ResourceValueRenderer.$$$reportNull$$$0(5);
            }
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(6);
            }
            if (name == null) {
                ResourceValueRenderer.$$$reportNull$$$0(7);
            }
            if (results == null) {
                ResourceValueRenderer.$$$reportNull$$$0(8);
            }
            if (facet2 == null) {
                ResourceValueRenderer.$$$reportNull$$$0(9);
            }
            Collection resDirectories = sourceProvider.getResDirectories();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File dir : resDirectories) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
                if (virtualFile == null) continue;
                ResourceFolderRepository resources = ResourceFolderRegistry.getInstance(facet2.getModule().getProject()).get(facet2, virtualFile);
                ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, (ResourceRepository)resources, false, type, name, results);
            }
        }

        private void addItemsFromFramework(@Nullable String flavor, int mask, int rank, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            ResourceRepository frameworkResources;
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(10);
            }
            if (name == null) {
                ResourceValueRenderer.$$$reportNull$$$0(11);
            }
            if (results == null) {
                ResourceValueRenderer.$$$reportNull$$$0(12);
            }
            if ((frameworkResources = this.getFrameworkResources()) == null) {
                return;
            }
            ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, frameworkResources, true, type, name, results);
        }

        private static void addItemsFromRepository(@Nullable String flavor, int mask, int rank, @NotNull ResourceRepository resources, boolean isFramework, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            if (resources == null) {
                ResourceValueRenderer.$$$reportNull$$$0(13);
            }
            if (type == null) {
                ResourceValueRenderer.$$$reportNull$$$0(14);
            }
            if (name == null) {
                ResourceValueRenderer.$$$reportNull$$$0(15);
            }
            if (results == null) {
                ResourceValueRenderer.$$$reportNull$$$0(16);
            }
            ResourceNamespace namespace = isFramework ? ResourceNamespace.ANDROID : ResourceNamespace.TODO();
            List items2 = resources.getResources(namespace, type, name);
            for (ResourceItem item : items2) {
                String folderName = null;
                PathString source = item.getSource();
                if (source != null) {
                    folderName = source.getParentFileName();
                }
                if (folderName == null) {
                    folderName = "?";
                }
                String folder = AndroidJavaDocRenderer.renderFolderName(folderName);
                ResourceValue value2 = item.getResourceValue();
                ItemInfo info = new ItemInfo(value2, item.getConfiguration(), folder, flavor, rank, mask);
                results.add(info);
            }
        }

        @Nullable
        private String renderKeyValues(@NotNull List<ItemInfo> items2, @NotNull ResourceUrl url) {
            if (items2 == null) {
                ResourceValueRenderer.$$$reportNull$$$0(17);
            }
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(18);
            }
            if (items2.isEmpty()) {
                return null;
            }
            AndroidJavaDocRenderer.markHidden(items2);
            HtmlBuilder builder2 = new HtmlBuilder();
            builder2.openHtmlBody();
            if (items2.size() == 1) {
                this.renderToHtml(builder2, items2.get(0), url, true, items2.get((int)0).value);
            } else {
                builder2.beginTable("valign=\"top\"");
                boolean haveFlavors = AndroidJavaDocRenderer.haveFlavors(items2);
                if (haveFlavors) {
                    builder2.addTableRow(true, new String[]{"Flavor/Library", "Configuration", "Value"});
                } else {
                    builder2.addTableRow(true, new String[]{"Configuration", "Value"});
                }
                String prevFlavor = null;
                boolean showResolution = true;
                for (ItemInfo info : items2) {
                    String style;
                    String folder = info.folder;
                    String flavor = StringUtil.notNullize((String)info.flavor);
                    if (flavor.equals(prevFlavor)) {
                        flavor = "";
                    } else {
                        prevFlavor = flavor;
                    }
                    builder2.addHtml("<tr>");
                    if (haveFlavors) {
                        style = (info.displayMask & 1) != 0 ? "b" : null;
                        this.addTableCell(builder2, style, flavor, null, null, false);
                    }
                    this.addTableCell(builder2, null, folder, null, null, false);
                    style = (info.displayMask & 2) != 0 ? "s" : null;
                    this.addTableCell(builder2, style, null, info, url, showResolution);
                    showResolution = false;
                    builder2.addHtml("</tr>");
                }
                builder2.endTable();
            }
            builder2.closeHtmlBody();
            return builder2.getHtml();
        }

        private void addTableCell(@NotNull HtmlBuilder builder2, @Nullable String attribute, @Nullable String text, @Nullable ItemInfo info, @Nullable ResourceUrl url, boolean showResolution) {
            if (builder2 == null) {
                ResourceValueRenderer.$$$reportNull$$$0(19);
            }
            builder2.addHtml("<td valign=\"top\">");
            if (attribute != null) {
                builder2.addHtml("<").addHtml(attribute).addHtml(">");
            }
            if (text != null) {
                builder2.add(text);
            } else {
                assert (info != null);
                assert (url != null);
                this.renderToHtml(builder2, info, url, showResolution, info.value);
            }
            if (attribute != null) {
                builder2.addHtml("</").addHtml(attribute).addHtml(">");
            }
            builder2.addHtml("</td>");
        }

        @NotNull
        protected ResourceItemResolver createResolver(@NotNull ItemInfo item) {
            if (item == null) {
                ResourceValueRenderer.$$$reportNull$$$0(20);
            }
            ResourceItemResolver resourceItemResolver = this.createResolver(item.value, item.configuration);
            if (resourceItemResolver == null) {
                ResourceValueRenderer.$$$reportNull$$$0(21);
            }
            return resourceItemResolver;
        }

        @NotNull
        protected ResourceItemResolver createResolver(@Nullable ResourceValue value2, @NotNull FolderConfiguration configuration) {
            if (configuration == null) {
                ResourceValueRenderer.$$$reportNull$$$0(22);
            }
            ResourceItemResolver resolver = new ResourceItemResolver(configuration, (ResourceItemResolver.ResourceProvider)this, null);
            ArrayList<ResourceValue> lookupChain = new ArrayList<ResourceValue>();
            lookupChain.add(value2);
            resolver.setLookupChainList(lookupChain);
            ResourceItemResolver resourceItemResolver = resolver;
            if (resourceItemResolver == null) {
                ResourceValueRenderer.$$$reportNull$$$0(23);
            }
            return resourceItemResolver;
        }

        protected void displayChain(@NotNull ResourceUrl url, @NotNull List<ResourceValue> lookupChain, @NotNull HtmlBuilder builder2, boolean newlineBefore, boolean newlineAfter) {
            if (url == null) {
                ResourceValueRenderer.$$$reportNull$$$0(24);
            }
            if (lookupChain == null) {
                ResourceValueRenderer.$$$reportNull$$$0(25);
            }
            if (builder2 == null) {
                ResourceValueRenderer.$$$reportNull$$$0(26);
            }
            if (!lookupChain.isEmpty()) {
                if (newlineBefore) {
                    builder2.newline();
                }
                String text = ResourceItemResolver.getDisplayString((String)url.toString(), lookupChain);
                builder2.add(text);
                builder2.newline();
                if (newlineAfter) {
                    builder2.newline();
                }
            }
        }

        @Nullable
        public ResourceRepository getFrameworkResources() {
            ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myModule);
            return repositoryManager == null ? null : repositoryManager.getFrameworkResources((Set<String>)ImmutableSet.of());
        }

        @Nullable
        public LocalResourceRepository getAppResources() {
            if (this.myAppResources == null) {
                this.myAppResources = ResourceRepositoryManager.getAppResources(this.myModule);
            }
            return this.myAppResources;
        }

        @Nullable
        public ResourceResolver getResolver(boolean createIfNecessary) {
            if (this.myResourceResolver == null && createIfNecessary) {
                VirtualFile layout2;
                AndroidFacet facet2;
                if (this.myConfiguration != null) {
                    this.myResourceResolver = this.myConfiguration.getResourceResolver();
                    if (this.myResourceResolver != null) {
                        return this.myResourceResolver;
                    }
                }
                if ((facet2 = AndroidFacet.getInstance((Module)this.myModule)) != null && (layout2 = ResourceHelper.pickAnyLayoutFile(facet2)) != null) {
                    Configuration configuration = ConfigurationManager.getOrCreateInstance(this.myModule).getConfiguration(layout2);
                    this.myResourceResolver = configuration.getResourceResolver();
                }
            }
            return this.myResourceResolver;
        }

        public static void renderError(@NotNull HtmlBuilder builder2, @Nullable String error) {
            if (builder2 == null) {
                ResourceValueRenderer.$$$reportNull$$$0(27);
            }
            builder2.beginColor((Color)JBColor.RED);
            builder2.addBold(error == null ? "Error" : error);
            builder2.endColor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 21: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 21: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 6: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 18: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceProvider";
                    break;
                }
                case 7: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 8: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resources";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 19: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupChain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "gatherItems";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addItemsFromSourceSet";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addItemsFromFramework";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addItemsFromRepository";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "renderKeyValues";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addTableCell";
                    break;
                }
                case 20: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "createResolver";
                    break;
                }
                case 21: 
                case 23: {
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "displayChain";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "renderError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 21: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

