/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.reference;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.util.LayoutBindingTypeUtil;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.reference.DbExprReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/lang/databinding/reference/PsiResourceReference;", "Lcom/android/tools/idea/lang/databinding/reference/DbExprReference;", "element", "Lcom/intellij/psi/PsiElement;", "resolveTo", "resourceValue", "Lorg/jetbrains/android/dom/resources/ResourceValue;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/android/dom/resources/ResourceValue;)V", "memberAccess", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass$MemberAccess;", "getMemberAccess", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass$MemberAccess;", "resolvedType", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "getResolvedType", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "handleElementRename", "newElementName", "", "parseType", "Lcom/intellij/psi/PsiType;", "name", "intellij.android.lang-databinding"})
public final class PsiResourceReference
extends DbExprReference {
    @NotNull
    private final PsiModelClass.MemberAccess memberAccess;
    private final ResourceValue resourceValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public PsiModelClass getResolvedType() {
        PsiType psiType;
        String string = this.resourceValue.getResourceType();
        if (string == null) return null;
        switch (string) {
            case "plurals": {
                PsiElement[] psiElementArray = this.getElement().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.children");
                PsiElement[] psiElementArray2 = psiElementArray;
                boolean bl = false;
                if (psiElementArray2.length == 0) {
                    psiType = (PsiType)PsiType.INT;
                    break;
                }
                psiType = this.parseType("java.lang.String");
                break;
            }
            case "anim": {
                psiType = this.parseType("android.view.animation.Animation");
                break;
            }
            case "animator": {
                psiType = this.parseType("android.animation.Animator");
                break;
            }
            case "colorStateList": {
                psiType = this.parseType("android.content.res.ColorStateList");
                break;
            }
            case "drawable": {
                psiType = this.parseType("android.graphics.drawable.Drawable");
                break;
            }
            case "stateListAnimator": {
                psiType = this.parseType("android.animation.StateListAnimator");
                break;
            }
            case "transition": {
                psiType = this.parseType("android.transition.Transition");
                break;
            }
            case "typedArray": {
                psiType = this.parseType("android.content.res.TypedArray");
                break;
            }
            case "interpolator": {
                psiType = this.parseType("android.view.animation.Interpolator");
                break;
            }
            case "bool": {
                psiType = (PsiType)PsiType.BOOLEAN;
                break;
            }
            case "color": 
            case "integer": 
            case "layout": 
            case "id": 
            case "dimenOffset": 
            case "dimenSize": {
                psiType = (PsiType)PsiType.INT;
                break;
            }
            case "dimen": 
            case "fraction": {
                psiType = (PsiType)PsiType.FLOAT;
                break;
            }
            case "intArray": {
                psiType = (PsiType)PsiType.INT.createArrayType();
                break;
            }
            case "string": {
                psiType = this.parseType("java.lang.String");
                break;
            }
            case "stringArray": {
                PsiType psiType2 = this.parseType("java.lang.String");
                psiType = (PsiType)(psiType2 != null ? psiType2.createArrayType() : null);
                break;
            }
            case "text": {
                psiType = this.parseType("java.lang.CharSequence");
                break;
            }
            default: {
                return null;
            }
        }
        if (psiType == null) return null;
        PsiType psiType3 = psiType;
        return new PsiModelClass(psiType3, DataBindingMode.Companion.fromPsiElement(this.getElement()));
    }

    @Override
    @NotNull
    public PsiModelClass.MemberAccess getMemberAccess() {
        return this.memberAccess;
    }

    private final PsiType parseType(String name) {
        return LayoutBindingTypeUtil.parsePsiType(name, this.getElement());
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.getElement().findElementAt(this.getRangeInElement().getStartOffset());
        if (!(psiElement instanceof LeafPsiElement)) {
            psiElement = null;
        }
        LeafPsiElement leafPsiElement = (LeafPsiElement)psiElement;
        if (leafPsiElement == null) {
            return null;
        }
        LeafPsiElement identifier = leafPsiElement;
        ResourceValue newResourceValue = ResourceValue.referenceTo(this.resourceValue.getPrefix(), this.resourceValue.getPackage(), this.resourceValue.getResourceType(), newElementName);
        identifier.rawReplaceWithText(newResourceValue.toString());
        return this.getElement();
    }

    public PsiResourceReference(@NotNull PsiElement element, @NotNull PsiElement resolveTo, @NotNull ResourceValue resourceValue2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)resolveTo, (String)"resolveTo");
        Intrinsics.checkNotNullParameter((Object)resourceValue2, (String)"resourceValue");
        super(element, resolveTo, null, 4, null);
        this.resourceValue = resourceValue2;
        this.memberAccess = PsiModelClass.MemberAccess.ALL_MEMBERS;
    }
}

