/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorAndroidLaunchTaskContributorKt;
import com.android.tools.idea.layoutinspector.LayoutInspectorPreferredProcess;
import com.android.tools.idea.layoutinspector.LayoutInspectorToolWindowFactoryKt;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspectorToolWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "wasWindowVisible", "", "stateChanged", "", "intellij.android.layout-inspector"})
final class LayoutInspectorToolWindowManagerListener
implements ToolWindowManagerListener {
    private boolean wasWindowVisible;
    private final Project project;

    public void stateChanged() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Layout Inspector");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window = toolWindow;
        boolean isWindowVisible = window.isVisible();
        boolean windowVisibilityChanged = isWindowVisible != this.wasWindowVisible;
        this.wasWindowVisible = isWindowVisible;
        if (windowVisibilityChanged && isWindowVisible) {
            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DYNAMIC_LAYOUT_INSPECTOR_EVENT).setDynamicLayoutInspectorEvent(DynamicLayoutInspectorEvent.newBuilder().setType(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.OPEN));
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"AndroidStudioEvent.newBu\u2026InspectorEventType.OPEN))");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
        }
        LayoutInspectorPreferredProcess layoutInspectorPreferredProcess = LayoutInspectorAndroidLaunchTaskContributorKt.getPreferredInspectorProcess(this.project);
        if (layoutInspectorPreferredProcess == null) {
            return;
        }
        LayoutInspectorPreferredProcess preferredProcess = layoutInspectorPreferredProcess;
        if (!windowVisibilityChanged || !isWindowVisible) {
            return;
        }
        LayoutInspector layoutInspector = LayoutInspectorToolWindowFactoryKt.lookupLayoutInspector(window);
        if (layoutInspector == null) {
            return;
        }
        LayoutInspector inspector = layoutInspector;
        if (!inspector.getCurrentClient().isConnected()) {
            Iterable iterable = inspector.getAllClients();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                InspectorClient it = (InspectorClient)t;
                boolean bl3 = false;
                if (!(it.attachIfSupported(preferredProcess) != null)) continue;
            }
        }
    }

    public LayoutInspectorToolWindowManagerListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

