/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.properties;

import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem;
import com.android.tools.property.panel.api.InspectorBuilder;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.ptable2.PTable;
import com.android.tools.property.ptable2.PTableCellRenderer;
import com.android.tools.property.ptable2.PTableCellRendererProvider;
import com.android.tools.property.ptable2.PTableColumn;
import com.android.tools.property.ptable2.PTableItem;
import com.android.tools.property.ptable2.PTableModel;
import com.android.tools.property.ptable2.PTableModelUpdateListener;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/DimensionBuilder;", "Lcom/android/tools/property/panel/api/InspectorBuilder;", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "()V", "attachToInspector", "", "inspector", "Lcom/android/tools/property/panel/api/InspectorPanel;", "properties", "Lcom/android/tools/property/panel/api/PropertiesTable;", "findSelectedRect", "Ljava/awt/Rectangle;", "pTable", "Lcom/android/tools/property/ptable2/PTable;", "scrollSelectedRowIntoView", "DimensionTableModel", "Item", "Renderer", "RendererProvider", "intellij.android.layout-inspector"})
public final class DimensionBuilder
implements InspectorBuilder<InspectorPropertyItem> {
    @Override
    public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<InspectorPropertyItem> properties) {
        Intrinsics.checkNotNullParameter((Object)inspector, (String)"inspector");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Object object = properties.getFirst();
        if (object == null || (object = ((InspectorPropertyItem)object).getView()) == null) {
            return;
        }
        Object view = object;
        PTable table2 = PTable.Companion.create$default(PTable.Companion, new DimensionTableModel((ViewNode)view), null, new RendererProvider(), null, null, null, 56, null);
        table2.getComponent().addFocusListener(new FocusAdapter(this, table2){
            final /* synthetic */ DimensionBuilder this$0;
            final /* synthetic */ PTable $table;

            public void focusGained(@NotNull FocusEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DimensionBuilder.access$scrollSelectedRowIntoView(this.this$0, this.$table);
            }
            {
                this.this$0 = this$0;
                this.$table = $captured_local_variable$1;
            }
        });
        InspectorPanel.DefaultImpls.addComponent$default(inspector, table2.getComponent(), null, 2, null);
    }

    private final void scrollSelectedRowIntoView(PTable pTable) {
        pTable.getComponent().scrollRectToVisible(this.findSelectedRect(pTable));
    }

    private final Rectangle findSelectedRect(PTable pTable) {
        JComponent jComponent = pTable.getComponent();
        if (!(jComponent instanceof JTable)) {
            jComponent = null;
        }
        JTable jTable = (JTable)jComponent;
        if (jTable == null) {
            Rectangle rectangle = pTable.getComponent().getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"pTable.component.bounds");
            return rectangle;
        }
        JTable table2 = jTable;
        int row = table2.getSelectedRow();
        if (row < 0) {
            Rectangle rectangle = table2.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"table.bounds");
            return rectangle;
        }
        Rectangle rectangle = table2.getCellRect(row, 1, true);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"table.getCellRect(row, 1, true)");
        return rectangle;
    }

    @Override
    public void resetCache() {
        InspectorBuilder.DefaultImpls.resetCache(this);
    }

    public static final /* synthetic */ void access$scrollSelectedRowIntoView(DimensionBuilder $this, PTable pTable) {
        $this.scrollSelectedRowIntoView(pTable);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/DimensionBuilder$DimensionTableModel;", "Lcom/android/tools/property/ptable2/PTableModel;", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "(Lcom/android/tools/idea/layoutinspector/model/ViewNode;)V", "editedItem", "Lcom/android/tools/property/ptable2/PTableItem;", "getEditedItem", "()Lcom/android/tools/property/ptable2/PTableItem;", "setEditedItem", "(Lcom/android/tools/property/ptable2/PTableItem;)V", "items", "", "getItems", "()Ljava/util/List;", "addItem", "item", "createDimensionItems", "removeItem", "", "intellij.android.layout-inspector"})
    private static final class DimensionTableModel
    implements PTableModel {
        @NotNull
        private final List<PTableItem> items;
        @Nullable
        private PTableItem editedItem;

        @Override
        @NotNull
        public List<PTableItem> getItems() {
            return this.items;
        }

        @Override
        @Nullable
        public PTableItem getEditedItem() {
            return this.editedItem;
        }

        @Override
        public void setEditedItem(@Nullable PTableItem pTableItem) {
            this.editedItem = pTableItem;
        }

        private final List<PTableItem> createDimensionItems(ViewNode view) {
            return CollectionsKt.listOf((Object[])new Item[]{new Item("x", String.valueOf(view.getBounds().x)), new Item("y", String.valueOf(view.getBounds().y)), new Item("width", String.valueOf(view.getBounds().width)), new Item("height", String.valueOf(view.getBounds().height))});
        }

        @Override
        @NotNull
        public PTableItem addItem(@NotNull PTableItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item;
        }

        @Override
        public void removeItem(@NotNull PTableItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        }

        public DimensionTableModel(@NotNull ViewNode view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.items = this.createDimensionItems(view);
        }

        @Override
        public boolean acceptMoveToNextEditor(@NotNull PTableItem item, @NotNull PTableColumn column) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
            return PTableModel.DefaultImpls.acceptMoveToNextEditor(this, item, column);
        }

        @Override
        public void addListener(@NotNull PTableModelUpdateListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            PTableModel.DefaultImpls.addListener(this, listener2);
        }

        @Override
        public boolean isCellEditable(@NotNull PTableItem item, @NotNull PTableColumn column) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
            return PTableModel.DefaultImpls.isCellEditable(this, item, column);
        }

        @Override
        public void refresh() {
            PTableModel.DefaultImpls.refresh(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/DimensionBuilder$Item;", "Lcom/android/tools/property/ptable2/PTableItem;", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "intellij.android.layout-inspector"})
    private static final class Item
    implements PTableItem {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        public Item(@NotNull String name, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.name = name;
            this.value = value2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/DimensionBuilder$RendererProvider;", "Lcom/android/tools/property/ptable2/PTableCellRendererProvider;", "()V", "renderer", "Lcom/android/tools/idea/layoutinspector/properties/DimensionBuilder$Renderer;", "invoke", "Lcom/android/tools/property/ptable2/PTableCellRenderer;", "table", "Lcom/android/tools/property/ptable2/PTable;", "item", "Lcom/android/tools/property/ptable2/PTableItem;", "column", "Lcom/android/tools/property/ptable2/PTableColumn;", "intellij.android.layout-inspector"})
    private static final class RendererProvider
    implements PTableCellRendererProvider {
        private final Renderer renderer = new Renderer();

        @NotNull
        public PTableCellRenderer invoke(@NotNull PTable table2, @NotNull PTableItem item, @NotNull PTableColumn column) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
            return this.renderer;
        }

        @Override
        public void updateUI() {
            PTableCellRendererProvider.DefaultImpls.updateUI(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/DimensionBuilder$Renderer;", "Lcom/android/tools/property/ptable2/PTableCellRenderer;", "()V", "emptyIcon", "Ljavax/swing/Icon;", "getEmptyIcon", "()Ljavax/swing/Icon;", "emptyIconCache", "Lcom/intellij/util/ui/EmptyIcon;", "Lorg/jetbrains/annotations/NotNull;", "textRenderer", "Lcom/intellij/ui/SimpleColoredRenderer;", "getEditorComponent", "Ljavax/swing/JComponent;", "table", "Lcom/android/tools/property/ptable2/PTable;", "item", "Lcom/android/tools/property/ptable2/PTableItem;", "column", "Lcom/android/tools/property/ptable2/PTableColumn;", "depth", "", "isSelected", "", "hasFocus", "isExpanded", "intellij.android.layout-inspector"})
    private static final class Renderer
    implements PTableCellRenderer {
        private final SimpleColoredRenderer textRenderer = new SimpleColoredRenderer();
        private EmptyIcon emptyIconCache;

        @Override
        @Nullable
        public JComponent getEditorComponent(@NotNull PTable table2, @NotNull PTableItem item, @NotNull PTableColumn column, int depth, boolean isSelected, boolean hasFocus, boolean isExpanded) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
            this.textRenderer.clear();
            if (column == PTableColumn.NAME) {
                this.textRenderer.setBorder((Border)JBUI.Borders.empty());
                this.textRenderer.setIpad((Insets)JBUI.insets((int)0, (int)3));
                this.textRenderer.setIcon(this.getEmptyIcon());
                this.textRenderer.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)UIUtil.getLabelFont()));
                this.textRenderer.append(item.getName());
            } else {
                this.textRenderer.setBorder(JBUI.Borders.customLine((Color)table2.getGridLineColor(), (int)0, (int)1, (int)0, (int)0));
                this.textRenderer.setIpad((Insets)JBUI.insets((int)0, (int)3));
                this.textRenderer.setFont(UIUtil.getLabelFont());
                String string = item.getValue();
                if (string == null) {
                    string = "";
                }
                this.textRenderer.append(string);
            }
            this.textRenderer.setForeground(isSelected && hasFocus ? UIUtil.getTableSelectionForeground((boolean)true) : table2.getForegroundColor());
            this.textRenderer.setBackground(isSelected && hasFocus ? UIUtil.getTableSelectionBackground((boolean)true) : table2.getBackgroundColor());
            return (JComponent)this.textRenderer;
        }

        private final Icon getEmptyIcon() {
            int n = this.emptyIconCache.getIconWidth();
            Icon icon2 = UIUtil.getTreeCollapsedIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"UIUtil.getTreeCollapsedIcon()");
            if (n != icon2.getIconWidth()) {
                EmptyIcon emptyIcon = EmptyIcon.create((Icon)UIUtil.getTreeCollapsedIcon());
                Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"EmptyIcon.create(UIUtil.getTreeCollapsedIcon())");
                this.emptyIconCache = emptyIcon;
            }
            return (Icon)this.emptyIconCache;
        }

        public Renderer() {
            EmptyIcon emptyIcon = EmptyIcon.create((Icon)UIUtil.getTreeCollapsedIcon());
            Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"EmptyIcon.create(UIUtil.getTreeCollapsedIcon())");
            this.emptyIconCache = emptyIcon;
        }
    }
}

