/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.ui.ViewDrawInfo;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u0002042\u001e\u0010F\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u0002040G0\u001f0\u001f2\u0006\u0010H\u001a\u00020\u0013H\u0002J\u0018\u0010I\u001a\u0004\u0018\u00010D2\u0006\u0010J\u001a\u0002082\u0006\u0010K\u001a\u000208JN\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u0002082\u0006\u0010P\u001a\u0002082\u001e\u0010Q\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u0002040G0\u00060\u00062\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0002J\u0006\u0010S\u001a\u00020!J\u0006\u0010T\u001a\u00020!J\u0016\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u0002082\u0006\u0010W\u001a\u000208R*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u0014\u0010\u001c\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000bR(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u0012\u001a\u0004\u0018\u00010#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0010R$\u00107\u001a\u0002088\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b9\u0010\t\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R$\u0010>\u001a\u0002088\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b?\u0010\t\u001a\u0004\b@\u0010;\"\u0004\bA\u0010=\u00a8\u0006X"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanelModel;", "", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;)V", "hitRects", "", "Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;", "getHitRects$annotations", "()V", "getHitRects", "()Ljava/util/List;", "setHitRects", "(Ljava/util/List;)V", "isActive", "", "()Z", "isRotated", "value", "", "layerSpacing", "getLayerSpacing", "()I", "setLayerSpacing", "(I)V", "maxDepth", "maxHeight", "getMaxHeight$intellij_android_layout_inspector", "maxWidth", "getMaxWidth$intellij_android_layout_inspector", "modificationListeners", "", "Lkotlin/Function0;", "", "getModificationListeners", "Ljava/awt/Image;", "overlay", "getOverlay", "()Ljava/awt/Image;", "setOverlay", "(Ljava/awt/Image;)V", "", "overlayAlpha", "getOverlayAlpha", "()F", "setOverlayAlpha", "(F)V", "pictureType", "Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$ComponentTreeEvent$PayloadType;", "getPictureType", "()Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$ComponentTreeEvent$PayloadType;", "rootBounds", "Ljava/awt/Rectangle;", "rotatable", "getRotatable", "xOff", "", "getXOff$annotations", "getXOff", "()D", "setXOff", "(D)V", "yOff", "getYOff$annotations", "getYOff", "setYOff", "buildLevelLists", "root", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "parentClip", "levelListCollector", "Lkotlin/Pair;", "level", "findTopRect", "x", "y", "rebuildRectsForLevel", "transform", "Ljava/awt/geom/AffineTransform;", "magnitude", "angle", "allLevels", "newHitRects", "refresh", "resetRotation", "rotate", "xRotation", "yRotation", "intellij.android.layout-inspector"})
public final class DeviceViewPanelModel {
    private double xOff;
    private double yOff;
    private Rectangle rootBounds;
    private int maxDepth;
    @NotNull
    private List<ViewDrawInfo> hitRects;
    @NotNull
    private final List<Function0<Unit>> modificationListeners;
    @Nullable
    private Image overlay;
    private float overlayAlpha;
    private int layerSpacing;
    private final InspectorModel model;

    @VisibleForTesting
    public static /* synthetic */ void getXOff$annotations() {
    }

    public final double getXOff() {
        return this.xOff;
    }

    public final void setXOff(double d) {
        this.xOff = d;
    }

    @VisibleForTesting
    public static /* synthetic */ void getYOff$annotations() {
    }

    public final double getYOff() {
        return this.yOff;
    }

    public final void setYOff(double d) {
        this.yOff = d;
    }

    public final int getMaxWidth$intellij_android_layout_inspector() {
        float f = this.maxDepth * this.layerSpacing;
        float f2 = this.rootBounds.width;
        boolean bl = false;
        return (int)Math.hypot(f, f2);
    }

    public final int getMaxHeight$intellij_android_layout_inspector() {
        float f = this.maxDepth * this.layerSpacing;
        float f2 = this.rootBounds.height;
        boolean bl = false;
        return (int)Math.hypot(f, f2);
    }

    public final boolean isRotated() {
        return this.xOff != 0.0 || this.yOff != 0.0;
    }

    @VisibleForTesting
    public static /* synthetic */ void getHitRects$annotations() {
    }

    @NotNull
    public final List<ViewDrawInfo> getHitRects() {
        return this.hitRects;
    }

    public final void setHitRects(@NotNull List<ViewDrawInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.hitRects = list;
    }

    @NotNull
    public final List<Function0<Unit>> getModificationListeners() {
        return this.modificationListeners;
    }

    @Nullable
    public final Image getOverlay() {
        return this.overlay;
    }

    public final void setOverlay(@Nullable Image value2) {
        if (value2 != null) {
            this.resetRotation();
        }
        this.overlay = value2;
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final float getOverlayAlpha() {
        return this.overlayAlpha;
    }

    public final void setOverlayAlpha(float value2) {
        this.overlayAlpha = value2;
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final int getLayerSpacing() {
        return this.layerSpacing;
    }

    public final void setLayerSpacing(int value2) {
        this.layerSpacing = value2;
        this.refresh();
    }

    public final boolean getRotatable() {
        return this.model.getHasSubImages() && this.overlay == null;
    }

    @NotNull
    public final LayoutInspectorProto.ComponentTreeEvent.PayloadType getPictureType() {
        LayoutInspectorProto.ComponentTreeEvent.PayloadType payloadType;
        ViewNode it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block13: {
            $this$any$iv = this.model.getRoot().getChildren();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ViewNode)element$iv;
                    boolean bl2 = false;
                    if (!(it.getImageType() == LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_AS_REQUESTED)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            payloadType = LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_AS_REQUESTED;
        } else {
            boolean bl3;
            block14: {
                $this$any$iv = this.model.getRoot().getChildren();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ViewNode)element$iv;
                        boolean bl4 = false;
                        if (!(it.getImageType() == LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_SKP_TOO_LARGE)) continue;
                        bl3 = true;
                        break block14;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                payloadType = LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_SKP_TOO_LARGE;
            } else {
                boolean bl5;
                block15: {
                    Iterable $this$all$iv = this.model.getRoot().getChildren();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (ViewNode)element$iv;
                            boolean bl6 = false;
                            if (it.getImageType() == LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_SKP_TOO_LARGE || Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"DIM_BEHIND")) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                payloadType = bl5 ? LayoutInspectorProto.ComponentTreeEvent.PayloadType.SKP : LayoutInspectorProto.ComponentTreeEvent.PayloadType.UNKNOWN;
            }
        }
        return payloadType;
    }

    public final boolean isActive() {
        return !this.model.isEmpty();
    }

    @Nullable
    public final ViewNode findTopRect(double x, double y) {
        ViewDrawInfo viewDrawInfo;
        block1: {
            List<ViewDrawInfo> list = this.hitRects;
            boolean bl = false;
            List<ViewDrawInfo> list2 = list;
            boolean bl2 = false;
            ListIterator<ViewDrawInfo> listIterator = list2.listIterator(list2.size());
            while (listIterator.hasPrevious()) {
                ViewDrawInfo viewDrawInfo2;
                ViewDrawInfo it = viewDrawInfo2 = listIterator.previous();
                boolean bl3 = false;
                if (!it.getBounds().contains(x, y)) continue;
                viewDrawInfo = viewDrawInfo2;
                break block1;
            }
            viewDrawInfo = null;
        }
        ViewDrawInfo viewDrawInfo3 = viewDrawInfo;
        return viewDrawInfo3 != null ? viewDrawInfo3.getNode() : null;
    }

    public final void rotate(double xRotation, double yRotation) {
        this.xOff = RangesKt.coerceIn((double)(this.xOff + xRotation), (double)-1.0, (double)1.0);
        this.yOff = RangesKt.coerceIn((double)(this.yOff + yRotation), (double)-1.0, (double)1.0);
        this.refresh();
    }

    /*
     * WARNING - void declaration
     */
    public final void refresh() {
        if (!this.getRotatable()) {
            this.xOff = 0.0;
            this.yOff = 0.0;
        }
        if (this.model.isEmpty()) {
            this.rootBounds = new Rectangle();
            this.maxDepth = 0;
            this.hitRects = CollectionsKt.emptyList();
            Iterable $this$forEach$iv = this.modificationListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
            return;
        }
        ViewNode root2 = this.model.getRoot();
        boolean bl = false;
        List levelLists = new ArrayList();
        Iterable $this$forEach$iv = root2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewNode it = (ViewNode)element$iv;
            boolean bl2 = false;
            this.buildLevelLists(it, root2.getBounds(), levelLists, levelLists.size());
        }
        this.maxDepth = levelLists.size();
        $i$f$forEach = false;
        List newHitRects = new ArrayList();
        AffineTransform transform = new AffineTransform();
        double magnitude = 0.0;
        double angle = 0.0;
        if (this.maxDepth > 0) {
            double d;
            void $this$reduce$iv22;
            Collection<Object> collection2;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = (Iterable)levelLists.get(0);
            DeviceViewPanelModel deviceViewPanelModel = this;
            boolean $i$f$map = false;
            void var11_24 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (Pair)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                Rectangle rectangle = (Rectangle)it.getSecond();
                collection2.add(rectangle);
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = collection2;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv22.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void bounds22;
                Rectangle $i$f$mapTo2 = (Rectangle)iterator$iv.next();
                Rectangle acc = (Rectangle)accumulator$iv;
                boolean bl4 = false;
                object = acc;
                boolean bl5 = false;
                boolean bl6 = false;
                Object $this$apply = object;
                boolean bl7 = false;
                ((Rectangle)$this$apply).add((Rectangle)bounds22);
                accumulator$iv = object;
            }
            collection2 = accumulator$iv;
            deviceViewPanelModel.rootBounds = (Rectangle)((Object)collection2);
            transform.translate((double)(-this.rootBounds.width) / 2.0, (double)(-this.rootBounds.height) / 2.0);
            double $this$reduce$iv22 = 1.0;
            double d2 = this.xOff;
            double bounds22 = this.yOff;
            boolean bl8 = false;
            d2 = Math.hypot(d2, bounds22);
            boolean bounds22 = false;
            magnitude = Math.min($this$reduce$iv22, d2);
            $this$reduce$iv22 = this.xOff;
            boolean bl9 = false;
            if (Math.abs($this$reduce$iv22) < 1.0E-5) {
                d = 1.5707963267948966;
            } else {
                $this$reduce$iv22 = this.yOff / this.xOff;
                bl9 = false;
                d = Math.atan($this$reduce$iv22);
            }
            angle = d;
            transform.translate((double)this.rootBounds.width / 2.0 - (double)this.rootBounds.x, (double)this.rootBounds.height / 2.0 - (double)this.rootBounds.y);
            transform.rotate(angle);
        } else {
            this.rootBounds = new Rectangle();
        }
        this.rebuildRectsForLevel(transform, magnitude, angle, levelLists, newHitRects);
        this.hitRects = CollectionsKt.toList((Iterable)newHitRects);
        Iterable $this$forEach$iv2 = this.modificationListeners;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Function0 it = (Function0)element$iv;
            boolean bl10 = false;
            it.invoke();
        }
    }

    private final void buildLevelLists(ViewNode root2, Rectangle parentClip, List<List<Pair<ViewNode, Rectangle>>> levelListCollector, int level) {
        Rectangle childClip = parentClip;
        int newLevelIndex = level;
        if (root2.getVisible()) {
            int n;
            int n2;
            block10: {
                List<List<Pair<ViewNode, Rectangle>>> $this$indexOfFirst$iv = levelListCollector.subList(level, levelListCollector.size());
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<List<Pair<ViewNode, Rectangle>>> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    block9: {
                        List<Pair<ViewNode, Rectangle>> item$iv;
                        List<Pair<ViewNode, Rectangle>> it = item$iv = iterator.next();
                        boolean bl2 = false;
                        Iterable $this$none$iv = it;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                Pair $dstr$node$_u24__u24 = (Pair)element$iv;
                                boolean bl3 = false;
                                ViewNode node = (ViewNode)$dstr$node$_u24__u24.component1();
                                if (!node.getBounds().intersects(root2.getBounds())) continue;
                                bl = false;
                                break block9;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        n2 = index$iv;
                        break block10;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            newLevelIndex = n = n2;
            if (newLevelIndex == -1) {
                newLevelIndex = levelListCollector.size();
                boolean $this$indexOfFirst$iv = false;
                levelListCollector.add(new ArrayList());
            } else {
                newLevelIndex += level;
            }
            List<Pair<ViewNode, Rectangle>> levelList = levelListCollector.get(newLevelIndex);
            Rectangle rectangle = parentClip.intersection(root2.getBounds());
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"parentClip.intersection(root.bounds)");
            childClip = rectangle;
            levelList.add((Pair<ViewNode, Rectangle>)new Pair((Object)root2, (Object)childClip));
        }
        Iterable $this$forEach$iv = root2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewNode it = (ViewNode)element$iv;
            boolean bl = false;
            this.buildLevelLists(it, childClip, levelListCollector, newLevelIndex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildRectsForLevel(AffineTransform transform, double magnitude, double angle, List<? extends List<? extends Pair<ViewNode, ? extends Rectangle>>> allLevels, List<ViewDrawInfo> newHitRects) {
        Iterable $this$forEachIndexed$iv = allLevels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void levelList;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int level = n;
            boolean bl2 = false;
            Iterable $this$forEach$iv = (Iterable)levelList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void view;
                Shape rect;
                Pair $dstr$view$clip = (Pair)element$iv;
                boolean bl3 = false;
                ViewNode viewNode = (ViewNode)$dstr$view$clip.component1();
                Rectangle clip = (Rectangle)$dstr$view$clip.component2();
                AffineTransform viewTransform = new AffineTransform(transform);
                int sign = this.xOff < 0.0 ? -1 : 1;
                viewTransform.translate(magnitude * (double)(level - this.maxDepth / 2) * (double)this.layerSpacing * (double)sign, 0.0);
                double d = 1.0 - magnitude * magnitude;
                boolean bl4 = false;
                viewTransform.scale(Math.sqrt(d), 1.0);
                viewTransform.rotate(-angle);
                viewTransform.translate((double)(-this.rootBounds.width) / 2.0, (double)(-this.rootBounds.height) / 2.0);
                Shape shape = rect = viewTransform.createTransformedShape(view.getBounds());
                Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"rect");
                newHitRects.add(new ViewDrawInfo(shape, viewTransform, (ViewNode)view, clip));
            }
        }
    }

    public final void resetRotation() {
        this.xOff = 0.0;
        this.yOff = 0.0;
        this.refresh();
    }

    public DeviceViewPanelModel(@NotNull InspectorModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        this.rootBounds = new Rectangle();
        boolean bl = false;
        this.hitRects = CollectionsKt.emptyList();
        bl = false;
        this.modificationListeners = new ArrayList();
        this.overlayAlpha = 0.6f;
        this.layerSpacing = 150;
        this.model.getModificationListeners().add(new Function3<ViewNode, ViewNode, Boolean, Unit>(){

            public final void invoke(@Nullable ViewNode $noName_0, @Nullable ViewNode viewNode, boolean $noName_2) {
                if (viewNode == null) {
                    this.setOverlay(null);
                }
            }
        });
        this.refresh();
    }
}

