/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.support.AndroidxName;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.ObjectAnimatorDetector;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/lint/AddKeepAnnotationFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "()V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "applyJava", "element", "applyKotlin", "getName", "", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.core"})
public final class AddKeepAnnotationFix
implements LintIdeQuickFix {
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        block1: {
            Language language;
            block0: {
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                language = startElement.getLanguage();
                if (!Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) break block0;
                this.applyJava(startElement);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) break block1;
            this.applyKotlin(startElement);
        }
    }

    private final void applyJava(PsiElement element) {
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
        if (psiModifierListOwner == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiModifierListOwner, (String)"PsiTreeUtil.getParentOfT\u2026er::class.java) ?: return");
        PsiModifierListOwner container = psiModifierListOwner;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Project project2 = project;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        AndroidxName androidxName = ObjectAnimatorDetector.KEEP_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)androidxName, (String)"KEEP_ANNOTATION");
        String annotationName = DependencyManagementUtil.mapAndroidxName(module, androidxName);
        new AddAnnotationFix(annotationName, container, new String[0]).invoke(project2, null, container.getContainingFile());
    }

    private final void applyKotlin(PsiElement element) {
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)element, KtNamedFunction.class);
        if (ktNamedFunction == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktNamedFunction, (String)"PsiTreeUtil.getParentOfT\u2026on::class.java) ?: return");
        KtNamedFunction method = ktNamedFunction;
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)method)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        AndroidxName androidxName = ObjectAnimatorDetector.KEEP_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)androidxName, (String)"KEEP_ANNOTATION");
        FqName annotationName = new FqName(DependencyManagementUtil.mapAndroidxName(module, androidxName));
        ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)method), (FqName)annotationName, null, (String)" ", null, (int)8, null);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return true;
    }

    @NotNull
    public String getName() {
        return "Annotate with @Keep";
    }
}

