/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLogFilterModel
extends LogFilterModel {
    private final List<LogFilterListener> myListeners;
    private final StringBuilder myMessageSoFar;
    @Nullable
    private LogCatHeader myPrevHeader;
    @Nullable
    private LogCatHeader myRejectBeforeHeader;
    @Nullable
    private Pattern myCustomPattern;
    private boolean myCustomApplicable;
    private boolean myConfiguredApplicable;
    @Nullable
    private AndroidLogcatFilter myConfiguredFilter;
    private final ImmutableList<AndroidLogLevelFilter> myLogLevelFilters;
    private final AndroidLogcatFormatter myFormatter;

    AndroidLogFilterModel(@NotNull AndroidLogcatFormatter formatter) {
        if (formatter == null) {
            AndroidLogFilterModel.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMessageSoFar = new StringBuilder();
        this.myCustomApplicable = false;
        this.myConfiguredApplicable = false;
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (Log.LogLevel logLevel : Log.LogLevel.values()) {
            builder2.add((Object)new AndroidLogLevelFilter(logLevel));
        }
        this.myLogLevelFilters = builder2.build();
        this.myFormatter = formatter;
    }

    public String getCustomFilter() {
        return "";
    }

    public void updateCustomPattern(@Nullable Pattern pattern) {
        this.myCustomPattern = pattern;
        this.fireTextFilterChange();
    }

    public final void updateLogcatFilter(@Nullable AndroidLogcatFilter filter2) {
        this.saveConfiguredFilterName(filter2 != null ? filter2.getName() : "");
        this.myConfiguredFilter = filter2;
        this.fireTextFilterChange();
    }

    protected abstract void saveConfiguredFilterName(String var1);

    protected abstract void saveLogLevel(String var1);

    public final void addFilterListener(LogFilterListener listener2) {
        this.myListeners.add(listener2);
    }

    public final void removeFilterListener(LogFilterListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void beginRejectingOldMessages() {
        if (this.myPrevHeader == null) {
            return;
        }
        this.myRejectBeforeHeader = this.myPrevHeader;
    }

    private void fireTextFilterChange() {
        for (LogFilterListener listener2 : this.myListeners) {
            listener2.onTextFilterChange();
        }
    }

    private void fireFilterChange(@NotNull LogFilter filter2) {
        if (filter2 == null) {
            AndroidLogFilterModel.$$$reportNull$$$0(1);
        }
        for (LogFilterListener listener2 : this.myListeners) {
            listener2.onFilterStateChange(filter2);
        }
    }

    public final boolean isApplicable(String line) {
        if (this.myCustomPattern != null && !this.myCustomPattern.matcher(line).find()) {
            return false;
        }
        LogFilter selectedLogLevelFilter = this.getSelectedLogLevelFilter();
        return selectedLogLevelFilter == null || selectedLogLevelFilter.isAcceptable(line);
    }

    private boolean isApplicableByConfiguredFilter(@NotNull String message2) {
        if (message2 == null) {
            AndroidLogFilterModel.$$$reportNull$$$0(2);
        }
        if (this.myConfiguredFilter == null) {
            return true;
        }
        assert (this.myPrevHeader != null);
        return this.myConfiguredFilter.isApplicable(message2, this.myPrevHeader.getTag(), this.myPrevHeader.getAppName(), this.myPrevHeader.getPid(), this.myPrevHeader.getLogLevel());
    }

    public final List<? extends LogFilter> getLogFilters() {
        return this.myLogLevelFilters;
    }

    public abstract String getSelectedLogLevelName();

    @Nullable
    private LogFilter getSelectedLogLevelFilter() {
        String filterName = this.getSelectedLogLevelName();
        if (filterName != null) {
            for (AndroidLogLevelFilter logFilter : this.myLogLevelFilters) {
                if (!filterName.equals(logFilter.myLogLevel.getStringValue())) continue;
                return logFilter;
            }
        }
        return null;
    }

    public boolean isFilterSelected(LogFilter filter2) {
        return filter2 == this.getSelectedLogLevelFilter();
    }

    public void selectFilter(LogFilter filter2) {
        if (!(filter2 instanceof AndroidLogLevelFilter)) {
            return;
        }
        String newFilterName = ((AndroidLogLevelFilter)filter2).myLogLevel.getStringValue();
        if (!Objects.equals(newFilterName, this.getSelectedLogLevelName())) {
            this.saveLogLevel(newFilterName);
            this.fireFilterChange(filter2);
        }
    }

    public void processingStarted() {
        this.myPrevHeader = null;
        this.myRejectBeforeHeader = null;
        this.myCustomApplicable = false;
        this.myConfiguredApplicable = false;
        this.myMessageSoFar.setLength(0);
    }

    @NotNull
    public final LogFilterModel.MyProcessingResult processLine(String line) {
        boolean isApplicable;
        boolean validContinuation;
        LogCatMessage message2 = this.myFormatter.tryParseMessage(line);
        String continuation = message2 == null ? AndroidLogcatFormatter.tryParseContinuation(line) : null;
        boolean bl = validContinuation = continuation != null && this.myPrevHeader != null;
        if (message2 == null && !validContinuation) {
            return new LogFilterModel.MyProcessingResult(ProcessOutputTypes.STDOUT, false, null);
        }
        if (message2 != null) {
            this.myPrevHeader = message2.getHeader();
            this.myCustomApplicable = this.isApplicable(line);
            this.myConfiguredApplicable = this.isApplicableByConfiguredFilter(message2.getMessage());
            this.myMessageSoFar.setLength(0);
        } else {
            this.myCustomApplicable = this.myCustomApplicable || this.isApplicable(continuation);
            this.myConfiguredApplicable = this.myConfiguredApplicable || this.isApplicableByConfiguredFilter(continuation);
        }
        boolean bl2 = isApplicable = this.myCustomApplicable && this.myConfiguredApplicable;
        if (isApplicable && this.myRejectBeforeHeader != null) {
            boolean bl3 = isApplicable = !this.myPrevHeader.isBefore(this.myRejectBeforeHeader);
        }
        if (!isApplicable) {
            this.myMessageSoFar.append(line);
            this.myMessageSoFar.append('\n');
        }
        Key key = AndroidLogcatUtils.getProcessOutputType(this.myPrevHeader.getLogLevel());
        LogFilterModel.MyProcessingResult result2 = new LogFilterModel.MyProcessingResult(key, isApplicable, this.myMessageSoFar.toString());
        if (isApplicable) {
            this.myMessageSoFar.setLength(0);
        }
        LogFilterModel.MyProcessingResult myProcessingResult = result2;
        if (myProcessingResult == null) {
            AndroidLogFilterModel.$$$reportNull$$$0(3);
        }
        return myProcessingResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogFilterModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogFilterModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fireFilterChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableByConfiguredFilter";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AndroidLogLevelFilter
    extends LogFilter {
        final Log.LogLevel myLogLevel;

        private AndroidLogLevelFilter(Log.LogLevel logLevel) {
            super(StringUtil.capitalize((String)logLevel.getStringValue()));
            this.myLogLevel = logLevel;
        }

        public boolean isAcceptable(String line) {
            return AndroidLogFilterModel.this.myPrevHeader != null && AndroidLogFilterModel.this.myPrevHeader.getLogLevel().getPriority() >= this.myLogLevel.getPriority();
        }
    }
}

