/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.DaemonMemorySettings;
import com.android.tools.idea.memorysettings.MemorySettingsRecommendation;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.google.wireless.android.sdk.stats.MemorySettingsEvent;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonsUi;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServices;

public class MemorySettingsConfigurable
implements SearchableConfigurable {
    private MyComponent myComponent = new MyComponent();

    @NotNull
    public String getHelpTopic() {
        return "memory.settings";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            MemorySettingsConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getDisplayName() {
        return AndroidBundle.message("configurable.MemorySettingsConfigurable.display.name", new Object[0]);
    }

    public void apply() throws ConfigurationException {
        this.myComponent.apply();
    }

    public boolean isModified() {
        return this.myComponent.isMemorySettingsModified();
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
        return this.myComponent.myPanel;
    }

    public void reset() {
        this.myComponent.reset();
    }

    public void disposeUIResources() {
        this.myComponent = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/memorysettings/MemorySettingsConfigurable", "getId"));
    }

    private static class MyComponent {
        private static final int MIN_IDE_XMX = 1024;
        private static final int DEFAULT_IDE_XMX = 1280;
        private static final int SIZE_INCREMENT = 1024;
        private static final float MAX_PERCENT_OF_AVAILABLE_RAM = 0.33f;
        private JPanel myPanel;
        private ComboBox<Integer> myIdeXmxBox;
        private ComboBox<Integer> myGradleDaemonXmxBox;
        private JBLabel myInfoLabel;
        private HyperlinkLabel myApplyRecommendationLabel;
        private JPanel myDaemonPanel;
        private ComboBox myKotlinDaemonXmxBox;
        private JBLabel myDaemonInfoLabel;
        private HyperlinkLabel myShowDaemonsLabel;
        private JBLabel myIdeBottomLabel;
        private JBLabel myIdeInfoLabel;
        private Project myProject;
        private int myCurrentIdeXmx;
        private int myRecommendedIdeXmx;
        private int myCurrentGradleXmx;
        private int myCurrentKotlinXmx;
        private int mySelectedIdeXmx;
        private int mySelectedGradleXmx;
        private int mySelectedKotlinXmx;
        private DaemonMemorySettings myDaemonMemorySettings;

        MyComponent() {
            this.$$$setupUI$$$();
            this.mySelectedIdeXmx = this.myCurrentIdeXmx = MemorySettingsUtil.getCurrentXmx();
            this.myProject = MemorySettingsUtil.getCurrentProject();
            this.myRecommendedIdeXmx = MemorySettingsRecommendation.getRecommended(this.myProject, this.myCurrentIdeXmx);
            this.setUI();
            MemorySettingsUtil.log(MemorySettingsEvent.EventKind.SHOW_CONFIG_DIALOG, this.myCurrentIdeXmx, this.myCurrentGradleXmx, this.myCurrentKotlinXmx, this.myRecommendedIdeXmx, -1, -1, -1, -1, -1);
        }

        private void setUI() {
            this.myInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)("<body>" + AndroidBundle.message("memory.settings.panel.top.message", new Object[0]) + "</body>")));
            this.myIdeBottomLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.ide.bottom.message", new Object[0])));
            this.myIdeBottomLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
            if (this.myRecommendedIdeXmx > 0) {
                this.myIdeInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.panel.ide.info", MyComponent.memSizeText(this.myRecommendedIdeXmx))));
                this.myApplyRecommendationLabel.setHyperlinkText(AndroidBundle.message("memory.settings.panel.use.recommended.values", new Object[0]));
                this.myApplyRecommendationLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        myIdeXmxBox.setSelectedItem((Object)myRecommendedIdeXmx);
                        mySelectedIdeXmx = myRecommendedIdeXmx;
                        MemorySettingsUtil.log(MemorySettingsEvent.EventKind.APPLY_RECOMMENDATION_BUTTON_CLICKED, myCurrentIdeXmx, myCurrentGradleXmx, myCurrentKotlinXmx, myRecommendedIdeXmx, -1, -1, myRecommendedIdeXmx, -1, -1);
                    }
                });
            } else {
                this.myIdeInfoLabel.setVisible(false);
                this.myApplyRecommendationLabel.setVisible(false);
            }
            int machineMem = MemorySettingsUtil.getMachineMem();
            int maxXmx = MyComponent.getMaxXmx(machineMem);
            this.setXmxBox((JComboBox)this.myIdeXmxBox, this.myCurrentIdeXmx, this.myRecommendedIdeXmx, 1280, maxXmx, 1024, new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1 && event.getItem() != null) {
                        mySelectedIdeXmx = (Integer)event.getItem();
                    }
                }
            });
            if (this.myProject != null) {
                this.myDaemonMemorySettings = new DaemonMemorySettings(this.myProject);
                this.mySelectedGradleXmx = this.myCurrentGradleXmx = this.myDaemonMemorySettings.getProjectGradleDaemonXmx();
                this.mySelectedKotlinXmx = this.myCurrentKotlinXmx = this.myDaemonMemorySettings.getProjectKotlinDaemonXmx();
                if (this.myDaemonMemorySettings.hasUserPropertiesPath()) {
                    this.setXmxBoxWithOnlyCurrentValue((JComboBox)this.myGradleDaemonXmxBox, this.myCurrentGradleXmx);
                    this.setXmxBoxWithOnlyCurrentValue((JComboBox)this.myKotlinDaemonXmxBox, this.myCurrentKotlinXmx);
                    this.myDaemonInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.has.user.properties", this.myDaemonMemorySettings.getUserPropertiesPath())));
                    this.myShowDaemonsLabel.setVisible(false);
                } else {
                    this.setDaemonPanelWhenNoUserGradleProperties();
                }
            } else {
                this.myDaemonPanel.setVisible(false);
                this.myDaemonInfoLabel.setVisible(false);
                this.myShowDaemonsLabel.setVisible(false);
            }
        }

        private void setDaemonPanelWhenNoUserGradleProperties() {
            this.setXmxBox((JComboBox)this.myGradleDaemonXmxBox, this.myCurrentGradleXmx, -1, this.myDaemonMemorySettings.getDefaultGradleDaemonXmx(), 2048, 512, new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1 && event.getItem() != null) {
                        mySelectedGradleXmx = (Integer)event.getItem();
                    }
                }
            });
            this.setXmxBox((JComboBox)this.myKotlinDaemonXmxBox, this.myCurrentKotlinXmx, -1, this.myDaemonMemorySettings.getDefaultKotlinDaemonXmx(), 2048, 512, new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1 && event.getItem() != null) {
                        mySelectedKotlinXmx = (Integer)event.getItem();
                    }
                }
            });
            this.myDaemonInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.panel.daemon.info", new Object[0])));
            this.myShowDaemonsLabel.setHyperlinkText(AndroidBundle.message("memory.settings.panel.show.daemons.info", new Object[0]));
            this.myShowDaemonsLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){
                DaemonsUi myUi;

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    this.myUi = new DaemonsUi(myProject){

                        public void dispose() {
                            myUi = null;
                        }
                    };
                    List daemonsStatus = GradleDaemonServices.getDaemonsStatus();
                    this.myUi.show(daemonsStatus);
                }
            });
        }

        private void setXmxBoxWithOnlyCurrentValue(JComboBox box, final int current) {
            box.setEditable(false);
            box.removeAllItems();
            box.addItem(current);
            box.setSelectedItem(current);
            box.setRenderer(new ColoredListCellRenderer<Integer>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Integer> list, Integer value2, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    this.append(String.format(Locale.US, "%s - current", MyComponent.memSizeText(current)), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/memorysettings/MemorySettingsConfigurable$MyComponent$6", "customizeCellRenderer"));
                }
            });
        }

        private void setXmxBox(JComboBox box, final int current, final int recommended, final int defaultSize, int max, int increment, ItemListener listener2) {
            box.setEditable(false);
            box.removeAllItems();
            ArrayList<Integer> items2 = new ArrayList<Integer>();
            items2.add(current);
            if (recommended > 0 && recommended != current) {
                items2.add(recommended);
            }
            if (defaultSize > 0 && defaultSize != current && defaultSize != recommended) {
                items2.add(defaultSize);
            }
            for (int size = 1024; size <= max; size += increment) {
                if (size == current || size == recommended || size == defaultSize) continue;
                items2.add(size);
            }
            Collections.sort(items2);
            Iterator iterator = items2.iterator();
            while (iterator.hasNext()) {
                int item = (Integer)iterator.next();
                box.addItem(item);
            }
            box.setSelectedItem(current);
            box.addItemListener(listener2);
            box.setRenderer(new ColoredListCellRenderer<Integer>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Integer> list, Integer value2, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (value2.equals(current)) {
                        this.append(String.format(Locale.US, "%s - current", MyComponent.memSizeText(current)), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                    } else if (value2.equals(defaultSize)) {
                        this.append(String.format(Locale.US, "%s - default", MyComponent.memSizeText(defaultSize)), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                    } else if (value2.equals(recommended)) {
                        this.append(String.format(Locale.US, "%s - recommended", MyComponent.memSizeText(recommended)), new SimpleTextAttributes(1, null));
                    } else {
                        this.append(MyComponent.memSizeText(value2), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/memorysettings/MemorySettingsConfigurable$MyComponent$7", "customizeCellRenderer"));
                }
            });
        }

        private boolean isMemorySettingsModified() {
            return this.isIdeXmxModified() || this.isGradleDaemonXmxModified() || this.isKotlinDaemonXmxModified();
        }

        private boolean isIdeXmxModified() {
            return this.mySelectedIdeXmx != this.myCurrentIdeXmx;
        }

        private boolean isGradleDaemonXmxModified() {
            return this.mySelectedGradleXmx != this.myCurrentGradleXmx;
        }

        private boolean isKotlinDaemonXmxModified() {
            return this.mySelectedKotlinXmx != this.myCurrentKotlinXmx;
        }

        private void reset() {
            this.myIdeXmxBox.setSelectedItem((Object)this.myCurrentIdeXmx);
            this.mySelectedIdeXmx = this.myCurrentIdeXmx;
            this.myGradleDaemonXmxBox.setSelectedItem((Object)this.myCurrentGradleXmx);
            this.mySelectedGradleXmx = this.myCurrentGradleXmx;
            this.myKotlinDaemonXmxBox.setSelectedItem((Object)this.myCurrentKotlinXmx);
            this.mySelectedKotlinXmx = this.myCurrentKotlinXmx;
        }

        private void apply() {
            MemorySettingsUtil.log(MemorySettingsEvent.EventKind.SETTINGS_CHANGE_SAVED, this.myCurrentIdeXmx, this.myCurrentGradleXmx, this.myCurrentKotlinXmx, this.myRecommendedIdeXmx, -1, -1, this.mySelectedIdeXmx, this.mySelectedGradleXmx, this.mySelectedKotlinXmx);
            boolean changed = false;
            boolean isGradleXmxModified = this.isGradleDaemonXmxModified();
            boolean isKotlinXmxModified = this.isKotlinDaemonXmxModified();
            if (isGradleXmxModified || isKotlinXmxModified) {
                if (isGradleXmxModified) {
                    this.myCurrentGradleXmx = this.mySelectedGradleXmx;
                }
                if (isKotlinXmxModified) {
                    this.myCurrentKotlinXmx = this.mySelectedKotlinXmx;
                }
                this.myDaemonMemorySettings.saveProjectDaemonXmx(this.myCurrentGradleXmx, this.myCurrentKotlinXmx);
                changed = true;
            }
            if (this.isIdeXmxModified()) {
                MemorySettingsUtil.saveXmx(this.mySelectedIdeXmx);
                this.myCurrentIdeXmx = this.mySelectedIdeXmx;
                if (Messages.showOkCancelDialog((String)XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.restart.needed", new Object[0])), (String)IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                    ((ApplicationEx)ApplicationManager.getApplication()).restart(true);
                }
                changed = true;
            }
            if (changed) {
                this.setUI();
            }
        }

        private static int getMaxXmx(int machineMem) {
            int ideXmxCap = MemorySettingsUtil.getIdeXmxCapInGB();
            return Math.min(Math.round((float)machineMem * 0.33f) >> 8 << 8, ideXmxCap << 10);
        }

        private static String memSizeText(int size) {
            return size < 0 ? "unknown" : size + " MB";
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBLabel jBLabel;
            JBLabel jBLabel2;
            HyperlinkLabel hyperlinkLabel;
            ComboBox comboBox;
            ComboBox comboBox2;
            JPanel jPanel;
            HyperlinkLabel hyperlinkLabel2;
            JBLabel jBLabel3;
            JBLabel jBLabel4;
            ComboBox comboBox3;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"IDE Heap Size Settings", (int)0, (int)0, null, null));
            JBLabel jBLabel5 = new JBLabel();
            Font font = this.$$$getFont$$$(null, -1, 12, jBLabel5.getFont());
            if (font != null) {
                jBLabel5.setFont(font);
            }
            jBLabel5.setText("IDE max heap size:");
            jPanel3.add((Component)jBLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, new Dimension(190, -1), new Dimension(184, 15), new Dimension(190, -1)));
            this.myIdeXmxBox = comboBox3 = new ComboBox();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement("1024");
            defaultComboBoxModel.addElement("1280");
            defaultComboBoxModel.addElement("2048");
            defaultComboBoxModel.addElement("3072");
            defaultComboBoxModel.addElement("4096");
            comboBox3.setModel(defaultComboBoxModel);
            jPanel3.add((Component)comboBox3, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
            this.myIdeBottomLabel = jBLabel4 = new JBLabel();
            Font font2 = this.$$$getFont$$$(null, -1, 10, jBLabel4.getFont());
            if (font2 != null) {
                jBLabel4.setFont(font2);
            }
            jBLabel4.setFontColor(UIUtil.FontColor.BRIGHTER);
            jBLabel4.setOpaque(false);
            jBLabel4.setText("Label");
            jPanel3.add((Component)jBLabel4, new GridConstraints(5, 1, 1, 2, 8, 0, 6, 0, null, new Dimension(400, -1), null));
            this.myIdeInfoLabel = jBLabel3 = new JBLabel();
            jBLabel3.setText("Label");
            jPanel3.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(600, -1), null));
            this.myApplyRecommendationLabel = hyperlinkLabel2 = new HyperlinkLabel();
            jPanel3.add((Component)hyperlinkLabel2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 3, null, new Dimension(643, 15), null));
            Spacer spacer = new Spacer();
            jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10)));
            Spacer spacer2 = new Spacer();
            jPanel3.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(184, 10), new Dimension(-1, 10)));
            Spacer spacer3 = new Spacer();
            jPanel3.add((Component)spacer3, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myDaemonPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Daemon Heap Size Settings", (int)0, (int)0, null, null));
            JBLabel jBLabel6 = new JBLabel();
            Font font3 = this.$$$getFont$$$(null, -1, 12, jBLabel6.getFont());
            if (font3 != null) {
                jBLabel6.setFont(font3);
            }
            jBLabel6.setText("Gradle daemon max heap size:");
            jPanel.add((Component)jBLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, new Dimension(190, -1), new Dimension(190, -1), new Dimension(190, -1)));
            this.myGradleDaemonXmxBox = comboBox2 = new ComboBox();
            DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
            defaultComboBoxModel2.addElement("1024");
            defaultComboBoxModel2.addElement("1280");
            defaultComboBoxModel2.addElement("2048");
            defaultComboBoxModel2.addElement("3072");
            defaultComboBoxModel2.addElement("4096");
            comboBox2.setModel(defaultComboBoxModel2);
            jPanel.add((Component)comboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
            Spacer spacer4 = new Spacer();
            jPanel.add((Component)spacer4, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            JBLabel jBLabel7 = new JBLabel();
            Font font4 = this.$$$getFont$$$(null, -1, 12, jBLabel7.getFont());
            if (font4 != null) {
                jBLabel7.setFont(font4);
            }
            jBLabel7.setText("Kotlin daemon max heap size:");
            jPanel.add((Component)jBLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, new Dimension(190, -1), new Dimension(190, -1), new Dimension(190, -1)));
            this.myKotlinDaemonXmxBox = comboBox = new ComboBox();
            DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
            defaultComboBoxModel3.addElement("1024");
            defaultComboBoxModel3.addElement("1280");
            defaultComboBoxModel3.addElement("2048");
            defaultComboBoxModel3.addElement("3072");
            defaultComboBoxModel3.addElement("4096");
            comboBox.setModel(defaultComboBoxModel3);
            jPanel.add((Component)comboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
            Spacer spacer5 = new Spacer();
            jPanel.add((Component)spacer5, new GridConstraints(6, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myShowDaemonsLabel = hyperlinkLabel = new HyperlinkLabel();
            jPanel.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 3, null, null, null));
            Spacer spacer6 = new Spacer();
            jPanel.add((Component)spacer6, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10)));
            this.myDaemonInfoLabel = jBLabel2 = new JBLabel();
            jBLabel2.setText("Label");
            jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(600, -1), null));
            Spacer spacer7 = new Spacer();
            jPanel.add((Component)spacer7, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10)));
            Spacer spacer8 = new Spacer();
            jPanel.add((Component)spacer8, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10)));
            this.myInfoLabel = jBLabel = new JBLabel();
            jBLabel.setText("Label");
            jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, new Dimension(600, -1), null));
            Spacer spacer9 = new Spacer();
            jPanel2.add((Component)spacer9, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10)));
            Spacer spacer10 = new Spacer();
            jPanel2.add((Component)spacer10, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(643, 15), new Dimension(-1, 15)));
            Spacer spacer11 = new Spacer();
            jPanel2.add((Component)spacer11, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup = new ButtonGroup();
            buttonGroup = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
            Font font2;
            if (font == null) {
                return null;
            }
            String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
            Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
            boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
            Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
            return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
        }
    }
}

