/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherLegacyIconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherIconGenerator
extends AdaptiveIconGenerator {
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    public static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX = new Rectangle(0, 0, 768, 768);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_PREVIEW_PLAY_STORE_PX = new Rectangle(0, 0, 528, 529);
    private static final Rectangle IMAGE_SIZE_TARGET_PLAY_STORE_PX = new Rectangle(8, 4, 528, 529);
    private final BoolProperty myGenerateRoundIcon;
    private final BoolProperty myGeneratePlayStoreIcon;
    private final ObjectProperty<IconGenerator.Shape> myLegacyIconShape;
    private final BoolProperty myShowGrid;
    private final ObjectValueProperty<Density> myPreviewDensity;

    public LauncherIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        if (project == null) {
            LauncherIconGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
        this.myGenerateRoundIcon = new BoolValueProperty(true);
        this.myGeneratePlayStoreIcon = new BoolValueProperty(true);
        this.myLegacyIconShape = new ObjectValueProperty<IconGenerator.Shape>(IconGenerator.Shape.SQUARE);
        this.myShowGrid = new BoolValueProperty();
        this.myPreviewDensity = new ObjectValueProperty<Density>(Density.XHIGH);
    }

    @NotNull
    public BoolProperty generateRoundIcon() {
        BoolProperty boolProperty = this.myGenerateRoundIcon;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(1);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty generatePlayStoreIcon() {
        BoolProperty boolProperty = this.myGeneratePlayStoreIcon;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(2);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> legacyIconShape() {
        ObjectProperty<IconGenerator.Shape> objectProperty = this.myLegacyIconShape;
        if (objectProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(3);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty showGrid() {
        BoolProperty boolProperty = this.myShowGrid;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(4);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectValueProperty<Density> previewDensity() {
        ObjectValueProperty<Density> objectValueProperty = this.myPreviewDensity;
        if (objectValueProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(5);
        }
        return objectValueProperty;
    }

    @Override
    @NotNull
    public LauncherIconOptions createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        double scaleFactor;
        LauncherIconOptions options = new LauncherIconOptions(forPreview);
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            Color color;
            options.useForegroundColor = foregroundAsset.isColorable();
            Color color2 = color = foregroundAsset.isColorable() ? (Color)foregroundAsset.color().getValueOrNull() : null;
            if (color != null) {
                options.foregroundColor = color.getRGB();
            }
            scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof ImageAsset && ((ImageAsset)foregroundAsset).isClipart()) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
            }
            options.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, color, this.getGraphicGeneratorContext());
        }
        if ((backgroundAsset = this.backgroundImageAsset().getValueOrNull()) != null) {
            scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, this.getGraphicGeneratorContext());
        }
        options.backgroundColor = ((Color)this.backgroundColor().get()).getRGB();
        options.showGrid = (Boolean)this.myShowGrid.get();
        options.showSafeZone = (Boolean)this.showSafeZone().get();
        options.previewDensity = this.myPreviewDensity.get();
        options.foregroundLayerName = (String)this.foregroundLayerName().get();
        options.backgroundLayerName = (String)this.backgroundLayerName().get();
        options.generateLegacyIcon = (Boolean)this.generateLegacyIcon().get();
        options.legacyIconShape = (IconGenerator.Shape)((Object)this.myLegacyIconShape.get());
        options.generateRoundIcon = (Boolean)this.myGenerateRoundIcon.get();
        options.generatePlayStoreIcon = (Boolean)this.myGeneratePlayStoreIcon.get();
        LauncherIconOptions launcherIconOptions = options;
        if (launcherIconOptions == null) {
            LauncherIconGenerator.$$$reportNull$$$0(6);
        }
        return launcherIconOptions;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(7);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(8);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(9);
        }
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, launcherIconOptions, tasks);
        this.createPreviewImagesTasks(context, launcherIconOptions, tasks);
        ArrayList<Callable<GeneratedIcon>> arrayList = tasks;
        if (arrayList == null) {
            LauncherIconGenerator.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(11);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(12);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(13);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(14);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        for (Density density : DENSITIES) {
            LauncherIconOptions localOptions = options.clone();
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(context, name, localOptions, density, tasks);
        }
        if (options.generatePlayStoreIcon) {
            tasks.add(() -> {
                LauncherIconOptions localOptions = options.clone();
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generatePlayStoreIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = IconGenerator.Shape.NONE;
                AnnotatedImage image = this.generateLegacyImage(context, localOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(localOptions, name)), IconCategory.PLAY_STORE, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull LauncherIconOptions options, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(15);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(16);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(17);
        }
        if (density == null) {
            LauncherIconGenerator.$$$reportNull$$$0(18);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(19);
        }
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions foregroundOptions = options.clone();
                foregroundOptions.generatePlayStoreIcon = false;
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions backgroundOptions = options.clone();
                backgroundOptions.generatePlayStoreIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePlayStoreIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = this.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options.generateRoundIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generatePlayStoreIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = IconGenerator.Shape.CIRCLE;
                AnnotatedImage legacyRound = this.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name + "_round", new PathString(this.getIconPath(legacyOptions, name + "_round")), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        TransformedImageAsset image;
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(20);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(21);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(22);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        LauncherIconOptions iconOptions = options.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.generatePlayStoreIcon = false;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (iconOptions.generateRoundIcon) {
            tasks.add(() -> {
                String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
                return new GeneratedXmlResource(name + "_round", new PathString(this.getIconPath(iconOptions, name + "_round")), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
            });
        }
        if (options.foregroundImage != null && options.foregroundImage.isDrawable()) {
            image = options.foregroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generatePlayStoreIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    LauncherIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    LauncherIconGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            image = options.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generatePlayStoreIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    LauncherIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    LauncherIconGenerator.getLog().error("Transformed background drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options.backgroundImage == null) {
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generatePlayStoreIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    private void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(23);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(24);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(25);
        }
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options.generatePlayStoreIcon) {
            previewShapes.add(PreviewShape.PLAY_STORE);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                LauncherIconOptions localOptions = options.clone();
                localOptions.density = options.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generatePlayStoreIcon = previewShape == PreviewShape.PLAY_STORE;
                try {
                    image = this.generatePreviewImage(context, localOptions);
                }
                catch (Throwable e) {
                    LauncherIconGenerator.getLog().error(e);
                    image = LauncherIconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name) {
        if (categoryMap == null) {
            LauncherIconGenerator.$$$reportNull$$$0(26);
        }
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(27);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(28);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(29);
        }
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        LauncherIconOptions localOptions = launcherIconOptions.clone();
        localOptions.generatePlayStoreIcon = false;
        Collection<GeneratedIcon> icons = this.generateIcons(context, options, name);
        icons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> icon2.getOutputPath() != null).forEach(icon2 -> {
            assert (icon2.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon2.getCategory().toString(), k -> new LinkedHashMap());
            LauncherIconOptions iconOptions = localOptions.clone();
            iconOptions.density = icon2.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            iconOptions.generatePlayStoreIcon = icon2.getCategory() == IconCategory.PLAY_STORE;
            imageMap.put(icon2.getOutputPath().toString(), new AnnotatedImage(icon2.getImage(), icon2.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(30);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(31);
        }
        if (options.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(32);
            }
            return annotatedImage;
        }
        return this.generatePreviewImage(context, (LauncherIconOptions)options);
    }

    @NotNull
    private AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(33);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(34);
        }
        switch (options.previewShape) {
            case CIRCLE: 
            case SQUIRCLE: 
            case ROUNDED_SQUARE: 
            case SQUARE: {
                return this.generateViewportPreviewImage(context, options);
            }
            case LEGACY: {
                options.generatePreviewIcons = true;
                options.generatePlayStoreIcon = false;
                return this.generateLegacyImage(context, options);
            }
            case LEGACY_ROUND: {
                options.generatePreviewIcons = true;
                options.generatePlayStoreIcon = false;
                options.legacyIconShape = IconGenerator.Shape.CIRCLE;
                return this.generateLegacyImage(context, options);
            }
            case FULL_BLEED: {
                AnnotatedImage annotatedImage = this.generateFullBleedPreviewImage(context, options);
                return new AnnotatedImage(LauncherIconGenerator.scaledPreviewImage(annotatedImage.getImage(), 0.8f), annotatedImage.getErrorMessage());
            }
            case PLAY_STORE: {
                options.generatePreviewIcons = true;
                options.generatePlayStoreIcon = true;
                options.legacyIconShape = IconGenerator.Shape.SQUARE;
                AnnotatedImage annotatedImage = this.generateLegacyImage(context, options);
                BufferedImage image = AssetUtil.trimmedImage((BufferedImage)annotatedImage.getImage());
                double scale = LauncherIconGenerator.getMdpiScaleFactor(options.previewDensity);
                return new AnnotatedImage(LauncherIconGenerator.scaledPreviewImage(image, 0.22 * scale), annotatedImage.getErrorMessage());
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private AnnotatedImage generateFullBleedPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(35);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(36);
        }
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, Color.BLACK);
        LauncherIconGenerator.drawGrid(options, mergedImage.getImage());
        AnnotatedImage annotatedImage = mergedImage;
        if (annotatedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(37);
        }
        return annotatedImage;
    }

    @NotNull
    private AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(38);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(39);
        }
        Rectangle viewportRect = this.getViewportRectangle(options);
        Rectangle legacyRect = this.getLegacyRectangle(options);
        Density legacyOrPlayStoreDensity = options.generatePlayStoreIcon ? Density.NODPI : options.density;
        Rectangle legacyShapeRect = options.generatePlayStoreIcon ? IMAGE_SIZE_TARGET_PLAY_STORE_PX : LauncherLegacyIconGenerator.getTargetRect(options.legacyIconShape, legacyOrPlayStoreDensity);
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, null);
        BufferedImage fullBleed = mergedImage.getImage();
        double viewportScale = LauncherIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : LauncherIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options.legacyIconShape != IconGenerator.Shape.NONE) {
            shapeImageBack = LauncherIconGenerator.loadBackImage(context, options.legacyIconShape, legacyOrPlayStoreDensity);
            shapeImageFore = LauncherIconGenerator.loadStyleImage(context, options.legacyIconShape, legacyOrPlayStoreDensity, IconGenerator.Style.SIMPLE);
            shapeImageMask = LauncherIconGenerator.loadMaskImage(context, options.legacyIconShape, legacyOrPlayStoreDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = LauncherIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        return new AnnotatedImage(legacyImage, mergedImage.getErrorMessage());
    }

    @NotNull
    private AnnotatedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(40);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(41);
        }
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, null);
        BufferedImage image = mergedImage.getImage();
        BufferedImage mask = this.generateMaskLayer(context, options, options.previewShape);
        image = this.cropImageToViewport(options, image);
        image = LauncherIconGenerator.applyMask(image, mask);
        LauncherIconGenerator.drawGrid(options, image);
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @Nullable
    private BufferedImage generateMaskLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull PreviewShape shape) {
        String maskName;
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(42);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(43);
        }
        if (shape == null) {
            LauncherIconGenerator.$$$reportNull$$$0(44);
        }
        switch (shape) {
            case CIRCLE: {
                maskName = "circle";
                break;
            }
            case SQUARE: {
                maskName = "square";
                break;
            }
            case ROUNDED_SQUARE: {
                maskName = "rounded_corner";
                break;
            }
            case SQUIRCLE: {
                maskName = "squircle";
                break;
            }
            default: {
                maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options.generatePlayStoreIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = context.loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            double scale = LauncherIconGenerator.getRectangleInsideScale(maskRect, this.getViewportRectangle(options));
            return options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(mask, scale) : LauncherIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options.density.getResourceValue());
        return context.loadImageResource(resourceName);
    }

    @Override
    @NotNull
    protected Rectangle getFullBleedRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(45);
        }
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            Rectangle rectangle = IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX;
            if (rectangle == null) {
                LauncherIconGenerator.$$$reportNull$$$0(46);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            LauncherIconGenerator.$$$reportNull$$$0(47);
        }
        return rectangle;
    }

    @Override
    @NotNull
    protected Rectangle getViewportRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(48);
        }
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            Rectangle rectangle = IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX;
            if (rectangle == null) {
                LauncherIconGenerator.$$$reportNull$$$0(49);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            LauncherIconGenerator.$$$reportNull$$$0(50);
        }
        return rectangle;
    }

    @Override
    @NotNull
    protected Rectangle getLegacyRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(51);
        }
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            Rectangle rectangle = options.generatePreviewIcons ? IMAGE_SIZE_VIEWPORT_PREVIEW_PLAY_STORE_PX : IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX;
            if (rectangle == null) {
                LauncherIconGenerator.$$$reportNull$$$0(52);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            LauncherIconGenerator.$$$reportNull$$$0(53);
        }
        return rectangle;
    }

    @Override
    protected Rectangle getMaxIconRectangle() {
        return IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX;
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull BufferedImage image) {
        if (launcherIconOptions == null) {
            LauncherIconGenerator.$$$reportNull$$$0(54);
        }
        if (image == null) {
            LauncherIconGenerator.$$$reportNull$$$0(55);
        }
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        LauncherIconGenerator.drawGrid(launcherIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull Graphics2D gOut) {
        if (launcherIconOptions == null) {
            LauncherIconGenerator.$$$reportNull$$$0(56);
        }
        if (gOut == null) {
            LauncherIconGenerator.$$$reportNull$$$0(57);
        }
        if (launcherIconOptions.generatePlayStoreIcon) {
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
                LauncherIconGenerator.drawFullBleedIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.LEGACY || launcherIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (launcherIconOptions.showGrid) {
                LauncherIconGenerator.drawLegacyIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
            LauncherIconGenerator.drawAdaptiveIconGrid(launcherIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(58);
        }
        if (out == null) {
            LauncherIconGenerator.$$$reportNull$$$0(59);
        }
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(60);
        }
        if (out == null) {
            LauncherIconGenerator.$$$reportNull$$$0(61);
        }
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, LauncherIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(62);
        }
        if (out == null) {
            LauncherIconGenerator.$$$reportNull$$$0(63);
        }
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            LauncherIconGenerator.$$$reportNull$$$0(64);
        }
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull IconGenerator.IconOptions options, @NotNull String iconName) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(65);
        }
        if (iconName == null) {
            LauncherIconGenerator.$$$reportNull$$$0(66);
        }
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            String string = iconName + "-playstore.png";
            if (string == null) {
                LauncherIconGenerator.$$$reportNull$$$0(67);
            }
            return string;
        }
        String string = super.getIconPath(options, iconName);
        if (string == null) {
            LauncherIconGenerator.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(LauncherIconGenerator.class);
        if (logger2 == null) {
            LauncherIconGenerator.$$$reportNull$$$0(69);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 32: 
            case 37: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 67: 
            case 68: 
            case 69: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 32: 
            case 37: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 67: 
            case 68: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 32: 
            case 37: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 67: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 51: 
            case 58: 
            case 60: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 18: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherIconOptions";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gOut";
                break;
            }
            case 59: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRoundIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePlayStoreIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "legacyIconShape";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showGrid";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "previewDensity";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconGenerationTasks";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFullBleedPreviewImage";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullBleedRectangle";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewportRectangle";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyRectangle";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 32: 
            case 37: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 67: 
            case 68: 
            case 69: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createIconGenerationTasks";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsTasks";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsForSingleDensityTasks";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createXmlDrawableResourcesTasks";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewImagesTasks";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generatePreviewImage";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateFullBleedPreviewImage";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "generateLegacyImage";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generateViewportPreviewImage";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "generateMaskLayer";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFullBleedRectangle";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getViewportRectangle";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyRectangle";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "drawGrid";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "drawAdaptiveIconGrid";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "drawFullBleedIconGrid";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "drawLegacyIconGrid";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 32: 
            case 37: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 67: 
            case 68: 
            case 69: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum PreviewShape {
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        PLAY_STORE("play-store", "Google Play Store"),
        NONE("none", "none");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            if (id == null) {
                PreviewShape.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                PreviewShape.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.displayName = displayName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator$PreviewShape";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class LauncherIconOptions
    extends AdaptiveIconGenerator.AdaptiveIconOptions
    implements Cloneable {
        public boolean generateRoundIcon = true;
        public boolean generatePlayStoreIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public IconGenerator.Shape legacyIconShape = IconGenerator.Shape.SQUARE;
        public boolean showGrid;

        public LauncherIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public LauncherIconOptions clone() {
            LauncherIconOptions launcherIconOptions = (LauncherIconOptions)super.clone();
            if (launcherIconOptions == null) {
                LauncherIconOptions.$$$reportNull$$$0(0);
            }
            return launcherIconOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator$LauncherIconOptions", "clone"));
        }
    }
}

