/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewAndroidModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.module.AndroidApiLevelComboBox;
import com.android.tools.idea.npw.module.AppNameToModuleNameExpression;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.AndroidVersionsInfoKt;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.template.ChooseActivityTypeStep;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.validator.ModuleValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidModuleStep
extends SkippableWizardStep<NewAndroidModuleModel> {
    private final AndroidVersionsInfo myAndroidVersionsInfo;
    private final List<UpdatablePackage> myInstallRequests;
    private final List<RemotePackage> myInstallLicenseRequests;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    @NotNull
    private final StudioWizardStepPanel myRootPanel;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    @NotNull
    private final FormFactor myFormFactor;
    private final int myMinSdkLevel;
    private AndroidApiLevelComboBox myApiLevelCombo;
    private JComboBox<Language> myLanguageCombo;
    private JTextField myModuleName;
    private JPanel myPanel;
    private JLabel myAppNameLabel;
    private JTextField myAppName;
    private LabelWithEditButton myPackageName;
    private JLabel myModuleNameLabel;
    @NotNull
    private RenderTemplateModel myRenderModel;

    public ConfigureAndroidModuleStep(final @NotNull NewAndroidModuleModel model2, @NotNull FormFactor formFactor, int minSdkLevel, final String basePackage, @NotNull String title) {
        if (model2 == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(0);
        }
        if (formFactor == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(2);
        }
        super(model2, title, formFactor.getIcon());
        this.$$$setupUI$$$();
        this.myAndroidVersionsInfo = new AndroidVersionsInfo();
        this.myInstallRequests = new ArrayList<UpdatablePackage>();
        this.myInstallLicenseRequests = new ArrayList<RemotePackage>();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myFormFactor = formFactor;
        this.myMinSdkLevel = minSdkLevel;
        if (model2.isLibrary()) {
            this.myAppNameLabel.setVisible(false);
            this.myAppName.setVisible(false);
        }
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        TextProperty moduleNameText = new TextProperty(this.myModuleName);
        Expression<String> computedPackageName = new Expression<String>(new ObservableValue[]{model2.getModuleName()}){

            @Override
            @NotNull
            public String get() {
                String string = String.format("%s.%s", basePackage, NewProjectModel.nameToJavaPackage(model2.getModuleName().get()));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/module/ConfigureAndroidModuleStep$1", "get"));
            }
        };
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model2.getPackageName(), packageNameText);
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName.get())));
        NewAndroidModuleModel moduleModel = (NewAndroidModuleModel)this.getModel();
        Project project = moduleModel.getProject();
        AppNameToModuleNameExpression computedModuleName = new AppNameToModuleNameExpression(project, model2.getApplicationName(), model2.getModuleParent());
        BoolValueProperty isModuleNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(moduleNameText, computedModuleName, isModuleNameSynced);
        this.myBindings.bind(model2.getModuleName(), moduleNameText);
        this.myListeners.listen(moduleNameText, value2 -> isModuleNameSynced.set(value2.equals(computedModuleName.get())));
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), model2.getApplicationName());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myValidatorPanel.registerValidator((ObservableValue)model2.getApplicationName(), value2 -> {
            if (value2.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.application.name", new Object[0]));
            }
            if (!model2.isLibrary() && !Character.isUpperCase(value2.charAt(0))) {
                return new Validator.Result(Validator.Severity.INFO, AndroidBundle.message("android.wizard.validate.lowercase.application.name", new Object[0]));
            }
            return Validator.Result.OK;
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)model2.getModuleName(), (Validator)new ModuleValidator(project), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)model2.getPackageName(), value2 -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value2)), new ObservableValue[0]);
        this.myRenderModel = RenderTemplateModel.fromModuleModel(moduleModel, null, AndroidBundle.message("android.wizard.activity.add", this.myFormFactor.id));
        this.myBindings.bind(model2.getAndroidSdkInfo(), new SelectedItemProperty(this.myApiLevelCombo));
        this.myValidatorPanel.registerValidator((ObservableValue)model2.getAndroidSdkInfo(), value2 -> {
            if (!value2.isPresent()) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("select.target.dialog.text", new Object[0]));
            }
            if (!(((AndroidVersionsInfo.VersionItem)value2.get()).getMinApiLevel() < 29 && this.myFormFactor != FormFactor.WEAR || MigrateToAndroidxUtil.isAndroidx(project))) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.module.needs.androidx", new Object[0]));
            }
            return Validator.Result.OK;
        }, new ObservableValue[0]);
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myLanguageCombo), ((NewAndroidModuleModel)this.getModel()).getLanguage());
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        ChooseActivityTypeStep chooseActivityStep = new ChooseActivityTypeStep(this.myRenderModel, this.myFormFactor, new ArrayList<NamedModuleTemplate>(), ((NewAndroidModuleModel)this.getModel()).getAndroidSdkInfo());
        chooseActivityStep.setShouldShow(!((NewAndroidModuleModel)this.getModel()).isLibrary());
        LicenseAgreementStep licenseAgreementStep = new LicenseAgreementStep(new LicenseAgreementModel(AndroidVersionsInfoKt.getSdkManagerLocalPath()), this.myInstallLicenseRequests);
        InstallSelectedPackagesStep installPackagesStep = new InstallSelectedPackagesStep(this.myInstallRequests, new HashSet<LocalPackage>(), AndroidSdks.getInstance().tryToChooseSdkHandler(), false);
        ArrayList arrayList = Lists.newArrayList((Object[])new ModelWizardStep[]{chooseActivityStep, licenseAgreementStep, installPackagesStep});
        if (arrayList == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    protected void onEntering() {
        this.myAndroidVersionsInfo.loadLocalVersions();
        this.myApiLevelCombo.init(this.myFormFactor, this.myAndroidVersionsInfo.getKnownTargetVersions(this.myFormFactor, this.myMinSdkLevel));
        this.myAndroidVersionsInfo.loadRemoteTargetVersions(this.myFormFactor, this.myMinSdkLevel, items2 -> this.myApiLevelCombo.init(this.myFormFactor, (List<AndroidVersionsInfo.VersionItem>)items2));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(4);
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        NewAndroidModuleModel moduleModel = (NewAndroidModuleModel)this.getModel();
        moduleModel.getModuleTemplateValues().put(this.myFormFactor.id + "included", true);
        ((NewAndroidModuleModel)this.getModel()).getModuleName().set(this.myModuleName.getText());
        Project project = moduleModel.getProject();
        ((NewAndroidModuleModel)this.getModel()).getTemplate().set(GradleAndroidModuleTemplate.createDefaultTemplateAt(project.getBasePath(), moduleModel.getModuleName().get()));
        this.myInstallRequests.clear();
        this.myInstallLicenseRequests.clear();
        List<AndroidVersionsInfo.VersionItem> installItems = Collections.singletonList((AndroidVersionsInfo.VersionItem)moduleModel.getAndroidSdkInfo().getValue());
        this.myInstallRequests.addAll(this.myAndroidVersionsInfo.loadInstallPackageList(installItems));
        this.myInstallLicenseRequests.addAll(this.myInstallRequests.stream().map(UpdatablePackage::getRemote).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myRootPanel;
        if (studioWizardStepPanel == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(5);
        }
        return studioWizardStepPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    private void createUIComponents() {
        this.myApiLevelCombo = new AndroidApiLevelComboBox();
        this.myLanguageCombo = new LanguageComboProvider().createComponent();
        this.myModuleNameLabel = ContextHelpLabel.create((String)AndroidBundle.message("android.wizard.module.help.name", new Object[0]));
        this.myPackageName = new LabelWithEditButton();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/module/ConfigureAndroidModuleStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/module/ConfigureAndroidModuleStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        LabelWithEditButton labelWithEditButton2;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(15, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myAppName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = labelWithEditButton2 = new LabelWithEditButton();
        labelWithEditButton2.setName("PackageName");
        jPanel.add((Component)labelWithEditButton2, new GridConstraints(8, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myModuleName = jTextField = new JTextField();
        jTextField.setName("ModuleName");
        jPanel.add((Component)jTextField, new GridConstraints(5, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        AndroidApiLevelComboBox androidApiLevelComboBox = this.myApiLevelCombo;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        androidApiLevelComboBox.setModel(defaultComboBoxModel);
        jPanel.add((Component)androidApiLevelComboBox, new GridConstraints(13, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font != null) {
            jLabel2.setFont(font);
        }
        jLabel2.setText("Package name");
        jPanel.add((Component)jLabel2, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = this.myModuleNameLabel;
        Font font2 = this.$$$getFont$$$(null, 1, -1, jLabel3.getFont());
        if (font2 != null) {
            jLabel3.setFont(font2);
        }
        jLabel3.setHorizontalTextPosition(2);
        jLabel3.setText("Module name");
        jLabel3.setDisplayedMnemonic('M');
        jLabel3.setDisplayedMnemonicIndex(0);
        ((Component)jLabel3).setVisible(true);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppNameLabel = jLabel = new JLabel();
        Font font3 = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font3 != null) {
            jLabel.setFont(font3);
        }
        jLabel.setText("Application/Library name");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 16), null));
        JLabel jLabel4 = new JLabel();
        Font font4 = this.$$$getFont$$$(null, 1, -1, jLabel4.getFont());
        if (font4 != null) {
            jLabel4.setFont(font4);
        }
        jLabel4.setText("Minimum SDK");
        jPanel.add((Component)jLabel4, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(14, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(9, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 16), null));
        JBLabel jBLabel = new JBLabel();
        Font font5 = this.$$$getFont$$$(null, 1, 20, jBLabel.getFont());
        if (font5 != null) {
            jBLabel.setFont(font5);
        }
        jBLabel.setText("Configure the new module");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 50), null));
        JLabel jLabel5 = new JLabel();
        Font font6 = this.$$$getFont$$$(null, 1, -1, jLabel5.getFont());
        if (font6 != null) {
            jLabel5.setFont(font6);
        }
        jLabel5.setText("Language");
        jPanel.add((Component)jLabel5, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<Language> jComboBox = this.myLanguageCombo;
        jPanel.add(jComboBox, new GridConstraints(11, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

