/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractObservableValue<T>
implements ObservableValue<T> {
    private final List<InvalidationListener> myListeners = new ArrayList<InvalidationListener>(0);
    private final List<WeakReference<InvalidationListener>> myWeakListeners = new ArrayList<WeakReference<InvalidationListener>>(0);
    private boolean myNotificationsEnabled = true;

    @Override
    public final void addListener(@NotNull InvalidationListener listener2) {
        if (listener2 == null) {
            AbstractObservableValue.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public final void removeListener(@NotNull InvalidationListener listener2) {
        if (listener2 == null) {
            AbstractObservableValue.$$$reportNull$$$0(1);
        }
        this.myListeners.remove(listener2);
        Iterator<WeakReference<InvalidationListener>> it = this.myWeakListeners.iterator();
        while (it.hasNext()) {
            InvalidationListener l = (InvalidationListener)it.next().get();
            if (l != null && l != listener2) continue;
            it.remove();
        }
    }

    @Override
    public final void addWeakListener(@NotNull InvalidationListener listener2) {
        if (listener2 == null) {
            AbstractObservableValue.$$$reportNull$$$0(2);
        }
        this.myWeakListeners.add(new WeakReference<InvalidationListener>(listener2));
    }

    protected final void notifyInvalidated() {
        if (!this.myNotificationsEnabled) {
            return;
        }
        ImmutableList listenersSnapshot = ImmutableList.copyOf(this.myListeners);
        ImmutableList weakListenersSnapshot = ImmutableList.copyOf(this.myWeakListeners);
        for (InvalidationListener listener2 : listenersSnapshot) {
            listener2.onInvalidated();
        }
        for (WeakReference reference2 : weakListenersSnapshot) {
            InvalidationListener listener3 = (InvalidationListener)reference2.get();
            if (listener3 == null) continue;
            listener3.onInvalidated();
        }
        Iterator<WeakReference<InvalidationListener>> it = this.myWeakListeners.iterator();
        while (it.hasNext()) {
            InvalidationListener listener2;
            listener2 = (InvalidationListener)it.next().get();
            if (listener2 != null) continue;
            it.remove();
        }
    }

    protected final void setNotificationsEnabled(boolean enabled) {
        this.myNotificationsEnabled = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "listener";
        objectArray2[1] = "com/android/tools/idea/observable/AbstractObservableValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addWeakListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

