/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.eventpreprocessor.EnergyUsagePreprocessor;
import com.android.tools.idea.profilers.eventpreprocessor.SimpleperfPipelinePreprocessor;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxyManager;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfSampleReporter;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerService
implements TransportDeviceManager.TransportDeviceManagerListener {
    private final int LIVE_ALLOCATION_STACK_DEPTH = Integer.getInteger("profiler.alloc.stack.depth", 50);

    public static AndroidProfilerService getInstance() {
        return (AndroidProfilerService)ApplicationManager.getApplication().getService(AndroidProfilerService.class);
    }

    AndroidProfilerService() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TransportDeviceManager.TOPIC, (Object)this);
    }

    @Override
    public void onPreTransportDaemonStart(@NotNull Common.Device device) {
        if (device == null) {
            AndroidProfilerService.$$$reportNull$$$0(0);
        }
    }

    @Override
    public void onStartTransportDaemonFail(@NotNull Common.Device device, @NotNull Exception exception) {
        if (device == null) {
            AndroidProfilerService.$$$reportNull$$$0(1);
        }
        if (exception == null) {
            AndroidProfilerService.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void onTransportProxyCreationFail(@NotNull Common.Device device, @NotNull Exception exception) {
        if (device == null) {
            AndroidProfilerService.$$$reportNull$$$0(3);
        }
        if (exception == null) {
            AndroidProfilerService.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void customizeProxyService(@NotNull TransportProxy proxy) {
        if (proxy == null) {
            AndroidProfilerService.$$$reportNull$$$0(5);
        }
        ProfilerServiceProxyManager.registerProxies(proxy);
        ProfilerServiceProxyManager.registerCommandHandlers(proxy);
        if (((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()) {
            proxy.registerEventPreprocessor(new EnergyUsagePreprocessor(TransportService.getInstance().getLogService()));
        }
        SimpleperfPipelinePreprocessor traceProcessor = new SimpleperfPipelinePreprocessor((TracePreProcessor)new SimpleperfSampleReporter());
        proxy.registerEventPreprocessor(traceProcessor);
        proxy.registerDataPreprocessor(traceProcessor);
    }

    @Override
    public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder configBuilder) {
        if (configBuilder == null) {
            AndroidProfilerService.$$$reportNull$$$0(6);
        }
        configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()).setProfilerCustomEventVisualization(((Boolean)StudioFlags.PROFILER_CUSTOM_EVENT_VISUALIZATION.get()).booleanValue())).setCpu(Transport.DaemonConfig.CpuConfig.newBuilder().setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC).setUsePerfetto(((Boolean)StudioFlags.PROFILER_USE_PERFETTO.get()).booleanValue()));
    }

    @Override
    public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder configBuilder, @Nullable AndroidRunConfigurationBase runConfig) {
        if (configBuilder == null) {
            AndroidProfilerService.$$$reportNull$$$0(7);
        }
        int liveAllocationSamplingRate = ((Boolean)StudioFlags.PROFILER_SAMPLE_LIVE_ALLOCATIONS.get()).booleanValue() ? (this.shouldEnableMemoryLiveAllocation(runConfig) ? PropertiesComponent.getInstance().getInt(IntellijProfilerPreferences.getProfilerPropertyName("memory.live.allocation.mode"), MemoryProfilerStage.DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.NONE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
        configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()).setProfilerCustomEventVisualization(((Boolean)StudioFlags.PROFILER_CUSTOM_EVENT_VISUALIZATION.get()).booleanValue())).setMem(Agent.AgentConfig.MemoryConfig.newBuilder().setUseLiveAlloc(((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue()).setMaxStackDepth(this.LIVE_ALLOCATION_STACK_DEPTH).setTrackGlobalJniRefs(((Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get()).booleanValue()).setSamplingRate(Memory.MemoryAllocSamplingData.newBuilder().setSamplingNumInterval(liveAllocationSamplingRate).build()).build()).setCpuApiTracingEnabled(((Boolean)StudioFlags.PROFILER_CPU_API_TRACING.get()).booleanValue()).setStartupProfilingEnabled(runConfig != null);
    }

    private boolean shouldEnableMemoryLiveAllocation(@Nullable AndroidRunConfigurationBase runConfig) {
        if (runConfig != null && runConfig.getProfilerState().STARTUP_CPU_PROFILING_ENABLED) {
            String configName = runConfig.getProfilerState().STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
            CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(runConfig.getProject()).getConfigByName(configName);
            return startupConfig == null || !startupConfig.isDisableLiveAllocation();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configBuilder";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onPreTransportDaemonStart";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onStartTransportDaemonFail";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onTransportProxyCreationFail";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeProxyService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeDaemonConfig";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeAgentConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

