/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.eventpreprocessor;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.energy.BatteryModel;
import com.android.tools.datastore.energy.CpuConfig;
import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Network;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyUsagePreprocessor
implements TransportEventPreprocessor {
    private static final long DEFAULT_SAMPLE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    @NotNull
    private final LogService myLogService;
    @NotNull
    private final BatteryModel myBatteryModel;
    private long mySampleInterval;
    private long myDataStartTimestampNs;
    @Nullable
    private CpuConfig myCpuConfig;
    @Nullable
    private Cpu.CpuUsageData myLastCpuUsageData;
    @NotNull
    private PowerProfile.NetworkType myLastNetworkType;

    public EnergyUsagePreprocessor(@NotNull LogService logService) {
        if (logService == null) {
            EnergyUsagePreprocessor.$$$reportNull$$$0(0);
        }
        this(logService, new BatteryModel(), DEFAULT_SAMPLE_INTERVAL_NS);
    }

    @VisibleForTesting
    public EnergyUsagePreprocessor(@NotNull LogService logService, @NotNull BatteryModel batteryModel, long sampleInterval) {
        if (logService == null) {
            EnergyUsagePreprocessor.$$$reportNull$$$0(1);
        }
        if (batteryModel == null) {
            EnergyUsagePreprocessor.$$$reportNull$$$0(2);
        }
        this.myDataStartTimestampNs = Long.MIN_VALUE;
        this.myCpuConfig = null;
        this.myLastCpuUsageData = null;
        this.myLastNetworkType = PowerProfile.NetworkType.NONE;
        this.myLogService = logService;
        this.myBatteryModel = batteryModel;
        this.mySampleInterval = sampleInterval;
    }

    @Override
    public boolean shouldPreprocess(Common.Event event) {
        switch (event.getKind()) {
            case CPU_CORE_CONFIG: 
            case CPU_USAGE: 
            case NETWORK_TYPE: 
            case NETWORK_SPEED: {
                return true;
            }
            case ENERGY_EVENT: {
                switch (event.getEnergyEvent().getMetadataCase()) {
                    case LOCATION_UPDATE_REQUESTED: 
                    case LOCATION_CHANGED: 
                    case LOCATION_UPDATE_REMOVED: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Iterable<Common.Event> preprocessEvent(Common.Event event) {
        switch (event.getKind()) {
            case CPU_CORE_CONFIG: {
                this.myCpuConfig = new CpuConfig(event.getCpuCoreConfig(), this.myLogService);
                break;
            }
            case CPU_USAGE: {
                if (this.myCpuConfig == null) {
                    this.myCpuConfig = new CpuConfig(Cpu.CpuCoreConfigData.getDefaultInstance(), this.myLogService);
                }
                if (this.myLastCpuUsageData != null) {
                    this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.CPU_USAGE, (Object)this.myCpuConfig.getCpuCoreUsages(this.myLastCpuUsageData, event.getCpuUsage()));
                }
                this.myLastCpuUsageData = event.getCpuUsage();
                List<Common.Event> list = this.generateEnergyUsageEvents(event);
                if (list == null) {
                    EnergyUsagePreprocessor.$$$reportNull$$$0(3);
                }
                return list;
            }
            case NETWORK_TYPE: {
                this.myLastNetworkType = PowerProfile.NetworkType.from((Network.NetworkTypeData.NetworkType)event.getNetworkType().getNetworkType());
                break;
            }
            case NETWORK_SPEED: {
                Network.NetworkSpeedData speedData = event.getNetworkSpeed();
                long rxSpeed = 0L;
                long txSpeed = 0L;
                if (event.getGroupId() == 102L) {
                    rxSpeed = speedData.getThroughput();
                } else if (event.getGroupId() == 101L) {
                    txSpeed = speedData.getThroughput();
                }
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.NETWORK_USAGE, (Object)new PowerProfile.NetworkStats(this.myLastNetworkType, rxSpeed, txSpeed));
                List<Common.Event> list = this.generateEnergyUsageEvents(event);
                if (list == null) {
                    EnergyUsagePreprocessor.$$$reportNull$$$0(4);
                }
                return list;
            }
            case ENERGY_EVENT: {
                switch (event.getEnergyEvent().getMetadataCase()) {
                    case LOCATION_UPDATE_REQUESTED: {
                        this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_REGISTER, (Object)new PowerProfile.LocationEvent(event.getGroupId(), PowerProfile.LocationType.from((String)event.getEnergyEvent().getLocationUpdateRequested().getRequest().getProvider())));
                        break;
                    }
                    case LOCATION_CHANGED: {
                        this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UPDATE, (Object)new PowerProfile.LocationEvent(event.getGroupId(), PowerProfile.LocationType.from((String)event.getEnergyEvent().getLocationChanged().getLocation().getProvider())));
                        break;
                    }
                    case LOCATION_UPDATE_REMOVED: {
                        this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UNREGISTER, (Object)new PowerProfile.LocationEvent(event.getGroupId(), PowerProfile.LocationType.NONE));
                        break;
                    }
                }
                List<Common.Event> list = this.generateEnergyUsageEvents(event);
                if (list == null) {
                    EnergyUsagePreprocessor.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<Common.Event> list = Collections.emptyList();
        if (list == null) {
            EnergyUsagePreprocessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private List<Common.Event> generateEnergyUsageEvents(Common.Event event) {
        if (this.myDataStartTimestampNs == Long.MIN_VALUE) {
            this.myDataStartTimestampNs = event.getTimestamp();
        }
        if (event.getTimestamp() - this.myDataStartTimestampNs > this.mySampleInterval) {
            ArrayList<Common.Event> result2 = new ArrayList<Common.Event>();
            this.myBatteryModel.getSamplesBetween(this.myDataStartTimestampNs, event.getTimestamp()).forEach(sample -> result2.add(Common.Event.newBuilder().setPid(event.getPid()).setTimestamp(sample.getTimestamp()).setKind(Common.Event.Kind.ENERGY_USAGE).setEnergyUsage(sample.getEnergyUsage()).build()));
            this.myDataStartTimestampNs = event.getTimestamp();
            return result2;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batteryModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/eventpreprocessor/EnergyUsagePreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/eventpreprocessor/EnergyUsagePreprocessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

