/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class AndroidKtsSupportNotification {
    public static final String KTS_DISABLED_WARNING_MSG = "This project uses Gradle KTS build files which are not fully supported. Some functions may be affected.";
    public static final String KTS_ENABLED_WARNING_MSG = "Support for <tt>gradle.kts</tt> build files is experimental: please file bugs to report any problems you encounter.";
    public static final String KTS_WARNING_TITLE = "Gradle Kotlinscript Build Files";
    public static final NotificationGroup KTS_NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Gradle KTS build files");
    @NotNull
    private final Project myProject;
    private boolean alreadyShown;

    @NotNull
    public static AndroidKtsSupportNotification getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidKtsSupportNotification.$$$reportNull$$$0(0);
        }
        AndroidKtsSupportNotification androidKtsSupportNotification = (AndroidKtsSupportNotification)ServiceManager.getService((Project)project, AndroidKtsSupportNotification.class);
        if (androidKtsSupportNotification == null) {
            AndroidKtsSupportNotification.$$$reportNull$$$0(1);
        }
        return androidKtsSupportNotification;
    }

    public AndroidKtsSupportNotification(@NotNull Project project) {
        if (project == null) {
            AndroidKtsSupportNotification.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.alreadyShown = false;
    }

    public void showWarningIfNotShown() {
        if (((Boolean)StudioFlags.KOTLIN_DSL_PARSING.get()).booleanValue()) {
            return;
        }
        if (!this.alreadyShown) {
            AndroidNotification.getInstance(this.myProject).showBalloon(KTS_WARNING_TITLE, KTS_DISABLED_WARNING_MSG, NotificationType.WARNING, KTS_NOTIFICATION_GROUP, new DisableAndroidKtsNotificationHyperlink());
            NotificationSettings settings = NotificationsConfigurationImpl.getSettings((String)KTS_NOTIFICATION_GROUP.getDisplayId());
            this.alreadyShown = settings.getDisplayType() != NotificationDisplayType.NONE || settings.isShouldLog();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/AndroidKtsSupportNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/AndroidKtsSupportNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DisableAndroidKtsNotificationHyperlink
    extends NotificationHyperlink {
        protected DisableAndroidKtsNotificationHyperlink() {
            super("disableKtsNotification", "Disable this warning");
            this.setCloseOnClick(true);
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                DisableAndroidKtsNotificationHyperlink.$$$reportNull$$$0(0);
            }
            NotificationsConfiguration.getNotificationsConfiguration().changeSettings(KTS_NOTIFICATION_GROUP.getDisplayId(), NotificationDisplayType.NONE, false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidKtsSupportNotification$DisableAndroidKtsNotificationHyperlink", "execute"));
        }
    }
}

