/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.ModuleBasedClassFileFinder;
import com.android.tools.idea.projectsystem.ClassFileFinderUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class GradleClassFileFinder
extends ModuleBasedClassFileFinder {
    @NotNull
    private static final String CLASSES_FOLDER_NAME = "classes";
    @NotNull
    private static final String RESOURCES_FOLDER_NAME = "resources";
    @NotNull
    private static final String MAIN_FOLDER_NAME = "main";
    @NotNull
    private static final String TEST_FOLDER_NAME = "test";
    @NotNull
    private static final String KOTLIN_FOLDER_NAME = "kotlin";

    public GradleClassFileFinder(@NotNull Module module) {
        if (module == null) {
            GradleClassFileFinder.$$$reportNull$$$0(0);
        }
        super(module);
    }

    @Override
    @Nullable
    protected VirtualFile findClassFileInModule(@NotNull Module module, @NotNull String className) {
        VirtualFile file;
        if (module == null) {
            GradleClassFileFinder.$$$reportNull$$$0(1);
        }
        if (className == null) {
            GradleClassFileFinder.$$$reportNull$$$0(2);
        }
        if ((file = super.findClassFileInModule(module, className)) != null) {
            return file;
        }
        for (VirtualFile outputDir : GradleClassFileFinder.getModuleCompileOutputs(module)) {
            file = ClassFileFinderUtil.findClassFileInOutputRoot(outputDir, className);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getCompilerOutputRoots(@NotNull AndroidModuleModel model2) {
        File outFolder;
        File file;
        if (model2 == null) {
            GradleClassFileFinder.$$$reportNull$$$0(3);
        }
        IdeVariant variant = model2.getSelectedVariant();
        String variantName = variant.getName();
        IdeAndroidArtifact mainArtifactInfo = model2.getMainArtifact();
        File classesFolder = mainArtifactInfo.getClassesFolder();
        ImmutableList.Builder compilerOutputs = new ImmutableList.Builder();
        if (classesFolder == null) {
            AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)mainArtifactInfo);
            file = output.getMainOutputFile().getOutputFile();
            File buildFolder = file.getParentFile().getParentFile();
            classesFolder = new File(buildFolder, CLASSES_FOLDER_NAME);
        }
        if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (file = VfsUtil.findFileByIoFile((File)outFolder, (boolean)true)) != null) {
            compilerOutputs.add((Object)file);
        }
        for (File additionalFolder : mainArtifactInfo.getAdditionalClassesFolders()) {
            VirtualFile file2 = VfsUtil.findFileByIoFile((File)additionalFolder, (boolean)true);
            if (file2 == null) continue;
            compilerOutputs.add((Object)file2);
        }
        ImmutableList immutableList = compilerOutputs.build();
        if (immutableList == null) {
            GradleClassFileFinder.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    private static Collection<File> getJavaAndKotlinCompilerOutputFolders(@NotNull JavaModuleModel javaModel, boolean includeProduction, boolean includeTests) {
        if (javaModel == null) {
            GradleClassFileFinder.$$$reportNull$$$0(5);
        }
        LinkedList<File> toAdd = new LinkedList<File>();
        File mainClassesFolderPath = null;
        File mainResourcesFolderPath = null;
        File testClassesFolderPath = null;
        File testResourcesFolderPath = null;
        File mainKotlinClassesFolderPath = null;
        File testKotlinClassesFolderPath = null;
        ExtIdeaCompilerOutput compilerOutput = javaModel.getCompilerOutput();
        if (compilerOutput != null) {
            mainClassesFolderPath = compilerOutput.getMainClassesDir();
            mainResourcesFolderPath = compilerOutput.getMainResourcesDir();
            testClassesFolderPath = compilerOutput.getTestClassesDir();
            testResourcesFolderPath = compilerOutput.getTestResourcesDir();
        }
        File buildFolderPath = javaModel.getBuildFolderPath();
        if (javaModel.isBuildable()) {
            if (mainClassesFolderPath == null) {
                mainClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (mainResourcesFolderPath == null) {
                mainResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (testClassesFolderPath == null) {
                testClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
            if (testResourcesFolderPath == null) {
                testResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
        }
        if (buildFolderPath != null) {
            File kotlinClasses = buildFolderPath.toPath().resolve(CLASSES_FOLDER_NAME).resolve(KOTLIN_FOLDER_NAME).toFile();
            if (includeTests) {
                testKotlinClassesFolderPath = new File(kotlinClasses, TEST_FOLDER_NAME);
            }
            if (includeProduction) {
                mainKotlinClassesFolderPath = new File(kotlinClasses, MAIN_FOLDER_NAME);
            }
        }
        if (includeTests) {
            if (testClassesFolderPath != null) {
                toAdd.add(testClassesFolderPath);
            }
            if (testKotlinClassesFolderPath != null) {
                toAdd.add(testKotlinClassesFolderPath);
            }
            if (testResourcesFolderPath != null) {
                toAdd.add(testResourcesFolderPath);
            }
        }
        if (includeProduction) {
            if (mainClassesFolderPath != null) {
                toAdd.add(mainClassesFolderPath);
            }
            if (mainKotlinClassesFolderPath != null) {
                toAdd.add(mainKotlinClassesFolderPath);
            }
            if (mainResourcesFolderPath != null) {
                toAdd.add(mainResourcesFolderPath);
            }
        }
        LinkedList<File> linkedList = toAdd;
        if (linkedList == null) {
            GradleClassFileFinder.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    @NotNull
    private static Collection<VirtualFile> getModuleCompileOutputs(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            GradleClassFileFinder.$$$reportNull$$$0(7);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            return GradleClassFileFinder.getCompilerOutputRoots(androidModel);
        }
        JavaModuleModel javaModel = JavaModuleModel.get(module);
        if (javaModel != null) {
            Collection collection2 = GradleClassFileFinder.getJavaAndKotlinCompilerOutputFolders(javaModel, true, false).stream().map(path2 -> VfsUtil.findFileByIoFile((File)path2, (boolean)true)).filter(Objects::nonNull).collect(Collectors.toList());
            if (collection2 == null) {
                GradleClassFileFinder.$$$reportNull$$$0(8);
            }
            return collection2;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            GradleClassFileFinder.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/projectsystem/gradle/GradleClassFileFinder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/projectsystem/gradle/GradleClassFileFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOutputRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaAndKotlinCompilerOutputFolders";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleCompileOutputs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClassFileInModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerOutputRoots";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJavaAndKotlinCompilerOutputFolders";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleCompileOutputs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

