/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.refactoring.modularize.AndroidCodeAndResourcesGraph;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeProcessor;
import com.android.tools.idea.refactoring.modularize.DependencyTreeNode;
import com.android.tools.idea.refactoring.modularize.ResourceUrlTreeNode;
import com.android.tools.idea.refactoring.modularize.UsageInfoTreeNode;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class AndroidModularizePreviewPanel {
    private static final Logger LOGGER = Logger.getInstance(AndroidModularizePreviewPanel.class);
    private static final boolean USE_DOMINATORS = false;
    private JPanel myPanel;
    private JPanel myDependenciesPanel;
    private JBLabel myClassesCount;
    private JBLabel myResourcesCount;
    private JBLabel myMethodsCount;
    private JBLabel mySizeEstimate;
    private final AndroidCodeAndResourcesGraph myGraph;
    private final Map<PsiElement, UsageInfo> myLookupMap;
    private final CheckedTreeNode myRootNode;
    private CodeAndResourcesTreeTable myTreeView;
    private final boolean myShouldSelectAllReferences;

    public AndroidModularizePreviewPanel(@NotNull AndroidCodeAndResourcesGraph graph, UsageInfo[] infos, boolean shouldSelectAllReferences) {
        if (graph == null) {
            AndroidModularizePreviewPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myRootNode = new CheckedTreeNode();
        this.myGraph = graph;
        this.myLookupMap = Maps.newHashMapWithExpectedSize((int)infos.length);
        for (UsageInfo info : infos) {
            this.myLookupMap.put(info.getElement(), info);
        }
        this.myShouldSelectAllReferences = shouldSelectAllReferences;
    }

    @NotNull
    public UsageInfo[] getSelectedUsages() {
        Set<UsageInfo> result2 = this.myTreeView.getCheckedNodes();
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            AndroidModularizePreviewPanel.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    public JPanel getPanel() {
        HashSet<PsiElement> parentElements = new HashSet<PsiElement>();
        for (PsiElement root2 : this.myGraph.getRoots()) {
            UsageInfoTreeNode rootNode = new UsageInfoTreeNode(this.myLookupMap.get(root2), 0);
            this.myRootNode.add((MutableTreeNode)((Object)rootNode));
            parentElements.add(root2);
            this.buildTree(rootNode, root2, parentElements, this.myGraph.getReferencedOutsideScope());
            parentElements.remove(root2);
        }
        PreviewRenderer renderer2 = new PreviewRenderer();
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        ColumnInfo[] classesColumns = new ColumnInfo[]{new TreeColumnInfo("")};
        this.myTreeView = new CodeAndResourcesTreeTable(this.myRootNode, renderer2, classesColumns);
        this.myDependenciesPanel.add((Component)new JBScrollPane((Component)((Object)this.myTreeView)), constraints);
        this.myTreeView.getTree().getSelectionModel().setSelectionMode(1);
        this.myTreeView.getTree().addTreeSelectionListener(e -> ApplicationManager.getApplication().invokeLater(this::updateCounts));
        this.updateCounts();
        return this.myPanel;
    }

    private void updateCounts() {
        int classesCount = 0;
        int methodsCount = 0;
        int resourcesCount = 0;
        long size = 0L;
        for (UsageInfo usageInfo : this.myTreeView.getCheckedNodes()) {
            PsiElement psiElement = usageInfo.getElement();
            if (psiElement instanceof PsiClass) {
                ++classesCount;
                methodsCount += ((PsiClass)psiElement).getMethods().length;
                size += psiElement.getContainingFile().getVirtualFile().getLength();
                continue;
            }
            if (psiElement instanceof PsiFile) {
                ++resourcesCount;
                size += ((PsiFile)psiElement).getVirtualFile().getLength();
                continue;
            }
            if (psiElement instanceof XmlTag) {
                size += (long)psiElement.getText().getBytes(Charset.defaultCharset()).length;
                continue;
            }
            LOGGER.warn("Couldn't determine contribution for element " + psiElement);
        }
        this.myClassesCount.setText(Integer.toString(classesCount));
        this.myMethodsCount.setText(Integer.toString(methodsCount));
        this.myResourcesCount.setText(Integer.toString(resourcesCount));
        this.mySizeEstimate.setText("~" + Long.toString(size / 1024L) + " KB");
    }

    private void buildTree(CheckedTreeNode parentNode, PsiElement psiElement, Set<PsiElement> parentElements, Set<PsiElement> outsiders) {
        Set<PsiElement> references = this.myGraph.getTargets(psiElement);
        ArrayList<DependencyTreeNode> childrenNodes = new ArrayList<DependencyTreeNode>(references.size());
        HashMap<ResourceReference, Set> resourceGroups = new HashMap<ResourceReference, Set>();
        for (PsiElement psiElement2 : references) {
            if (parentElements.contains(psiElement2)) continue;
            if (this.myLookupMap.get(psiElement2) instanceof AndroidModularizeProcessor.ResourceXmlUsageInfo) {
                ResourceItem resourceItem = ((AndroidModularizeProcessor.ResourceXmlUsageInfo)this.myLookupMap.get(psiElement2)).getResourceItem();
                ResourceReference resourceReference = resourceItem.getReferenceToSelf();
                Set otherItems = resourceGroups.computeIfAbsent(resourceReference, k -> new HashSet());
                otherItems.add(psiElement2);
                continue;
            }
            UsageInfoTreeNode childNode = new UsageInfoTreeNode(this.myLookupMap.get(psiElement2), this.myGraph.getFrequency(psiElement, psiElement2));
            childrenNodes.add(childNode);
            childNode.setChecked(this.myShouldSelectAllReferences || !outsiders.contains(psiElement2));
            parentElements.add(psiElement2);
            this.buildTree(childNode, psiElement2, parentElements, outsiders);
            parentElements.remove(psiElement2);
        }
        for (ResourceReference resourceReference : resourceGroups.keySet()) {
            ResourceUrlTreeNode urlTreeNode = new ResourceUrlTreeNode(resourceReference.getResourceUrl());
            childrenNodes.add(urlTreeNode);
            boolean checked = true;
            for (PsiElement reference3 : (Set)resourceGroups.get(resourceReference)) {
                if (this.myShouldSelectAllReferences || !outsiders.contains(reference3)) continue;
                checked = false;
                break;
            }
            for (PsiElement reference2 : (Set)resourceGroups.get(resourceReference)) {
                UsageInfoTreeNode childNode = new UsageInfoTreeNode(this.myLookupMap.get(reference2), this.myGraph.getFrequency(psiElement, reference2));
                childNode.setEnabled(false);
                childNode.setChecked(checked);
                urlTreeNode.add((MutableTreeNode)((Object)childNode));
                parentElements.add(reference2);
                this.buildTree(childNode, reference2, parentElements, outsiders);
                parentElements.remove(reference2);
            }
            urlTreeNode.setChecked(checked);
        }
        for (CheckedTreeNode checkedTreeNode : childrenNodes) {
            parentNode.add((MutableTreeNode)checkedTreeNode);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/refactoring/modularize/AndroidModularizePreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizePreviewPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(640, 480));
        this.myDependenciesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 8, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Classes:");
        jPanel3.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Resource files:");
        jPanel3.add((Component)jBLabel6, new GridConstraints(0, 4, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myClassesCount = jBLabel4 = new JBLabel();
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResourcesCount = jBLabel3 = new JBLabel();
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Methods:");
        jPanel3.add((Component)jBLabel7, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myMethodsCount = jBLabel2 = new JBLabel();
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Size:");
        jPanel3.add((Component)jBLabel8, new GridConstraints(0, 6, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySizeEstimate = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 7, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class CodeAndResourcesTreeTable
    extends TreeTableView {
        private final EventDispatcher<CheckboxTreeListener> myEventDispatcher;

        public CodeAndResourcesTreeTable(CheckedTreeNode root2, CheckboxTree.CheckboxTreeCellRenderer renderer2, ColumnInfo[] columns2) {
            super(new ListTreeTableModelOnColumns((TreeNode)root2, columns2));
            TreeTableTree tree = this.getTree();
            this.myEventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);
            CheckboxTreeBase.CheckPolicy selectionPolicy = new CheckboxTreeBase.CheckPolicy(true, true, true, false);
            CheckboxTreeHelper helper2 = new CheckboxTreeHelper(selectionPolicy, this.myEventDispatcher);
            helper2.initTree((Tree)tree, (JComponent)((Object)this), (CheckboxTreeBase.CheckboxTreeCellRendererBase)renderer2);
            tree.setSelectionRow(0);
            for (int i2 = 0; i2 < root2.getChildCount(); ++i2) {
                tree.expandPath(new TreePath(((DefaultMutableTreeNode)root2.getChildAt(i2)).getPath()));
            }
        }

        public void addCheckboxTreeListener(@NotNull CheckboxTreeListener listener2) {
            if (listener2 == null) {
                CodeAndResourcesTreeTable.$$$reportNull$$$0(0);
            }
            this.myEventDispatcher.addListener((EventListener)listener2);
        }

        public Set<UsageInfo> getCheckedNodes() {
            final HashSet<UsageInfo> nodes = new HashSet<UsageInfo>();
            new Object(){

                public void collect(CheckedTreeNode node) {
                    if (!node.isChecked()) {
                        return;
                    }
                    Object userObject = node.getUserObject();
                    if (userObject instanceof UsageInfo) {
                        nodes.add((UsageInfo)userObject);
                    }
                    if (!node.isLeaf()) {
                        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                            TreeNode child = node.getChildAt(i2);
                            if (!(child instanceof CheckedTreeNode)) continue;
                            this.collect((CheckedTreeNode)child);
                        }
                    }
                }
            }.collect((CheckedTreeNode)this.getTree().getModel().getRoot());
            return nodes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/refactoring/modularize/AndroidModularizePreviewPanel$CodeAndResourcesTreeTable", "addCheckboxTreeListener"));
        }
    }

    private static class PreviewRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private PreviewRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof DependencyTreeNode) {
                ((DependencyTreeNode)((Object)value2)).render(this.getTextRenderer());
            }
        }
    }
}

