/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderProblem
implements Comparable<RenderProblem> {
    public static final int PRIORITY_UNEXPECTED = 10;
    public static final int PRIORITY_MISSING_CLASSES = 20;
    public static final int PRIORITY_BROKEN_CLASSES = 30;
    public static final int PRIORITY_MISSING_ATTRIBUTE = 40;
    public static final int PRIORITY_MISSING_STYLE = 50;
    public static final int PRIORITY_NINEPATCH_RENDER_ERROR = 60;
    public static final int PRIORITY_RENDERING_FIDELITY = 1000;
    @NotNull
    private final HighlightSeverity mySeverity;
    private final int myOrdinal;
    private int myPriority;
    @Nullable
    private Throwable myThrowable;
    @Nullable
    private Object myClientData;
    @Nullable
    private String myTag;
    protected boolean myIsDefaultHtml;
    private static int ourNextOrdinal;

    @NotNull
    public static RenderProblem createPlain(@NotNull HighlightSeverity severity, @Nullable String message2) {
        if (severity == null) {
            RenderProblem.$$$reportNull$$$0(0);
        }
        return new Plain(severity, ourNextOrdinal++, message2 != null ? XmlUtils.toXmlTextValue((String)message2) : "");
    }

    @NotNull
    public static RenderProblem createPlain(@NotNull HighlightSeverity severity, @NotNull String message2, @Nullable Project project, @NotNull HtmlLinkManager linkManager, @Nullable Throwable throwable) {
        if (severity == null) {
            RenderProblem.$$$reportNull$$$0(1);
        }
        if (message2 == null) {
            RenderProblem.$$$reportNull$$$0(2);
        }
        if (linkManager == null) {
            RenderProblem.$$$reportNull$$$0(3);
        }
        Html problem = new Html(severity, ourNextOrdinal++);
        HtmlBuilder builder2 = problem.getHtmlBuilder();
        builder2.add(message2);
        if (throwable != null) {
            problem.throwable(throwable);
            String url = linkManager.createRunnableLink(new ShowExceptionFix(project, problem));
            builder2.add(" (").addLink("Details", url).add(")");
            if (message2.equals(throwable.getMessage())) {
                problem.myIsDefaultHtml = true;
            }
        }
        Html html = problem;
        if (html == null) {
            RenderProblem.$$$reportNull$$$0(4);
        }
        return html;
    }

    @NotNull
    public static Html create(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            RenderProblem.$$$reportNull$$$0(5);
        }
        return new Html(severity, ourNextOrdinal++);
    }

    @NotNull
    public static RenderProblem createDeferred(@NotNull HighlightSeverity severity, @Nullable String tag, @NotNull String text, @Nullable Throwable throwable) {
        if (severity == null) {
            RenderProblem.$$$reportNull$$$0(6);
        }
        if (text == null) {
            RenderProblem.$$$reportNull$$$0(7);
        }
        return new Deferred(severity, tag, text, throwable);
    }

    private RenderProblem(@NotNull HighlightSeverity severity, int ordinal) {
        if (severity == null) {
            RenderProblem.$$$reportNull$$$0(8);
        }
        this.myPriority = 10;
        this.mySeverity = severity;
        this.myOrdinal = ordinal;
    }

    public RenderProblem throwable(@Nullable Throwable throwable) {
        this.myThrowable = throwable;
        return this;
    }

    public RenderProblem priority(int priority) {
        this.myPriority = priority;
        return this;
    }

    public RenderProblem tag(@Nullable String tag) {
        this.myTag = tag;
        return this;
    }

    @Nullable
    public String getTag() {
        return this.myTag;
    }

    @NotNull
    public abstract String getHtml();

    public boolean isDefaultHtml() {
        return this.myIsDefaultHtml;
    }

    public void appendHtml(@NotNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            RenderProblem.$$$reportNull$$$0(9);
        }
        stringBuilder.append(this.getHtml());
    }

    @Override
    public int compareTo(RenderProblem other) {
        if (this.mySeverity != other.mySeverity) {
            return this.mySeverity.compareTo(other.mySeverity);
        }
        if (this.myPriority != other.myPriority) {
            return this.myPriority - other.myPriority;
        }
        return this.myOrdinal - other.myOrdinal;
    }

    @NotNull
    public static String format(List<RenderProblem> messages) {
        StringBuilder sb = new StringBuilder();
        for (RenderProblem message2 : messages) {
            sb.append(message2.getHtml());
            sb.append("<br/>\n");
        }
        String string = sb.toString();
        if (string == null) {
            RenderProblem.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            RenderProblem.$$$reportNull$$$0(11);
        }
        return highlightSeverity;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @Nullable
    public Object getClientData() {
        return this.myClientData;
    }

    public void setClientData(@Nullable Object clientData) {
        this.myClientData = clientData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkManager";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderProblem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderProblem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlain";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPlain";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDeferred";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Deferred
    extends RenderProblem {
        protected final String myText;

        protected Deferred(@NotNull HighlightSeverity severity, @Nullable String tag, @NotNull String text, @Nullable Throwable throwable) {
            if (severity == null) {
                Deferred.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Deferred.$$$reportNull$$$0(1);
            }
            super(severity, ourNextOrdinal++);
            this.myText = text;
            this.tag(tag);
            this.throwable(throwable);
        }

        @Override
        @NotNull
        public String getHtml() {
            String string = new HtmlBuilder().add(this.myText).getHtml();
            if (string == null) {
                Deferred.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/RenderProblem$Deferred";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/RenderProblem$Deferred";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHtml";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Html
    extends RenderProblem {
        @NotNull
        private final HtmlBuilder myBuilder;

        private Html(@NotNull HighlightSeverity severity, int ordinal) {
            if (severity == null) {
                Html.$$$reportNull$$$0(0);
            }
            super(severity, ordinal);
            this.myBuilder = new HtmlBuilder();
        }

        @Override
        @NotNull
        public String getHtml() {
            String string = this.myBuilder.getHtml();
            if (string == null) {
                Html.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public HtmlBuilder getHtmlBuilder() {
            this.myIsDefaultHtml = false;
            HtmlBuilder htmlBuilder = this.myBuilder;
            if (htmlBuilder == null) {
                Html.$$$reportNull$$$0(2);
            }
            return htmlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/RenderProblem$Html";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/RenderProblem$Html";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHtml";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHtmlBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Plain
    extends RenderProblem {
        @NotNull
        private final String myHtml;

        private Plain(@NotNull HighlightSeverity severity, int ordinal, @NotNull String text) {
            if (severity == null) {
                Plain.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Plain.$$$reportNull$$$0(1);
            }
            super(severity, ordinal);
            this.myHtml = text;
        }

        @Override
        @NotNull
        public String getHtml() {
            String string = this.myHtml;
            if (string == null) {
                Plain.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/RenderProblem$Plain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/RenderProblem$Plain";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHtml";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

