/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.rendering.classloading.ClassConverter;
import com.android.tools.idea.rendering.classloading.InconvertibleClassError;
import com.android.tools.idea.rendering.classloading.VersionClassTransform;
import com.android.tools.idea.rendering.classloading.ViewMethodWrapperTransform;
import com.google.common.base.Suppliers;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    private static final Function<ClassVisitor, ClassVisitor> DEFAULT_TRANSFORMS = visitor -> new ViewMethodWrapperTransform(new VersionClassTransform((ClassVisitor)visitor, ClassConverter.getCurrentClassVersion(), 0));
    private final Object myJarClassLoaderLock = new Object();
    @GuardedBy(value="myJarClassLoaderLock")
    private Supplier<UrlClassLoader> myJarClassLoader = Suppliers.memoize(() -> this.createJarClassLoader(this.getExternalJars()));
    protected boolean myInsideJarClassLoader;

    public RenderClassLoader(@Nullable ClassLoader parent) {
        super(parent);
    }

    protected abstract List<URL> getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clazz = this.loadClassFromNonProjectDependency(name);
        if (clazz == null) {
            RenderClassLoader.$$$reportNull$$$0(0);
        }
        return clazz;
    }

    @NotNull
    private UrlClassLoader createJarClassLoader(@NotNull List<URL> urls) {
        if (urls == null) {
            RenderClassLoader.$$$reportNull$$$0(1);
        }
        UrlClassLoader urlClassLoader = UrlClassLoader.build().parent((ClassLoader)this).urls(urls).setLogErrorOnMissingJar(false).get();
        if (urlClassLoader == null) {
            RenderClassLoader.$$$reportNull$$$0(2);
        }
        return urlClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    protected Class<?> loadClassFromNonProjectDependency(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        InputStream is;
        block18: {
            UrlClassLoader jarClassLoaders;
            if (name == null) {
                RenderClassLoader.$$$reportNull$$$0(3);
            }
            Object object = this.myJarClassLoaderLock;
            synchronized (object) {
                jarClassLoaders = this.myJarClassLoader.get();
            }
            this.myInsideJarClassLoader = true;
            is = jarClassLoaders.getResourceAsStream(name.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            byte[] data = ByteStreams.toByteArray((InputStream)is);
            if (!ClassConverter.isValidClassFile(data)) {
                throw new ClassFormatError(name);
            }
            byte[] rewritten = ClassConverter.rewriteClass(data, DEFAULT_TRANSFORMS);
            clazz = this.defineClassAndPackage(name, rewritten, 0, rewritten.length);
            if (is == null) break block18;
            is.close();
        }
        this.myInsideJarClassLoader = false;
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            RenderClassLoader.$$$reportNull$$$0(4);
        }
        return clazz2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        LOG.debug((Throwable)e);
                        this.myInsideJarClassLoader = false;
                    }
                }
                catch (Throwable throwable3) {
                    this.myInsideJarClassLoader = false;
                    throw throwable3;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ClassNotFoundException(%s)", name));
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        if (classFile == null) {
            RenderClassLoader.$$$reportNull$$$0(5);
        }
        try {
            byte[] data = classFile.contentsToByteArray();
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    protected Class<?> loadClass(@NotNull String fqcn, @NotNull byte[] data) {
        Class<?> clazz;
        if (fqcn == null) {
            RenderClassLoader.$$$reportNull$$$0(6);
        }
        if (data == null) {
            RenderClassLoader.$$$reportNull$$$0(7);
        }
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = ClassConverter.rewriteClass(data, DEFAULT_TRANSFORMS);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Defining class '%s' from disk file", LogAnonymizerUtil.anonymizeClassName((String)fqcn)));
            }
            clazz = this.defineClassAndPackage(fqcn, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            LOG.debug((Throwable)inner);
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
        if (clazz == null) {
            RenderClassLoader.$$$reportNull$$$0(8);
        }
        return clazz;
    }

    @NotNull
    protected Class<?> defineClassAndPackage(@NotNull String name, @NotNull byte[] b, int offset, int len) {
        String packageName;
        Package pkg;
        int i2;
        if (name == null) {
            RenderClassLoader.$$$reportNull$$$0(9);
        }
        if (b == null) {
            RenderClassLoader.$$$reportNull$$$0(10);
        }
        if ((i2 = name.lastIndexOf(46)) > 0 && (pkg = this.getPackage(packageName = name.substring(0, i2))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        Class<?> clazz = this.defineClass(name, b, offset, len);
        if (clazz == null) {
            RenderClassLoader.$$$reportNull$$$0(11);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean areDependenciesUpToDate() {
        List currentDependencies;
        List<URL> updatedDependencies = this.getExternalJars();
        Object object = this.myJarClassLoaderLock;
        synchronized (object) {
            currentDependencies = this.myJarClassLoader.get().getUrls();
        }
        if (updatedDependencies.size() != currentDependencies.size()) {
            return false;
        }
        return currentDependencies.containsAll(updatedDependencies);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/classloading/RenderClassLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/classloading/RenderClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createJarClassLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClassFromNonProjectDependency";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "defineClassAndPackage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createJarClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFromNonProjectDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "defineClassAndPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

