/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.imagepool;

import com.android.tools.idea.rendering.imagepool.ImagePool;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NonPooledImage
implements ImagePool.Image {
    private BufferedImage myImage;

    private NonPooledImage(@NotNull BufferedImage image) {
        if (image == null) {
            NonPooledImage.$$$reportNull$$$0(0);
        }
        this.myImage = image;
    }

    @Override
    public int getWidth() {
        assert (this.myImage != null) : "Image already disposed";
        return this.myImage.getWidth();
    }

    @Override
    public int getHeight() {
        assert (this.myImage != null) : "Image already disposed";
        return this.myImage.getHeight();
    }

    @Override
    public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        if (g == null) {
            NonPooledImage.$$$reportNull$$$0(1);
        }
        assert (this.myImage != null) : "Image already disposed";
        g.drawImage(this.myImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    @Override
    public void paint(Consumer<Graphics2D> command) {
        assert (this.myImage != null) : "Image already disposed";
        command.accept(this.myImage.createGraphics());
    }

    @Override
    @Nullable
    public BufferedImage getCopy(@Nullable GraphicsConfiguration gc, int x, int y, int w, int h) {
        assert (this.myImage != null) : "Image already disposed";
        if (x == 0 && y == 0 && w == this.getWidth() && h == this.getHeight()) {
            return NonPooledImage.copy(this.myImage);
        }
        return NonPooledImage.copy(this.myImage.getSubimage(x, y, w, h));
    }

    @Override
    public void dispose() {
        this.myImage = null;
    }

    @NotNull
    private static BufferedImage copy(@NotNull BufferedImage originalImage) {
        if (originalImage == null) {
            NonPooledImage.$$$reportNull$$$0(2);
        }
        WritableRaster raster = originalImage.copyData(originalImage.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(originalImage.getColorModel(), raster, originalImage.isAlphaPremultiplied(), null);
    }

    @NotNull
    public static NonPooledImage create(int w, int h, int type) {
        return new NonPooledImage(new BufferedImage(w, h, type));
    }

    @NotNull
    static NonPooledImage copyOf(@NotNull BufferedImage image) {
        if (image == null) {
            NonPooledImage.$$$reportNull$$$0(3);
        }
        return new NonPooledImage(NonPooledImage.copy(image));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalImage";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/rendering/imagepool/NonPooledImage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "drawImageTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copyOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

