/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.tools.idea.rendering.parsers.AaptAttrAttributeSnapshot;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TagSnapshot {
    @Nullable
    public final String namespace;
    @NotNull
    public final String tagName;
    @Nullable
    public final XmlTag tag;
    @Nullable
    public final String prefix;
    @Nullable
    private TagSnapshot myNext;
    @NotNull
    public List<TagSnapshot> children;
    @NotNull
    public List<AttributeSnapshot> attributes;
    @NotNull
    public Map<String, String> namespaceDeclarations;
    public boolean hasDeclaredAaptAttrs;

    private TagSnapshot(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children, boolean hasDeclaredAaptAttrs) {
        if (attributes == null) {
            TagSnapshot.$$$reportNull$$$0(0);
        }
        if (children == null) {
            TagSnapshot.$$$reportNull$$$0(1);
        }
        this.hasDeclaredAaptAttrs = false;
        this.tagName = tagName != null ? tagName : "?";
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.namespace = namespace;
        this.tag = tag;
        this.attributes = attributes;
        this.children = children;
        this.hasDeclaredAaptAttrs = hasDeclaredAaptAttrs;
        this.namespaceDeclarations = tag != null ? tag.getLocalNamespaceDeclarations() : Collections.emptyMap();
    }

    static TagSnapshot createSyntheticTag(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children, @Nullable Consumer<TagSnapshot> afterCreate) {
        if (attributes == null) {
            TagSnapshot.$$$reportNull$$$0(2);
        }
        if (children == null) {
            TagSnapshot.$$$reportNull$$$0(3);
        }
        TagSnapshot newSnapshot = new TagSnapshot(tag, tagName, prefix, namespace, attributes, children, false);
        if (afterCreate != null) {
            afterCreate.accept(newSnapshot);
        }
        return newSnapshot;
    }

    @NotNull
    public static TagSnapshot createTagSnapshot(@NotNull XmlTag tag, @Nullable Consumer<TagSnapshot> afterCreate) {
        XmlAttribute useTagAttribute;
        ArrayList children;
        if (tag == null) {
            TagSnapshot.$$$reportNull$$$0(4);
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        XmlTag[] subTags = tag.getSubTags();
        boolean hasDeclaredAaptAttrs = false;
        if (subTags.length > 0) {
            TagSnapshot last = null;
            children = Lists.newArrayListWithCapacity((int)subTags.length);
            for (XmlTag subTag : subTags) {
                if ("http://schemas.android.com/aapt".equals(subTag.getNamespace())) {
                    AaptAttrAttributeSnapshot aaptAttribute;
                    if (!"attr".equals(subTag.getLocalName()) || subTag.getAttribute("name") == null || (aaptAttribute = AaptAttrAttributeSnapshot.createAttributeSnapshot(subTag)) == null) continue;
                    attributes.add(aaptAttribute);
                    hasDeclaredAaptAttrs = true;
                    continue;
                }
                TagSnapshot child = TagSnapshot.createTagSnapshot(subTag, afterCreate);
                hasDeclaredAaptAttrs |= child.hasDeclaredAaptAttrs;
                children.add(child);
                if (last != null) {
                    last.myNext = child;
                }
                last = child;
            }
        } else {
            children = Collections.emptyList();
        }
        String tagName = (useTagAttribute = tag.getAttribute("useTag", "http://schemas.android.com/tools")) == null ? tag.getName() : useTagAttribute.getValue();
        TagSnapshot newSnapshot = new TagSnapshot(tag, tagName, tag.getNamespacePrefix(), tag.getNamespace(), attributes, children, hasDeclaredAaptAttrs);
        if (afterCreate != null) {
            afterCreate.accept(newSnapshot);
        }
        TagSnapshot tagSnapshot = newSnapshot;
        if (tagSnapshot == null) {
            TagSnapshot.$$$reportNull$$$0(5);
        }
        return tagSnapshot;
    }

    @NotNull
    public static TagSnapshot createTagSnapshotWithoutChildren(@NotNull XmlTag tag) {
        if (tag == null) {
            TagSnapshot.$$$reportNull$$$0(6);
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        boolean hasDeclaredAaptAttrs = false;
        for (XmlTag subTag : tag.getSubTags()) {
            AaptAttrAttributeSnapshot aaptAttribute;
            if (!"http://schemas.android.com/aapt".equals(subTag.getNamespace()) || !"attr".equals(subTag.getLocalName()) || subTag.getAttribute("name") == null || (aaptAttribute = AaptAttrAttributeSnapshot.createAttributeSnapshot(subTag)) == null) continue;
            attributes.add(aaptAttribute);
            hasDeclaredAaptAttrs = true;
        }
        return new TagSnapshot(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace(), attributes, Collections.emptyList(), hasDeclaredAaptAttrs);
    }

    @Nullable
    public String getAttribute(@NotNull String name) {
        if (name == null) {
            TagSnapshot.$$$reportNull$$$0(7);
        }
        return this.getAttribute(name, null);
    }

    @Nullable
    public String getAttribute(@NotNull String name, @Nullable String namespace) {
        if (name == null) {
            TagSnapshot.$$$reportNull$$$0(8);
        }
        int n = this.attributes.size();
        for (int i2 = 0; i2 < n; ++i2) {
            AttributeSnapshot attribute = this.attributes.get(i2);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            return attribute.value;
        }
        return null;
    }

    public void setAttribute(@NotNull String name, @Nullable String namespace, @Nullable String prefix, @Nullable String value2, boolean overrideIfExists) {
        if (name == null) {
            TagSnapshot.$$$reportNull$$$0(9);
        }
        int n = this.attributes.size();
        for (int i2 = 0; i2 < n; ++i2) {
            AttributeSnapshot attribute = this.attributes.get(i2);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            if (overrideIfExists) {
                this.attributes.remove(i2);
                break;
            }
            return;
        }
        if (value2 != null) {
            if (this.attributes.isEmpty()) {
                this.attributes = new ArrayList<AttributeSnapshot>();
            }
            this.attributes.add(new AttributeSnapshot(namespace, prefix, name, value2));
        }
    }

    public void setAttribute(@NotNull String name, @Nullable String namespace, @Nullable String prefix, @Nullable String value2) {
        if (name == null) {
            TagSnapshot.$$$reportNull$$$0(10);
        }
        this.setAttribute(name, namespace, prefix, value2, true);
    }

    @Nullable
    public TagSnapshot getNextSibling() {
        return this.myNext;
    }

    public String toString() {
        return "TagSnapshot{" + this.tagName + ", attributes=" + this.attributes + ", children=\n" + this.children + "\n}";
    }

    public long getSignature() {
        HashFunction hashFunction = Hashing.goodFastHash((int)64);
        Hasher hasher = hashFunction.newHasher();
        hasher.putString((CharSequence)this.tagName, Charsets.UTF_8);
        for (AttributeSnapshot attribute : this.attributes) {
            if (attribute.prefix != null) {
                hasher.putString((CharSequence)attribute.prefix, Charsets.UTF_8);
            }
            hasher.putString((CharSequence)attribute.name, Charsets.UTF_8);
            if (attribute.value == null) continue;
            hasher.putString((CharSequence)attribute.value, Charsets.UTF_8);
        }
        return hasher.hash().asLong();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/parsers/TagSnapshot";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/parsers/TagSnapshot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSyntheticTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTagSnapshot";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTagSnapshotWithoutChildren";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

