/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.res.AndroidPluginVersion;
import com.android.tools.idea.resources.aar.CachingData;
import com.android.tools.idea.resources.aar.FrameworkResourceRepository;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager$CacheKey;", "Lcom/android/tools/idea/resources/aar/FrameworkResourceRepository;", "clearCache", "", "createCachingData", "Lcom/android/tools/idea/resources/aar/CachingData;", "resFolderOrJar", "Ljava/nio/file/Path;", "getFrameworkResources", "resourceDirectoryOrFile", "Ljava/io/File;", "useCompiled9Patches", "", "languages", "", "", "CacheKey", "Companion", "intellij.android.core"})
public final class FrameworkResourceRepositoryManager {
    private final ConcurrentHashMap<CacheKey, FrameworkResourceRepository> cache = new ConcurrentHashMap();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FrameworkResourceRepository getFrameworkResources(@NotNull File resourceDirectoryOrFile, boolean useCompiled9Patches, @NotNull Set<String> languages) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)resourceDirectoryOrFile, (String)"resourceDirectoryOrFile");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Path path3 = path2 = resourceDirectoryOrFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
        CacheKey cacheKey = new CacheKey(path3, useCompiled9Patches);
        CachingData cachingData = this.createCachingData(path2);
        FrameworkResourceRepository frameworkResourceRepository = this.cache.computeIfAbsent(cacheKey, new Function<CacheKey, FrameworkResourceRepository>(path2, languages, cachingData, useCompiled9Patches){
            final /* synthetic */ Path $path;
            final /* synthetic */ Set $languages;
            final /* synthetic */ CachingData $cachingData;
            final /* synthetic */ boolean $useCompiled9Patches;

            @NotNull
            public final FrameworkResourceRepository apply(@NotNull CacheKey it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FrameworkResourceRepository.create(this.$path, this.$languages, this.$cachingData, this.$useCompiled9Patches);
            }
            {
                this.$path = path2;
                this.$languages = set;
                this.$cachingData = cachingData;
                this.$useCompiled9Patches = bl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)frameworkResourceRepository, (String)"cache.computeIfAbsent(ca\u2026seCompiled9Patches)\n    }");
        FrameworkResourceRepository cached2 = frameworkResourceRepository;
        if (languages.isEmpty()) {
            return cached2;
        }
        FrameworkResourceRepository frameworkResourceRepository2 = cached2.loadMissingLanguages(languages, cachingData);
        Intrinsics.checkNotNullExpressionValue((Object)frameworkResourceRepository2, (String)"cached.loadMissingLangua\u2026s(languages, cachingData)");
        FrameworkResourceRepository repository = frameworkResourceRepository2;
        if (repository != cached2) {
            ((Map)this.cache).put(cacheKey, repository);
        }
        return repository;
    }

    private final CachingData createCachingData(Path resFolderOrJar) {
        Path cacheFile;
        String string;
        if (StringsKt.endsWith((String)((Object)resFolderOrJar.getFileName()).toString(), (String)".jar", (boolean)true)) {
            return null;
        }
        String string2 = AndroidPluginVersion.getAndroidPluginVersion();
        if (string2 == null) {
            return null;
        }
        String codeVersion = string2;
        try {
            string = Files.getLastModifiedTime(resFolderOrJar.resolve("../../package.xml"), new LinkOption[0]).toString();
        }
        catch (NoSuchFileException e) {
            string = "";
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n      Files.getLas\u2026ception) {\n      \"\"\n    }");
        String contentVersion = string3;
        String string4 = Hashing.farmHashFingerprint64().hashUnencodedChars((CharSequence)((Object)resFolderOrJar).toString()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Hashing.farmHashFingerpr\u2026ar.toString()).toString()");
        String pathHash = string4;
        Path path2 = resFolderOrJar.getParent();
        String string5 = String.valueOf(path2 != null && (path2 = path2.getParent()) != null ? path2.getFileName() : null);
        if (string5 == null) {
            string5 = "framework";
        }
        String prefix = string5;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string6 = "%s_%s.dat";
        Object[] objectArray = new Object[]{prefix, pathHash};
        boolean bl = false;
        String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
        String filename = string7;
        Path path3 = cacheFile = Paths.get(PathManager.getSystemPath(), "caches/resources", filename);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"cacheFile");
        return new CachingData(path3, contentVersion, codeVersion, AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor());
    }

    @TestOnly
    public final void clearCache() {
        this.cache.clear();
    }

    @JvmStatic
    @NotNull
    public static final FrameworkResourceRepositoryManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager$CacheKey;", "", "path", "Ljava/nio/file/Path;", "useCompiled9Patches", "", "(Ljava/nio/file/Path;Z)V", "getPath", "()Ljava/nio/file/Path;", "getUseCompiled9Patches", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    private static final class CacheKey {
        @NotNull
        private final Path path;
        private final boolean useCompiled9Patches;

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean getUseCompiled9Patches() {
            return this.useCompiled9Patches;
        }

        public CacheKey(@NotNull Path path2, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.path = path2;
            this.useCompiled9Patches = useCompiled9Patches;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final CacheKey copy(@NotNull Path path2, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return new CacheKey(path2, useCompiled9Patches);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, Path path2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = cacheKey.path;
            }
            if ((n & 2) != 0) {
                bl = cacheKey.useCompiled9Patches;
            }
            return cacheKey.copy(path2, bl);
        }

        @NotNull
        public String toString() {
            return "CacheKey(path=" + this.path + ", useCompiled9Patches=" + this.useCompiled9Patches + ")";
        }

        public int hashCode() {
            Path path2 = this.path;
            int n = (path2 != null ? ((Object)path2).hashCode() : 0) * 31;
            int n2 = this.useCompiled9Patches ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CacheKey)) break block3;
                    CacheKey cacheKey = (CacheKey)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)cacheKey.path) || this.useCompiled9Patches != cacheKey.useCompiled9Patches) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FrameworkResourceRepositoryManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(FrameworkResourceRepositoryManager.class);
            Intrinsics.checkNotNull((Object)object);
            return (FrameworkResourceRepositoryManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

