/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.projectmodel.ExternalLibrary;
import com.android.tools.idea.AndroidProjectModelUtils;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.AarResourceRepositoryCache;
import com.android.tools.idea.res.AllResourceRepository;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.TestAppResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceRepositoryManager
implements Disposable {
    private static final Key<ResourceRepositoryManager> KEY = Key.create((String)ResourceRepositoryManager.class.getName());
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static final Object TEST_RESOURCES_LOCK = new Object();
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final AaptOptions.Namespacing myNamespacing;
    @Nullable
    private ResourceNamespace mySharedNamespaceInstance;
    @Nullable
    private ResourceNamespace mySharedTestNamespaceInstance;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private LocalResourceRepository myModuleResources;
    private LocalResourceRepository myTestAppResources;
    private LocalResourceRepository myTestModuleResources;
    private CachedValue<LocalesAndLanguages> myLocalesAndLanguages;
    private Map<ExternalLibrary, AarResourceRepository> myLibraryResourceMap;
    @Nullable
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private final Object myLibraryLock;

    @NotNull
    public static ResourceRepositoryManager getInstance(@NotNull AndroidFacet facet2) {
        ResourceRepositoryManager manager;
        if (facet2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(0);
        }
        AaptOptions.Namespacing namespacing = AndroidProjectModelUtils.getNamespacing(facet2);
        ResourceRepositoryManager instance = (ResourceRepositoryManager)facet2.getUserData(KEY);
        if (instance != null && instance.myNamespacing != namespacing) {
            if (facet2.replace(KEY, (Object)instance, null)) {
                Disposer.dispose((Disposable)instance);
            }
            instance = null;
        }
        if (instance == null && (instance = (ResourceRepositoryManager)facet2.putUserDataIfAbsent(KEY, (Object)(manager = new ResourceRepositoryManager(facet2, namespacing)))) == manager) {
            Disposer.register((Disposable)facet2, (Disposable)instance);
            AndroidProjectRootListener.ensureSubscribed(manager.getProject());
        }
        ResourceRepositoryManager resourceRepositoryManager = instance;
        if (resourceRepositoryManager == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(1);
        }
        return resourceRepositoryManager;
    }

    @Nullable
    public static ResourceRepositoryManager getInstance(@NotNull Module module) {
        AndroidFacet facet2;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(2);
        }
        return (facet2 = AndroidFacet.getInstance((Module)module)) == null ? null : ResourceRepositoryManager.getInstance(facet2);
    }

    @Nullable
    public static ResourceRepositoryManager getInstance(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            return null;
        }
        return ResourceRepositoryManager.getInstance(facet2);
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getAppResources(@NotNull Module module) {
        AndroidFacet facet2;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(4);
        }
        return (facet2 = AndroidFacet.getInstance((Module)module)) != null ? ResourceRepositoryManager.getAppResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getAppResources(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(5);
        }
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getInstance(facet2).getAppResources();
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(6);
        }
        return localResourceRepository;
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getProjectResources(@NotNull Module module) {
        AndroidFacet facet2;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(7);
        }
        return (facet2 = AndroidFacet.getInstance((Module)module)) != null ? ResourceRepositoryManager.getProjectResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getProjectResources(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(8);
        }
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getInstance(facet2).getProjectResources();
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(9);
        }
        return localResourceRepository;
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module) {
        AndroidFacet facet2;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(10);
        }
        return (facet2 = AndroidFacet.getInstance((Module)module)) != null ? ResourceRepositoryManager.getModuleResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(11);
        }
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getInstance(facet2).getModuleResources();
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(12);
        }
        return localResourceRepository;
    }

    private ResourceRepositoryManager(@NotNull AndroidFacet facet2, @NotNull AaptOptions.Namespacing namespacing) {
        if (facet2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(13);
        }
        if (namespacing == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(14);
        }
        this.myLibraryLock = new Object();
        this.myFacet = facet2;
        this.myNamespacing = namespacing;
    }

    public static boolean testAndClearTempResourceCached(@NotNull Project project) {
        if (project == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(15);
        }
        if (project.getUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE) != Boolean.TRUE) {
            return false;
        }
        project.putUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE, null);
        return true;
    }

    @NotNull
    public static Collection<Library> findAarLibraries(@NotNull AndroidFacet facet2) {
        AndroidModuleModel androidModel;
        if (facet2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(16);
        }
        ArrayList<Library> libraries = new ArrayList<Library>();
        if (AndroidModel.isRequired(facet2) && (androidModel = AndroidModuleModel.get(facet2)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet2.getModule(), true);
            ResourceRepositoryManager.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                ResourceRepositoryManager.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        ArrayList<Library> arrayList = libraries;
        if (arrayList == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static void addGradleLibraries(@NotNull List<Library> list, @NotNull AndroidModuleModel androidModuleModel) {
        if (list == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(18);
        }
        if (androidModuleModel == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(19);
        }
        list.addAll(androidModuleModel.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries());
    }

    @Nullable
    public ResourceRepository getAllResources() {
        ResourceRepository frameworkResources = this.getFrameworkResources(Collections.emptySet());
        return frameworkResources == null ? null : new AllResourceRepository((ResourceRepository)this.getAppResources(), frameworkResources);
    }

    @Slow
    @NotNull
    public LocalResourceRepository getAppResources() {
        LocalResourceRepository appResources = this.getExistingAppResources();
        if (appResources != null) {
            LocalResourceRepository localResourceRepository = appResources;
            if (localResourceRepository == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(20);
            }
            return localResourceRepository;
        }
        this.getLibraryResources();
        LocalResourceRepository localResourceRepository = (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myAppResources = AppResourceRepository.create(this.myFacet, this.getLibraryResources());
                    Disposer.register((Disposable)this, (Disposable)this.myAppResources);
                }
                return this.myAppResources;
            }
        }));
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(21);
        }
        return localResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingAppResources() {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            return this.myAppResources;
        }
    }

    @Slow
    @NotNull
    public LocalResourceRepository getProjectResources() {
        LocalResourceRepository projectResources = this.getExistingProjectResources();
        if (projectResources != null) {
            LocalResourceRepository localResourceRepository = projectResources;
            if (localResourceRepository == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(22);
            }
            return localResourceRepository;
        }
        LocalResourceRepository localResourceRepository = (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = PROJECT_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myProjectResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myProjectResources = ProjectResourceRepository.create(this.myFacet);
                    Disposer.register((Disposable)this, (Disposable)this.myProjectResources);
                }
                return this.myProjectResources;
            }
        }));
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(23);
        }
        return localResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingProjectResources() {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            return this.myProjectResources;
        }
    }

    @Slow
    @NotNull
    public LocalResourceRepository getModuleResources() {
        LocalResourceRepository moduleResources = this.getExistingModuleResources();
        if (moduleResources != null) {
            LocalResourceRepository localResourceRepository = moduleResources;
            if (localResourceRepository == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(24);
            }
            return localResourceRepository;
        }
        LocalResourceRepository localResourceRepository = (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = MODULE_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myModuleResources = ModuleResourceRepository.forMainResources(this.myFacet, this.getNamespace());
                    ResourceRepositoryManager.registerIfDisposable(this, (Object)this.myModuleResources);
                }
                return this.myModuleResources;
            }
        }));
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(25);
        }
        return localResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingModuleResources() {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            return this.myModuleResources;
        }
    }

    @NotNull
    public LocalResourceRepository getTestAppResources() {
        LocalResourceRepository localResourceRepository = (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestAppResources = this.computeTestAppResources();
                    ResourceRepositoryManager.registerIfDisposable(this, (Object)this.myTestAppResources);
                }
                return this.myTestAppResources;
            }
        }));
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(26);
        }
        return localResourceRepository;
    }

    @NotNull
    public LocalResourceRepository getTestModuleResources() {
        LocalResourceRepository localResourceRepository = (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestModuleResources = ModuleResourceRepository.forTestResources(this.myFacet, this.getTestNamespace());
                    ResourceRepositoryManager.registerIfDisposable(this, (Object)this.myTestModuleResources);
                }
                return this.myTestModuleResources;
            }
        }));
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(27);
        }
        return localResourceRepository;
    }

    @NotNull
    private LocalResourceRepository computeTestAppResources() {
        LocalResourceRepository moduleTestResources = this.getTestModuleResources();
        AndroidModuleModel model2 = AndroidModuleModel.get(this.myFacet);
        if (model2 == null) {
            LocalResourceRepository localResourceRepository = moduleTestResources;
            if (localResourceRepository == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(28);
            }
            return localResourceRepository;
        }
        TestAppResourceRepository testAppResourceRepository = TestAppResourceRepository.create(this.myFacet, moduleTestResources, model2);
        if (testAppResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(29);
        }
        return testAppResourceRepository;
    }

    @Slow
    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull Set<String> languages) {
        AndroidPlatform androidPlatform;
        if (languages == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(30);
        }
        if ((androidPlatform = AndroidPlatform.getInstance(this.myFacet.getModule())) == null) {
            return null;
        }
        return androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget()).getFrameworkResources(languages);
    }

    @Slow
    @NotNull
    public List<ResourceRepository> getAppResourcesForNamespace(@NotNull ResourceNamespace namespace) {
        if (namespace == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(31);
        }
        AppResourceRepository appRepository = (AppResourceRepository)this.getAppResources();
        if (this.myNamespacing == AaptOptions.Namespacing.DISABLED) {
            ImmutableList immutableList = ImmutableList.of((Object)((Object)appRepository));
            if (immutableList == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(32);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.copyOf(appRepository.getRepositoriesForNamespace(namespace));
        if (immutableList == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(33);
        }
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResources() {
        this.resetVisibility();
        this.resetLibraries();
        SampleDataResourceRepository.SampleDataRepositoryManager.getInstance(this.myFacet).reset();
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                ResourceRepositoryManager.disposeIfDisposable((Object)this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                Disposer.dispose((Disposable)this.myProjectResources);
                this.myProjectResources = null;
                this.myLocalesAndLanguages = null;
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources != null) {
                Disposer.dispose((Disposable)this.myAppResources);
                this.myAppResources = null;
            }
        }
        object = TEST_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myTestAppResources != null) {
                ResourceRepositoryManager.disposeIfDisposable((Object)this.myTestAppResources);
                this.myTestAppResources = null;
            }
            if (this.myTestModuleResources != null) {
                ResourceRepositoryManager.disposeIfDisposable((Object)this.myTestModuleResources);
                this.myTestModuleResources = null;
            }
        }
    }

    private static void disposeIfDisposable(@NotNull Object object) {
        if (object == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(34);
        }
        if (object instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)object));
        }
    }

    private static void registerIfDisposable(@NotNull Disposable parent, @NotNull Object object) {
        if (parent == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(35);
        }
        if (object == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(36);
        }
        if (object instanceof Disposable) {
            Disposer.register((Disposable)parent, (Disposable)((Disposable)object));
        }
    }

    public void dispose() {
    }

    public void resetAllCaches() {
        this.resetResources();
        ConfigurationManager.getOrCreateInstance(this.myFacet.getModule()).getResolverCache().reset();
        ResourceFolderRegistry.getInstance(this.getProject()).reset();
        AarResourceRepositoryCache.getInstance().clear();
    }

    @NotNull
    private Project getProject() {
        Project project = this.myFacet.getModule().getProject();
        if (project == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(37);
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetVisibility() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myResourceVisibilityProvider = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLibraries() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myLibraryResourceMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRootsAndLibraries() {
        Map<ExternalLibrary, AarResourceRepository> oldLibraryResourceMap;
        this.resetVisibility();
        ProjectResourceRepository projectResources = (ProjectResourceRepository)this.getExistingProjectResources();
        AppResourceRepository appResources = (AppResourceRepository)this.getExistingAppResources();
        if (projectResources != null) {
            projectResources.updateRoots();
        }
        Object object = this.myLibraryLock;
        synchronized (object) {
            oldLibraryResourceMap = this.myLibraryResourceMap;
            this.myLibraryResourceMap = null;
        }
        if (appResources != null) {
            appResources.updateRoots(this.getLibraryResources());
        }
        if (oldLibraryResourceMap != null) {
            oldLibraryResourceMap.size();
        }
    }

    @NotNull
    public AaptOptions.Namespacing getNamespacing() {
        AaptOptions.Namespacing namespacing = this.myNamespacing;
        if (namespacing == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(38);
        }
        return namespacing;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        if (this.myNamespacing == AaptOptions.Namespacing.DISABLED) {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            if (resourceNamespace == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(39);
            }
            return resourceNamespace;
        }
        String packageName = AndroidManifestUtils.getPackageName(this.myFacet);
        if (packageName == null) {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            if (resourceNamespace == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(40);
            }
            return resourceNamespace;
        }
        if (this.mySharedNamespaceInstance == null || !packageName.equals(this.mySharedNamespaceInstance.getPackageName())) {
            this.mySharedNamespaceInstance = ResourceNamespace.fromPackageName((String)packageName);
        }
        ResourceNamespace resourceNamespace = this.mySharedNamespaceInstance;
        if (resourceNamespace == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(41);
        }
        return resourceNamespace;
    }

    @NotNull
    public ResourceNamespace getTestNamespace() {
        if (this.myNamespacing == AaptOptions.Namespacing.DISABLED) {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            if (resourceNamespace == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(42);
            }
            return resourceNamespace;
        }
        String testPackageName = AndroidManifestUtils.getTestPackageName(this.myFacet);
        if (testPackageName == null) {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            if (resourceNamespace == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(43);
            }
            return resourceNamespace;
        }
        if (this.mySharedTestNamespaceInstance == null || !testPackageName.equals(this.mySharedTestNamespaceInstance.getPackageName())) {
            this.mySharedTestNamespaceInstance = ResourceNamespace.fromPackageName((String)testPackageName);
        }
        ResourceNamespace resourceNamespace = this.mySharedTestNamespaceInstance;
        if (resourceNamespace == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(44);
        }
        return resourceNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            if (this.myResourceVisibilityProvider == null) {
                if (!AndroidModel.isRequired(this.myFacet) || AndroidModel.get(this.myFacet) == null) {
                    return null;
                }
                this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
            }
            return this.myResourceVisibilityProvider;
        }
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility() {
        ResourceVisibilityLookup.Provider provider2;
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel != null && (provider2 = this.getResourceVisibilityProvider()) != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            IdeVariant variant = androidModel.getSelectedVariant();
            ResourceVisibilityLookup resourceVisibilityLookup = provider2.get(androidProject, (Variant)variant);
            if (resourceVisibilityLookup == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(45);
            }
            return resourceVisibilityLookup;
        }
        ResourceVisibilityLookup resourceVisibilityLookup = ResourceVisibilityLookup.NONE;
        if (resourceVisibilityLookup == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(46);
        }
        return resourceVisibilityLookup;
    }

    @Slow
    @NotNull
    public Collection<VirtualFile> getAllResourceDirs() {
        Collection<VirtualFile> collection2 = ((AppResourceRepository)this.getAppResources()).getAllResourceDirs();
        if (collection2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(47);
        }
        return collection2;
    }

    @Nullable
    public AarResourceRepository findLibraryResources(@NotNull ExternalLibrary library) {
        if (library == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(48);
        }
        return this.getLibraryResourceMap().get(library);
    }

    @Slow
    @NotNull
    public Collection<AarResourceRepository> getLibraryResources() {
        Collection<AarResourceRepository> collection2 = this.getLibraryResourceMap().values();
        if (collection2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(49);
        }
        return collection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Map<ExternalLibrary, AarResourceRepository> getLibraryResourceMap() {
        Object object = this.myLibraryLock;
        // MONITORENTER : object
        if (this.myLibraryResourceMap == null) {
            this.myLibraryResourceMap = this.computeLibraryResourceMap();
        }
        Map<ExternalLibrary, AarResourceRepository> map2 = this.myLibraryResourceMap;
        // MONITOREXIT : object
        if (map2 != null) return map2;
        ResourceRepositoryManager.$$$reportNull$$$0(50);
        return map2;
    }

    @NotNull
    private Map<ExternalLibrary, AarResourceRepository> computeLibraryResourceMap() {
        Collection<ExternalLibrary> libraries = AndroidProjectModelUtils.findDependenciesWithResources(this.myFacet.getModule(), true).values();
        AarResourceRepositoryCache aarResourceRepositoryCache = AarResourceRepositoryCache.getInstance();
        Function<ExternalLibrary, AarResourceRepository> factory = this.myNamespacing == AaptOptions.Namespacing.DISABLED ? aarResourceRepositoryCache::getSourceRepository : aarResourceRepositoryCache::getProtoRepository;
        ExecutorService executor = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
        HashMap futures = Maps.newHashMapWithExpectedSize((int)libraries.size());
        for (ExternalLibrary library : libraries) {
            futures.put(library, executor.submit(() -> (AarResourceRepository)factory.apply(library)));
        }
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                map2.put((Object)((ExternalLibrary)entry.getKey()), (Object)((AarResourceRepository)((Future)entry.getValue()).get()));
            }
            catch (ExecutionException e) {
                ResourceRepositoryManager.cancelPendingTasks(futures.values());
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new UncheckedExecutionException(e.getCause());
            }
            catch (InterruptedException e) {
                ResourceRepositoryManager.cancelPendingTasks(futures.values());
                throw new ProcessCanceledException((Throwable)e);
            }
        }
        ImmutableMap immutableMap = map2.build();
        if (immutableMap == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(51);
        }
        return immutableMap;
    }

    private static void cancelPendingTasks(Collection<Future<AarResourceRepository>> futures) {
        futures.forEach(f -> f.cancel(true));
    }

    @NotNull
    public ImmutableList<Locale> getLocalesInProject() {
        ImmutableList<Locale> immutableList = this.getLocalesAndLanguages().locales;
        if (immutableList == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(52);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableSortedSet<String> getLanguagesInProject() {
        ImmutableSortedSet<String> immutableSortedSet = this.getLocalesAndLanguages().languages;
        if (immutableSortedSet == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(53);
        }
        return immutableSortedSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private LocalesAndLanguages getLocalesAndLanguages() {
        Object object = PROJECT_RESOURCES_LOCK;
        // MONITORENTER : object
        if (this.myLocalesAndLanguages == null) {
            this.myLocalesAndLanguages = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(this.myFacet);
                SortedSet localeQualifiers = ResourceRepositoryUtil.getLocales((ResourceRepository)projectResources);
                ImmutableList.Builder localesBuilder = ImmutableList.builderWithExpectedSize((int)localeQualifiers.size());
                ImmutableSortedSet.Builder languagesBuilder = ImmutableSortedSet.naturalOrder();
                for (LocaleQualifier localeQualifier : localeQualifiers) {
                    localesBuilder.add((Object)Locale.create(localeQualifier));
                    String language = localeQualifier.getLanguage();
                    if (language == null) continue;
                    languagesBuilder.add((Object)language);
                }
                return CachedValueProvider.Result.create((Object)new LocalesAndLanguages((ImmutableList<Locale>)localesBuilder.build(), (ImmutableSortedSet<String>)languagesBuilder.build()), (Object[])new Object[]{projectResources});
            });
        }
        LocalesAndLanguages localesAndLanguages = (LocalesAndLanguages)this.myLocalesAndLanguages.getValue();
        // MONITOREXIT : object
        if (localesAndLanguages != null) return localesAndLanguages;
        ResourceRepositoryManager.$$$reportNull$$$0(54);
        return localesAndLanguages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceRepositoryManager";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacing";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleModel";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceRepositoryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppResources";
                break;
            }
            case 9: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectResources";
                break;
            }
            case 12: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleResources";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findAarLibraries";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestAppResources";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestModuleResources";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTestAppResources";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppResourcesForNamespace";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacing";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamespace";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceVisibility";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryResources";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryResourceMap";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLibraryResourceMap";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalesInProject";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesInProject";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalesAndLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAppResources";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProjectResources";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleResources";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "testAndClearTempResourceCached";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findAarLibraries";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addGradleLibraries";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkResources";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAppResourcesForNamespace";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "disposeIfDisposable";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerIfDisposable";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalesAndLanguages {
        @NotNull
        final ImmutableList<Locale> locales;
        @NotNull
        final ImmutableSortedSet<String> languages;

        LocalesAndLanguages(@NotNull ImmutableList<Locale> locales, @NotNull ImmutableSortedSet<String> languages) {
            if (locales == null) {
                LocalesAndLanguages.$$$reportNull$$$0(0);
            }
            if (languages == null) {
                LocalesAndLanguages.$$$reportNull$$$0(1);
            }
            this.locales = locales;
            this.languages = languages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "locales";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languages";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/res/ResourceRepositoryManager$LocalesAndLanguages";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

