/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataListener;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SampleDataResourceRepository
extends LocalResourceRepository
implements SingleNamespaceResourceRepository,
Disposable {
    private static final Logger LOG = Logger.getInstance(SampleDataResourceRepository.class);
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable;

    @NotNull
    public static SampleDataResourceRepository getInstance(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(0);
        }
        SampleDataResourceRepository sampleDataResourceRepository = SampleDataRepositoryManager.getInstance(facet2).getRepository();
        if (sampleDataResourceRepository == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(1);
        }
        return sampleDataResourceRepository;
    }

    private SampleDataResourceRepository(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(2);
        }
        super("Sample Data");
        this.myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
        this.myAndroidFacet = androidFacet;
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(androidFacet);
        this.myNamespace = repositoryManager.getNamespace();
        this.loadItems();
        SampleDataListener.ensureSubscribed(androidFacet.getModule().getProject());
    }

    @Override
    public void addParent(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(3);
        }
        if (!this.myAndroidFacet.isDisposed()) {
            super.addParent(parent);
        }
    }

    void reload() {
        this.loadItems();
    }

    @Override
    @GuardedBy(value="ITEM_MAP_LOCK")
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(4);
        }
        if (type == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(5);
        }
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.myResourceTable.get(type);
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(6);
        }
        return resourceNamespace;
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myAndroidFacet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor) {
        if (visitor == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(7);
        }
        if (visitor.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (SampleDataResourceRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor) == ResourceVisitor.VisitResult.ABORT) {
                    ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.ABORT;
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (visitResult == null) {
                        SampleDataResourceRepository.$$$reportNull$$$0(8);
                    }
                    return visitResult;
                }
            }
        }
        ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.CONTINUE;
        if (visitResult == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(9);
        }
        return visitResult;
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(10);
        }
        return immutableSet;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadItems() {
        if (this.myAndroidFacet.isDisposed()) {
            return;
        }
        Object items2 = ImmutableList.of();
        VirtualFile sampleDataDir = FileExtensions.toVirtualFile(ProjectSystemUtil.getModuleSystem(this.myAndroidFacet.getModule()).getSampleDataDirectory());
        if (sampleDataDir != null) {
            ArrayList items1 = new ArrayList();
            PsiManager psiManager = PsiManager.getInstance((Project)this.myAndroidFacet.getModule().getProject());
            Stream<VirtualFile> childrenStream = Arrays.stream(sampleDataDir.getChildren());
            ApplicationManager.getApplication().runReadAction(() -> childrenStream.map(vf -> vf.isDirectory() ? psiManager.findDirectory(vf) : psiManager.findFile(vf)).filter(Objects::nonNull).forEach(f -> items1.addAll(this.loadItemsFromFile((PsiFileSystemItem)f))));
            items2 = items1;
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.myResourceTable.clear();
            if (!items2.isEmpty()) {
                ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
                for (ResourceItem item : items2) {
                    assert (item.getNamespace().equals((Object)this.myNamespace));
                    mapBuilder.put((Object)item.getName(), (Object)item);
                }
                this.myResourceTable.put(ResourceType.SAMPLE_DATA, (ListMultimap<String, ResourceItem>)mapBuilder.build());
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(this, ResourceType.SAMPLE_DATA);
        }
    }

    @NotNull
    private List<SampleDataResourceItem> loadItemsFromFile(@NotNull PsiFileSystemItem sampleDataFile) {
        List<SampleDataResourceItem> list;
        if (sampleDataFile == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(11);
        }
        try {
            list = SampleDataResourceItem.getFromPsiFileSystemItem(this, sampleDataFile);
        }
        catch (IOException e) {
            LOG.warn("Error loading sample data file " + sampleDataFile.getName(), (Throwable)e);
            List<SampleDataResourceItem> list2 = Collections.emptyList();
            if (list2 == null) {
                SampleDataResourceRepository.$$$reportNull$$$0(13);
            }
            return list2;
        }
        if (list == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/SampleDataResourceRepository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleDataFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadItemsFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadItemsFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class SampleDataRepositoryManager
    extends AndroidFacetScopedService {
        private static final Key<SampleDataRepositoryManager> KEY = Key.create((String)SampleDataRepositoryManager.class.getName());
        private final Object repositoryLock;
        @GuardedBy(value="repositoryLock")
        private SampleDataResourceRepository repository;

        @NotNull
        public static SampleDataRepositoryManager getInstance(@NotNull AndroidFacet facet2) {
            SampleDataRepositoryManager manager;
            if (facet2 == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(0);
            }
            if ((manager = (SampleDataRepositoryManager)facet2.getUserData(KEY)) == null) {
                manager = new SampleDataRepositoryManager(facet2);
                facet2.putUserData(KEY, (Object)manager);
            }
            SampleDataRepositoryManager sampleDataRepositoryManager = manager;
            if (sampleDataRepositoryManager == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(1);
            }
            return sampleDataRepositoryManager;
        }

        private SampleDataRepositoryManager(@NotNull AndroidFacet facet2) {
            if (facet2 == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(2);
            }
            super(facet2);
            this.repositoryLock = new Object();
        }

        @Override
        protected void onServiceDisposal(@NotNull AndroidFacet facet2) {
            if (facet2 == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public SampleDataResourceRepository getRepository() {
            if (this.isDisposed()) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " is disposed");
            }
            Object object = this.repositoryLock;
            // MONITORENTER : object
            if (this.repository == null) {
                this.repository = new SampleDataResourceRepository(this.getFacet());
                Disposer.register((Disposable)this, (Disposable)this.repository);
            }
            SampleDataResourceRepository sampleDataResourceRepository = this.repository;
            // MONITOREXIT : object
            if (sampleDataResourceRepository != null) return sampleDataResourceRepository;
            SampleDataRepositoryManager.$$$reportNull$$$0(4);
            return sampleDataResourceRepository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasRepository() {
            Object object = this.repositoryLock;
            synchronized (object) {
                return this.repository != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            SampleDataResourceRepository localRepository;
            Object object = this.repositoryLock;
            synchronized (object) {
                localRepository = this.repository;
                this.repository = null;
            }
            if (localRepository != null) {
                Disposer.dispose((Disposable)localRepository);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/SampleDataResourceRepository$SampleDataRepositoryManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceRepository$SampleDataRepositoryManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepository";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onServiceDisposal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

