/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Arity;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.ProtoConfigurationDecoder;
import com.android.tools.idea.resources.aar.ProtoStyledStringDecoder;
import com.android.tools.idea.resources.base.BasicArrayResourceItem;
import com.android.tools.idea.resources.base.BasicAttrReference;
import com.android.tools.idea.resources.base.BasicAttrResourceItem;
import com.android.tools.idea.resources.base.BasicDensityBasedFileResourceItem;
import com.android.tools.idea.resources.base.BasicFileResourceItem;
import com.android.tools.idea.resources.base.BasicPluralsResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.BasicStyleResourceItem;
import com.android.tools.idea.resources.base.BasicStyleableResourceItem;
import com.android.tools.idea.resources.base.BasicTextValueResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItem;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.RepositoryLoader;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.android.tools.idea.resources.base.ResourceSourceFileImpl;
import com.android.tools.idea.resources.base.ResourceUrlParser;
import com.android.utils.DecimalUtils;
import com.android.utils.SdkUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Table;
import com.google.protobuf.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.BitUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarProtoResourceRepository
extends AbstractAarResourceRepository {
    protected static final Predicate<ConfigurationOuterClass.Configuration> TRIVIAL_CONFIG_FILTER = config -> true;
    protected static final Predicate<ResourceType> TRIVIAL_RESOURCE_TYPE_FILTER = type -> true;
    @NotNull
    private static final String APK_PROTOCOL = "apk";
    private static final String RESOURCE_TABLE_ENTRY = "resources.pb";
    private static final Logger LOG = Logger.getInstance(AarProtoResourceRepository.class);
    private static final int COMPLEX_UNIT_MASK = 15;
    private static final String[] DIMEN_SUFFIXES = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_SUFFIXES = new String[]{"%", "%p"};
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final double[] RADIX_FACTORS = new double[]{1.0, 0.0078125, 3.0517578125E-5, 1.1920928955078125E-7};
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    @NotNull
    protected final Path myResApkFile;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final String myResourceUrlPrefix;
    @Nullable
    private final String mySourceAttachmentPrefix;

    protected AarProtoResourceRepository(@NotNull Loader loader, @Nullable String libraryName, @Nullable Path sourceJar) {
        if (loader == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(0);
        }
        super(loader.myNamespace, libraryName);
        this.myResApkFile = loader.myResApkFile;
        this.myResourcePathPrefix = this.myResApkFile.toString() + "!/";
        this.myResourceUrlPrefix = "apk://" + RepositoryLoader.portableFileName(this.myResApkFile.toString()) + "!/";
        this.mySourceAttachmentPrefix = sourceJar != null && loader.myPackageName != null ? sourceJar.toString() + "!/" + AarProtoResourceRepository.getPackageNamePrefix(loader.myPackageName) : null;
    }

    @Override
    @NotNull
    public Path getOrigin() {
        Path path2 = this.myResApkFile;
        if (path2 == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(1);
        }
        return path2;
    }

    @Nullable
    public final String getPackageName() {
        return this.myNamespace.getPackageName();
    }

    @NotNull
    public static AarProtoResourceRepository create(@NotNull Path resApkFile, @NotNull String libraryName) {
        if (resApkFile == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(2);
        }
        if (libraryName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(3);
        }
        Loader loader = new Loader(resApkFile, TRIVIAL_CONFIG_FILTER, TRIVIAL_RESOURCE_TYPE_FILTER);
        try {
            loader.readApkFile();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return new AarProtoResourceRepository(loader, libraryName, null);
        }
        Path sourceJar = AarProtoResourceRepository.getSourceJarPath(resApkFile);
        if (!Files.exists(sourceJar, new LinkOption[0])) {
            sourceJar = null;
        }
        AarProtoResourceRepository repository = new AarProtoResourceRepository(loader, libraryName, sourceJar);
        loader.loadRepositoryContents(repository);
        AarProtoResourceRepository aarProtoResourceRepository = repository;
        if (aarProtoResourceRepository == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(4);
        }
        return aarProtoResourceRepository;
    }

    private static Path getSourceJarPath(@NotNull Path resApkFile) {
        Object filename;
        int extensionPos;
        if (resApkFile == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(5);
        }
        if ((extensionPos = ((String)(filename = resApkFile.getFileName().toString())).lastIndexOf(46)) >= 0) {
            filename = ((String)filename).substring(0, extensionPos);
        }
        filename = (String)filename + "-src.jar";
        return resApkFile.resolveSibling((String)filename);
    }

    @Override
    @NotNull
    public final String getResourceUrl(@NotNull String relativeResourcePath) {
        if (relativeResourcePath == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(6);
        }
        String string = this.expandRelativeResourcePath(this.myResourceUrlPrefix, relativeResourcePath, true);
        if (string == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public final PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        if (relativeResourcePath == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(8);
        }
        return new PathString(APK_PROTOCOL, this.expandRelativeResourcePath(this.myResourcePathPrefix, relativeResourcePath, forFileResource));
    }

    private String expandRelativeResourcePath(@NotNull String prefix, @NotNull String relativeResourcePath, boolean forFileResource) {
        if (prefix == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(9);
        }
        if (relativeResourcePath == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(10);
        }
        int offset = 0;
        if (this.hasOverlaySegment(relativeResourcePath, forFileResource)) {
            assert (Character.isDigit(relativeResourcePath.charAt(0)));
            offset = relativeResourcePath.indexOf(47) + 1;
        }
        int prefixLength = prefix.length();
        int pathLength = relativeResourcePath.length();
        char[] result2 = new char[prefixLength + pathLength - offset];
        prefix.getChars(0, prefixLength, result2, 0);
        relativeResourcePath.getChars(offset, pathLength, result2, prefixLength);
        return new String(result2);
    }

    private boolean hasOverlaySegment(@NotNull String relativeResourcePath, boolean forFileResource) {
        if (relativeResourcePath == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(11);
        }
        return forFileResource && this.mySourceAttachmentPrefix != null && AarProtoResourceRepository.isXml(relativeResourcePath);
    }

    @Override
    @Nullable
    public final PathString getOriginalSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        if (relativeResourcePath == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(12);
        }
        if (AarProtoResourceRepository.isXml(relativeResourcePath)) {
            if (this.mySourceAttachmentPrefix == null) {
                return null;
            }
            return new PathString("jar", this.mySourceAttachmentPrefix + relativeResourcePath);
        }
        return this.getSourceFile(relativeResourcePath, forFileResource);
    }

    private static boolean isXml(@NotNull String filePath) {
        if (filePath == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(13);
        }
        return SdkUtils.endsWithIgnoreCase((String)filePath, (String)".xml");
    }

    @NotNull
    private static String getPackageNamePrefix(@NotNull String packageName) {
        if (packageName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(14);
        }
        String string = packageName.replace('.', '/') + "/";
        if (string == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(15);
        }
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " for " + this.myResApkFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/aar/AarProtoResourceRepository";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resApkFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeResourcePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/aar/AarProtoResourceRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceUrl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNamePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceJarPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResourceUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expandRelativeResourcePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasOverlaySegment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalSourceFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isXml";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNamePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringPool {
        private static final int STRING_COUNT_OFFSET = 8;
        private static final int FLAGS_OFFSET = 16;
        private static final int STRINGS_START_INDEX_OFFSET = 20;
        private static final int UTF8_FLAG = 256;
        private static final String REPLACEMENT_PREFIX = "0/res/";
        @NotNull
        final String[] strings;
        private int currentOffset;

        StringPool(@NotNull Resources.StringPool stringPoolMsg, @Nullable String packageName) {
            if (stringPoolMsg == null) {
                StringPool.$$$reportNull$$$0(0);
            }
            ByteString bytes = stringPoolMsg.getData();
            if ((StringPool.getInt32(bytes, 16) & 0x100) == 0) {
                throw new IllegalArgumentException("UTF-16 encoded string pool is not supported");
            }
            int stringCount = StringPool.getInt32(bytes, 8);
            this.strings = new String[stringCount];
            this.currentOffset = StringPool.getInt32(bytes, 20);
            for (int i2 = 0; i2 < stringCount; ++i2) {
                this.getByteEncodedLength(bytes);
                int byteCount = this.getByteEncodedLength(bytes);
                int endOffset = this.currentOffset + byteCount;
                this.strings[i2] = bytes.substring(this.currentOffset, endOffset).toStringUtf8();
                this.currentOffset = endOffset + 1;
            }
            this.normalizePaths(packageName);
        }

        private static int getByte(@NotNull ByteString bytes, int offset) {
            if (bytes == null) {
                StringPool.$$$reportNull$$$0(1);
            }
            return bytes.byteAt(offset) & 0xFF;
        }

        private static int getInt32(@NotNull ByteString bytes, int offset) {
            if (bytes == null) {
                StringPool.$$$reportNull$$$0(2);
            }
            return StringPool.getByte(bytes, offset) | StringPool.getByte(bytes, offset + 1) << 8 | StringPool.getByte(bytes, offset + 2) << 16 | StringPool.getByte(bytes, offset + 3) << 24;
        }

        private int getByteEncodedLength(@NotNull ByteString bytes) {
            int b;
            if (bytes == null) {
                StringPool.$$$reportNull$$$0(3);
            }
            if (((b = StringPool.getByte(bytes, this.currentOffset++)) & 0x80) == 0) {
                return b;
            }
            return (b & 0x7F) << 8 | StringPool.getByte(bytes, this.currentOffset++);
        }

        /*
         * WARNING - void declaration
         */
        private void normalizePaths(@Nullable String packageName) {
            String packagePrefix = packageName == null ? null : AarProtoResourceRepository.getPackageNamePrefix(packageName);
            String prefix = null;
            for (String string : this.strings) {
                void var6_11;
                if (string.isEmpty()) continue;
                String string2 = RepositoryLoader.portableFileName(string);
                if (string2.charAt(0) == '/') {
                    String anchor;
                    int pos;
                    if (prefix == null && (pos = string2.indexOf(anchor = "/res/")) >= 0) {
                        prefix = string2.substring(0, pos + anchor.length());
                    }
                    if (prefix == null && (pos = string2.indexOf(anchor = "/namespaced_res/")) >= 0 && (pos = string2.indexOf(47, pos + anchor.length())) >= 0) {
                        prefix = string2.substring(0, pos + 1);
                    }
                    if (prefix != null && string2.startsWith(prefix)) {
                        String string3 = REPLACEMENT_PREFIX + string2.substring(prefix.length());
                    }
                } else if (packagePrefix != null && string2.startsWith(packagePrefix)) {
                    String string4 = string2.substring(packagePrefix.length());
                }
                this.strings[i] = var6_11;
            }
        }

        @NotNull
        public String getString(int index) {
            String string = this.strings[index];
            if (string == null) {
                StringPool.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringPoolMsg";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/resources/aar/AarProtoResourceRepository$StringPool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/resources/aar/AarProtoResourceRepository$StringPool";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getByte";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getInt32";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getByteEncodedLength";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class Loader {
        @NotNull
        private final Path myResApkFile;
        @NotNull
        private final Predicate<ConfigurationOuterClass.Configuration> myConfigFilter;
        @NotNull
        private final Predicate<ResourceType> myResourceTypeFilter;
        @NotNull
        private final ResourceUrlParser myUrlParser;
        @NotNull
        private final ListMultimap<String, BasicStyleableResourceItem> myStyleables;
        @NotNull
        private final Table<String, ConfigurationOuterClass.Configuration, ResourceSourceFile> mySourceFileCache;
        @Nullable
        private Resources.ResourceTable myResourceTableMsg;
        @Nullable
        private String myPackageName;
        private ResourceNamespace myNamespace;

        Loader(@NotNull Path resApkFile, @NotNull Predicate<ConfigurationOuterClass.Configuration> configFilter, @NotNull Predicate<ResourceType> resourceTypeFilter) {
            if (resApkFile == null) {
                Loader.$$$reportNull$$$0(0);
            }
            if (configFilter == null) {
                Loader.$$$reportNull$$$0(1);
            }
            if (resourceTypeFilter == null) {
                Loader.$$$reportNull$$$0(2);
            }
            this.myUrlParser = new ResourceUrlParser();
            this.myStyleables = ArrayListMultimap.create();
            this.mySourceFileCache = HashBasedTable.create();
            this.myResApkFile = resApkFile;
            this.myConfigFilter = configFilter;
            this.myResourceTypeFilter = resourceTypeFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readApkFile() throws IOException {
            ResourceNamespace resourceNamespace;
            try {
                try (ZipFile zipFile = new ZipFile(this.myResApkFile.toFile());){
                    this.myResourceTableMsg = Loader.readResourceTableFromResApk(zipFile);
                    this.myPackageName = AndroidManifestPackageNameUtils.getPackageNameFromResApk((ZipFile)zipFile);
                }
                resourceNamespace = this.myPackageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)this.myPackageName);
            }
            catch (Throwable throwable) {
                this.myNamespace = this.myPackageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)this.myPackageName);
                throw throwable;
            }
            this.myNamespace = resourceNamespace;
        }

        public void loadRepositoryContents(@NotNull AarProtoResourceRepository repository) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(3);
            }
            if (this.myResourceTableMsg != null) {
                this.loadFromResourceTable(repository, this.myResourceTableMsg);
            }
        }

        private void loadFromResourceTable(@NotNull AarProtoResourceRepository repository, @NotNull Resources.ResourceTable resourceTableMsg) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(4);
            }
            if (resourceTableMsg == null) {
                Loader.$$$reportNull$$$0(5);
            }
            StringPool stringPool = repository.mySourceAttachmentPrefix == null ? null : new StringPool(resourceTableMsg.getSourcePool(), this.myNamespace.getPackageName());
            for (Resources.Package packageMsg : resourceTableMsg.getPackageList()) {
                for (Resources.Type typeMsg : packageMsg.getTypeList()) {
                    String typeName = typeMsg.getName();
                    ResourceType resourceType = ResourceType.fromClassName((String)typeName);
                    if (resourceType == null) {
                        if (typeName.equals("^attr-private")) {
                            resourceType = ResourceType.ATTR;
                        } else {
                            LOG.warn("Unexpected resource type: " + typeName);
                            continue;
                        }
                    }
                    if (!this.myResourceTypeFilter.test(resourceType)) continue;
                    for (Resources.Entry entryMsg : typeMsg.getEntryList()) {
                        String resourceName = entryMsg.getName();
                        Resources.Visibility visibilityMsg = entryMsg.getVisibility();
                        ResourceVisibility visibility = Loader.decodeVisibility(visibilityMsg);
                        for (Resources.ConfigValue configValueMsg : entryMsg.getConfigValueList()) {
                            ResourceSourceFile sourceFile;
                            BasicResourceItem item;
                            ConfigurationOuterClass.Configuration configMsg;
                            String sourcePath;
                            Resources.Value valueMsg = configValueMsg.getValue();
                            Resources.Source sourceMsg = valueMsg.getSource();
                            String string = sourcePath = stringPool == null ? null : stringPool.getString(sourceMsg.getPathIdx());
                            if (sourcePath != null && sourcePath.isEmpty()) {
                                sourcePath = null;
                            }
                            if (!this.myConfigFilter.test(configMsg = configValueMsg.getConfig()) || (item = this.createResourceItem(valueMsg, resourceType, resourceName, sourceFile = this.getSourceFile(repository, sourcePath, configMsg), visibility)) == null) continue;
                            this.addResourceItem(repository, (ResourceItem)item);
                        }
                    }
                }
            }
            for (BasicStyleableResourceItem styleable : this.myStyleables.values()) {
                repository.addResourceItem((ResourceItem)RepositoryLoader.resolveAttrReferences(styleable));
            }
            repository.populatePublicResourcesMap();
            repository.freezeResources();
        }

        private void addResourceItem(@NotNull AarProtoResourceRepository repository, @NotNull ResourceItem item) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(6);
            }
            if (item == null) {
                Loader.$$$reportNull$$$0(7);
            }
            if (item.getType() == ResourceType.STYLEABLE) {
                this.myStyleables.put((Object)item.getName(), (Object)((BasicStyleableResourceItem)item));
            } else {
                repository.addResourceItem(item);
            }
        }

        @Nullable
        private BasicResourceItem createResourceItem(@NotNull Resources.Value valueMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            if (valueMsg == null) {
                Loader.$$$reportNull$$$0(8);
            }
            if (resourceType == null) {
                Loader.$$$reportNull$$$0(9);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(10);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(11);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(12);
            }
            switch (valueMsg.getValueCase()) {
                case ITEM: {
                    return this.createResourceItem(valueMsg.getItem(), resourceType, resourceName, sourceFile, visibility);
                }
                case COMPOUND_VALUE: {
                    String description = valueMsg.getComment();
                    if (CharMatcher.whitespace().matchesAllOf((CharSequence)description)) {
                        description = null;
                    }
                    return this.createResourceItem(valueMsg.getCompoundValue(), resourceName, sourceFile, visibility, description);
                }
            }
            LOG.warn("Unexpected Value message: " + valueMsg);
            return null;
        }

        @Nullable
        private BasicResourceItem createResourceItem(@NotNull Resources.Item itemMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            if (itemMsg == null) {
                Loader.$$$reportNull$$$0(13);
            }
            if (resourceType == null) {
                Loader.$$$reportNull$$$0(14);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(15);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(16);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(17);
            }
            switch (itemMsg.getValueCase()) {
                case FILE: {
                    Density densityValue;
                    FolderConfiguration folderConfiguration;
                    DensityQualifier densityQualifier;
                    String path2 = sourceFile.getRelativePath();
                    if (path2 == null || !AarProtoResourceRepository.isXml(path2)) {
                        path2 = itemMsg.getFile().getPath();
                    }
                    RepositoryConfiguration configuration = sourceFile.getConfiguration();
                    if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = (folderConfiguration = configuration.getFolderConfiguration()).getDensityQualifier()) != null && (densityValue = densityQualifier.getValue()) != null) {
                        return new BasicDensityBasedFileResourceItem(resourceType, resourceName, configuration, visibility, path2, densityValue);
                    }
                    return new BasicFileResourceItem(resourceType, resourceName, configuration, visibility, path2);
                }
                case REF: {
                    String ref = this.decode(itemMsg.getRef());
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, ref);
                }
                case STR: {
                    String textValue = itemMsg.getStr().getValue();
                    return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue);
                }
                case RAW_STR: {
                    String str = itemMsg.getRawStr().getValue();
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, str);
                }
                case PRIM: {
                    String str = Loader.decode(itemMsg.getPrim());
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, str);
                }
                case STYLED_STR: {
                    Resources.StyledString styledStrMsg = itemMsg.getStyledStr();
                    String textValue = styledStrMsg.getValue();
                    String rawXmlValue = ProtoStyledStringDecoder.getRawXmlValue(styledStrMsg);
                    if (rawXmlValue.equals(textValue)) {
                        return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue);
                    }
                    return new BasicTextValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue, rawXmlValue);
                }
                case ID: {
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, null);
                }
            }
            LOG.warn("Unexpected Item message: " + itemMsg);
            return null;
        }

        @NotNull
        private static BasicResourceItem createResourceItem(@NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String value2) {
            if (resourceType == null) {
                Loader.$$$reportNull$$$0(18);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(19);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(20);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(21);
            }
            return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, value2);
        }

        @Nullable
        private BasicResourceItem createResourceItem(@NotNull Resources.CompoundValue compoundValueMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String description) {
            if (compoundValueMsg == null) {
                Loader.$$$reportNull$$$0(22);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(23);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(24);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(25);
            }
            switch (compoundValueMsg.getValueCase()) {
                case ATTR: {
                    return Loader.createAttr(compoundValueMsg.getAttr(), resourceName, sourceFile, visibility, description);
                }
                case STYLE: {
                    return this.createStyle(compoundValueMsg.getStyle(), resourceName, sourceFile, visibility);
                }
                case STYLEABLE: {
                    return this.createStyleable(compoundValueMsg.getStyleable(), resourceName, sourceFile, visibility);
                }
                case ARRAY: {
                    return this.createArray(compoundValueMsg.getArray(), resourceName, sourceFile, visibility);
                }
                case PLURAL: {
                    return this.createPlurals(compoundValueMsg.getPlural(), resourceName, sourceFile, visibility);
                }
            }
            LOG.warn("Unexpected CompoundValue message: " + compoundValueMsg);
            return null;
        }

        @NotNull
        private static BasicAttrResourceItem createAttr(@NotNull Resources.Attribute attributeMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String description) {
            if (attributeMsg == null) {
                Loader.$$$reportNull$$$0(26);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(27);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(28);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(29);
            }
            Set<AttributeFormat> formats = Loader.decodeFormatFlags(attributeMsg.getFormatFlags());
            List symbolList = attributeMsg.getSymbolList();
            Map<String, Integer> valueMap = Collections.emptyMap();
            Map<String, String> valueDescriptionMap = Collections.emptyMap();
            for (Resources.Attribute.Symbol symbolMsg : symbolList) {
                String name = symbolMsg.getName().getName();
                int slashPos = name.lastIndexOf(47);
                if (slashPos >= 0) {
                    name = name.substring(slashPos + 1);
                }
                String symbolDescription = symbolMsg.getComment();
                if (CharMatcher.whitespace().matchesAllOf((CharSequence)symbolDescription)) {
                    symbolDescription = null;
                }
                if (valueMap.isEmpty()) {
                    valueMap = new HashMap<String, Integer>();
                }
                valueMap.put(name, symbolMsg.getValue());
                if (symbolDescription == null) continue;
                if (valueDescriptionMap.isEmpty()) {
                    valueDescriptionMap = new HashMap<String, String>();
                }
                valueDescriptionMap.put(name, symbolDescription);
            }
            String groupName = null;
            return new BasicAttrResourceItem(resourceName, sourceFile, visibility, description, groupName, formats, valueMap, valueDescriptionMap);
        }

        @NotNull
        private BasicStyleResourceItem createStyle(@NotNull Resources.Style styleMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            if (styleMsg == null) {
                Loader.$$$reportNull$$$0(30);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(31);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(32);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(33);
            }
            String libraryName = sourceFile.getRepository().getLibraryName();
            this.myUrlParser.parseResourceUrl(styleMsg.getParent().getName());
            String parentStyle = this.myUrlParser.getQualifiedName();
            if (StyleResourceValue.isDefaultParentStyleName((String)parentStyle, (String)resourceName)) {
                parentStyle = null;
            }
            ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>(styleMsg.getEntryCount());
            for (Resources.Style.Entry entryMsg : styleMsg.getEntryList()) {
                String url = entryMsg.getKey().getName();
                this.myUrlParser.parseResourceUrl(url);
                String name = this.myUrlParser.getQualifiedName();
                String value2 = this.decode(entryMsg.getItem());
                StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(this.myNamespace, name, value2, libraryName);
                styleItems.add((StyleItemResourceValue)itemValue);
            }
            return new BasicStyleResourceItem(resourceName, sourceFile, visibility, parentStyle, styleItems);
        }

        @NotNull
        private BasicStyleableResourceItem createStyleable(@NotNull Resources.Styleable styleableMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            if (styleableMsg == null) {
                Loader.$$$reportNull$$$0(34);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(35);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(36);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(37);
            }
            ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>(styleableMsg.getEntryCount());
            for (Resources.Styleable.Entry entryMsg : styleableMsg.getEntryList()) {
                String url = entryMsg.getAttr().getName();
                this.myUrlParser.parseResourceUrl(url);
                String packageName = this.myUrlParser.getNamespacePrefix();
                ResourceNamespace attrNamespace = packageName == null ? this.myNamespace : ResourceNamespace.fromPackageName((String)packageName);
                String comment = entryMsg.getComment();
                BasicAttrReference attr2 = new BasicAttrReference(attrNamespace, this.myUrlParser.getName(), sourceFile, visibility, comment.isEmpty() ? null : comment, null);
                attrs.add(attr2);
            }
            return new BasicStyleableResourceItem(resourceName, sourceFile, visibility, attrs);
        }

        @NotNull
        private BasicArrayResourceItem createArray(@NotNull Resources.Array arrayMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            if (arrayMsg == null) {
                Loader.$$$reportNull$$$0(38);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(39);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(40);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(41);
            }
            ArrayList<String> elements = new ArrayList<String>(arrayMsg.getElementCount());
            for (Resources.Array.Element elementMsg : arrayMsg.getElementList()) {
                String text = this.decode(elementMsg.getItem());
                if (text == null) continue;
                elements.add(text);
            }
            return new BasicArrayResourceItem(resourceName, sourceFile, visibility, elements, 0);
        }

        @NotNull
        private BasicPluralsResourceItem createPlurals(@NotNull Resources.Plural pluralMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            if (pluralMsg == null) {
                Loader.$$$reportNull$$$0(42);
            }
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(43);
            }
            if (sourceFile == null) {
                Loader.$$$reportNull$$$0(44);
            }
            if (visibility == null) {
                Loader.$$$reportNull$$$0(45);
            }
            EnumMap<Arity, String> values = new EnumMap<Arity, String>(Arity.class);
            for (Resources.Plural.Entry entryMsg : pluralMsg.getEntryList()) {
                values.put(Loader.decodeArity(entryMsg.getArity()), this.decode(entryMsg.getItem()));
            }
            return new BasicPluralsResourceItem(resourceName, sourceFile, visibility, values, null);
        }

        @NotNull
        private ResourceSourceFile getSourceFile(@NotNull AarProtoResourceRepository repository, @Nullable String sourcePath, @NotNull ConfigurationOuterClass.Configuration configMsg) {
            String sourcePathKey;
            ResourceSourceFile sourceFile;
            if (repository == null) {
                Loader.$$$reportNull$$$0(46);
            }
            if (configMsg == null) {
                Loader.$$$reportNull$$$0(47);
            }
            if ((sourceFile = (ResourceSourceFile)this.mySourceFileCache.get((Object)(sourcePathKey = sourcePath == null ? "" : sourcePath), (Object)configMsg)) != null) {
                ResourceSourceFile resourceSourceFile = sourceFile;
                if (resourceSourceFile == null) {
                    Loader.$$$reportNull$$$0(48);
                }
                return resourceSourceFile;
            }
            FolderConfiguration configuration = ProtoConfigurationDecoder.getConfiguration(configMsg);
            configuration.normalizeByRemovingRedundantVersionQualifier();
            sourceFile = new ResourceSourceFileImpl(sourcePath, new RepositoryConfiguration(repository, configuration));
            this.mySourceFileCache.put((Object)sourcePathKey, (Object)configMsg, (Object)sourceFile);
            ResourceSourceFile resourceSourceFile = sourceFile;
            if (resourceSourceFile == null) {
                Loader.$$$reportNull$$$0(49);
            }
            return resourceSourceFile;
        }

        @Nullable
        private String decode(@NotNull Resources.Item itemMsg) {
            if (itemMsg == null) {
                Loader.$$$reportNull$$$0(50);
            }
            switch (itemMsg.getValueCase()) {
                case REF: {
                    return this.decode(itemMsg.getRef());
                }
                case STR: {
                    return itemMsg.getStr().getValue();
                }
                case RAW_STR: {
                    return itemMsg.getRawStr().getValue();
                }
                case STYLED_STR: {
                    return itemMsg.getStyledStr().getValue();
                }
                case FILE: {
                    return itemMsg.getFile().getPath();
                }
                case ID: {
                    return null;
                }
                case PRIM: {
                    return Loader.decode(itemMsg.getPrim());
                }
            }
            return null;
        }

        @NotNull
        private String decode(@NotNull Resources.Reference referenceMsg) {
            String name;
            if (referenceMsg == null) {
                Loader.$$$reportNull$$$0(51);
            }
            if ((name = referenceMsg.getName()).isEmpty()) {
                return "";
            }
            if (referenceMsg.getType() == Resources.Reference.Type.ATTRIBUTE) {
                this.myUrlParser.parseResourceUrl(name);
                if (this.myUrlParser.hasType(ResourceType.ATTR.getName())) {
                    name = this.myUrlParser.getQualifiedName();
                }
                String string = "?" + name;
                if (string == null) {
                    Loader.$$$reportNull$$$0(52);
                }
                return string;
            }
            String string = "@" + name;
            if (string == null) {
                Loader.$$$reportNull$$$0(53);
            }
            return string;
        }

        @Nullable
        private static String decode(@NotNull Resources.Primitive primitiveMsg) {
            if (primitiveMsg == null) {
                Loader.$$$reportNull$$$0(54);
            }
            switch (primitiveMsg.getOneofValueCase()) {
                case NULL_VALUE: {
                    return null;
                }
                case EMPTY_VALUE: {
                    return "";
                }
                case FLOAT_VALUE: {
                    return DecimalUtils.trimInsignificantZeros((String)Float.toString(primitiveMsg.getFloatValue()));
                }
                case DIMENSION_VALUE: {
                    return Loader.decodeComplexDimensionValue(primitiveMsg.getDimensionValue(), 1.0, DIMEN_SUFFIXES);
                }
                case FRACTION_VALUE: {
                    return Loader.decodeComplexDimensionValue(primitiveMsg.getFractionValue(), 100.0, FRACTION_SUFFIXES);
                }
                case INT_DECIMAL_VALUE: {
                    return Integer.toString(primitiveMsg.getIntDecimalValue());
                }
                case INT_HEXADECIMAL_VALUE: {
                    return String.format("0x%X", primitiveMsg.getIntHexadecimalValue());
                }
                case BOOLEAN_VALUE: {
                    return Boolean.toString(primitiveMsg.getBooleanValue());
                }
                case COLOR_ARGB8_VALUE: {
                    return String.format("#%08X", primitiveMsg.getColorArgb8Value());
                }
                case COLOR_RGB8_VALUE: {
                    return String.format("#%06X", primitiveMsg.getColorRgb8Value() & 0xFFFFFF);
                }
                case COLOR_ARGB4_VALUE: {
                    int argb = primitiveMsg.getColorArgb4Value();
                    return String.format("#%X%X%X%X", argb >>> 24 & 0xF, argb >>> 16 & 0xF, argb >>> 8 & 0xF, argb & 0xF);
                }
                case COLOR_RGB4_VALUE: {
                    int rgb = primitiveMsg.getColorRgb4Value();
                    return String.format("#%X%X%X", rgb >>> 16 & 0xF, rgb >>> 8 & 0xF, rgb & 0xF);
                }
            }
            LOG.warn("Unexpected Primitive message: " + primitiveMsg);
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private static String decodeComplexDimensionValue(int bits, double scaleFactor, @NotNull String[] stringArray) {
            void unitSuffixes;
            int unitCode;
            if (stringArray == null) {
                Loader.$$$reportNull$$$0(55);
            }
            String unit = (unitCode = bits & 0xF) < ((void)unitSuffixes).length ? unitSuffixes[unitCode] : " unknown unit: " + unitCode;
            int radix = bits >> 4 & 3;
            int mantissa = bits >> 8;
            double value2 = (double)mantissa * RADIX_FACTORS[radix] * scaleFactor;
            return DecimalUtils.trimInsignificantZeros((String)String.format(Locale.US, "%.5g", value2)) + unit;
        }

        @NotNull
        private static Set<AttributeFormat> decodeFormatFlags(int flags) {
            EnumSet<AttributeFormat> result2 = EnumSet.noneOf(AttributeFormat.class);
            if (BitUtil.isSet((int)flags, (int)1)) {
                result2.add(AttributeFormat.REFERENCE);
            }
            if (BitUtil.isSet((int)flags, (int)2)) {
                result2.add(AttributeFormat.STRING);
            }
            if (BitUtil.isSet((int)flags, (int)4)) {
                result2.add(AttributeFormat.INTEGER);
            }
            if (BitUtil.isSet((int)flags, (int)8)) {
                result2.add(AttributeFormat.BOOLEAN);
            }
            if (BitUtil.isSet((int)flags, (int)16)) {
                result2.add(AttributeFormat.COLOR);
            }
            if (BitUtil.isSet((int)flags, (int)32)) {
                result2.add(AttributeFormat.FLOAT);
            }
            if (BitUtil.isSet((int)flags, (int)64)) {
                result2.add(AttributeFormat.DIMENSION);
            }
            if (BitUtil.isSet((int)flags, (int)128)) {
                result2.add(AttributeFormat.FRACTION);
            }
            if (BitUtil.isSet((int)flags, (int)65536)) {
                result2.add(AttributeFormat.ENUM);
            }
            if (BitUtil.isSet((int)flags, (int)131072)) {
                result2.add(AttributeFormat.FLAGS);
            }
            EnumSet<AttributeFormat> enumSet = result2;
            if (enumSet == null) {
                Loader.$$$reportNull$$$0(56);
            }
            return enumSet;
        }

        @NotNull
        private static Arity decodeArity(@NotNull Resources.Plural.Arity arity) {
            if (arity == null) {
                Loader.$$$reportNull$$$0(57);
            }
            switch (arity) {
                case ZERO: {
                    Arity arity2 = Arity.ZERO;
                    if (arity2 == null) {
                        Loader.$$$reportNull$$$0(58);
                    }
                    return arity2;
                }
                case ONE: {
                    Arity arity3 = Arity.ONE;
                    if (arity3 == null) {
                        Loader.$$$reportNull$$$0(59);
                    }
                    return arity3;
                }
                case TWO: {
                    Arity arity4 = Arity.TWO;
                    if (arity4 == null) {
                        Loader.$$$reportNull$$$0(60);
                    }
                    return arity4;
                }
                case FEW: {
                    Arity arity5 = Arity.FEW;
                    if (arity5 == null) {
                        Loader.$$$reportNull$$$0(61);
                    }
                    return arity5;
                }
                case MANY: {
                    Arity arity6 = Arity.MANY;
                    if (arity6 == null) {
                        Loader.$$$reportNull$$$0(62);
                    }
                    return arity6;
                }
            }
            Arity arity7 = Arity.OTHER;
            if (arity7 == null) {
                Loader.$$$reportNull$$$0(63);
            }
            return arity7;
        }

        @NotNull
        private static ResourceVisibility decodeVisibility(@NotNull Resources.Visibility visibilityMsg) {
            if (visibilityMsg == null) {
                Loader.$$$reportNull$$$0(64);
            }
            switch (visibilityMsg.getLevel()) {
                case UNKNOWN: {
                    ResourceVisibility resourceVisibility = ResourceVisibility.PRIVATE_XML_ONLY;
                    if (resourceVisibility == null) {
                        Loader.$$$reportNull$$$0(65);
                    }
                    return resourceVisibility;
                }
                case PRIVATE: {
                    ResourceVisibility resourceVisibility = ResourceVisibility.PRIVATE;
                    if (resourceVisibility == null) {
                        Loader.$$$reportNull$$$0(66);
                    }
                    return resourceVisibility;
                }
                case PUBLIC: {
                    ResourceVisibility resourceVisibility = ResourceVisibility.PUBLIC;
                    if (resourceVisibility == null) {
                        Loader.$$$reportNull$$$0(67);
                    }
                    return resourceVisibility;
                }
            }
            ResourceVisibility resourceVisibility = ResourceVisibility.UNDEFINED;
            if (resourceVisibility == null) {
                Loader.$$$reportNull$$$0(68);
            }
            return resourceVisibility;
        }

        @NotNull
        private static Resources.ResourceTable readResourceTableFromResApk(@NotNull ZipFile resApk) throws IOException {
            ZipEntry zipEntry;
            if (resApk == null) {
                Loader.$$$reportNull$$$0(69);
            }
            if ((zipEntry = resApk.getEntry(AarProtoResourceRepository.RESOURCE_TABLE_ENTRY)) == null) {
                throw new IOException("\"resources.pb\" not found in " + resApk.getName());
            }
            BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));
            Resources.ResourceTable resourceTable = Resources.ResourceTable.parseFrom((InputStream)stream);
            Resources.ResourceTable resourceTable2 = resourceTable;
            if (resourceTable2 == null) {
                Loader.$$$reportNull$$$0(70);
            }
            return resourceTable2;
            finally {
                ((InputStream)stream).close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resApkFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceTypeFilter";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 46: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceTableMsg";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueMsg";
                    break;
                }
                case 9: 
                case 14: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceType";
                    break;
                }
                case 10: 
                case 15: 
                case 19: 
                case 23: 
                case 27: 
                case 31: 
                case 35: 
                case 39: 
                case 43: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceName";
                    break;
                }
                case 11: 
                case 16: 
                case 20: 
                case 24: 
                case 28: 
                case 32: 
                case 36: 
                case 40: 
                case 44: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
                case 12: 
                case 17: 
                case 21: 
                case 25: 
                case 29: 
                case 33: 
                case 37: 
                case 41: 
                case 45: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibility";
                    break;
                }
                case 13: 
                case 50: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemMsg";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compoundValueMsg";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeMsg";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styleMsg";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styleableMsg";
                    break;
                }
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayMsg";
                    break;
                }
                case 42: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluralMsg";
                    break;
                }
                case 47: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configMsg";
                    break;
                }
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/resources/aar/AarProtoResourceRepository$Loader";
                    break;
                }
                case 51: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceMsg";
                    break;
                }
                case 54: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primitiveMsg";
                    break;
                }
                case 55: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unitSuffixes";
                    break;
                }
                case 57: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arity";
                    break;
                }
                case 64: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibilityMsg";
                    break;
                }
                case 69: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resApk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/resources/aar/AarProtoResourceRepository$Loader";
                    break;
                }
                case 48: 
                case 49: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFile";
                    break;
                }
                case 52: 
                case 53: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decode";
                    break;
                }
                case 56: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decodeFormatFlags";
                    break;
                }
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decodeArity";
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decodeVisibility";
                    break;
                }
                case 70: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readResourceTableFromResApk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRepositoryContents";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFromResourceTable";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addResourceItem";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "createResourceItem";
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "createAttr";
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "createStyle";
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "createStyleable";
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    objectArray = objectArray;
                    objectArray[2] = "createArray";
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    objectArray = objectArray;
                    objectArray[2] = "createPlurals";
                    break;
                }
                case 46: 
                case 47: {
                    objectArray = objectArray;
                    objectArray[2] = "getSourceFile";
                    break;
                }
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: {
                    break;
                }
                case 50: 
                case 51: 
                case 54: {
                    objectArray = objectArray;
                    objectArray[2] = "decode";
                    break;
                }
                case 55: {
                    objectArray = objectArray;
                    objectArray[2] = "decodeComplexDimensionValue";
                    break;
                }
                case 57: {
                    objectArray = objectArray;
                    objectArray[2] = "decodeArity";
                    break;
                }
                case 64: {
                    objectArray = objectArray;
                    objectArray[2] = "decodeVisibility";
                    break;
                }
                case 69: {
                    objectArray = objectArray;
                    objectArray[2] = "readResourceTableFromResApk";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

