/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.resources.aar.AarSourceResourceRepository;
import com.android.tools.idea.resources.aar.CachingData;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItemBase;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.NamespaceResolver;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.RepositoryLoader;
import com.android.tools.idea.resources.base.ResourceSerializationUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FrameworkResourceRepository
extends AarSourceResourceRepository {
    private static final ResourceNamespace ANDROID_NAMESPACE = ResourceNamespace.ANDROID;
    private static final Map<String, String> LANGUAGE_TO_GROUP = ImmutableMap.of((Object)"rm", (Object)"it");
    private static final String RESOURCES_TABLE_PREFIX = "resources_";
    private static final String RESOURCE_TABLE_SUFFIX = ".bin";
    private static final String COMPILED_9PNG_EXTENSION = ".compiled.9.png";
    private static final Logger LOG = Logger.getInstance(FrameworkResourceRepository.class);
    private final Set<String> myLanguageGroups;
    private int myNumberOfLanguageGroupsLoadedFromCache;
    private final boolean myUseCompiled9Patches;

    private FrameworkResourceRepository(@NotNull RepositoryLoader<FrameworkResourceRepository> loader, boolean useCompiled9Patches) {
        if (loader == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(0);
        }
        super(loader, null);
        this.myLanguageGroups = new TreeSet<String>();
        this.myUseCompiled9Patches = useCompiled9Patches;
    }

    @NotNull
    public static FrameworkResourceRepository create(@NotNull Path resourceDirectoryOrFile, @Nullable Set<String> languagesToLoad, @Nullable CachingData cachingData, boolean useCompiled9Patches) {
        if (resourceDirectoryOrFile == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(1);
        }
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Set<String> languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        Loader loader = new Loader(resourceDirectoryOrFile, languageGroups);
        FrameworkResourceRepository repository = new FrameworkResourceRepository((RepositoryLoader<FrameworkResourceRepository>)loader, useCompiled9Patches);
        repository.load(null, cachingData, loader, languageGroups, loader.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = repository.getNumberOfLanguageGroupsLoadedFromOrigin() == 0 ? "cache" : (repository.myNumberOfLanguageGroupsLoadedFromCache == 0 ? resourceDirectoryOrFile.toString() : "cache and " + resourceDirectoryOrFile);
            LOG.debug("Loaded from " + source + " with " + (repository.myLanguageGroups.size() - 1) + " languages in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec");
        }
        FrameworkResourceRepository frameworkResourceRepository = repository;
        if (frameworkResourceRepository == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(2);
        }
        return frameworkResourceRepository;
    }

    @NotNull
    public FrameworkResourceRepository loadMissingLanguages(@Nullable Set<String> languagesToLoad, @Nullable CachingData cachingData) {
        Set<String> languageGroups;
        Set<String> set = languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        if (languageGroups != null && this.myLanguageGroups.containsAll(languageGroups)) {
            FrameworkResourceRepository frameworkResourceRepository = this;
            if (frameworkResourceRepository == null) {
                FrameworkResourceRepository.$$$reportNull$$$0(3);
            }
            return frameworkResourceRepository;
        }
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Loader loader = new Loader(this, languageGroups);
        FrameworkResourceRepository newRepository = new FrameworkResourceRepository((RepositoryLoader<FrameworkResourceRepository>)loader, this.myUseCompiled9Patches);
        newRepository.load(this, cachingData, loader, languageGroups, loader.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = newRepository.getNumberOfLanguageGroupsLoadedFromOrigin() == this.getNumberOfLanguageGroupsLoadedFromOrigin() ? "cache" : (newRepository.myNumberOfLanguageGroupsLoadedFromCache == this.myNumberOfLanguageGroupsLoadedFromCache ? this.myResourceDirectoryOrFile.toString() : "cache and " + this.myResourceDirectoryOrFile);
            LOG.debug("Loaded " + (newRepository.myLanguageGroups.size() - this.myLanguageGroups.size()) + " additional languages from " + source + " in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec");
        }
        FrameworkResourceRepository frameworkResourceRepository = newRepository;
        if (frameworkResourceRepository == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(4);
        }
        return frameworkResourceRepository;
    }

    private void load(@Nullable FrameworkResourceRepository sourceRepository, @Nullable CachingData cachingData, @NotNull Loader loader, @Nullable Set<String> languageGroups, @NotNull Set<String> languageGroupsLoadedFromSourceRepositoryOrCache) {
        Executor executor;
        ImmutableSet configurationsToTakeOver;
        if (loader == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(5);
        }
        if (languageGroupsLoadedFromSourceRepositoryOrCache == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(6);
        }
        HashMap stringCache = Maps.newHashMapWithExpectedSize((int)10000);
        HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
        Object object = configurationsToTakeOver = sourceRepository == null ? ImmutableSet.of() : this.copyFromRepository(sourceRepository, stringCache, namespaceResolverCache);
        if (!loader.isLoadingFromZipArchive() && cachingData != null) {
            this.loadFromPersistentCache(cachingData, languageGroups, languageGroupsLoadedFromSourceRepositoryOrCache, stringCache, namespaceResolverCache);
        }
        this.myLanguageGroups.addAll(languageGroupsLoadedFromSourceRepositoryOrCache);
        if (languageGroups == null || !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(languageGroups)) {
            loader.loadRepositoryContents(this);
        }
        this.myLoadedFromCache = this.myNumberOfLanguageGroupsLoadedFromCache == this.myLanguageGroups.size();
        this.populatePublicResourcesMap();
        this.freezeResources();
        this.takeOverConfigurations((Set<RepositoryConfiguration>)configurationsToTakeOver);
        if (!loader.isLoadingFromZipArchive() && cachingData != null && (executor = cachingData.getCacheCreationExecutor()) != null && !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(this.myLanguageGroups)) {
            executor.execute(() -> this.createPersistentCache(cachingData, languageGroupsLoadedFromSourceRepositoryOrCache));
        }
    }

    @Override
    @Nullable
    public String getPackageName() {
        return ANDROID_NAMESPACE.getPackageName();
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull ResourceNamespace namespace) {
        if (namespace == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(7);
        }
        ImmutableSet immutableSet = namespace == ANDROID_NAMESPACE ? Sets.immutableEnumSet(this.myResources.keySet()) : ImmutableSet.of();
        if (immutableSet == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(8);
        }
        return immutableSet;
    }

    @NotNull
    private Set<RepositoryConfiguration> copyFromRepository(@NotNull FrameworkResourceRepository sourceRepository, @NotNull Map<String, String> stringCache, @NotNull Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        if (sourceRepository == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(9);
        }
        if (stringCache == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(10);
        }
        if (namespaceResolverCache == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(11);
        }
        Collection resourceMaps = sourceRepository.myResources.values();
        Set sourceConfigurations = Sets.newIdentityHashSet();
        for (ListMultimap resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                this.addResourceItem(item);
                sourceConfigurations.add(((BasicResourceItemBase)item).getRepositoryConfiguration());
                if (item instanceof BasicValueResourceItemBase) {
                    ResourceNamespace.Resolver resolver = ((BasicValueResourceItemBase)item).getNamespaceResolver();
                    NamespaceResolver namespaceResolver2 = resolver == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver;
                    namespaceResolverCache.put(namespaceResolver2, namespaceResolver2);
                }
                String name = item.getName();
                stringCache.put(name, name);
            }
        }
        this.myNumberOfLanguageGroupsLoadedFromCache += sourceRepository.myNumberOfLanguageGroupsLoadedFromCache;
        Set set = sourceConfigurations;
        if (set == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(12);
        }
        return set;
    }

    private void loadFromPersistentCache(@NotNull CachingData cachingData, @Nullable Set<String> languagesToLoad, @NotNull Set<String> loadedLanguages, @NotNull Map<String, String> stringCache, @Nullable Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        if (cachingData == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(13);
        }
        if (loadedLanguages == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(14);
        }
        if (stringCache == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(15);
        }
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        Set<String> languages = languagesToLoad == null ? fileNameGenerator.getAllCacheFileLanguages() : languagesToLoad;
        for (String language : languages) {
            if (loadedLanguages.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            try (Base128InputStream stream = new Base128InputStream(cacheFile);){
                byte[] header = ResourceSerializationUtil.getCacheFileHeader(s -> this.writeCacheHeaderContent(cachingData, language, s));
                if (!stream.validateContents(header)) {
                    if (!language.isEmpty()) continue;
                    break;
                }
                this.loadFromStream(stream, stringCache, namespaceResolverCache);
                loadedLanguages.add(language);
                ++this.myNumberOfLanguageGroupsLoadedFromCache;
            }
            catch (NoSuchFileException e) {
                if (!language.isEmpty()) continue;
                break;
            }
            catch (Throwable e) {
                this.cleanupAfterFailedLoadingFromCache();
                loadedLanguages.clear();
                this.myNumberOfLanguageGroupsLoadedFromCache = 0;
                LOG.warn("Failed to load from cache file " + cacheFile.toString(), e);
                break;
            }
        }
    }

    private void createPersistentCache(@NotNull CachingData cachingData, @NotNull Set<String> languagesToSkip) {
        if (cachingData == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(16);
        }
        if (languagesToSkip == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(17);
        }
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        for (String language : this.myLanguageGroups) {
            if (languagesToSkip.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, language, stream));
            ResourceSerializationUtil.createPersistentCache(cacheFile, header, stream -> this.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config))));
        }
    }

    private void writeCacheHeaderContent(@NotNull CachingData cachingData, @NotNull String language, @NotNull Base128OutputStream stream) throws IOException {
        if (cachingData == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(18);
        }
        if (language == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(19);
        }
        if (stream == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(20);
        }
        this.writeCacheHeaderContent(cachingData, stream);
        stream.writeString(language);
    }

    static String getResourceTableNameForLanguage(@NotNull String language) {
        if (language == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(21);
        }
        return language.isEmpty() ? "resources.bin" : RESOURCES_TABLE_PREFIX + language + RESOURCE_TABLE_SUFFIX;
    }

    @NotNull
    static String getLanguageGroup(@NotNull FolderConfiguration config) {
        LocaleQualifier locale;
        if (config == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(22);
        }
        return (locale = config.getLocaleQualifier()) == null ? "" : FrameworkResourceRepository.getLanguageGroup(StringUtil.notNullize((String)locale.getLanguage()));
    }

    @NotNull
    private static String getLanguageGroup(@NotNull String language) {
        if (language == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(23);
        }
        String string = LANGUAGE_TO_GROUP.getOrDefault(language, language);
        if (string == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static Set<String> getLanguageGroups(@NotNull Set<String> languages) {
        if (languages == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(25);
        }
        TreeSet<String> result2 = new TreeSet<String>();
        result2.add("");
        for (String language : languages) {
            result2.add(FrameworkResourceRepository.getLanguageGroup(language));
        }
        TreeSet<String> treeSet = result2;
        if (treeSet == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(26);
        }
        return treeSet;
    }

    @NotNull
    Set<String> getLanguageGroups() {
        TreeSet<String> languages = new TreeSet<String>();
        for (ListMultimap resourceMap : this.myResources.values()) {
            for (ResourceItem item : resourceMap.values()) {
                FolderConfiguration config = item.getConfiguration();
                languages.add(FrameworkResourceRepository.getLanguageGroup(config));
            }
        }
        TreeSet<String> treeSet = languages;
        if (treeSet == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(27);
        }
        return treeSet;
    }

    private int getNumberOfLanguageGroupsLoadedFromOrigin() {
        return this.myLanguageGroups.size() - this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    @TestOnly
    int getNumberOfLanguageGroupsLoadedFromCache() {
        return this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    @NotNull
    private String updateResourcePath(@NotNull String relativeResourcePath) {
        if (relativeResourcePath == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(28);
        }
        if (this.myUseCompiled9Patches && relativeResourcePath.endsWith(".9.png")) {
            String string = StringUtil.replaceSubstring((String)relativeResourcePath, (TextRange)TextRange.create((int)(relativeResourcePath.length() - ".9.png".length()), (int)relativeResourcePath.length()), (String)COMPILED_9PNG_EXTENSION);
            if (string == null) {
                FrameworkResourceRepository.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = relativeResourcePath;
        if (string == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Override
    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        if (relativeResourcePath == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(31);
        }
        String string = super.getResourceUrl(this.updateResourcePath(relativeResourcePath));
        if (string == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        if (relativeResourcePath == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(33);
        }
        PathString pathString = super.getSourceFile(this.updateResourcePath(relativeResourcePath), forFileResource);
        if (pathString == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(34);
        }
        return pathString;
    }

    private void takeOverConfigurations(@NotNull Set<RepositoryConfiguration> sourceConfigurations) {
        if (sourceConfigurations == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(35);
        }
        for (RepositoryConfiguration configuration : sourceConfigurations) {
            configuration.transferOwnershipTo(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectoryOrFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/aar/FrameworkResourceRepository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageGroupsLoadedFromSourceRepositoryOrCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRepository";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringCache";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolverCache";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachingData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedLanguages";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languagesToSkip";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeResourcePath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/aar/FrameworkResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMissingLanguages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFromRepository";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageGroup";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageGroups";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "updateResourcePath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceUrl";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyFromRepository";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadFromPersistentCache";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPersistentCache";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeCacheHeaderContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTableNameForLanguage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageGroup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageGroups";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateResourcePath";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getResourceUrl";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "takeOverConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CacheFileNameGenerator {
        private Path myLanguageNeutralFile;
        private String myPrefix;
        private String mySuffix;

        CacheFileNameGenerator(@NotNull CachingData cachingData) {
            if (cachingData == null) {
                CacheFileNameGenerator.$$$reportNull$$$0(0);
            }
            this.myLanguageNeutralFile = cachingData.getCacheFile();
            String fileName = this.myLanguageNeutralFile.getFileName().toString();
            int dotPos = fileName.lastIndexOf(46);
            this.myPrefix = dotPos >= 0 ? fileName.substring(0, dotPos) : fileName;
            this.mySuffix = dotPos >= 0 ? fileName.substring(dotPos) : "";
        }

        @NotNull
        Path getCacheFile(@NotNull String language) {
            if (language == null) {
                CacheFileNameGenerator.$$$reportNull$$$0(1);
            }
            Path path2 = language.isEmpty() ? this.myLanguageNeutralFile : this.myLanguageNeutralFile.resolveSibling(this.myPrefix + "_" + language + this.mySuffix);
            if (path2 == null) {
                CacheFileNameGenerator.$$$reportNull$$$0(2);
            }
            return path2;
        }

        @Nullable
        String getLanguage(@NotNull String cacheFileName) {
            if (cacheFileName == null) {
                CacheFileNameGenerator.$$$reportNull$$$0(3);
            }
            if (!cacheFileName.startsWith(this.myPrefix) || !cacheFileName.endsWith(this.mySuffix)) {
                return null;
            }
            int baseLength = this.myPrefix.length() + this.mySuffix.length();
            if (cacheFileName.length() == baseLength) {
                return "";
            }
            if (cacheFileName.length() != baseLength + 3 || cacheFileName.charAt(this.myPrefix.length()) != '_') {
                return null;
            }
            String language = cacheFileName.substring(this.myPrefix.length() + 1, this.myPrefix.length() + 3);
            if (!CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(0)) || !CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(1))) {
                return null;
            }
            return language;
        }

        @NotNull
        public Set<String> getAllCacheFileLanguages() {
            TreeSet<String> result2 = new TreeSet<String>();
            try (Stream<Path> stream = Files.list(this.myLanguageNeutralFile.getParent());){
                stream.forEach(file -> {
                    String language = this.getLanguage(file.getFileName().toString());
                    if (language != null) {
                        result2.add(language);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TreeSet<String> treeSet = result2;
            if (treeSet == null) {
                CacheFileNameGenerator.$$$reportNull$$$0(4);
            }
            return treeSet;
        }

        private static boolean isLowerCaseLatinLetter(char c) {
            return 'a' <= c && c <= 'z';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachingData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/resources/aar/FrameworkResourceRepository$CacheFileNameGenerator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cacheFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/resources/aar/FrameworkResourceRepository$CacheFileNameGenerator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCacheFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllCacheFileLanguages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCacheFile";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLanguage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Loader
    extends RepositoryLoader<FrameworkResourceRepository> {
        @NotNull
        private final Set<String> myLoadedLanguageGroups;
        @Nullable
        private Set<String> myLanguageGroups;

        Loader(@NotNull Path resourceDirectoryOrFile, @Nullable Set<String> languageGroups) {
            if (resourceDirectoryOrFile == null) {
                Loader.$$$reportNull$$$0(0);
            }
            super(resourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>();
        }

        Loader(@NotNull FrameworkResourceRepository sourceRepository, @Nullable Set<String> languageGroups) {
            if (sourceRepository == null) {
                Loader.$$$reportNull$$$0(1);
            }
            super(sourceRepository.myResourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>(sourceRepository.myLanguageGroups);
        }

        @Override
        protected void loadFromZip(@NotNull FrameworkResourceRepository repository) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(2);
            }
            try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
                if (this.myLanguageGroups == null) {
                    this.myLanguageGroups = Loader.readLanguageGroups(zipFile);
                }
                HashMap stringCache = Maps.newHashMapWithExpectedSize((int)10000);
                HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
                for (String language : this.myLanguageGroups) {
                    if (this.myLoadedLanguageGroups.contains(language)) continue;
                    String entryName = FrameworkResourceRepository.getResourceTableNameForLanguage(language);
                    ZipEntry zipEntry = zipFile.getEntry(entryName);
                    if (zipEntry == null) {
                        if (!language.isEmpty()) continue;
                        throw new IOException("\"" + entryName + "\" not found in " + this.myResourceDirectoryOrFile.toString());
                    }
                    try (Base128InputStream stream = new Base128InputStream(zipFile.getInputStream(zipEntry));){
                        repository.loadFromStream(stream, stringCache, namespaceResolverCache);
                    }
                }
                repository.populatePublicResourcesMap();
                repository.freezeResources();
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
        }

        @NotNull
        private static Set<String> readLanguageGroups(@NotNull ZipFile zipFile) {
            if (zipFile == null) {
                Loader.$$$reportNull$$$0(3);
            }
            ImmutableSortedSet.Builder result2 = ImmutableSortedSet.naturalOrder();
            result2.add((Object)"");
            zipFile.stream().forEach(entry -> {
                String name = entry.getName();
                if (name.startsWith(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX) && name.endsWith(FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX) && name.length() == FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX.length() + 2 && Character.isLetter(name.charAt(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length())) && Character.isLetter(name.charAt(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + 1))) {
                    result2.add((Object)name.substring(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length(), FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + 2));
                }
            });
            ImmutableSortedSet immutableSortedSet = result2.build();
            if (immutableSortedSet == null) {
                Loader.$$$reportNull$$$0(4);
            }
            return immutableSortedSet;
        }

        @Override
        public void loadRepositoryContents(@NotNull FrameworkResourceRepository repository) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(5);
            }
            super.loadRepositoryContents(repository);
            Set<String> languageGroups = this.myLanguageGroups == null ? repository.getLanguageGroups() : this.myLanguageGroups;
            repository.myLanguageGroups.addAll(languageGroups);
        }

        @Override
        public boolean isIgnored(@NotNull Path fileOrDirectory, @NotNull BasicFileAttributes attrs) {
            if (fileOrDirectory == null) {
                Loader.$$$reportNull$$$0(6);
            }
            if (attrs == null) {
                Loader.$$$reportNull$$$0(7);
            }
            if (fileOrDirectory.equals(this.myResourceDirectoryOrFile)) {
                return false;
            }
            if (super.isIgnored(fileOrDirectory, attrs)) {
                return true;
            }
            String fileName = fileOrDirectory.getFileName().toString();
            if (attrs.isDirectory()) {
                if (fileName.startsWith("values-mcc") || fileName.startsWith("raw") && (fileName.length() == "raw".length() || fileName.charAt("raw".length()) == '-')) {
                    return true;
                }
                if (this.myLanguageGroups != null || !this.myLoadedLanguageGroups.isEmpty()) {
                    FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)fileName);
                    if (config == null) {
                        return true;
                    }
                    String language = FrameworkResourceRepository.getLanguageGroup(config);
                    if (this.myLanguageGroups != null && !this.myLanguageGroups.contains(language) || this.myLoadedLanguageGroups.contains(language)) {
                        return true;
                    }
                    this.myFolderConfigCache.put(config.getQualifierString(), config);
                }
            } else {
                if ((fileName.equals("public.xml") || fileName.equals("symbols.xml")) && "values".equals(new PathString(fileOrDirectory).getParentFileName())) {
                    return true;
                }
                if (fileName.endsWith(FrameworkResourceRepository.COMPILED_9PNG_EXTENSION)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected final void addResourceItem(@NotNull BasicResourceItem item, @NotNull FrameworkResourceRepository repository) {
            if (item == null) {
                Loader.$$$reportNull$$$0(8);
            }
            if (repository == null) {
                Loader.$$$reportNull$$$0(9);
            }
            repository.addResourceItem((ResourceItem)item);
        }

        @Override
        @NotNull
        protected String getKeyForVisibilityLookup(@NotNull String resourceName) {
            if (resourceName == null) {
                Loader.$$$reportNull$$$0(10);
            }
            String string = resourceName;
            if (string == null) {
                Loader.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceDirectoryOrFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRepository";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "zipFile";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/resources/aar/FrameworkResourceRepository$Loader";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOrDirectory";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrs";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/resources/aar/FrameworkResourceRepository$Loader";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readLanguageGroups";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyForVisibilityLookup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFromZip";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readLanguageGroups";
                    break;
                }
                case 4: 
                case 11: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRepositoryContents";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnored";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addResourceItem";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeyForVisibilityLookup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

