/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicFileResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.android.utils.HashCodes;
import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicResourceItemBase
implements BasicResourceItem,
ResourceValue {
    @NotNull
    private final String myName;
    private final byte myTypeOrdinal;
    private final byte myVisibilityOrdinal;

    BasicResourceItemBase(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceVisibility visibility) {
        if (type == null) {
            BasicResourceItemBase.$$$reportNull$$$0(0);
        }
        if (name == null) {
            BasicResourceItemBase.$$$reportNull$$$0(1);
        }
        if (visibility == null) {
            BasicResourceItemBase.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myTypeOrdinal = (byte)type.ordinal();
        this.myVisibilityOrdinal = (byte)visibility.ordinal();
    }

    @NotNull
    public final ResourceType getType() {
        return this.getResourceType();
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.getRepository().getNamespace();
        if (resourceNamespace == null) {
            BasicResourceItemBase.$$$reportNull$$$0(3);
        }
        return resourceNamespace;
    }

    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            BasicResourceItemBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public final String getLibraryName() {
        return this.getRepository().getLibraryName();
    }

    @NotNull
    public final ResourceType getResourceType() {
        ResourceType resourceType = ResourceType.values()[this.myTypeOrdinal];
        if (resourceType == null) {
            BasicResourceItemBase.$$$reportNull$$$0(5);
        }
        return resourceType;
    }

    @NotNull
    public final ResourceVisibility getVisibility() {
        ResourceVisibility resourceVisibility = ResourceVisibility.values()[this.myVisibilityOrdinal];
        if (resourceVisibility == null) {
            BasicResourceItemBase.$$$reportNull$$$0(6);
        }
        return resourceVisibility;
    }

    @NotNull
    public final ResourceReference getReferenceToSelf() {
        return this.asReference();
    }

    @NotNull
    public final ResourceValue getResourceValue() {
        BasicResourceItemBase basicResourceItemBase = this;
        if (basicResourceItemBase == null) {
            BasicResourceItemBase.$$$reportNull$$$0(7);
        }
        return basicResourceItemBase;
    }

    public final boolean isUserDefined() {
        return this.getRepository().containsUserDefinedResources();
    }

    public final boolean isFramework() {
        return this.getNamespace().equals((Object)ResourceNamespace.ANDROID);
    }

    @NotNull
    public final ResourceReference asReference() {
        return new ResourceReference(this.getNamespace(), this.getResourceType(), this.myName);
    }

    @NotNull
    public final LoadableResourceRepository getRepository() {
        LoadableResourceRepository loadableResourceRepository = this.getRepositoryConfiguration().getRepository();
        if (loadableResourceRepository == null) {
            BasicResourceItemBase.$$$reportNull$$$0(8);
        }
        return loadableResourceRepository;
    }

    @NotNull
    public final FolderConfiguration getConfiguration() {
        FolderConfiguration folderConfiguration = this.getRepositoryConfiguration().getFolderConfiguration();
        if (folderConfiguration == null) {
            BasicResourceItemBase.$$$reportNull$$$0(9);
        }
        return folderConfiguration;
    }

    @NotNull
    public abstract RepositoryConfiguration getRepositoryConfiguration();

    @NotNull
    public final String getKey() {
        String qualifiers = this.getConfiguration().getQualifierString();
        if (!qualifiers.isEmpty()) {
            String string = this.getType().getName() + "-" + qualifiers + "/" + this.getName();
            if (string == null) {
                BasicResourceItemBase.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = this.getType().getName() + "/" + this.getName();
        if (string == null) {
            BasicResourceItemBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    public final void setValue(@Nullable String value2) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicResourceItemBase other = (BasicResourceItemBase)obj;
        return this.myTypeOrdinal == other.myTypeOrdinal && this.myName.equals(other.myName) && this.myVisibilityOrdinal == other.myVisibilityOrdinal;
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myTypeOrdinal, (int)this.myName.hashCode());
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getResourceType()).add("name", (Object)this.getName()).add("value", (Object)this.getValue()).toString();
        if (string == null) {
            BasicResourceItemBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        if (stream == null) {
            BasicResourceItemBase.$$$reportNull$$$0(13);
        }
        if (configIndexes == null) {
            BasicResourceItemBase.$$$reportNull$$$0(14);
        }
        if (sourceFileIndexes == null) {
            BasicResourceItemBase.$$$reportNull$$$0(15);
        }
        if (namespaceResolverIndexes == null) {
            BasicResourceItemBase.$$$reportNull$$$0(16);
        }
        stream.writeInt((this.myTypeOrdinal << 1) + (this.isFileBased() ? 1 : 0));
        stream.writeString(this.myName);
        stream.writeInt(this.myVisibilityOrdinal);
    }

    @NotNull
    public static BasicResourceItemBase deserialize(@NotNull Base128InputStream stream, @NotNull List<RepositoryConfiguration> configurations, @NotNull List<ResourceSourceFile> sourceFiles, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        if (stream == null) {
            BasicResourceItemBase.$$$reportNull$$$0(17);
        }
        if (configurations == null) {
            BasicResourceItemBase.$$$reportNull$$$0(18);
        }
        if (sourceFiles == null) {
            BasicResourceItemBase.$$$reportNull$$$0(19);
        }
        if (namespaceResolvers == null) {
            BasicResourceItemBase.$$$reportNull$$$0(20);
        }
        assert (!configurations.isEmpty());
        int encodedType = stream.readInt();
        boolean isFileBased = (encodedType & 1) != 0;
        ResourceType resourceType = ResourceType.values()[encodedType >>> 1];
        String name = stream.readString();
        if (name == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        ResourceVisibility visibility = ResourceVisibility.values()[stream.readInt()];
        if (isFileBased) {
            LoadableResourceRepository repository = configurations.get(0).getRepository();
            BasicFileResourceItem basicFileResourceItem = repository.deserializeFileResourceItem(stream, resourceType, name, visibility, configurations);
            if (basicFileResourceItem == null) {
                BasicResourceItemBase.$$$reportNull$$$0(21);
            }
            return basicFileResourceItem;
        }
        BasicValueResourceItemBase basicValueResourceItemBase = BasicValueResourceItemBase.deserialize(stream, resourceType, name, visibility, configurations, sourceFiles, namespaceResolvers);
        if (basicValueResourceItemBase == null) {
            BasicResourceItemBase.$$$reportNull$$$0(22);
        }
        return basicValueResourceItemBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/base/BasicResourceItemBase";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configIndexes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileIndexes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolverIndexes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/base/BasicResourceItemBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

